/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.event.EventBusHolder;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class EventsRule<T>
implements TestRule {
    private List<T> capturedEvents = Lists.newArrayList();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                EventBusHolder.register((Object)EventsRule.this);
                try {
                    base.evaluate();
                }
                finally {
                    EventBusHolder.deregister((Object)EventsRule.this);
                }
            }
        };
    }

    public List<T> getCapturedEvents() {
        return this.capturedEvents;
    }

    protected void capture(T event) {
        this.capturedEvents.add(event);
    }
}

