/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.security.auth.Subject;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.cluster.ClusterContext;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.cluster.WorkspaceEventChannel;
import org.apache.jackrabbit.core.cluster.WorkspaceListener;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.virtual.VirtualNodeTypeStateManager;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.simple.SimpleSecurityManager;
import org.apache.jackrabbit.core.state.CacheManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ManagedMLRUItemStateCacheFactory;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.util.RepositoryLock;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.core.xml.ClonedInputSource;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.RegistryNamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RepositoryImpl
extends AbstractRepository
implements JackrabbitRepository,
SessionListener,
EventListener,
WorkspaceListener {
    private static Logger log;
    public static final NodeId ROOT_NODE_ID;
    public static final NodeId SYSTEM_ROOT_NODE_ID;
    public static final NodeId VERSION_STORAGE_NODE_ID;
    public static final NodeId NODETYPES_NODE_ID;
    private static final String PROPERTIES_RESOURCE = "rep.properties";
    private final Properties repProps;
    public static final String STATS_NODE_COUNT_PROPERTY = "jcr.repository.stats.nodes.count";
    public static final String STATS_PROP_COUNT_PROPERTY = "jcr.repository.stats.properties.count";
    private NodeId rootNodeId;
    private final NamespaceRegistryImpl nsReg;
    private final NodeTypeRegistry ntReg;
    private final VersionManagerImpl vMgr;
    private final VirtualNodeTypeStateManager virtNTMgr;
    private JackrabbitSecurityManager securityMgr;
    private SearchManager systemSearchMgr;
    protected final RepositoryConfig repConfig;
    private final FileSystem repStore;
    private final FileSystem metaDataStore;
    private final DataStore dataStore;
    private final DelegatingObservationDispatcher delegatingDispatcher = new DelegatingObservationDispatcher();
    private final HashMap wspInfos = new HashMap();
    private final ReferenceMap activeSessions = new ReferenceMap(2, 2);
    private long nodesCount = 0L;
    private long propsCount = 0L;
    private boolean disposed = false;
    private RepositoryLock repLock;
    private ClusterNode clusterNode;
    private final ReadWriteLock shutdownLock = new WriterPreferenceReadWriteLock();
    private final CacheManager cacheMgr = new CacheManager();
    private final ItemStateCacheFactory cacheFactory = new ManagedMLRUItemStateCacheFactory(this.cacheMgr);
    private WorkspaceEventChannel createWorkspaceEventChannel;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RepositoryImpl(RepositoryConfig repConfig) throws RepositoryException {
        this.repLock = new RepositoryLock(repConfig.getHomeDir());
        this.repLock.acquire();
        log.info("Starting repository...");
        boolean succeeded = false;
        try {
            int maxIdleTime;
            this.repConfig = repConfig;
            this.repStore = repConfig.getFileSystem();
            String fsRootPath = "/meta";
            try {
                if (!this.repStore.exists(fsRootPath) || !this.repStore.isFolder(fsRootPath)) {
                    this.repStore.createFolder(fsRootPath);
                }
            }
            catch (FileSystemException fse) {
                String msg = "failed to create folder for repository meta data";
                log.error(msg, (Throwable)fse);
                throw new RepositoryException(msg, (Throwable)fse);
            }
            this.metaDataStore = new BasedFileSystem(this.repStore, fsRootPath);
            this.rootNodeId = this.loadRootNodeId(this.metaDataStore);
            this.repProps = this.loadRepProps();
            this.nodesCount = Long.parseLong(this.repProps.getProperty(STATS_NODE_COUNT_PROPERTY, "0"));
            this.propsCount = Long.parseLong(this.repProps.getProperty(STATS_PROP_COUNT_PROPERTY, "0"));
            this.nsReg = this.createNamespaceRegistry(new BasedFileSystem(this.repStore, "/namespaces"));
            this.ntReg = this.createNodeTypeRegistry(this.nsReg, new BasedFileSystem(this.repStore, "/nodetypes"));
            this.dataStore = repConfig.getDataStore();
            if (this.dataStore != null && !$assertionsDisabled && !InternalValue.USE_DATA_STORE) {
                throw new AssertionError();
            }
            Iterator iter = repConfig.getWorkspaceConfigs().iterator();
            while (iter.hasNext()) {
                WorkspaceConfig config = (WorkspaceConfig)iter.next();
                WorkspaceInfo info = this.createWorkspaceInfo(config);
                this.wspInfos.put(config.getName(), info);
            }
            if (repConfig.getClusterConfig() != null) {
                this.clusterNode = this.createClusterNode();
                this.nsReg.setEventChannel(this.clusterNode);
                this.ntReg.setEventChannel(this.clusterNode);
                this.createWorkspaceEventChannel = this.clusterNode;
                this.clusterNode.setListener(this);
            }
            this.vMgr = this.createVersionManager(repConfig.getVersioningConfig(), this.delegatingDispatcher);
            if (this.clusterNode != null) {
                this.vMgr.setEventChannel(this.clusterNode.createUpdateChannel(null));
            }
            this.virtNTMgr = new VirtualNodeTypeStateManager(this.getNodeTypeRegistry(), this.delegatingDispatcher, NODETYPES_NODE_ID, SYSTEM_ROOT_NODE_ID);
            this.initStartupWorkspaces();
            this.getSystemSearchManager(repConfig.getDefaultWorkspaceName());
            this.virtNTMgr.setSession(this.getSystemSession(repConfig.getDefaultWorkspaceName()));
            if (this.clusterNode != null) {
                try {
                    this.clusterNode.start();
                }
                catch (ClusterException e) {
                    String msg = "Unable to start clustered node, forcing shutdown...";
                    log.error(msg, (Throwable)e);
                    this.shutdown();
                    throw new RepositoryException(msg, (Throwable)e);
                }
            }
            if ((maxIdleTime = repConfig.getWorkspaceMaxIdleTime()) != 0) {
                Thread wspJanitor = new Thread(new WorkspaceJanitor(maxIdleTime * 1000));
                wspJanitor.setName("WorkspaceJanitor");
                wspJanitor.setPriority(1);
                wspJanitor.setDaemon(true);
                wspJanitor.start();
            }
            succeeded = true;
            log.info("Repository started");
        }
        catch (RepositoryException e) {
            log.error("failed to start Repository: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (!succeeded) {
                this.shutdown();
            }
        }
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public CacheManager getCacheManager() {
        return this.cacheMgr;
    }

    public ItemStateCacheFactory getItemStateCacheFactory() {
        return this.cacheFactory;
    }

    public ClusterNode getClusterNode() {
        return this.clusterNode;
    }

    protected synchronized JackrabbitSecurityManager getSecurityManager() throws RepositoryException {
        if (this.securityMgr == null) {
            SecurityManagerConfig smc = this.getConfig().getSecurityConfig().getSecurityManagerConfig();
            String workspaceName = this.getConfig().getDefaultWorkspaceName();
            if (smc != null && smc.getWorkspaceName() != null) {
                workspaceName = smc.getWorkspaceName();
            }
            SystemSession securitySession = this.getSystemSession(workspaceName);
            this.onSessionCreated(securitySession);
            if (smc == null) {
                log.debug("No configuration entry for SecurityManager. Using org.apache.jackrabbit.core.security.simple.SimpleSecurityManager");
                this.securityMgr = new SimpleSecurityManager();
            } else {
                this.securityMgr = (JackrabbitSecurityManager)smc.newInstance();
            }
            this.securityMgr.init(this, securitySession);
            log.info("SecurityManager = " + this.securityMgr.getClass());
        }
        return this.securityMgr;
    }

    protected VersionManagerImpl createVersionManager(VersioningConfig vConfig, DelegatingObservationDispatcher delegatingDispatcher) throws RepositoryException {
        FileSystem fs = vConfig.getFileSystem();
        PersistenceManager pm = RepositoryImpl.createPersistenceManager(vConfig.getHomeDir(), fs, vConfig.getPersistenceManagerConfig(), this.rootNodeId, this.nsReg, this.ntReg, this.dataStore);
        ISMLocking ismLocking = vConfig.getISMLockingConfig().createISMLocking();
        return new VersionManagerImpl(pm, fs, this.ntReg, delegatingDispatcher, VERSION_STORAGE_NODE_ID, SYSTEM_ROOT_NODE_ID, this.cacheFactory, ismLocking);
    }

    protected void initStartupWorkspaces() throws RepositoryException {
        String wspName = this.repConfig.getDefaultWorkspaceName();
        String secWspName = null;
        SecurityManagerConfig smc = this.repConfig.getSecurityConfig().getSecurityManagerConfig();
        if (smc != null) {
            secWspName = smc.getWorkspaceName();
        }
        try {
            ((WorkspaceInfo)this.wspInfos.get(wspName)).initialize();
            if (secWspName != null && !this.wspInfos.containsKey(secWspName)) {
                this.createWorkspace(secWspName);
                log.info("created system workspace: {}", (Object)secWspName);
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to initialize workspace '" + wspName + "'", (Throwable)e);
            log.error("Unable to start repository, forcing shutdown...");
            this.shutdown();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeId loadRootNodeId(FileSystem fs) throws RepositoryException {
        FileSystemResource uuidFile = new FileSystemResource(fs, "rootUUID");
        try {
            if (uuidFile.exists()) {
                try {
                    InputStream in = uuidFile.getInputStream();
                    char[] chars = new char[36];
                    InputStreamReader reader = new InputStreamReader(in);
                    try {
                        reader.read(chars);
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)reader);
                    }
                    return NodeId.valueOf(new String(chars));
                }
                catch (Exception e) {
                    String msg = "failed to load persisted repository state";
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)e);
                }
            }
            try {
                OutputStream out = uuidFile.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                try {
                    writer.write(ROOT_NODE_ID.toString());
                }
                finally {
                    IOUtils.closeQuietly((Writer)writer);
                }
                return ROOT_NODE_ID;
            }
            catch (Exception e) {
                String msg = "failed to persist repository state";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to access repository state";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)fse);
        }
    }

    protected NamespaceRegistryImpl createNamespaceRegistry(FileSystem fs) throws RepositoryException {
        return new NamespaceRegistryImpl(fs);
    }

    protected NodeTypeRegistry createNodeTypeRegistry(NamespaceRegistry nsReg, FileSystem fs) throws RepositoryException {
        return NodeTypeRegistry.create(nsReg, fs);
    }

    public static RepositoryImpl create(RepositoryConfig config) throws RepositoryException {
        return new RepositoryImpl(config);
    }

    protected void sanityCheck() throws RepositoryException {
        if (this.disposed) {
            throw new RepositoryException("This repository instance has been shut down.");
        }
    }

    private SearchManager getSystemSearchManager(String wspName) throws RepositoryException {
        if (this.systemSearchMgr == null && this.repConfig.getSearchConfig() != null) {
            this.systemSearchMgr = new SearchManager(this.repConfig.getSearchConfig(), this.nsReg, this.ntReg, this.getWorkspaceInfo(wspName).itemStateMgr, this.vMgr.getPersistenceManager(), SYSTEM_ROOT_NODE_ID, null, null);
            SystemSession defSysSession = this.getSystemSession(wspName);
            ObservationManager obsMgr = defSysSession.getWorkspace().getObservationManager();
            obsMgr.addEventListener((EventListener)this.systemSearchMgr, 31, "/" + defSysSession.getJCRName(NameConstants.JCR_SYSTEM), true, null, null, false);
        }
        return this.systemSearchMgr;
    }

    protected ClusterNode createClusterNode() throws RepositoryException {
        try {
            ClusterNode clusterNode = new ClusterNode();
            clusterNode.init(new ExternalEventListener());
            return clusterNode;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected NamespaceRegistryImpl getNamespaceRegistry() {
        return this.nsReg;
    }

    protected NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    protected VersionManager getVersionManager() {
        return this.vMgr;
    }

    protected NodeId getRootNodeId() {
        return this.rootNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getWorkspaceNames() {
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            return this.wspInfos.keySet().toArray(new String[this.wspInfos.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceInfo getWorkspaceInfo(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        WorkspaceInfo wspInfo;
        this.sanityCheck();
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            wspInfo = (WorkspaceInfo)this.wspInfos.get(workspaceName);
            if (wspInfo == null) {
                throw new NoSuchWorkspaceException(workspaceName);
            }
        }
        try {
            wspInfo.initialize();
        }
        catch (RepositoryException e) {
            log.error("Unable to initialize workspace '" + workspaceName + "'", (Throwable)e);
            throw new NoSuchWorkspaceException(workspaceName);
        }
        return wspInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWorkspace(String workspaceName) throws RepositoryException {
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            if (this.wspInfos.containsKey(workspaceName)) {
                throw new RepositoryException("workspace '" + workspaceName + "' already exists.");
            }
            StringBuffer workspaceConfigContent = this.clusterNode != null ? new StringBuffer() : null;
            WorkspaceConfig config = this.repConfig.createWorkspaceConfig(workspaceName, workspaceConfigContent);
            WorkspaceInfo info = this.createWorkspaceInfo(config);
            this.wspInfos.put(workspaceName, info);
            if (workspaceConfigContent != null && this.createWorkspaceEventChannel != null) {
                InputSource s = new InputSource(new StringReader(workspaceConfigContent.toString()));
                this.createWorkspaceEventChannel.workspaceCreated(workspaceName, new ClonedInputSource(s));
            }
        }
    }

    public void externalWorkspaceCreated(String workspaceName, InputSource configTemplate) throws RepositoryException {
        this.createWorkspaceInternal(workspaceName, configTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWorkspaceInternal(String workspaceName, InputSource configTemplate) throws RepositoryException {
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            if (this.wspInfos.containsKey(workspaceName)) {
                throw new RepositoryException("workspace '" + workspaceName + "' already exists.");
            }
            WorkspaceConfig config = this.repConfig.createWorkspaceConfig(workspaceName, configTemplate);
            WorkspaceInfo info = this.createWorkspaceInfo(config);
            this.wspInfos.put(workspaceName, info);
        }
    }

    protected void createWorkspace(String workspaceName, InputSource configTemplate) throws RepositoryException {
        if (this.createWorkspaceEventChannel == null) {
            this.createWorkspaceInternal(workspaceName, configTemplate);
        } else {
            ClonedInputSource template = new ClonedInputSource(configTemplate);
            this.createWorkspaceInternal(workspaceName, template.cloneInputSource());
            this.createWorkspaceEventChannel.workspaceCreated(workspaceName, template);
        }
    }

    SharedItemStateManager getWorkspaceStateManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getItemStateProvider();
    }

    protected void setReferentialIntegrityChecking(String workspace, boolean enabled) throws RepositoryException {
        SharedItemStateManager manager = this.getWorkspaceStateManager(workspace);
        manager.setCheckReferences(enabled);
    }

    ObservationDispatcher getObservationDispatcher(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getObservationDispatcher();
    }

    SearchManager getSearchManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getSearchManager();
    }

    LockManager getLockManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getLockManager();
    }

    SystemSession getSystemSession(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getSystemSession();
    }

    protected final SessionImpl createSession(AuthContext loginContext, String workspaceName) throws NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        WorkspaceInfo wspInfo = this.getWorkspaceInfo(workspaceName);
        SessionImpl ses = this.createSessionInstance(loginContext, wspInfo.getConfig());
        this.onSessionCreated(ses);
        wspInfo.setIdleTimestamp(0L);
        return ses;
    }

    protected final SessionImpl createSession(Subject subject, String workspaceName) throws NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        WorkspaceInfo wspInfo = this.getWorkspaceInfo(workspaceName);
        SessionImpl ses = this.createSessionInstance(subject, wspInfo.getConfig());
        this.onSessionCreated(ses);
        wspInfo.setIdleTimestamp(0L);
        return ses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSessionCreated(SessionImpl session) {
        ReferenceMap referenceMap = this.activeSessions;
        synchronized (referenceMap) {
            session.addListener(this);
            this.activeSessions.put((Object)session, (Object)session);
        }
    }

    private Session extendAuthentication(String workspaceName) throws RepositoryException, AccessDeniedException {
        SessionImpl s;
        Subject subject = null;
        try {
            AccessControlContext acc = AccessController.getContext();
            subject = Subject.getSubject(acc);
        }
        catch (SecurityException e) {
            log.warn("Can't check for preauthentication. Reason:", (Object)e.getMessage());
        }
        if (subject == null) {
            log.debug("No preauthenticated subject found -> return null.");
            return null;
        }
        if (subject.isReadOnly()) {
            log.debug("Preauthenticated Subject is read-only -> create Session");
            s = this.createSession(subject, workspaceName);
        } else {
            log.debug("Found preauthenticated Subject, try to extend authentication");
            AuthContext authCtx = this.getSecurityManager().getAuthContext(null, subject);
            try {
                authCtx.login();
                s = this.createSession(authCtx, workspaceName);
            }
            catch (javax.security.auth.login.LoginException e) {
                log.debug("Preauthentication could not be extended");
                s = this.createSession(subject, workspaceName);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.shutdownLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Shutdown lock could not be acquired", e);
        }
        try {
            if (!this.disposed) {
                this.doShutdown();
            }
        }
        finally {
            this.shutdownLock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doShutdown() {
        SessionImpl[] sa;
        log.info("Shutting down repository...");
        if (this.clusterNode != null) {
            this.clusterNode.stop();
        }
        if (this.securityMgr != null) {
            this.securityMgr.close();
        }
        ReferenceMap referenceMap = this.activeSessions;
        synchronized (referenceMap) {
            int cnt = 0;
            sa = new SessionImpl[this.activeSessions.size()];
            Iterator it = this.activeSessions.values().iterator();
            while (it.hasNext()) {
                sa[cnt] = (SessionImpl)it.next();
                ++cnt;
            }
        }
        for (int i = 0; i < sa.length; ++i) {
            if (sa[i] == null) continue;
            sa[i].logout();
        }
        if (this.systemSearchMgr != null) {
            this.systemSearchMgr.close();
        }
        HashMap i = this.wspInfos;
        synchronized (i) {
            Iterator it = this.wspInfos.values().iterator();
            while (it.hasNext()) {
                WorkspaceInfo wspInfo = (WorkspaceInfo)it.next();
                wspInfo.dispose();
            }
        }
        if (this.vMgr != null) {
            try {
                this.vMgr.close();
            }
            catch (Exception e) {
                log.error("Error while closing Version Manager.", (Throwable)e);
            }
        }
        if (this.repProps != null) {
            try {
                this.storeRepProps(this.repProps);
            }
            catch (RepositoryException e) {
                log.error("failed to persist repository properties", (Throwable)e);
            }
        }
        if (this.repStore != null) {
            try {
                this.repStore.close();
            }
            catch (FileSystemException e) {
                log.error("error while closing repository file system", (Throwable)e);
            }
        }
        this.disposed = true;
        this.notifyAll();
        this.repLock.release();
        log.info("Repository has been shutdown");
    }

    public RepositoryConfig getConfig() {
        return this.repConfig;
    }

    protected FileSystem getFileSystem() {
        return this.repStore;
    }

    protected void setDefaultRepositoryProperties(Properties props) throws RepositoryException {
        InputStream in = RepositoryImpl.class.getResourceAsStream("repository.properties");
        try {
            props.load(in);
            in.close();
            if (!props.containsKey(STATS_NODE_COUNT_PROPERTY)) {
                props.setProperty(STATS_NODE_COUNT_PROPERTY, Long.toString(this.nodesCount));
            }
            if (!props.containsKey(STATS_PROP_COUNT_PROPERTY)) {
                props.setProperty(STATS_PROP_COUNT_PROPERTY, Long.toString(this.propsCount));
            }
        }
        catch (IOException e) {
            String msg = "Failed to load repository properties: " + e.toString();
            log.error(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadRepProps() throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.metaDataStore, PROPERTIES_RESOURCE);
        try {
            Properties props = new Properties();
            if (propFile.exists()) {
                InputStream in = propFile.getInputStream();
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
            }
            this.setDefaultRepositoryProperties(props);
            this.storeRepProps(props);
            return props;
        }
        catch (Exception e) {
            String msg = "failed to load repository properties";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeRepProps(Properties props) throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.metaDataStore, PROPERTIES_RESOURCE);
        try {
            propFile.makeParentDirs();
            OutputStream os = propFile.getOutputStream();
            try {
                props.store(os, null);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to persist repository properties";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private static PersistenceManager createPersistenceManager(File homeDir, FileSystem fs, PersistenceManagerConfig pmConfig, NodeId rootNodeId, NamespaceRegistry nsReg, NodeTypeRegistry ntReg, DataStore dataStore) throws RepositoryException {
        try {
            PersistenceManager pm = (PersistenceManager)pmConfig.newInstance();
            pm.init(new PMContext(homeDir, fs, rootNodeId, nsReg, ntReg, dataStore));
            return pm;
        }
        catch (Exception e) {
            String msg = "Cannot instantiate persistence manager " + pmConfig.getClassName();
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected SharedItemStateManager createItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, boolean usesReferences, ItemStateCacheFactory cacheFactory, ISMLocking locking) throws ItemStateException {
        return new SharedItemStateManager(persistMgr, rootNodeId, ntReg, true, cacheFactory, locking);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        try {
            this.shutdownLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RepositoryException("Login lock could not be acquired", (Throwable)e);
        }
        try {
            this.sanityCheck();
            if (workspaceName == null) {
                workspaceName = this.repConfig.getDefaultWorkspaceName();
            }
            this.getWorkspaceInfo(workspaceName);
            if (credentials == null) {
                Session session = this.extendAuthentication(workspaceName);
                if (session != null) {
                    Session session2 = session;
                    return session2;
                }
                log.debug("Attempt to login without Credentials and Subject -> try login with null credentials.");
            }
            AuthContext authCtx = this.getSecurityManager().getAuthContext(credentials, new Subject());
            authCtx.login();
            SessionImpl sessionImpl = this.createSession(authCtx, workspaceName);
            return sessionImpl;
        }
        catch (SecurityException se) {
            throw new LoginException("Unable to access authentication information", (Throwable)se);
        }
        catch (javax.security.auth.login.LoginException le) {
            throw new LoginException(le.getMessage(), (Throwable)le);
        }
        catch (AccessDeniedException ade) {
            throw new LoginException("Workspace access denied", (Throwable)ade);
        }
        finally {
            this.shutdownLock.readLock().release();
        }
    }

    public String getDescriptor(String key) {
        return this.repProps.getProperty(key);
    }

    public String[] getDescriptorKeys() {
        Object[] keys = this.repProps.keySet().toArray(new String[this.repProps.keySet().size()]);
        Arrays.sort(keys);
        return keys;
    }

    public void loggingOut(SessionImpl session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loggedOut(SessionImpl session) {
        ReferenceMap referenceMap = this.activeSessions;
        synchronized (referenceMap) {
            this.activeSessions.remove((Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        if (this.disposed) {
            return;
        }
        Properties properties = this.repProps;
        synchronized (properties) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                long type = event.getType();
                if ((type & 1L) == 1L) {
                    ++this.nodesCount;
                    this.repProps.setProperty(STATS_NODE_COUNT_PROPERTY, Long.toString(this.nodesCount));
                }
                if ((type & 2L) == 2L) {
                    --this.nodesCount;
                    this.repProps.setProperty(STATS_NODE_COUNT_PROPERTY, Long.toString(this.nodesCount));
                }
                if ((type & 4L) == 4L) {
                    ++this.propsCount;
                    this.repProps.setProperty(STATS_PROP_COUNT_PROPERTY, Long.toString(this.propsCount));
                }
                if ((type & 8L) != 8L) continue;
                --this.propsCount;
                this.repProps.setProperty(STATS_PROP_COUNT_PROPERTY, Long.toString(this.propsCount));
            }
        }
    }

    protected SessionImpl createSessionInstance(AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new XASessionImpl(this, loginContext, wspConfig);
    }

    protected SessionImpl createSessionInstance(Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new XASessionImpl(this, subject, wspConfig);
    }

    protected WorkspaceInfo createWorkspaceInfo(WorkspaceConfig wspConfig) {
        return new WorkspaceInfo(wspConfig);
    }

    static {
        $assertionsDisabled = !RepositoryImpl.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)RepositoryImpl.class);
        ROOT_NODE_ID = NodeId.valueOf("cafebabe-cafe-babe-cafe-babecafebabe");
        SYSTEM_ROOT_NODE_ID = NodeId.valueOf("deadbeef-cafe-babe-cafe-babecafebabe");
        VERSION_STORAGE_NODE_ID = NodeId.valueOf("deadbeef-face-babe-cafe-babecafebabe");
        NODETYPES_NODE_ID = NodeId.valueOf("deadbeef-cafe-cafe-cafe-babecafebabe");
    }

    class ExternalEventListener
    implements ClusterContext {
        ExternalEventListener() {
        }

        public ClusterConfig getClusterConfig() {
            return RepositoryImpl.this.getConfig().getClusterConfig();
        }

        public File getRepositoryHome() {
            return new File(RepositoryImpl.this.getConfig().getHomeDir());
        }

        public NamespaceResolver getNamespaceResolver() {
            return new RegistryNamespaceResolver(RepositoryImpl.this.getNamespaceRegistry());
        }

        public void updateEventsReady(String workspace) throws RepositoryException {
            RepositoryImpl.this.getWorkspaceInfo(workspace);
        }

        public void lockEventsReady(String workspace) throws RepositoryException {
            RepositoryImpl.this.getWorkspaceInfo(workspace).getLockManager();
        }

        public DataStore getDataStore() {
            return RepositoryImpl.this.getDataStore();
        }
    }

    private class WorkspaceJanitor
    implements Runnable {
        private long maxIdleTime;
        private long checkInterval;

        WorkspaceJanitor(long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            this.checkInterval = (long)(0.1 * (double)maxIdleTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: while (true) {
                HashSet wspNames;
                RepositoryImpl repositoryImpl = RepositoryImpl.this;
                synchronized (repositoryImpl) {
                    try {
                        RepositoryImpl.this.wait(this.checkInterval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (RepositoryImpl.this.disposed) {
                        return;
                    }
                }
                HashMap e = RepositoryImpl.this.wspInfos;
                synchronized (e) {
                    wspNames = new HashSet(RepositoryImpl.this.wspInfos.keySet());
                }
                wspNames.remove(RepositoryImpl.this.repConfig.getDefaultWorkspaceName());
                e = RepositoryImpl.this.activeSessions;
                synchronized (e) {
                    Iterator it = RepositoryImpl.this.activeSessions.values().iterator();
                    while (it.hasNext()) {
                        SessionImpl ses = (SessionImpl)it.next();
                        wspNames.remove(ses.getWorkspace().getName());
                    }
                }
                Iterator it = wspNames.iterator();
                while (true) {
                    WorkspaceInfo wspInfo;
                    if (!it.hasNext()) continue block14;
                    HashMap hashMap = RepositoryImpl.this.wspInfos;
                    synchronized (hashMap) {
                        wspInfo = (WorkspaceInfo)RepositoryImpl.this.wspInfos.get(it.next());
                    }
                    wspInfo.disposeIfIdle(this.maxIdleTime);
                }
                break;
            }
        }
    }

    protected class WorkspaceInfo
    implements UpdateEventListener {
        private final WorkspaceConfig config;
        private FileSystem fs;
        private PersistenceManager persistMgr;
        private SharedItemStateManager itemStateMgr;
        private ObservationDispatcher dispatcher;
        private SystemSession systemSession;
        private SearchManager searchMgr;
        private LockManagerImpl lockMgr;
        private boolean initialized;
        private final ReadWriteLock initLock = new ReentrantWriterPreferenceReadWriteLock();
        private long idleTimestamp;
        private final Mutex xaLock = new Mutex();
        private UpdateEventChannel updateChannel;
        private LockEventChannel lockChannel;

        protected WorkspaceInfo(WorkspaceConfig config) {
            this.config = config;
            this.idleTimestamp = 0L;
            this.initialized = false;
        }

        protected String getName() {
            return this.config.getName();
        }

        public WorkspaceConfig getConfig() {
            return this.config;
        }

        final long getIdleTimestamp() {
            return this.idleTimestamp;
        }

        final void setIdleTimestamp(long ts) {
            this.idleTimestamp = ts;
        }

        protected final boolean isInitialized() {
            try {
                if (!this.initLock.readLock().attempt(0L)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            boolean ret = this.initialized;
            this.initLock.readLock().release();
            return ret;
        }

        protected FileSystem getFileSystem() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.fs;
        }

        protected PersistenceManager getPersistenceManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.persistMgr;
        }

        protected SharedItemStateManager getItemStateProvider() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.itemStateMgr;
        }

        protected ObservationDispatcher getObservationDispatcher() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SearchManager getSearchManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.searchMgr == null) {
                    if (this.config.getSearchConfig() == null) {
                        return null;
                    }
                    this.searchMgr = new SearchManager(this.config.getSearchConfig(), RepositoryImpl.this.nsReg, RepositoryImpl.this.ntReg, this.itemStateMgr, this.persistMgr, RepositoryImpl.this.rootNodeId, RepositoryImpl.this.getSystemSearchManager(this.getName()), SYSTEM_ROOT_NODE_ID);
                }
                return this.searchMgr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected LockManager getLockManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.lockMgr == null) {
                    this.lockMgr = new LockManagerImpl(this.getSystemSession(), this.fs);
                    if (RepositoryImpl.this.clusterNode != null && this.config.isClustered()) {
                        this.lockChannel = RepositoryImpl.this.clusterNode.createLockChannel(this.getName());
                        this.lockMgr.setEventChannel(this.lockChannel);
                    }
                }
                return this.lockMgr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SystemSession getSystemSession() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.systemSession == null) {
                    this.systemSession = SystemSession.create(RepositoryImpl.this, this.config);
                }
                return this.systemSession;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean initialize() throws RepositoryException {
            try {
                this.initLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                throw new RepositoryException("Unable to aquire read lock.", (Throwable)e);
            }
            try {
                if (this.initialized) {
                    boolean e = false;
                    return e;
                }
            }
            finally {
                this.initLock.readLock().release();
            }
            try {
                this.initLock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                throw new RepositoryException("Unable to aquire write lock.", (Throwable)e);
            }
            try {
                if (this.initialized) {
                    boolean bl = false;
                    return bl;
                }
                log.info("initializing workspace '" + this.getName() + "'...");
                this.doInitialize();
                this.initialized = true;
                this.doPostInitialize();
                log.info("workspace '" + this.getName() + "' initialized");
                boolean bl = true;
                return bl;
            }
            finally {
                this.initLock.writeLock().release();
            }
        }

        protected void doInitialize() throws RepositoryException {
            this.fs = this.config.getFileSystem();
            this.persistMgr = RepositoryImpl.createPersistenceManager(new File(this.config.getHomeDir()), this.fs, this.config.getPersistenceManagerConfig(), RepositoryImpl.this.rootNodeId, RepositoryImpl.this.nsReg, RepositoryImpl.this.ntReg, RepositoryImpl.this.dataStore);
            ISMLocking ismLocking = this.config.getISMLockingConfig().createISMLocking();
            try {
                this.itemStateMgr = RepositoryImpl.this.createItemStateManager(this.persistMgr, RepositoryImpl.this.rootNodeId, RepositoryImpl.this.ntReg, true, RepositoryImpl.this.cacheFactory, ismLocking);
                try {
                    this.itemStateMgr.addVirtualItemStateProvider(RepositoryImpl.this.vMgr.getVirtualItemStateProvider());
                    this.itemStateMgr.addVirtualItemStateProvider(RepositoryImpl.this.virtNTMgr.getVirtualItemStateProvider());
                }
                catch (Exception e) {
                    log.error("Unable to add vmgr: " + e.toString(), (Throwable)e);
                }
                if (RepositoryImpl.this.clusterNode != null && this.config.isClustered()) {
                    this.updateChannel = RepositoryImpl.this.clusterNode.createUpdateChannel(this.getName());
                    this.itemStateMgr.setEventChannel(this.updateChannel);
                    this.updateChannel.setListener(this);
                }
            }
            catch (ItemStateException ise) {
                String msg = "failed to instantiate shared item state manager";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
            this.dispatcher = new ObservationDispatcher();
            RepositoryImpl.this.delegatingDispatcher.addDispatcher(this.dispatcher);
        }

        protected void doPostInitialize() throws RepositoryException {
            WorkspaceImpl wsp = (WorkspaceImpl)this.getSystemSession().getWorkspace();
            wsp.getObservationManager().addEventListener((EventListener)RepositoryImpl.this, 15, "/", true, null, null, false);
            SearchManager searchMgr = this.getSearchManager();
            if (searchMgr != null) {
                wsp.getObservationManager().addEventListener((EventListener)searchMgr, 31, "/", true, null, null, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void disposeIfIdle(long maxIdleTime) {
            try {
                this.initLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                if (!this.initialized) {
                    return;
                }
                long currentTS = System.currentTimeMillis();
                if (this.idleTimestamp == 0L) {
                    this.idleTimestamp = currentTS;
                } else if (currentTS - this.idleTimestamp > maxIdleTime) {
                    log.info("disposing workspace '" + this.getName() + "' which has been idle for " + (currentTS - this.idleTimestamp) + " ms");
                    this.dispose();
                }
            }
            finally {
                this.initLock.readLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void dispose() {
            try {
                this.initLock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Unable to aquire write lock.");
            }
            try {
                if (!this.initialized) {
                    return;
                }
                log.info("shutting down workspace '" + this.getName() + "'...");
                this.doDispose();
                this.idleTimestamp = 0L;
                this.initialized = false;
                log.info("workspace '" + this.getName() + "' has been shutdown");
            }
            finally {
                this.initLock.writeLock().release();
            }
        }

        protected void doDispose() {
            if (this.updateChannel != null) {
                this.updateChannel.setListener(null);
            }
            if (this.lockChannel != null) {
                this.lockChannel.setListener(null);
            }
            RepositoryImpl.this.delegatingDispatcher.removeDispatcher(this.dispatcher);
            this.dispatcher.dispose();
            this.dispatcher = null;
            if (this.searchMgr != null) {
                this.searchMgr.close();
                this.searchMgr = null;
            }
            if (RepositoryImpl.this.securityMgr != null) {
                RepositoryImpl.this.securityMgr.dispose(this.getName());
            }
            if (this.systemSession != null) {
                this.systemSession.removeListener(RepositoryImpl.this);
                this.systemSession.logout();
                this.systemSession = null;
            }
            this.itemStateMgr.dispose();
            this.itemStateMgr = null;
            try {
                this.persistMgr.close();
            }
            catch (Exception e) {
                log.error("error while closing persistence manager of workspace " + this.config.getName(), (Throwable)e);
            }
            this.persistMgr = null;
            if (this.lockMgr != null) {
                this.lockMgr.close();
                this.lockMgr = null;
            }
            try {
                this.fs.close();
            }
            catch (FileSystemException fse) {
                log.error("error while closing file system of workspace " + this.config.getName(), (Throwable)fse);
            }
            this.fs = null;
        }

        void lockAcquire() throws TransactionException {
            try {
                this.xaLock.acquire();
            }
            catch (InterruptedException e) {
                throw new TransactionException("Error while acquiering lock", e);
            }
        }

        void lockRelease() {
            this.xaLock.release();
        }

        public void externalUpdate(ChangeLog external, List events) throws RepositoryException {
            try {
                EventStateCollection esc = new EventStateCollection(this.getObservationDispatcher(), null, null);
                esc.addAll(events);
                this.getItemStateProvider().externalUpdate(external, esc);
            }
            catch (IllegalStateException e) {
                String msg = "Unable to deliver events: " + e.getMessage();
                throw new RepositoryException(msg);
            }
        }
    }
}

