/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.api.v1.PhaseApi;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TaskApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class XLReleaseServiceHolder {
    private static Map<String, ? extends ApiService> apiServiceMap = Collections.emptyMap();

    private XLReleaseServiceHolder() {
    }

    public static void init(List<? extends ApiService> apiServiceList) {
        apiServiceMap = apiServiceList.stream().collect(Collectors.toMap(ApiService::serviceName, Function.identity()));
    }

    public static List<? extends ApiService> getApiServices() {
        return new ArrayList<ApiService>(apiServiceMap.values());
    }

    public static Object getRepositoryService() {
        throw new IllegalStateException("RepositoryService was removed together with Jackrabbit backend in XL Release 7.5.0, please use public API of XL Release");
    }

    @PublicApiMember
    public static TaskApi getTaskApi() {
        return (TaskApi)apiServiceMap.get("taskApi");
    }

    @PublicApiMember
    public static PhaseApi getPhaseApi() {
        return (PhaseApi)apiServiceMap.get("phaseApi");
    }

    @PublicApiMember
    public static ReleaseApi getReleaseApi() {
        return (ReleaseApi)apiServiceMap.get("releaseApi");
    }

    @PublicApiMember
    public static TemplateApi getTemplateApi() {
        return (TemplateApi)apiServiceMap.get("templateApi");
    }

    @PublicApiMember
    public static ConfigurationApi getConfigurationApi() {
        return (ConfigurationApi)apiServiceMap.get("configurationApi");
    }
}

