/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.FilterOrderRegistration;
import org.springframework.security.config.annotation.web.configurers.AnonymousConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.JeeConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.PortMapperConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.config.annotation.web.configurers.SecurityContextConfigurer;
import org.springframework.security.config.annotation.web.configurers.ServletApiConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.X509Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public final class HttpSecurity
extends AbstractConfiguredSecurityBuilder<DefaultSecurityFilterChain, HttpSecurity>
implements SecurityBuilder<DefaultSecurityFilterChain>,
HttpSecurityBuilder<HttpSecurity> {
    private final RequestMatcherConfigurer requestMatcherConfigurer;
    private List<OrderedFilter> filters = new ArrayList<OrderedFilter>();
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;
    private FilterOrderRegistration filterOrders = new FilterOrderRegistration();

    public HttpSecurity(ObjectPostProcessor<Object> objectPostProcessor, AuthenticationManagerBuilder authenticationBuilder, Map<Class<?>, Object> sharedObjects) {
        super(objectPostProcessor);
        Assert.notNull((Object)authenticationBuilder, (String)"authenticationBuilder cannot be null");
        this.setSharedObject(AuthenticationManagerBuilder.class, authenticationBuilder);
        for (Map.Entry<Class<?>, Object> entry : sharedObjects.entrySet()) {
            this.setSharedObject(entry.getKey(), entry.getValue());
        }
        ApplicationContext context = (ApplicationContext)sharedObjects.get(ApplicationContext.class);
        this.requestMatcherConfigurer = new RequestMatcherConfigurer(context);
    }

    private ApplicationContext getContext() {
        return this.getSharedObject(ApplicationContext.class);
    }

    @Deprecated
    public OpenIDLoginConfigurer<HttpSecurity> openidLogin() throws Exception {
        return this.getOrApply(new OpenIDLoginConfigurer());
    }

    @Deprecated
    public HttpSecurity openidLogin(Customizer<OpenIDLoginConfigurer<HttpSecurity>> openidLoginCustomizer) throws Exception {
        openidLoginCustomizer.customize(this.getOrApply(new OpenIDLoginConfigurer()));
        return this;
    }

    public HeadersConfigurer<HttpSecurity> headers() throws Exception {
        return this.getOrApply(new HeadersConfigurer());
    }

    public HttpSecurity headers(Customizer<HeadersConfigurer<HttpSecurity>> headersCustomizer) throws Exception {
        headersCustomizer.customize(this.getOrApply(new HeadersConfigurer()));
        return this;
    }

    public CorsConfigurer<HttpSecurity> cors() throws Exception {
        return this.getOrApply(new CorsConfigurer());
    }

    public HttpSecurity cors(Customizer<CorsConfigurer<HttpSecurity>> corsCustomizer) throws Exception {
        corsCustomizer.customize(this.getOrApply(new CorsConfigurer()));
        return this;
    }

    public SessionManagementConfigurer<HttpSecurity> sessionManagement() throws Exception {
        return this.getOrApply(new SessionManagementConfigurer());
    }

    public HttpSecurity sessionManagement(Customizer<SessionManagementConfigurer<HttpSecurity>> sessionManagementCustomizer) throws Exception {
        sessionManagementCustomizer.customize(this.getOrApply(new SessionManagementConfigurer()));
        return this;
    }

    public PortMapperConfigurer<HttpSecurity> portMapper() throws Exception {
        return this.getOrApply(new PortMapperConfigurer());
    }

    public HttpSecurity portMapper(Customizer<PortMapperConfigurer<HttpSecurity>> portMapperCustomizer) throws Exception {
        portMapperCustomizer.customize(this.getOrApply(new PortMapperConfigurer()));
        return this;
    }

    public JeeConfigurer<HttpSecurity> jee() throws Exception {
        return this.getOrApply(new JeeConfigurer());
    }

    public HttpSecurity jee(Customizer<JeeConfigurer<HttpSecurity>> jeeCustomizer) throws Exception {
        jeeCustomizer.customize(this.getOrApply(new JeeConfigurer()));
        return this;
    }

    public X509Configurer<HttpSecurity> x509() throws Exception {
        return this.getOrApply(new X509Configurer());
    }

    public HttpSecurity x509(Customizer<X509Configurer<HttpSecurity>> x509Customizer) throws Exception {
        x509Customizer.customize(this.getOrApply(new X509Configurer()));
        return this;
    }

    public RememberMeConfigurer<HttpSecurity> rememberMe() throws Exception {
        return this.getOrApply(new RememberMeConfigurer());
    }

    public HttpSecurity rememberMe(Customizer<RememberMeConfigurer<HttpSecurity>> rememberMeCustomizer) throws Exception {
        rememberMeCustomizer.customize(this.getOrApply(new RememberMeConfigurer()));
        return this;
    }

    public ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new ExpressionUrlAuthorizationConfigurer(context)).getRegistry();
    }

    public HttpSecurity authorizeRequests(Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> authorizeRequestsCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        authorizeRequestsCustomizer.customize(this.getOrApply(new ExpressionUrlAuthorizationConfigurer(context)).getRegistry());
        return this;
    }

    public RequestCacheConfigurer<HttpSecurity> requestCache() throws Exception {
        return this.getOrApply(new RequestCacheConfigurer());
    }

    public HttpSecurity requestCache(Customizer<RequestCacheConfigurer<HttpSecurity>> requestCacheCustomizer) throws Exception {
        requestCacheCustomizer.customize(this.getOrApply(new RequestCacheConfigurer()));
        return this;
    }

    public ExceptionHandlingConfigurer<HttpSecurity> exceptionHandling() throws Exception {
        return this.getOrApply(new ExceptionHandlingConfigurer());
    }

    public HttpSecurity exceptionHandling(Customizer<ExceptionHandlingConfigurer<HttpSecurity>> exceptionHandlingCustomizer) throws Exception {
        exceptionHandlingCustomizer.customize(this.getOrApply(new ExceptionHandlingConfigurer()));
        return this;
    }

    public SecurityContextConfigurer<HttpSecurity> securityContext() throws Exception {
        return this.getOrApply(new SecurityContextConfigurer());
    }

    public HttpSecurity securityContext(Customizer<SecurityContextConfigurer<HttpSecurity>> securityContextCustomizer) throws Exception {
        securityContextCustomizer.customize(this.getOrApply(new SecurityContextConfigurer()));
        return this;
    }

    public ServletApiConfigurer<HttpSecurity> servletApi() throws Exception {
        return this.getOrApply(new ServletApiConfigurer());
    }

    public HttpSecurity servletApi(Customizer<ServletApiConfigurer<HttpSecurity>> servletApiCustomizer) throws Exception {
        servletApiCustomizer.customize(this.getOrApply(new ServletApiConfigurer()));
        return this;
    }

    public CsrfConfigurer<HttpSecurity> csrf() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new CsrfConfigurer(context));
    }

    public HttpSecurity csrf(Customizer<CsrfConfigurer<HttpSecurity>> csrfCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        csrfCustomizer.customize(this.getOrApply(new CsrfConfigurer(context)));
        return this;
    }

    public LogoutConfigurer<HttpSecurity> logout() throws Exception {
        return this.getOrApply(new LogoutConfigurer());
    }

    public HttpSecurity logout(Customizer<LogoutConfigurer<HttpSecurity>> logoutCustomizer) throws Exception {
        logoutCustomizer.customize(this.getOrApply(new LogoutConfigurer()));
        return this;
    }

    public AnonymousConfigurer<HttpSecurity> anonymous() throws Exception {
        return this.getOrApply(new AnonymousConfigurer());
    }

    public HttpSecurity anonymous(Customizer<AnonymousConfigurer<HttpSecurity>> anonymousCustomizer) throws Exception {
        anonymousCustomizer.customize(this.getOrApply(new AnonymousConfigurer()));
        return this;
    }

    public FormLoginConfigurer<HttpSecurity> formLogin() throws Exception {
        return this.getOrApply(new FormLoginConfigurer());
    }

    public HttpSecurity formLogin(Customizer<FormLoginConfigurer<HttpSecurity>> formLoginCustomizer) throws Exception {
        formLoginCustomizer.customize(this.getOrApply(new FormLoginConfigurer()));
        return this;
    }

    public Saml2LoginConfigurer<HttpSecurity> saml2Login() throws Exception {
        return this.getOrApply(new Saml2LoginConfigurer());
    }

    public HttpSecurity saml2Login(Customizer<Saml2LoginConfigurer<HttpSecurity>> saml2LoginCustomizer) throws Exception {
        saml2LoginCustomizer.customize(this.getOrApply(new Saml2LoginConfigurer()));
        return this;
    }

    public OAuth2LoginConfigurer<HttpSecurity> oauth2Login() throws Exception {
        return this.getOrApply(new OAuth2LoginConfigurer());
    }

    public HttpSecurity oauth2Login(Customizer<OAuth2LoginConfigurer<HttpSecurity>> oauth2LoginCustomizer) throws Exception {
        oauth2LoginCustomizer.customize(this.getOrApply(new OAuth2LoginConfigurer()));
        return this;
    }

    public OAuth2ClientConfigurer<HttpSecurity> oauth2Client() throws Exception {
        OAuth2ClientConfigurer<HttpSecurity> configurer = this.getOrApply(new OAuth2ClientConfigurer());
        this.postProcess(configurer);
        return configurer;
    }

    public HttpSecurity oauth2Client(Customizer<OAuth2ClientConfigurer<HttpSecurity>> oauth2ClientCustomizer) throws Exception {
        oauth2ClientCustomizer.customize(this.getOrApply(new OAuth2ClientConfigurer()));
        return this;
    }

    public OAuth2ResourceServerConfigurer<HttpSecurity> oauth2ResourceServer() throws Exception {
        OAuth2ResourceServerConfigurer<HttpSecurity> configurer = this.getOrApply(new OAuth2ResourceServerConfigurer(this.getContext()));
        this.postProcess(configurer);
        return configurer;
    }

    public HttpSecurity oauth2ResourceServer(Customizer<OAuth2ResourceServerConfigurer<HttpSecurity>> oauth2ResourceServerCustomizer) throws Exception {
        OAuth2ResourceServerConfigurer configurer = this.getOrApply(new OAuth2ResourceServerConfigurer(this.getContext()));
        this.postProcess(configurer);
        oauth2ResourceServerCustomizer.customize(configurer);
        return this;
    }

    public ChannelSecurityConfigurer.ChannelRequestMatcherRegistry requiresChannel() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new ChannelSecurityConfigurer(context)).getRegistry();
    }

    public HttpSecurity requiresChannel(Customizer<ChannelSecurityConfigurer.ChannelRequestMatcherRegistry> requiresChannelCustomizer) throws Exception {
        ApplicationContext context = this.getContext();
        requiresChannelCustomizer.customize(this.getOrApply(new ChannelSecurityConfigurer(context)).getRegistry());
        return this;
    }

    public HttpBasicConfigurer<HttpSecurity> httpBasic() throws Exception {
        return this.getOrApply(new HttpBasicConfigurer());
    }

    public HttpSecurity httpBasic(Customizer<HttpBasicConfigurer<HttpSecurity>> httpBasicCustomizer) throws Exception {
        httpBasicCustomizer.customize(this.getOrApply(new HttpBasicConfigurer()));
        return this;
    }

    @Override
    public <C> void setSharedObject(Class<C> sharedType, C object) {
        super.setSharedObject(sharedType, object);
    }

    @Override
    protected void beforeConfigure() throws Exception {
        this.setSharedObject(AuthenticationManager.class, this.getAuthenticationRegistry().build());
    }

    @Override
    protected DefaultSecurityFilterChain performBuild() {
        this.filters.sort((Comparator<OrderedFilter>)OrderComparator.INSTANCE);
        ArrayList<Filter> sortedFilters = new ArrayList<Filter>(this.filters.size());
        for (Filter filter : this.filters) {
            sortedFilters.add(((OrderedFilter)filter).filter);
        }
        return new DefaultSecurityFilterChain(this.requestMatcher, sortedFilters);
    }

    @Override
    public HttpSecurity authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.getAuthenticationRegistry().authenticationProvider(authenticationProvider);
        return this;
    }

    @Override
    public HttpSecurity userDetailsService(UserDetailsService userDetailsService) throws Exception {
        this.getAuthenticationRegistry().userDetailsService(userDetailsService);
        return this;
    }

    private AuthenticationManagerBuilder getAuthenticationRegistry() {
        return this.getSharedObject(AuthenticationManagerBuilder.class);
    }

    @Override
    public HttpSecurity addFilterAfter(Filter filter, Class<? extends Filter> afterFilter) {
        return this.addFilterAtOffsetOf(filter, 1, afterFilter);
    }

    @Override
    public HttpSecurity addFilterBefore(Filter filter, Class<? extends Filter> beforeFilter) {
        return this.addFilterAtOffsetOf(filter, -1, beforeFilter);
    }

    private HttpSecurity addFilterAtOffsetOf(Filter filter, int offset, Class<? extends Filter> registeredFilter) {
        int order = this.filterOrders.getOrder(registeredFilter) + offset;
        this.filters.add(new OrderedFilter(filter, order));
        this.filterOrders.put(filter.getClass(), order);
        return this;
    }

    @Override
    public HttpSecurity addFilter(Filter filter) {
        Integer order = this.filterOrders.getOrder(filter.getClass());
        if (order == null) {
            throw new IllegalArgumentException("The Filter class " + filter.getClass().getName() + " does not have a registered order and cannot be added without a specified order. Consider using addFilterBefore or addFilterAfter instead.");
        }
        this.filters.add(new OrderedFilter(filter, order));
        return this;
    }

    public HttpSecurity addFilterAt(Filter filter, Class<? extends Filter> atFilter) {
        return this.addFilterAtOffsetOf(filter, 0, atFilter);
    }

    public RequestMatcherConfigurer requestMatchers() {
        return this.requestMatcherConfigurer;
    }

    public HttpSecurity requestMatchers(Customizer<RequestMatcherConfigurer> requestMatcherCustomizer) {
        requestMatcherCustomizer.customize(this.requestMatcherConfigurer);
        return this;
    }

    public HttpSecurity requestMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
        return this;
    }

    public HttpSecurity antMatcher(String antPattern) {
        return this.requestMatcher((RequestMatcher)new AntPathRequestMatcher(antPattern));
    }

    public HttpSecurity mvcMatcher(String mvcPattern) {
        HandlerMappingIntrospector introspector = new HandlerMappingIntrospector(this.getContext());
        return this.requestMatcher((RequestMatcher)new MvcRequestMatcher(introspector, mvcPattern));
    }

    public HttpSecurity regexMatcher(String pattern) {
        return this.requestMatcher((RequestMatcher)new RegexRequestMatcher(pattern, null));
    }

    private <C extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity>> C getOrApply(C configurer) throws Exception {
        SecurityConfigurerAdapter existingConfig = (SecurityConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existingConfig != null) {
            return (C)existingConfig;
        }
        return this.apply(configurer);
    }

    private static final class OrderedFilter
    implements Ordered,
    Filter {
        private final Filter filter;
        private final int order;

        private OrderedFilter(Filter filter, int order) {
            this.filter = filter;
            this.order = order;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.filter.doFilter(servletRequest, servletResponse, filterChain);
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderedFilter{filter=" + this.filter + ", order=" + this.order + '}';
        }
    }

    public class RequestMatcherConfigurer
    extends AbstractRequestMatcherRegistry<RequestMatcherConfigurer> {
        protected List<RequestMatcher> matchers = new ArrayList<RequestMatcher>();

        RequestMatcherConfigurer(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        public MvcMatchersRequestMatcherConfigurer mvcMatchers(HttpMethod method, String ... mvcPatterns) {
            List<MvcRequestMatcher> mvcMatchers = this.createMvcMatchers(method, mvcPatterns);
            this.setMatchers(mvcMatchers);
            return new MvcMatchersRequestMatcherConfigurer(HttpSecurity.this.getContext(), mvcMatchers);
        }

        @Override
        public MvcMatchersRequestMatcherConfigurer mvcMatchers(String ... patterns) {
            return this.mvcMatchers((HttpMethod)null, patterns);
        }

        @Override
        protected RequestMatcherConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.setMatchers(requestMatchers);
            return this;
        }

        private void setMatchers(List<? extends RequestMatcher> requestMatchers) {
            this.matchers.addAll(requestMatchers);
            HttpSecurity.this.requestMatcher((RequestMatcher)new OrRequestMatcher(this.matchers));
        }

        public HttpSecurity and() {
            return HttpSecurity.this;
        }
    }

    public final class MvcMatchersRequestMatcherConfigurer
    extends RequestMatcherConfigurer {
        private MvcMatchersRequestMatcherConfigurer(ApplicationContext context, List<MvcRequestMatcher> matchers) {
            super(context);
            this.matchers = new ArrayList<MvcRequestMatcher>(matchers);
        }

        public RequestMatcherConfigurer servletPath(String servletPath) {
            for (RequestMatcher matcher : this.matchers) {
                ((MvcRequestMatcher)matcher).setServletPath(servletPath);
            }
            return this;
        }
    }
}

