/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.package;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Growable;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dw!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004\"B\u001d\u0002\t\u0003Qd\u0001B\u0018!\u0001-C\u0011\u0002\u0016\u0003\u0003\u0002\u0003\u0006Y!\u00164\t\u000b]\"A\u0011A4\t\u000b)$A\u0011A6\t\u000b1$A\u0011A7\t\u000f\u0005\rA\u0001\"\u0001\u0002\u0006!9\u00111\u0005\u0003\u0005\u0002\u0005\u0015\u0002bBA\u0017\t\u0011\u0005\u0011q\u0006\u0005\b\u0003w!A\u0011AA\u001f\u0011\u001d\t\u0019\u0005\u0002C\u0001\u0003\u000bBq!a\u0018\u0005\t\u0003\t\t\u0007C\u0004\u0002h\u0011!\t!!\u001b\t\u000f\u00055D\u0001\"\u0001\u0002p!9\u0011Q\u000f\u0003\u0005\u0002\u0005]\u0004bBAB\t\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u001b#A\u0011AAH\u0011\u0019\ty\n\u0002C\u0001W\"1\u0011\u0011\u0015\u0003\u0005\u0002-Dq!a)\u0005\t\u0013\t)\u000bC\u0004\u0002.\u0012!I!a,\t\u000f\u0005]F\u0001\"\u0003\u00020\"9\u0011\u0011\u0018\u0003\u0005\n\u0005=\u0006bBA^\t\u0011%\u0011q\u0016\u0005\b\u0003{#A\u0011BAX\u0011\u001d\ty\f\u0002C\u0005\u0003_Cq!!1\u0005\t\u0013\ty\u000bC\u0004\u0002D\u0012!\t%!2\u0002\u001fQ\u000b7o[:Tc2\u0014U/\u001b7eKJT!!\t\u0012\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003G\u0011\n1a]9m\u0015\t)c%\u0001\u0006sKB|7/\u001b;pefT!a\n\u0015\u0002\u0013ad'/\u001a7fCN,'BA\u0015+\u0003%AXMY5bY\u0006\u00147OC\u0001,\u0003\r\u0019w.\\\u0002\u0001!\tq\u0013!D\u0001!\u0005=!\u0016m]6t'Fd')^5mI\u0016\u00148CA\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!L\u0001\u000e]>\u0014X.\u00197ju\u0016$\u0016mZ:\u0015\u0005mJ\u0005c\u0001\u001fD\r:\u0011Q(\u0011\t\u0003}Mj\u0011a\u0010\u0006\u0003\u00012\na\u0001\u0010:p_Rt\u0014B\u0001\"4\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0004'\u0016$(B\u0001\"4!\tat)\u0003\u0002I\u000b\n11\u000b\u001e:j]\u001eDQAS\u0002A\u0002m\nA\u0001^1hgN\u0011A\u0001\u0014\t\u0004\u001bF\u001bV\"\u0001(\u000b\u0005\rz%B\u0001)'\u0003\t!'-\u0003\u0002S\u001d\nQ1+\u001d7Ck&dG-\u001a:\u0011\u00059\"\u0011a\u00023jC2,7\r\u001e\t\u0003-\u000et!aV1\u000f\u0005a\u0003gBA-`\u001d\tQfL\u0004\u0002\\;:\u0011a\bX\u0005\u0002W%\u0011\u0011FK\u0005\u0003O!J!\u0001\u0015\u0014\n\u0005\rz\u0015B\u00012O\u0003)\u0019\u0016\u000f\u001c\"vS2$WM]\u0005\u0003I\u0016\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002c\u001d&\u0011A+\u0015\u000b\u0002QR\u00111+\u001b\u0005\u0006)\u001a\u0001\u001d!V\u0001\rg\u0016dWm\u0019;UCN\\\u0017\n\u001a\u000b\u0002'\u0006Ar/\u001b;i\u001f:,wJ\u001a*fY\u0016\f7/Z*uCR,8/Z:\u0015\u0005Ms\u0007\"B8\t\u0001\u0004\u0001\u0018\u0001C:uCR,8/Z:\u0011\u0007E4\u0018P\u0004\u0002si:\u0011ah]\u0005\u0002i%\u0011QoM\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bPA\u0002TKFT!!^\u001a\u0011\u0005i|X\"A>\u000b\u0005ql\u0018AB:uCR,8O\u0003\u0002\u007fM\u00051Am\\7bS:L1!!\u0001|\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vg\u0006yq/\u001b;i)\u0006\u001c8\u000eV=qK:{G\u000fF\u0002T\u0003\u000fAq!!\u0003\n\u0001\u0004\tY!\u0001\u0005uCN\\G+\u001f9f!\u0011\ti!a\b\u000e\u0005\u0005=!\u0002BA\t\u0003'\tqA]3gY\u0016\u001cGO\u0003\u0003\u0002\u0016\u0005]\u0011aA1qS*!\u0011\u0011DA\u000e\u0003\u0019\u0001H.^4j]*\u0019\u0011Q\u0004\u0015\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!\t\u0002\u0010\t!A+\u001f9f\u000359\u0018\u000e\u001e5UCN\\G+\u001f9fgR\u00191+a\n\t\u000f\u0005%\"\u00021\u0001\u0002,\u0005IA/Y:l)f\u0004Xm\u001d\t\u0005cZ\fY!A\u000bxSRDwJ\\3PMR\u000b7o[*uCR,8/Z:\u0015\u0007M\u000b\t\u0004\u0003\u0004p\u0017\u0001\u0007\u00111\u0007\t\u0005cZ\f)\u0004E\u0002{\u0003oI1!!\u000f|\u0005)!\u0016m]6Ti\u0006$Xo]\u0001\u000bo&$\bNR5mi\u0016\u0014HcA*\u0002@!1\u0011\u0011\t\u0007A\u0002\u0019\u000baAZ5mi\u0016\u0014\u0018!C<ji\"$\u0015\r^3t)\u0015\u0019\u0016qIA.\u0011\u001d\tI%\u0004a\u0001\u0003\u0017\nAA\u001a:p[B!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001B;uS2T!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u00033\nyE\u0001\u0003ECR,\u0007bBA/\u001b\u0001\u0007\u00111J\u0001\u0003i>\fac^5uQN\u001b\u0007.\u001a3vY\u0016$7\u000b^1si\u0012\u000bG/\u001a\u000b\u0004'\u0006\r\u0004bBA3\u001d\u0001\u0007\u00111J\u0001\u0005I\u0006$X-A\u0007xSRD\u0017I\\=PMR\u000bwm\u001d\u000b\u0004'\u0006-\u0004\"\u0002&\u0010\u0001\u0004Y\u0014!D<ji\"4u\u000e\u001c3fe&#7\u000fF\u0002T\u0003cBa!a\u001d\u0011\u0001\u0004Y\u0014!\u00034pY\u0012,'/\u00133t\u0003A9\u0018\u000e\u001e5BgNLwM\\3e)>lU\rF\u0002T\u0003sBq!a\u001f\u0012\u0001\u0004\ti(\u0001\u0006qe&t7-\u001b9bYN\u0004B!]A@\r&\u0019\u0011\u0011\u0011=\u0003\u0011%#XM]1cY\u0016\f\u0011d^5uQ\u0006\u001b8/[4oK\u0012$v.T3Pe6KH+Z1ngR)1+a\"\u0002\n\"9\u00111\u0010\nA\u0002\u0005u\u0004bBAF%\u0001\u0007\u0011QP\u0001\be>dW-\u00133t\u0003U9\u0018\u000e\u001e5BgNLwM\\3e)>\fe.\u001f2pIf$raUAI\u0003'\u000b)\nC\u0004\u0002|M\u0001\r!! \t\u000f\u0005-5\u00031\u0001\u0002~!9\u0011qS\nA\u0002\u0005e\u0015aB5t\u0003\u0012l\u0017N\u001c\t\u0004e\u0005m\u0015bAAOg\t9!i\\8mK\u0006t\u0017!D<ji\"\fe.\u001f$bG\u0016$8/A\u0007pe\u0012,'OQ=UCN\\\u0017\nZ\u0001\bE&tG-\u001b8h)\r1\u0015q\u0015\u0005\b\u0003S3\u0002\u0019AAV\u0003\u00191\u0018\r\\;fgB!\u0011/a 2\u0003%Qw.\u001b8UK\u0006l7\u000f\u0006\u0002\u00022B\u0019!'a-\n\u0007\u0005U6G\u0001\u0003V]&$\u0018\u0001\u00056pS:$V-Y7t)>$\u0016m]6t\u00035Qw.\u001b8UK\u0006l'k\u001c7fg\u0006\u0011\"n\\5o)\u0016\fW\u000e\u0015:j]\u000eL\u0007/\u00197t\u0003MQw.\u001b8UK\u0006l\u0007+\u001a:nSN\u001c\u0018n\u001c8t\u0003-Qw.\u001b8G_2$WM]:\u0002\u0015)|\u0017N\u001c$bG\u0016$8/A\u0006oK^Len\u001d;b]\u000e,W#A*")
public class TasksSqlBuilder
extends SqlBuilder<TasksSqlBuilder> {
    public static Set<String> normalizeTags(Set<String> set) {
        return TasksSqlBuilder$.MODULE$.normalizeTags(set);
    }

    public TasksSqlBuilder selectTaskId() {
        return (TasksSqlBuilder)super.select(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(127).append("SELECT\n         |  DISTINCT tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).append("\n         |FROM\n         |  ").append(Schema.TASKS$.MODULE$.TABLE()).append(" tasks\n         |  JOIN ").append(Schema.RELEASES$.MODULE$.TABLE()).append(" releases ON tasks.").append(Schema.TASKS$.MODULE$.RELEASE_UID()).append(" = releases.").append(Schema.RELEASES$.MODULE$.CI_UID()).append("\n         ").toString())));
    }

    public TasksSqlBuilder withOneOfReleaseStatuses(Seq<ReleaseStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(15).append("releases.").append(Schema.RELEASES$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable)x$2 -> x$2.value()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withTaskTypeNot(Type taskType) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(11).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_TYPE()).append(" != ?").toString(), (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{taskType.toString()}))));
        return this;
    }

    public TasksSqlBuilder withTaskTypes(Seq<Type> taskTypes) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(12).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_TYPE()).append(" IN (").append(this.binding((Iterable<Object>)taskTypes)).append(")").toString(), (Iterable)taskTypes.map((Function1 & Serializable)x$3 -> x$3.toString())));
        return this;
    }

    public TasksSqlBuilder withOneOfTaskStatuses(Seq<TaskStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(12).append("tasks.").append(Schema.TASKS$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable)x$4 -> x$4.value()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withFilter(String filter) {
        Object object = filter != null ? this.likeOr((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TITLE()).toString(), new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.OWNER()).toString(), new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TEAM()).toString(), new StringBuilder(9).append("releases.").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).toString()})), filter) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withDates(Date from, Date to) {
        Object object;
        if (from != null && to != null) {
            object = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(43).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(") AND tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Date[]{from, from, to}))));
        } else {
            Object object2 = from != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(28).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(")").toString(), (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Date[]{from, from})))) : BoxedUnit.UNIT;
            object = to != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(10).append("tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Date[]{to})))) : BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withScheduledStartDate(Date date) {
        this.conditions().$plus$eq((Object)new package.Sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(32).append("\n         |tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" = ?\n         |").toString())), (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Date[]{new Date(Predef$.MODULE$.Long2long(DateVariableUtils.truncateMilliseconds((Long)Predef$.MODULE$.long2Long(date.getTime()))))}))));
        return this;
    }

    public TasksSqlBuilder withAnyOfTags(Set<String> tags) {
        BoxedUnit boxedUnit;
        Set<String> normalizedTags = TasksSqlBuilder$.MODULE$.normalizeTags(tags);
        if (normalizedTags.nonEmpty()) {
            String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(159).append("\n           |tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" IN (\n           |  SELECT DISTINCT task_tags.").append(Schema.TASK_TAGS$.MODULE$.CI_UID()).append("\n           |  FROM ").append(Schema.TASK_TAGS$.MODULE$.TABLE()).append(" task_tags\n           |  WHERE task_tags.").append(Schema.TASK_TAGS$.MODULE$.VALUE()).append(" IN (").append(this.binding((Iterable<Object>)normalizedTags)).append(")\n           |)\n           |").toString()));
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(sql, normalizedTags));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withFolderIds(Set<String> folderIds) {
        BoxedUnit boxedUnit;
        Set normalizedFolderIds = (Set)folderIds.map((Function1 & Serializable)x$1 -> Ids.getName((String)x$1));
        if (normalizedFolderIds.nonEmpty()) {
            this.joinFolders();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(14).append("folders.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" IN (").append(this.binding((Iterable<Object>)normalizedFolderIds)).append(")").toString(), (Iterable)normalizedFolderIds));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMe(Iterable<String> principals) {
        BoxedUnit boxedUnit;
        if (principals.nonEmpty()) {
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable)x$5 -> x$5.toLowerCase())));
        } else {
            this.nothingToBeFound_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMeOrMyTeams(Iterable<String> principals, Iterable<String> roleIds) {
        this.joinTeamsToTasks();
        Seq orConditions = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
        if (principals.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable)x$6 -> x$6.toLowerCase()))})));
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(105).append("teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" IN (SELECT ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append(" FROM ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" assignedToMeOrTeamsPrincipals WHERE LOWER(assignedToMeOrTeamsPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (").append(this.binding(principals)).append("))").toString(), (Iterable)principals.map((Function1 & Serializable)x$7 -> x$7.toLowerCase()))})));
        }
        if (roleIds.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(95).append("teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" IN (SELECT ").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).append(" FROM ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" assignedToMeOrTeamsRoles WHERE LOWER(assignedToMeOrTeamsRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(") IN (").append(this.binding(roleIds)).append("))").toString(), (Iterable)roleIds.map((Function1 & Serializable)x$8 -> x$8.toLowerCase()))})));
        }
        Growable growable = orConditions.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(2).append("(").append(((IterableOnceOps)orConditions.map((Function1 & Serializable)c -> new StringBuilder(2).append("(").append(c.sql()).append(")").toString())).mkString(" OR ")).append(")").toString(), (Iterable)orConditions.flatMap((Function1 & Serializable)x$9 -> x$9.parameters()))) : this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withAssignedToAnybody(Iterable<String> principals, Iterable<String> roleIds, boolean isAdmin) {
        BoxedUnit boxedUnit;
        if (!isAdmin) {
            Seq orConditions = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
            if (roleIds.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(49).append("(LOWER(assignedToTeamRoles.MEMBER_ROLE_ID) IN (").append(this.binding(roleIds)).append("))").toString(), (Iterable)roleIds.map((Function1 & Serializable)x$10 -> x$10.toLowerCase()))})));
            }
            if (principals.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(54).append("(LOWER(assignedToTeamPrincipals.PRINCIPAL_NAME) IN (").append(this.binding(principals)).append("))").toString(), (Iterable)principals.map((Function1 & Serializable)x$11 -> x$11.toLowerCase()))})));
            }
            boxedUnit = orConditions.isEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$))) : this.conditions().$plus$eq((Object)new package.Sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(425).append("releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" IN (\n             |  SELECT assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).append(" FROM ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" assignedToTeams\n             |  JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" assignedToTeamPermissions ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).append("\n             |  LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" assignedToTeamPrincipals ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append("\n             |  LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" assignedToTeamRoles ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).append("\n             |  WHERE assignedToTeamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName()).append(" = '").append(XLReleasePermissions.VIEW_RELEASE.getPermissionName()).append("' AND (").append(((IterableOnceOps)orConditions.map((Function1 & Serializable)x$12 -> x$12.sql())).mkString(" OR ")).append("))").toString())), (Iterable)orConditions.flatMap((Function1 & Serializable)x$13 -> x$13.parameters())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAnyFacets() {
        this.joinFacets();
        return this;
    }

    public TasksSqlBuilder orderByTaskId() {
        this.orderBy(new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).toString());
        return this;
    }

    private String binding(Iterable<Object> values) {
        return ((IterableOnceOps)values.toSeq().map((Function1 & Serializable)x$14 -> "?")).mkString(",");
    }

    private void joinTeams() {
        this.addJoin(new StringBuilder(33).append("JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).toString());
    }

    private void joinTeamsToTasks() {
        this.addJoin(new StringBuilder(58).append("LEFT JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).append(" AND tasks.").append(Schema.TASKS$.MODULE$.TEAM()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.name()).toString());
    }

    private void joinTeamRoles() {
        this.addJoin(new StringBuilder(43).append("LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" teamRoles ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).toString());
    }

    private void joinTeamPrincipals() {
        this.addJoin(new StringBuilder(53).append("LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" teamPrincipals ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).toString());
    }

    private void joinTeamPermissions() {
        this.addJoin(new StringBuilder(50).append("JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" teamPermissions ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).toString());
    }

    private void joinFolders() {
        this.addJoin(new StringBuilder(37).append("JOIN ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" folders ON releases.").append(Schema.RELEASES$.MODULE$.FOLDER_CI_UID()).append(" = folders.").append(Schema.FOLDERS$.MODULE$.CI_UID()).toString());
    }

    private void joinFacets() {
        this.addJoin(new StringBuilder(32).append("JOIN ").append(Schema.FACETS$.MODULE$.TABLE()).append(" facets ON tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" = facets.").append(Schema.FACETS$.MODULE$.APPLIED_TO_TASK_UID()).toString());
    }

    public TasksSqlBuilder newInstance() {
        return new TasksSqlBuilder(super.dialect());
    }

    public TasksSqlBuilder(SqlBuilder.Dialect dialect) {
        super(dialect);
    }
}

