/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding.external.internal;

import akka.Done;
import akka.Done$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressFromURIString$;
import akka.annotation.InternalApi;
import akka.cluster.ddata.DistributedData;
import akka.cluster.ddata.DistributedData$;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.LWWMap;
import akka.cluster.ddata.LWWMap$;
import akka.cluster.ddata.LWWMapKey;
import akka.cluster.ddata.ReplicatedData;
import akka.cluster.ddata.Replicator;
import akka.cluster.ddata.SelfUniqueAddress;
import akka.cluster.sharding.external.ClientTimeoutException;
import akka.cluster.sharding.external.ExternalShardAllocationStrategy;
import akka.cluster.sharding.external.ExternalShardAllocationStrategy$;
import akka.cluster.sharding.external.ShardLocations;
import akka.cluster.sharding.external.javadsl.ExternalShardAllocationClient;
import akka.dispatch.MessageDispatcher;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.JavaDurationConverters;
import akka.util.JavaDurationConverters$;
import akka.util.PrettyDuration;
import akka.util.PrettyDuration$;
import akka.util.Timeout;
import akka.util.ccompat.package;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f!\u0002\r\u001a\u0005m\u0019\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011u\u0002!\u0011!Q\u0001\nyBQ!\u0013\u0001\u0005\u0002)Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004X\u0001\u0001\u0006I!\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019i\u0006\u0001)A\u00055\"9a\f\u0001b\u0001\n\u0013y\u0006B\u00024\u0001A\u0003%\u0001\rC\u0004h\u0001\t\u0007I\u0011\u00025\t\rE\u0004\u0001\u0015!\u0003j\u0011\u001d\u0011\bA1A\u0005\fMDaA\u001f\u0001!\u0002\u0013!\bbB>\u0001\u0005\u0004%Y\u0001 \u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003~\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0007\u0011\u001d\ty\u0003\u0001C!\u0003cAq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002j\u0001!\t%a\u001b\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAF\u0001\u0011\u0005\u0013Q\u0012\u0002\"\u000bb$XM\u001d8bYNC\u0017M\u001d3BY2|7-\u0019;j_:\u001cE.[3oi&k\u0007\u000f\u001c\u0006\u00035m\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00039u\t\u0001\"\u001a=uKJt\u0017\r\u001c\u0006\u0003=}\t\u0001b\u001d5be\u0012Lgn\u001a\u0006\u0003A\u0005\nqa\u00197vgR,'OC\u0001#\u0003\u0011\t7n[1\u0014\t\u0001!#\u0006\r\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055Z\u0012\u0001C:dC2\fGm\u001d7\n\u0005=b#!H#yi\u0016\u0014h.\u00197TQ\u0006\u0014H-\u00117m_\u000e\fG/[8o\u00072LWM\u001c;\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MZ\u0012a\u00026bm\u0006$7\u000f\\\u0005\u0003_I\naa]=ti\u0016l7\u0001\u0001\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0005\nQ!Y2u_JL!\u0001P\u001d\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\tif\u0004XMT1nKB\u0011qH\u0012\b\u0003\u0001\u0012\u0003\"!\u0011\u0014\u000e\u0003\tS!a\u0011\u001c\u0002\rq\u0012xn\u001c;?\u0013\t)e%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#'\u0003\u0019a\u0014N\\5u}Q\u00191*\u0014(\u0011\u00051\u0003Q\"A\r\t\u000bU\u001a\u0001\u0019A\u001c\t\u000bu\u001a\u0001\u0019\u0001 \u0002\u00071|w-F\u0001R!\t\u0011V+D\u0001T\u0015\t!\u0016%A\u0003fm\u0016tG/\u0003\u0002W'\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n!B]3qY&\u001c\u0017\r^8s+\u0005Q\u0006C\u0001\u001d\\\u0013\ta\u0016H\u0001\u0005BGR|'OU3g\u0003-\u0011X\r\u001d7jG\u0006$xN\u001d\u0011\u0002\tM,GNZ\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111mH\u0001\u0006I\u0012\fG/Y\u0005\u0003K\n\u0014\u0011cU3mMVs\u0017.];f\u0003\u0012$'/Z:t\u0003\u0015\u0019X\r\u001c4!\u0003\u001d!\u0018.\\3pkR,\u0012!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003]\u001a\n!bY8oGV\u0014(/\u001a8u\u0013\t\u00018N\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u0011QLW.Z8vi\u0002\n!\"Y:l)&lWm\\;u+\u0005!\bCA;y\u001b\u00051(BA<\"\u0003\u0011)H/\u001b7\n\u0005e4(a\u0002+j[\u0016|W\u000f^\u0001\fCN\\G+[7f_V$\b%\u0001\u0002fGV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003\t\u0013\u0001\u00033jgB\fGo\u00195\n\u0007\u0005\u0015qPA\tNKN\u001c\u0018mZ3ESN\u0004\u0018\r^2iKJ\f1!Z2!\u0003\rYU-_\u000b\u0003\u0003\u001b\u0001b!YA\b\u0003'q\u0014bAA\tE\nIAjV,NCB\\U-\u001f\t\u0005\u0003+\t9C\u0004\u0003\u0002\u0018\u0005\rb\u0002BA\r\u0003CqA!a\u0007\u0002 9\u0019\u0011)!\b\n\u0003\tJ!\u0001I\u0011\n\u0005yy\u0012bAA\u0013;\u0005Y1\u000b[1sIJ+w-[8o\u0013\u0011\tI#a\u000b\u0003\u000fMC\u0017M\u001d3JI*\u0019\u0011QE\u000f\u0002\t-+\u0017\u0010I\u0001\u0014kB$\u0017\r^3TQ\u0006\u0014H\rT8dCRLwN\u001c\u000b\u0007\u0003g\t\u0019%a\u0012\u0011\r\u0005U\u0012qGA\u001e\u001b\u0005i\u0017bAA\u001d[\n1a)\u001e;ve\u0016\u0004B!!\u0010\u0002@5\t\u0011%C\u0002\u0002B\u0005\u0012A\u0001R8oK\"9\u0011Q\t\nA\u0002\u0005M\u0011!B:iCJ$\u0007bBA%%\u0001\u0007\u00111J\u0001\tY>\u001c\u0017\r^5p]B\u0019\u0001(!\u0014\n\u0007\u0005=\u0013HA\u0004BI\u0012\u0014Xm]:\u0002!M,Go\u00155be\u0012dunY1uS>tGCBA+\u0003K\n9\u0007\u0005\u0004\u0002X\u0005\u0005\u00141H\u0007\u0003\u00033R1A\\A.\u0015\r9\u0018Q\f\u0006\u0003\u0003?\nAA[1wC&!\u00111MA-\u0005=\u0019u.\u001c9mKRLwN\\*uC\u001e,\u0007bBA#'\u0001\u0007\u00111\u0003\u0005\b\u0003\u0013\u001a\u0002\u0019AA&\u00039\u0019\b.\u0019:e\u0019>\u001c\u0017\r^5p]N$\"!!\u001c\u0011\r\u0005U\u0012qGA8!\u0011\t\t(a\u001d\u000e\u0003mI1!!\u001e\u001c\u00059\u0019\u0006.\u0019:e\u0019>\u001c\u0017\r^5p]N\f\u0011cZ3u'\"\f'\u000f\u001a'pG\u0006$\u0018n\u001c8t)\t\tY\b\u0005\u0004\u0002X\u0005\u0005\u0014qN\u0001\u0015kB$\u0017\r^3TQ\u0006\u0014H\rT8dCRLwN\\:\u0015\t\u0005M\u0012\u0011\u0011\u0005\b\u0003\u00073\u0002\u0019AAC\u0003%awnY1uS>t7\u000fE\u0004@\u0003\u000f\u000b\u0019\"a\u0013\n\u0007\u0005%\u0005JA\u0002NCB\f\u0011c]3u'\"\f'\u000f\u001a'pG\u0006$\u0018n\u001c8t)\u0011\t)&a$\t\u000f\u0005\ru\u00031\u0001\u0002\u0012BA\u00111SAK\u0003'\tY%\u0004\u0002\u0002\\%!\u0011\u0011RA.Q\r\u0001\u0011\u0011\u0014\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011qT\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0006u%aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public final class ExternalShardAllocationClientImpl
implements akka.cluster.sharding.external.scaladsl.ExternalShardAllocationClient,
ExternalShardAllocationClient {
    private final LoggingAdapter log;
    private final ActorRef replicator;
    private final SelfUniqueAddress self;
    private final FiniteDuration timeout;
    private final Timeout askTimeout;
    private final MessageDispatcher ec;
    private final LWWMapKey<String, String> Key;

    private LoggingAdapter log() {
        return this.log;
    }

    private ActorRef replicator() {
        return this.replicator;
    }

    private SelfUniqueAddress self() {
        return this.self;
    }

    private FiniteDuration timeout() {
        return this.timeout;
    }

    private Timeout askTimeout() {
        return this.askTimeout;
    }

    private MessageDispatcher ec() {
        return this.ec;
    }

    private LWWMapKey<String, String> Key() {
        return this.Key;
    }

    @Override
    public Future<Done> updateShardLocation(String shard, Address location) {
        this.log().debug("updateShardLocation {} {} key {}", (Object)shard, (Object)location, this.Key());
        ActorRef qual$1 = package$.MODULE$.ask(this.replicator());
        Replicator.Update x$1 = Replicator.Update$.MODULE$.apply(this.Key(), (ReplicatedData)LWWMap$.MODULE$.empty(), (Replicator.WriteConsistency)Replicator.WriteLocal$.MODULE$, (Option)None$.MODULE$, (Function1 & Serializable)existing -> existing.put(this.self(), (Object)shard, (Object)location.toString()));
        Timeout x$2 = this.askTimeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Object object = x0$1;
            if (object instanceof Replicator.UpdateSuccess) {
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else if (Replicator.UpdateTimeout$.MODULE$.equals(object)) {
                future = Future$.MODULE$.failed((Throwable)new ClientTimeoutException(new StringBuilder(38).append("Unable to update shard location after ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout())))).toString()));
            } else {
                throw new MatchError(object);
            }
            return future;
        }, (ExecutionContext)this.ec());
    }

    @Override
    public CompletionStage<Done> setShardLocation(String shard, Address location) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(this.updateShardLocation(shard, location)));
    }

    @Override
    public Future<ShardLocations> shardLocations() {
        ActorRef qual$1 = package$.MODULE$.ask(this.replicator());
        Replicator.Get x$1 = new Replicator.Get(this.Key(), (Replicator.ReadConsistency)new Replicator.ReadMajority(this.timeout(), Replicator.ReadMajority$.MODULE$.apply$default$2()), Replicator.Get$.MODULE$.apply$default$3());
        Timeout x$2 = this.askTimeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).flatMap((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof Replicator.GetSuccess) {
                Replicator.GetSuccess getSuccess = (Replicator.GetSuccess)object;
                Key key = getSuccess.key();
                LWWMapKey<String, String> lWWMapKey = this.Key();
                Key key2 = key;
                if (lWWMapKey == null) {
                    if (key2 == null) return Future$.MODULE$.successful((Object)((LWWMap)getSuccess.get(this.Key())).entries().transform((Function2 & Serializable)(x$1, asStr) -> new ExternalShardAllocationStrategy.ShardLocation(AddressFromURIString$.MODULE$.apply(asStr))));
                } else if (lWWMapKey.equals((Object)key2)) {
                    return Future$.MODULE$.successful((Object)((LWWMap)getSuccess.get(this.Key())).entries().transform((Function2 & Serializable)(x$1, asStr) -> new ExternalShardAllocationStrategy.ShardLocation(AddressFromURIString$.MODULE$.apply(asStr))));
                }
            }
            if (object instanceof Replicator.NotFound) {
                return Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
            }
            if (!(object instanceof Replicator.GetFailure)) throw new MatchError(object);
            return Future$.MODULE$.failed((Throwable)new ClientTimeoutException(new StringBuilder(36).append("Unable to get shard locations after ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout())))).toString()));
        }, (ExecutionContext)this.ec()).map((Function1 & Serializable)locations -> new ShardLocations((scala.collection.immutable.Map<String, ExternalShardAllocationStrategy.ShardLocation>)locations), (ExecutionContext)this.ec());
    }

    @Override
    public CompletionStage<ShardLocations> getShardLocations() {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(this.shardLocations()));
    }

    @Override
    public Future<Done> updateShardLocations(scala.collection.immutable.Map<String, Address> locations) {
        this.log().debug("updateShardLocations {} for {}", locations, this.Key());
        ActorRef qual$1 = package$.MODULE$.ask(this.replicator());
        Replicator.Update x$1 = Replicator.Update$.MODULE$.apply(this.Key(), (ReplicatedData)LWWMap$.MODULE$.empty(), (Replicator.WriteConsistency)Replicator.WriteLocal$.MODULE$, (Option)None$.MODULE$, (Function1 & Serializable)existing -> (LWWMap)locations.foldLeft(existing, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            LWWMap acc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    acc = (LWWMap)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String shardId = (String)tuple2._1();
            Address address = (Address)tuple2._2();
            LWWMap lWWMap = acc.put(this.self(), (Object)shardId, (Object)address.toString());
            return lWWMap;
        }));
        Timeout x$2 = this.askTimeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).flatMap((Function1 & Serializable)x0$2 -> {
            Future future;
            Object object = x0$2;
            if (object instanceof Replicator.UpdateSuccess) {
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else if (Replicator.UpdateTimeout$.MODULE$.equals(object)) {
                future = Future$.MODULE$.failed((Throwable)new ClientTimeoutException(new StringBuilder(38).append("Unable to update shard location after ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout())))).toString()));
            } else {
                throw new MatchError(object);
            }
            return future;
        }, (ExecutionContext)this.ec());
    }

    @Override
    public CompletionStage<Done> setShardLocations(Map<String, Address> locations) {
        return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(this.updateShardLocations((scala.collection.immutable.Map<String, Address>)package.JavaConverters$.MODULE$.MapHasAsScala(locations).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    public ExternalShardAllocationClientImpl(ActorSystem system, String typeName) {
        this.log = Logging$.MODULE$.apply(system, ExternalShardAllocationClientImpl.class, LogSource$.MODULE$.fromAnyClass());
        this.replicator = ((DistributedData)DistributedData$.MODULE$.apply(system)).replicator();
        this.self = ((DistributedData)DistributedData$.MODULE$.apply(system)).selfUniqueAddress();
        this.timeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(system.settings().config().getDuration("akka.cluster.sharding.external-shard-allocation-strategy.client-timeout")));
        this.askTimeout = new Timeout(this.timeout().$times(2L));
        this.ec = system.dispatchers().internalDispatcher();
        this.Key = ExternalShardAllocationStrategy$.MODULE$.ddataKey(typeName);
    }
}

