/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMetering;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMeteringClientBuilder;
import com.amazonaws.services.marketplacemetering.model.AWSMarketplaceMeteringException;
import com.amazonaws.services.marketplacemetering.model.BatchMeterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.BatchMeterUsageResult;
import com.amazonaws.services.marketplacemetering.model.MeterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.MeterUsageResult;
import com.amazonaws.services.marketplacemetering.model.RegisterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.RegisterUsageResult;
import com.amazonaws.services.marketplacemetering.model.ResolveCustomerRequest;
import com.amazonaws.services.marketplacemetering.model.ResolveCustomerResult;
import com.amazonaws.services.marketplacemetering.model.transform.BatchMeterUsageRequestProtocolMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.BatchMeterUsageResultJsonUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.CustomerNotEntitledExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.DisabledApiExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.DuplicateRequestExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.ExpiredTokenExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InternalServiceErrorExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InvalidCustomerIdentifierExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InvalidEndpointRegionExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InvalidProductCodeExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InvalidPublicKeyVersionExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InvalidRegionExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InvalidTokenExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.InvalidUsageDimensionExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.MeterUsageRequestProtocolMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.MeterUsageResultJsonUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.PlatformNotSupportedExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.RegisterUsageRequestProtocolMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.RegisterUsageResultJsonUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.ResolveCustomerRequestProtocolMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.ResolveCustomerResultJsonUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.TimestampOutOfBoundsExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMarketplaceMeteringClient
extends AmazonWebServiceClient
implements AWSMarketplaceMetering {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMarketplaceMetering.class);
    private static final String DEFAULT_SIGNING_NAME = "aws-marketplace";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ExpiredTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidEndpointRegionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidEndpointRegionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PlatformNotSupportedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)PlatformNotSupportedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TimestampOutOfBoundsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TimestampOutOfBoundsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidUsageDimensionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidUsageDimensionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DuplicateRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPublicKeyVersionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidPublicKeyVersionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRegionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRegionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CustomerNotEntitledException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CustomerNotEntitledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DisabledApiException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DisabledApiExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCustomerIdentifierException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidCustomerIdentifierExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidProductCodeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidProductCodeExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMarketplaceMeteringException.class));

    @Deprecated
    public AWSMarketplaceMeteringClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSMarketplaceMeteringClientBuilder builder() {
        return AWSMarketplaceMeteringClientBuilder.standard();
    }

    AWSMarketplaceMeteringClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMarketplaceMeteringClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("metering.marketplace");
        this.setEndpoint("https://metering.marketplace.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/marketplacemetering/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/marketplacemetering/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchMeterUsageResult batchMeterUsage(BatchMeterUsageRequest request) {
        request = (BatchMeterUsageRequest)this.beforeClientExecution(request);
        return this.executeBatchMeterUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchMeterUsageResult executeBatchMeterUsage(BatchMeterUsageRequest batchMeterUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchMeterUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchMeterUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchMeterUsageRequestProtocolMarshaller(protocolFactory).marshall((BatchMeterUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchMeterUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Metering");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchMeterUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchMeterUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchMeterUsageResult batchMeterUsageResult = (BatchMeterUsageResult)response.getAwsResponse();
            return batchMeterUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public MeterUsageResult meterUsage(MeterUsageRequest request) {
        request = (MeterUsageRequest)this.beforeClientExecution(request);
        return this.executeMeterUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final MeterUsageResult executeMeterUsage(MeterUsageRequest meterUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(meterUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<MeterUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new MeterUsageRequestProtocolMarshaller(protocolFactory).marshall((MeterUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)meterUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Metering");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"MeterUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new MeterUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            MeterUsageResult meterUsageResult = (MeterUsageResult)response.getAwsResponse();
            return meterUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterUsageResult registerUsage(RegisterUsageRequest request) {
        request = (RegisterUsageRequest)this.beforeClientExecution(request);
        return this.executeRegisterUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterUsageResult executeRegisterUsage(RegisterUsageRequest registerUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterUsageRequestProtocolMarshaller(protocolFactory).marshall((RegisterUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Metering");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterUsageResult registerUsageResult = (RegisterUsageResult)response.getAwsResponse();
            return registerUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResolveCustomerResult resolveCustomer(ResolveCustomerRequest request) {
        request = (ResolveCustomerRequest)this.beforeClientExecution(request);
        return this.executeResolveCustomer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResolveCustomerResult executeResolveCustomer(ResolveCustomerRequest resolveCustomerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resolveCustomerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResolveCustomerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResolveCustomerRequestProtocolMarshaller(protocolFactory).marshall((ResolveCustomerRequest)super.beforeMarshalling((AmazonWebServiceRequest)resolveCustomerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Metering");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ResolveCustomer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResolveCustomerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResolveCustomerResult resolveCustomerResult = (ResolveCustomerResult)response.getAwsResponse();
            return resolveCustomerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

