/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.FolderVariableCreateOperation;
import com.xebialabs.xlrelease.events.FolderVariableDeleteOperation;
import com.xebialabs.xlrelease.events.FolderVariableUpdateOperation;
import com.xebialabs.xlrelease.events.GlobalVariableCreateOperation;
import com.xebialabs.xlrelease.events.GlobalVariableDeleteOperation;
import com.xebialabs.xlrelease.events.GlobalVariableUpdateOperation;
import com.xebialabs.xlrelease.events.ReleaseVariableCreateOperation;
import com.xebialabs.xlrelease.events.ReleaseVariableDeleteOperation;
import com.xebialabs.xlrelease.events.ReleaseVariableUpdateOperation;
import com.xebialabs.xlrelease.events.VariableCreateOperation;
import com.xebialabs.xlrelease.events.VariableDeleteOperation;
import com.xebialabs.xlrelease.events.VariableUpdateOperation;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariableFactory;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class ScriptVariableProcessorFactory {
    ScriptVariableProcessorFactory() {
    }

    static ScriptVariableProcessorFactory globalVariablesProcessor(CiIdService ciIdService, Task task, GlobalVariables globals) {
        return new GlobalVariablesProcessor(ciIdService, task, globals);
    }

    static ScriptVariableProcessorFactory folderVariablesProcessor(PermissionChecker permissionChecker, Task task, FolderVariables folderVariables) {
        return new FolderVariablesProcessor(permissionChecker, task, folderVariables);
    }

    static ScriptVariableProcessorFactory releaseVariableProcessor(CiIdService ciIdService, Release release) {
        return new ReleaseVariablesProcessor(ciIdService, release);
    }

    Changes.VariablesChanges processVariablesAndUpdateInContainer(Map<String, Object> contextVariables, Map<String, Variable> initialVariables) {
        Variable variable;
        Changes.VariablesChanges changes = new Changes.VariablesChanges();
        Map<String, Object> decryptedContextVariables = contextVariables.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (initialVariables.containsKey(entry.getKey()) && entry.getValue() instanceof String && ((Variable)initialVariables.get(entry.getKey())).isPassword()) {
                return PasswordEncrypter.getInstance().ensureDecrypted((String)entry.getValue());
            }
            return entry.getValue();
        }));
        Map decryptedInitialVariableValues = (Map)initialVariables.entrySet().stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(Map.Entry::getKey, e -> {
            Object value = Optional.ofNullable(((Variable)e.getValue()).getValue()).orElse(((Variable)e.getValue()).getEmptyValue());
            if (value instanceof String && ((Variable)e.getValue()).isPassword()) {
                return PasswordEncrypter.getInstance().ensureDecrypted((String)value);
            }
            return value;
        }));
        MapDifference decryptedDifference = Maps.difference(decryptedContextVariables, (Map)decryptedInitialVariableValues);
        for (Map.Entry createdVariable : decryptedDifference.entriesOnlyOnLeft().entrySet()) {
            Variable addedVariable = this.newVariable((String)createdVariable.getKey(), contextVariables.get(createdVariable.getKey()));
            changes.getOperations().add(this.createOperation(addedVariable));
            changes.getCreatedVariables().add(addedVariable);
        }
        for (Map.Entry deletedVariable : decryptedDifference.entriesOnlyOnRight().entrySet()) {
            variable = initialVariables.get(VariableHelper.withoutVariableSyntax((String)((String)deletedVariable.getKey())));
            changes.getOperations().add(this.deleteOperation(variable));
            changes.getDeletedVariables().add(variable);
        }
        for (Map.Entry updatedVariable : decryptedDifference.entriesDiffering().entrySet()) {
            variable = initialVariables.get(VariableHelper.withoutVariableSyntax((String)((String)updatedVariable.getKey())));
            Variable original = CiCloneHelper.cloneCi(variable);
            variable.setUntypedValue(contextVariables.get(updatedVariable.getKey()));
            changes.getOperations().add(this.updateOperation(original, variable));
            changes.getUpdatedVariables().add(variable);
        }
        return changes;
    }

    abstract Variable newVariable(String var1, Object var2);

    abstract VariableUpdateOperation updateOperation(Variable var1, Variable var2);

    abstract VariableCreateOperation createOperation(Variable var1);

    abstract VariableDeleteOperation deleteOperation(Variable var1);

    private static class FolderVariablesProcessor
    extends ScriptVariableProcessorFactory {
        private PermissionChecker permissionChecker;
        private Task task;
        private FolderVariables folderVariables;

        public FolderVariablesProcessor(PermissionChecker permissionChecker, Task task, FolderVariables folderVariables) {
            this.permissionChecker = permissionChecker;
            this.task = task;
            this.folderVariables = folderVariables;
        }

        @Override
        Variable newVariable(String key, Object value) {
            String folderId = this.task.getRelease().findFolderId();
            this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId);
            Variable variable = VariableFactory.createVariableByValueType((String)key, (Object)value, (boolean)false, (boolean)true);
            variable.setFolderId(folderId);
            variable = this.folderVariables.addVariable(variable);
            return variable;
        }

        @Override
        VariableUpdateOperation updateOperation(Variable original, Variable updated) {
            this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, updated.getFolderId());
            return new FolderVariableUpdateOperation(original, updated, this.task.getId());
        }

        @Override
        VariableCreateOperation createOperation(Variable newVariable) {
            return new FolderVariableCreateOperation(newVariable, this.task.getId());
        }

        @Override
        VariableDeleteOperation deleteOperation(Variable deletedVariable) {
            this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, deletedVariable.getFolderId());
            return new FolderVariableDeleteOperation(deletedVariable, this.task.getId());
        }
    }

    private static class GlobalVariablesProcessor
    extends ScriptVariableProcessorFactory {
        private CiIdService ciIdService;
        private String taskId;
        private GlobalVariables globalVariables;

        GlobalVariablesProcessor(CiIdService ciIdService, Task task, GlobalVariables globalVariables) {
            this.ciIdService = ciIdService;
            this.globalVariables = globalVariables;
            this.taskId = task.getId();
        }

        @Override
        Variable newVariable(String key, Object value) {
            Variable variable = this.globalVariables.addVariable(VariableFactory.createVariableByValueType((String)key, (Object)value, (boolean)false, (boolean)true));
            VariablePersistenceHelper.fixUpVariableIds(this.globalVariables.getId(), this.globalVariables.getVariables(), this.ciIdService);
            return variable;
        }

        @Override
        VariableUpdateOperation updateOperation(Variable original, Variable updated) {
            return new GlobalVariableUpdateOperation(original, updated, this.taskId);
        }

        @Override
        VariableCreateOperation createOperation(Variable newVariable) {
            return new GlobalVariableCreateOperation(newVariable, this.taskId);
        }

        @Override
        VariableDeleteOperation deleteOperation(Variable deletedVariable) {
            return new GlobalVariableDeleteOperation(deletedVariable, this.taskId);
        }
    }

    private static class ReleaseVariablesProcessor
    extends ScriptVariableProcessorFactory {
        private CiIdService ciIdService;
        private Release release;

        ReleaseVariablesProcessor(CiIdService ciIdService, Release release) {
            this.ciIdService = ciIdService;
            this.release = release;
        }

        @Override
        Variable newVariable(String key, Object value) {
            Variable variable = VariableFactory.createVariableByValueType((String)key, (Object)value, (boolean)false, (boolean)false);
            this.release.checkVariableCanBeAdded(variable);
            VariablePersistenceHelper.fixUpVariableIds(this.release.getId(), Collections.singletonList(variable), this.ciIdService);
            return variable;
        }

        @Override
        VariableUpdateOperation updateOperation(Variable original, Variable updated) {
            return new ReleaseVariableUpdateOperation(original, updated);
        }

        @Override
        VariableCreateOperation createOperation(Variable newVariable) {
            return new ReleaseVariableCreateOperation(newVariable);
        }

        @Override
        VariableDeleteOperation deleteOperation(Variable deletedVariable) {
            return new ReleaseVariableDeleteOperation(deletedVariable);
        }
    }
}

