/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp.credentials;

import com.google.common.collect.Sets;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.gcp.credentials.DefaultCredentialsGcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ServiceAccountFileGcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ServiceAccountJsonGcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ServiceAccountPkcs8GcpCredentialFactory;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public enum GcpCredentialsType {
    Default((Set)Sets.newHashSet((Object[])new String[]{"projectId", "clientEmail"})){

        @Override
        protected GcpCredentialFactory doCreate(ConnectionOptions options) {
            return new DefaultCredentialsGcpCredentialFactory((String)options.get("projectId"), (String)options.get("clientEmail"));
        }

        @Override
        public String createKey(ConnectionOptions options) {
            return this.composeKey((String)options.get("clientEmail"), options);
        }
    }
    ,
    ServiceAccountJsonFile((Set)Sets.newHashSet((Object[])new String[]{"credentialsFile"})){

        @Override
        protected GcpCredentialFactory doCreate(ConnectionOptions options) {
            return new ServiceAccountFileGcpCredentialFactory(new File((String)options.get("credentialsFile")));
        }

        @Override
        public String createKey(ConnectionOptions options) {
            return this.composeKey((String)options.get("credentialsFile"), options);
        }
    }
    ,
    ServiceAccountJson((Set)Sets.newHashSet((Object[])new String[]{"credentialsJson"})){

        @Override
        protected GcpCredentialFactory doCreate(ConnectionOptions options) {
            return new ServiceAccountJsonGcpCredentialFactory((String)options.get("credentialsJson"));
        }

        @Override
        public String createKey(ConnectionOptions options) {
            return this.composeKey((String)options.get("credentialsJson"), options);
        }
    }
    ,
    ServiceAccountPkcs8((Set)Sets.newHashSet((Object[])new String[]{"projectId", "clientId", "clientEmail", "privateKeyPkcs8", "privateKeyId"})){

        @Override
        protected GcpCredentialFactory doCreate(ConnectionOptions options) {
            String projectId = (String)options.get("projectId");
            String clientId = (String)options.get("clientId");
            String clientEmail = (String)options.get("clientEmail");
            String privateKeyPkcs8 = (String)options.get("privateKeyPkcs8");
            String privateKeyId = (String)options.get("privateKeyId");
            String scopesString = (String)options.getOptional("scopes");
            List<String> scopes = Collections.emptyList();
            if (scopesString != null) {
                scopes = Arrays.asList(scopesString.split(","));
            }
            URI tokenServerUri = URI.create((String)options.getOptional("tokenServerUri"));
            String serviceAccountUser = (String)options.getOptional("serviceAccountUser");
            return new ServiceAccountPkcs8GcpCredentialFactory(projectId, clientId, clientEmail, privateKeyPkcs8, privateKeyId, scopes, null, tokenServerUri, serviceAccountUser);
        }

        @Override
        public String createKey(ConnectionOptions options) {
            return this.composeKey((String)options.get("privateKeyId"), options);
        }
    };

    private final Set<String> requiredOptions;

    private GcpCredentialsType(Set<String> requiredOptions) {
        this.requiredOptions = requiredOptions;
    }

    public void validateOptions(ConnectionOptions options) {
        for (String requiredOption : this.requiredOptions) {
            if (options.containsKey(requiredOption)) continue;
            throw new IllegalArgumentException("For gcp credentials type " + this.name() + " is missing required option " + requiredOption);
        }
    }

    protected abstract GcpCredentialFactory doCreate(ConnectionOptions var1);

    protected String composeKey(String keySuffix, ConnectionOptions options) {
        return this.name() + ":" + keySuffix + ":" + options.get("username", "");
    }

    public GcpCredentialFactory createGcpCredentialFactory(ConnectionOptions options) {
        this.validateOptions(options);
        return this.doCreate(options);
    }

    public abstract String createKey(ConnectionOptions var1);

    public static GcpCredentialsType resolve(ConnectionOptions options) {
        return options.getEnum("gcpCredentialsType", GcpCredentialsType.class);
    }
}

