/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.configuration.AbstractConfigurationContainer;

public class LiquibaseProConfiguration
extends AbstractConfigurationContainer {
    public static final String LIQUIBSE_PRO_CONFIG_BASE = "liquibase.pro";
    public static final String MARK_UNUSED_NOT_DROP = "markUnusedNotDrop";
    public static final String DROP_PUBLIC_SYNONYMS_KEY = "synonyms.drop.public";
    public static final String INLINE_SQL_KEY = "sql.inline";

    public LiquibaseProConfiguration() {
        super(LIQUIBSE_PRO_CONFIG_BASE);
        this.getContainer().addProperty(MARK_UNUSED_NOT_DROP, Boolean.class).setDescription("If a column would be dropped in a diffChangeLog, call markUnused instead if set to true").setDefaultValue(Boolean.FALSE);
        this.getContainer().addProperty(DROP_PUBLIC_SYNONYMS_KEY, Boolean.class).setDescription("If false, do not drop public synonyms in diffChangeLog/dropAll").setDefaultValue(Boolean.TRUE);
        this.getContainer().addProperty(INLINE_SQL_KEY, Boolean.class).setDescription("If true, generate changeSets with SQL-based changes inlined instead of saving them to an external file").setDefaultValue(Boolean.FALSE);
    }

    public LiquibaseProConfiguration setMarkUnusedNotDrop(boolean bl2) {
        this.getContainer().setValue(MARK_UNUSED_NOT_DROP, bl2);
        return this;
    }

    public boolean getMarkUnusedNotDrop() {
        return this.getContainer().getValue(MARK_UNUSED_NOT_DROP, Boolean.class);
    }

    public LiquibaseProConfiguration setDropPublicSynonyms(boolean bl2) {
        this.getContainer().setValue(DROP_PUBLIC_SYNONYMS_KEY, bl2);
        return this;
    }

    public boolean getDropPublicSynonyms() {
        return this.getContainer().getValue(DROP_PUBLIC_SYNONYMS_KEY, Boolean.class);
    }

    public LiquibaseProConfiguration setInlineSql(boolean bl2) {
        this.getContainer().setValue(INLINE_SQL_KEY, bl2);
        return this;
    }

    public boolean getInlineSql() {
        return this.getContainer().getValue(INLINE_SQL_KEY, Boolean.class);
    }
}

