/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.rmi.client.ClientNode;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;

public class ClientVersionHistory
extends ClientNode
implements VersionHistory {
    private RemoteVersionHistory remote;

    public ClientVersionHistory(Session session, RemoteVersionHistory remote, LocalAdapterFactory factory) {
        super(session, remote, factory);
        this.remote = remote;
    }

    public Version getRootVersion() throws RepositoryException {
        try {
            return this.getFactory().getVersion(this.getSession(), this.remote.getRootVersion());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        try {
            return this.getFactory().getVersionIterator(this.getSession(), this.remote.getAllVersions());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Version getVersion(String versionName) throws VersionException, RepositoryException {
        try {
            return this.getFactory().getVersion(this.getSession(), this.remote.getVersion(versionName));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Version getVersionByLabel(String label) throws RepositoryException {
        try {
            return this.getFactory().getVersion(this.getSession(), this.remote.getVersionByLabel(label));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void addVersionLabel(String versionName, String label, boolean moveLabel) throws VersionException, RepositoryException {
        try {
            this.remote.addVersionLabel(versionName, label, moveLabel);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void removeVersionLabel(String label) throws VersionException, RepositoryException {
        try {
            this.remote.removeVersionLabel(label);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        try {
            return this.remote.hasVersionLabel(label);
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        try {
            String versionUUID = version.getUUID();
            return this.remote.hasVersionLabel(versionUUID, label);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String[] getVersionLabels() throws RepositoryException {
        try {
            return this.remote.getVersionLabels();
        }
        catch (RemoteException ex) {
            return new String[0];
        }
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        try {
            String versionUUID = version.getUUID();
            return this.remote.getVersionLabels(versionUUID);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void removeVersion(String versionName) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        try {
            this.remote.removeVersion(versionName);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String getVersionableUUID() throws RepositoryException {
        try {
            return this.remote.getVersionableUUID();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

