/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\r\u0015h\u0001B\u001d;\u0001\u0015C\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005%\"A\u0011\f\u0001BC\u0002\u0013\u0005!\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003\\\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011%\u0004!Q1A\u0005\u0002)D\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t_\u0002\u0011)\u0019!C\u0001a\"Aq\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005y\u0001\t\u0015\r\u0011\"\u0001z\u0011!i\bA!A!\u0002\u0013Q\b\u0002\u0003@\u0001\u0005\u000b\u0007I\u0011A@\t\u0015\u0005E\u0001A!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\u0014\u0001\u0011)\u0019!C\u0001\u0003+A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBAa\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003\u0003\u0004A\u0011AAf\u0011\u001d\t)\u000e\u0001C\u0001\u0003/Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002\"\u0003B'\u0001E\u0005I\u0011\u0001B(\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KBqAa\u001d\u0001\t\u0003\u0011)\bC\u0005\u0003\u0016\u0002\t\n\u0011\"\u0001\u0003\u0018\"9!1\u0014\u0001\u0005\u0002\tu\u0005b\u0002B:\u0001\u0011\u0005!1\u0017\u0005\b\u0005{\u0003A\u0011\u0001B`\u0011%\u0011Y\rAI\u0001\n\u0003\u0011y\u0005C\u0004\u0003N\u0002!\tAa4\t\u000f\te\u0007\u0001\"\u0001\u0003\\\"9!\u0011\u001c\u0001\u0005\u0002\t=\bb\u0002B}\u0001\u0011\u0005!1 \u0005\b\u0005s\u0004A\u0011AB\u0002\u0011\u001d\u0019Y\u0001\u0001C\u0001\u0007\u001bAqaa\u0006\u0001\t\u0013\u0019I\u0002C\u0004\u00044\u0001!Ia!\u000e\t\u000f\re\u0002\u0001\"\u0001\u0004<!91\u0011\b\u0001\u0005\u0002\r}\u0002bBB$\u0001\u0011\u00051\u0011\n\u0005\b\u0007\u001b\u0002A\u0011BB(\u0011\u001d\u0019i\u0006\u0001C\u0005\u0007?Bqaa\u0019\u0001\t\u0003\u0019)\u0007C\u0005\u0004n\u0001\t\n\u0011\"\u0001\u0003P!91q\u000e\u0001\u0005\n\rE\u0004bBB@\u0001\u0011%1\u0011\u0011\u0005\b\u0007w\u0003A\u0011BB_\u0011%\u0019)\rAI\u0001\n\u0013\u00199\rC\u0004\u0004L\u0002!\tf!4\u0003-\u0011+G.\u001b<fef\u0004\u0016\r\u001e;fe:\u001cVM\u001d<jG\u0016T!a\u000f\u001f\u0002\u000fM,'O^5dK*\u0011QHP\u0001\tI\u0016d\u0017N^3ss*\u0011q\bQ\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0011\"\u0002\u0013a,'-[1mC\n\u001c(\"A\"\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011E\n\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001b:k\u0011AO\u0005\u0003\u001fj\u0012A\u0003R3mSZ,'/_*feZL7-Z+uS2\u001c\u0018A\u00053fY&4XM]=SKB|7/\u001b;pef,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+r\n!B]3q_NLGo\u001c:z\u0013\t9FK\u0001\nEK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\u0018a\u00053fY&4XM]=SKB|7/\u001b;pef\u0004\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\t1\f\u0005\u0002]=6\tQL\u0003\u0002V}%\u0011q,\u0018\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\naB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001d!\t!g-D\u0001f\u0015\tYd(\u0003\u0002hK\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002WB\u0011A\r\\\u0005\u0003[\u0016\u00141bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u0005\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AOP\u0001\u0003I\nL!A^:\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u0005iam\u001c7eKJ\u001cVM\u001d<jG\u0016,\u0012A\u001f\t\u0003InL!\u0001`3\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u000391w\u000e\u001c3feN+'O^5dK\u0002\n1B]8mKN+'O^5dKV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003!\u0019XmY;sSRL(bAA\u0006\u0001\u0006AA-\u001a9m_fLG/\u0003\u0003\u0002\u0010\u0005\u0015!a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\fAB]8mKN+'O^5dK\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;q\u0014AB3wK:$8/\u0003\u0003\u0002\"\u0005m!!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011\b\t\u0003\u001b\u0002AQ\u0001U\tA\u0002ICQ!W\tA\u0002mCQ!Y\tA\u0002\rDQ![\tA\u0002-DQa\\\tA\u0002EDQ\u0001_\tA\u0002iDaA`\tA\u0002\u0005\u0005\u0001bBA\n#\u0001\u0007\u0011q\u0003\u0015\u0004#\u0005u\u0002\u0003BA \u0003+j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u000bC:tw\u000e^1uS>t'\u0002BA$\u0003\u0013\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002L\u00055\u0013!\u00022fC:\u001c(\u0002BA(\u0003#\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003'\n1a\u001c:h\u0013\u0011\t9&!\u0011\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AC4fiB\u000bG\u000f^3s]R!\u0011QLA6!\u0011\ty&a\u001a\u000e\u0005\u0005\u0005$bA\u001f\u0002d)\u0019\u0011Q\r \u0002\r\u0011|W.Y5o\u0013\u0011\tI'!\u0019\u0003\u0011\u0011+G.\u001b<fefDq!!\u001c\u0013\u0001\u0004\ty'A\u0005qCR$XM\u001d8JIB!\u0011\u0011OA@\u001d\u0011\t\u0019(a\u001f\u0011\u0007\u0005U\u0004*\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010#\u0002\rq\u0012xn\u001c;?\u0013\r\ti\bS\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00151\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0004\nK\u0002\u0013\u0003\u000f\u0003B!!#\u0002\u00166\u0011\u00111\u0012\u0006\u0005\u0003\u0007\niI\u0003\u0003\u0002\u0010\u0006E\u0015aB7fiJL7m\u001d\u0006\u0004\u0003'\u0013\u0015\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005]\u00151\u0012\u0002\u0006)&lW\rZ\u0001\u0016O\u0016$\b+\u0019;uKJt')_%e\u001fJ$\u0016\u000e\u001e7f)\u0011\ti&!(\t\u000f\u0005}5\u00031\u0001\u0002p\u0005\u0001\u0002/\u0019;uKJt\u0017\nZ(s)&$H.\u001a\u0015\u0004'\u0005\u001d\u0015AF3ySN$8\u000fU1ui\u0016\u0014hnV5uQRKG\u000f\\3\u0015\r\u0005\u001d\u0016QVAY!\r9\u0015\u0011V\u0005\u0004\u0003WC%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003_#\u0002\u0019AA8\u0003\tIG\rC\u0004\u00024R\u0001\r!a\u001c\u0002\u000bQLG\u000f\\3)\u0007Q\t9)A\u0007fq&\u001cHo\u001d)biR,'O\u001c\u000b\u0005\u0003O\u000bY\fC\u0004\u0002>V\u0001\r!a\u001c\u0002\u0015\u0011,G.\u001b<fefLE\rK\u0002\u0016\u0003\u000f\u000bQc\u0019:fCR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002^\u0005\u0015\u0007bBAd-\u0001\u0007\u0011QL\u0001\ba\u0006$H/\u001a:oQ\r1\u0012q\u0011\u000b\u0007\u0003;\ni-a4\t\u000f\u0005\u001dw\u00031\u0001\u0002^!9\u0011\u0011[\fA\u0002\u0005\u001d\u0016AE:i_VdGMU3tKR\u0004\u0016\r\u001e;fe:D3aFAD\u0003U)\b\u000fZ1uK\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:$B!!\u0018\u0002Z\"9\u00111\u001c\rA\u0002\u0005u\u0013aB;qI\u0006$X\r\u001a\u0015\u00041\u0005\u001d\u0015!\u00063fY\u0016$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u0003G\fI\u000fE\u0002H\u0003KL1!a:I\u0005\u0011)f.\u001b;\t\u000f\u00055\u0014\u00041\u0001\u0002p!\u001a\u0011$a\"\u00021\u0011,\b\u000f\\5dCR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0004\u0002^\u0005E\u00181\u001f\u0005\b\u0003[R\u0002\u0019AA8\u0011\u001d\t)P\u0007a\u0001\u0003o\fa\u0001]1sC6\u001c\b\u0003BA}\u0005\u000fi!!a?\u000b\t\u0005u\u0018q`\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0005\u0003\u0011\u0019!\u0001\u0002wc)\u0019!Q\u0001 \u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\n\u0005m(\u0001\u0007#va2L7-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]\"\u001a!$a\"\u00023\r\u0014X-\u0019;f\t\u0016d\u0017N^3ss\u001a\u0013x.\u001c)biR,'O\u001c\u000b\u0007\u0003;\u0012\tBa\u0005\t\u000f\u000554\u00041\u0001\u0002p!9!QC\u000eA\u0002\t]\u0011A\u00039be\u0006lW\r^3sgB!\u0011\u0011 B\r\u0013\u0011\u0011Y\"a?\u0003\u001d\r\u0013X-\u0019;f\t\u0016d\u0017N^3ss\"\u001a1$a\"\u0002\u001dM,\u0017M]2i!\u0006$H/\u001a:ogRA!1\u0005B\u001a\u0005{\u00119\u0005\u0005\u0004\u0003&\t=\u0012QL\u0007\u0003\u0005OQAA!\u000b\u0003,\u0005!Q\u000f^5m\u0015\t\u0011i#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0019\u0005O\u0011A\u0001T5ti\"9!Q\u0007\u000fA\u0002\t]\u0012a\u00024jYR,'o\u001d\t\u0005\u0003s\u0014I$\u0003\u0003\u0003<\u0005m(A\u0006#fY&4XM]=QCR$XM\u001d8GS2$XM]:\t\u000f\t}B\u00041\u0001\u0003B\u0005!\u0001/Y4f!\ra&1I\u0005\u0004\u0005\u000bj&\u0001\u0002)bO\u0016D\u0011B!\u0013\u001d!\u0003\u0005\r!a*\u0002%\u0015tgm\u001c:dKB+'/\\5tg&|gn\u001d\u0015\u00049\u0005\u001d\u0015\u0001G:fCJ\u001c\u0007\u000eU1ui\u0016\u0014hn\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u000b\u0016\u0005\u0003O\u0013\u0019f\u000b\u0002\u0003VA!!q\u000bB0\u001b\t\u0011IF\u0003\u0003\u0003\\\tu\u0013!C;oG\",7m[3e\u0015\r\t\u0019\u0005S\u0005\u0005\u0005C\u0012IFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011bZ3u'R\fw-Z:\u0015\t\t\u001d$q\u000e\t\u0007\u0005K\u0011yC!\u001b\u0011\t\u0005}#1N\u0005\u0005\u0005[\n\tGA\u0003Ti\u0006<W\rC\u0004\u0002ny\u0001\r!a\u001c)\u0007y\t9)\u0001\u0005bI\u0012\u001cF/Y4f)!\u0011IGa\u001e\u0003z\tu\u0004bBA7?\u0001\u0007\u0011q\u000e\u0005\b\u0005wz\u0002\u0019\u0001B5\u0003\u0015\u0019H/Y4f\u0011%\u0011yh\bI\u0001\u0002\u0004\u0011\t)\u0001\u0005q_NLG/[8o!\u0019\u0011)Ca!\u0003\b&!!Q\u0011B\u0014\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003\u0002BE\u0005\u001fk!Aa#\u000b\t\t5%1F\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0012\n-%aB%oi\u0016<WM\u001d\u0015\u0004?\u0005\u001d\u0015AE1eIN#\u0018mZ3%I\u00164\u0017-\u001e7uIM*\"A!'+\t\t\u0005%1K\u0001\u0010C\u0012$7\u000b^1hK\n+Go^3f]RQ!\u0011\u000eBP\u0005C\u0013\u0019K!,\t\u000f\u00055\u0014\u00051\u0001\u0002p!9!1P\u0011A\u0002\t%\u0004b\u0002BSC\u0001\u0007!qU\u0001\u0007E\u00164wN]3\u0011\u000b\u001d\u0013I+a\u001c\n\u0007\t-\u0006J\u0001\u0004PaRLwN\u001c\u0005\b\u0005_\u000b\u0003\u0019\u0001BT\u0003\u0015\tg\r^3sQ\r\t\u0013q\u0011\u000b\t\u0005S\u0012)La.\u0003:\"9\u0011q\u0019\u0012A\u0002\u0005u\u0003b\u0002B>E\u0001\u0007!\u0011\u000e\u0005\b\u0005\u007f\u0012\u0003\u0019\u0001BAQ\r\u0011\u0013qQ\u0001\fkB$\u0017\r^3Ti\u0006<W\r\u0006\u0005\u0003j\t\u0005'1\u0019Bc\u0011\u001d\tig\ta\u0001\u0003_Bq!a7$\u0001\u0004\u0011I\u0007C\u0005\u0003H\u000e\u0002\n\u00111\u0001\u0002(\u0006IaM]8n\u0005\u0006$8\r\u001b\u0015\u0004G\u0005\u001d\u0015!F;qI\u0006$Xm\u0015;bO\u0016$C-\u001a4bk2$HeM\u0001\fI\u0016dW\r^3Ti\u0006<W\r\u0006\u0004\u0002d\nE'1\u001b\u0005\b\u0003[*\u0003\u0019AA8\u0011\u001d\u0011).\na\u0001\u0003_\nqa\u001d;bO\u0016LE\rK\u0002&\u0003\u000f\u000bQ\"\u00193e)J\fgn]5uS>tG\u0003\u0003Bo\u0005G\u0014)O!;\u0011\t\u0005}#q\\\u0005\u0005\u0005C\f\tG\u0001\u0006Ue\u0006t7/\u001b;j_:Dq!!\u001c'\u0001\u0004\ty\u0007C\u0004\u0003h\u001a\u0002\r!a\u001c\u0002\u001dM$\u0018mZ3JI>\u0013H+\u001b;mK\"9!1\u001e\u0014A\u0002\tu\u0017A\u0003;sC:\u001c\u0018\u000e^5p]\"\u001aa%a\"\u0015\u0011\tu'\u0011\u001fBz\u0005kDq!a2(\u0001\u0004\ti\u0006C\u0004\u0003h\u001e\u0002\r!a\u001c\t\u000f\t-x\u00051\u0001\u0003^\"\u001aq%a\"\u0002!U\u0004H-\u0019;f)J\fgn]5uS>tGC\u0002Bo\u0005{\u0014y\u0010C\u0004\u0002n!\u0002\r!a\u001c\t\u000f\u0005m\u0007\u00061\u0001\u0003^\"\u001a\u0001&a\"\u0015\r\tu7QAB\u0004\u0011\u001d\t9-\u000ba\u0001\u0003;Bq!a7*\u0001\u0004\u0011i\u000eK\u0002*\u0003\u000f\u000b\u0001\u0003Z3mKR,GK]1og&$\u0018n\u001c8\u0015\r\u0005\r8qBB\t\u0011\u001d\tiG\u000ba\u0001\u0003_Bqaa\u0005+\u0001\u0004\ty'\u0001\u0007ue\u0006t7/\u001b;j_:LE\rK\u0002+\u0003\u000f\u000b\u0001dZ3oKJ\fG/\u001a+ji2,\u0017J\u001a(fG\u0016\u001c8/\u0019:z)\u0019\t\u0019oa\u0007\u0004\u001e!9!1P\u0016A\u0002\t%\u0004bBB\u0010W\u0001\u00071\u0011E\u0001\u0007gR\fw-Z:\u0011\r\r\r2Q\u0006B5\u001d\u0011\u0019)c!\u000b\u000f\t\u0005U4qE\u0005\u0002\u0013&\u001911\u0006%\u0002\u000fA\f7m[1hK&!1qFB\u0019\u0005\r\u0019V-\u001d\u0006\u0004\u0007WA\u0015AD2iK\u000e\\\u0017j\u001d)biR,'O\u001c\u000b\u0005\u0003G\u001c9\u0004\u0003\u0004>Y\u0001\u0007\u0011QL\u0001\u0010m\u0006d\u0017\u000eZ1uKB\u000bG\u000f^3s]R!\u00111]B\u001f\u0011\u0019iT\u00061\u0001\u0002^Q1\u00111]B!\u0007\u0007Ba!\u0010\u0018A\u0002\u0005u\u0003bBB#]\u0001\u0007\u0011qU\u0001\fo&$\b.U;fe&,7/\u0001\u0013wC2LG-\u0019;f'R\fw-Z:B]\u0012$&/\u00198tSRLwN\\:B]\u0012LE/Z7t)\u0011\t\u0019oa\u0013\t\u000f\u0005\u001dw\u00061\u0001\u0002^\u0005\u0001b/\u00197jI\u0006$XMT3x'R\fw-\u001a\u000b\t\u0003G\u001c\tfa\u0015\u0004V!91q\u0004\u0019A\u0002\r\u0005\u0002b\u0002B>a\u0001\u0007!\u0011\u000e\u0005\b\u0005\u007f\u0002\u0004\u0019AB,!\r95\u0011L\u0005\u0004\u00077B%aA%oi\u00069b/\u00197jI\u0006$Xm\u0015;bO\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003G\u001c\t\u0007C\u0004\u0003|E\u0002\rA!\u001b\u0002\u0019I,7/\u001a;QCR$XM\u001d8\u0015\r\u0005\r8qMB5\u0011\u001d\t9M\ra\u0001\u0003;B\u0011ba\u001b3!\u0003\u0005\r!a*\u0002\u0017\u0019|'oY3OK^LEm]\u0001\u0017e\u0016\u001cX\r\u001e)biR,'O\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005q!/Z:fi\u000e{g\u000eZ5uS>tGCBAr\u0007g\u001a)\bC\u0004\u0003lR\u0002\rA!8\t\u000f\r]D\u00071\u0001\u0004z\u0005I1m\u001c8eSRLwN\u001c\t\u0005\u0003?\u001aY(\u0003\u0003\u0004~\u0005\u0005$!C\"p]\u0012LG/[8o\u0003I9WM\\3sCR,wJ]+qI\u0006$X-\u00133\u0016\t\r\r51\u0014\u000b\u000b\u0007\u000b\u001bik!-\u00046\u000eeF\u0003BA8\u0007\u000fC\u0011b!#6\u0003\u0003\u0005\u001daa#\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0004\u000e\u000eM5qS\u0007\u0003\u0007\u001fS1a!%I\u0003\u001d\u0011XM\u001a7fGRLAa!&\u0004\u0010\nA1\t\\1tgR\u000bw\r\u0005\u0003\u0004\u001a\u000emE\u0002\u0001\u0003\b\u0007;+$\u0019ABP\u0005\u0005!\u0016\u0003BBQ\u0007O\u00032aRBR\u0013\r\u0019)\u000b\u0013\u0002\b\u001d>$\b.\u001b8h!\r95\u0011V\u0005\u0004\u0007WC%aA!os\"91qV\u001bA\u0002\u0005=\u0014AC3ySN$\u0018N\\4JI\"911W\u001bA\u0002\u0005=\u0014aC8mIB\u000b'/\u001a8u\u0013\u0012Dqaa.6\u0001\u0004\ty'A\u0006oK^\u0004\u0016M]3oi&#\u0007bBB6k\u0001\u0007\u0011qU\u0001\u0015C2\u0014X-\u00193z\u000bbL7\u000f^:CsRKG\u000f\\3\u0015\r\u0005\u001d6qXBb\u0011\u001d\u0019\tM\u000ea\u0001\u0003_\nA\u0002]1ui\u0016\u0014h\u000eV5uY\u0016D\u0011\"!\u001c7!\u0003\u0005\r!a\u001c\u0002=\u0005d'/Z1es\u0016C\u0018n\u001d;t\u0005f$\u0016\u000e\u001e7fI\u0011,g-Y;mi\u0012\u0012TCABeU\u0011\tyGa\u0015\u0002!\rDWmY6JgV\u0003H-\u0019;bE2,GCBAr\u0007\u001f\u001c\u0019\u000eC\u0004\u0004Rb\u0002\r!!\u0018\u0002!\u0015D\u0018n\u001d;j]\u001e$U\r\\5wKJL\b\"CBkqA\u0005\t\u0019AA8\u0003\u0019\t7\r^5p]\"\u001a\u0001a!7\u0011\t\rm7\u0011]\u0007\u0003\u0007;TAaa8\u0002N\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\r\r8Q\u001c\u0002\b'\u0016\u0014h/[2f\u0001")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validate(Delivery delivery, boolean withQueries) {
        DeliveryServiceUtils.validate$(this, delivery, withQueries);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        return this.createDeliveryPattern(pattern, true);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern, boolean shouldResetPattern) {
        Checks.checkNotNull((Object)pattern, (String)"Release delivery");
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append(pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        if (shouldResetPattern) {
            this.resetPattern(pattern, this.resetPattern$default$2());
        }
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append(updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$"));
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])c))).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1)));
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(Integer.toString(++orderNumber)).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        if (parameters.getFolderId() != null) {
            delivery.setFolderId(parameters.getFolderId());
        }
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page, boolean enforcePermissions) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.deliveryRepository().search((AbstractDeliveryFilters)filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (scala.collection.immutable.Seq<Permission>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())), enforcePermissions)).asJava();
    }

    public boolean searchPatterns$default$3() {
        return true;
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Optional<Integer> position) {
        return this.addStage(this.getPattern(patternId), stage, position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Timed
    public Stage addStageBetween(String patternId, Stage stage, Option<String> before, Option<String> after) {
        Stage stage2;
        Delivery pattern = this.getPattern(patternId);
        Option beforeIndex = before.map(DeliveryPatternService.getStageIndex$1(pattern));
        Option afterIndex = after.map(DeliveryPatternService.getStageIndex$1(pattern));
        if (before.isDefined()) {
            if (after.isDefined()) {
                if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != BoxesRunTime.unboxToInt((Object)beforeIndex.get()) - 1) throw new LogFriendlyConcurrentModificationException("Unable to add stage between %s and %s, because these two stages are not neighbors any more", new Object[]{after.get(), before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)beforeIndex.get()))));
                return stage2;
            } else {
                if (BoxesRunTime.unboxToInt((Object)beforeIndex.get()) != 0) throw new LogFriendlyConcurrentModificationException("Unable to add first stage before %s, because it is not first stage of delivery pattern any more", new Object[]{before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(0)));
            }
            return stage2;
        } else if (after.isDefined()) {
            if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != pattern.getStages().size() - 1) throw new LogFriendlyConcurrentModificationException("Unable to add last stage after %s, because it is not last stage of the delivery pattern any more", new Object[]{after.get()});
            stage2 = this.addStage(pattern, stage, Optional.empty());
            return stage2;
        } else {
            if (!pattern.getStages().isEmpty()) throw new LogFriendlyConcurrentModificationException("Unable to add first stage to the pattern, because pattern is not empty any more", new Object[0]);
            stage2 = this.addStage(pattern, stage, Optional.empty());
        }
        return stage2;
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage, Optional<Integer> position) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Adding new stage '").append(stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        this.generateTitleIfNecessary(stage, (scala.collection.immutable.Seq<Stage>)stages);
        Integer realPosition = position.orElse(Predef$.MODULE$.int2Integer(stages.size()));
        this.validateStageProperties(stage);
        this.validateNewStage((scala.collection.immutable.Seq<Stage>)stages, stage, Predef$.MODULE$.Integer2int(realPosition));
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, Predef$.MODULE$.Integer2int(realPosition));
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    public Optional<Integer> addStage$default$3() {
        return Optional.empty();
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated, boolean fromBatch) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(31).append("Updating stage '").append(updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStageProperties(updated);
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        if (!fromBatch) {
            this.validateNewStage((scala.collection.immutable.Seq<Stage>)((scala.collection.immutable.Seq)stages.diff((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Stage[]{original})))), updated, stages.indexOf((Object)original));
        }
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    public boolean updateStage$default$3() {
        return false;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Adding new transition '").append(transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        if (stage.getTransition() != null) {
            throw new LogFriendlyConcurrentModificationException("There is already a transition named '%s' associated with stage '%s'", new Object[]{stage.getTransition().getTitle(), stage.getTitle()});
        }
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)x$2));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Updating transition '").append(updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)updated, (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)x$3));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, scala.collection.immutable.Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)stage, (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    public void validatePattern(Delivery delivery) {
        this.validatePattern(delivery, true);
    }

    public void validatePattern(Delivery delivery, boolean withQueries) {
        block0: {
            this.validate(delivery, withQueries);
            this.checkIsPattern(delivery);
            Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
            if (!withQueries) break block0;
            Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
        }
    }

    public void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties((Stage)stage);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTitle());
        Buffer duplicateStages = (Buffer)((SeqOps)stageTitles.diff((Seq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getTrackedItems()).asScala().map((Function1 & Serializable)x$6 -> x$6.getTitle().toLowerCase());
        Buffer duplicateItems = (Buffer)((SeqOps)trackedItemTitles.diff((Seq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(scala.collection.immutable.Seq<Stage> stages, Stage stage, int position) {
        Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        Checks.checkArgument((!stages.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Stage stage) {
        Checks.checkNotNull((Object)stage, (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    public void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    public boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds((AbstractDeliveryFilters)filters).exists((Function1 & Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$addStageBetween$2(String folderlessId$1, Tuple2 t) {
        return Ids.getName((String)((BaseConfigurationItem)t._1()).getId()).equals(folderlessId$1);
    }

    public static final /* synthetic */ int $anonfun$addStageBetween$1(Delivery pattern$2, String id) {
        String folderlessId = Ids.getName((String)id);
        return ((Tuple2)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(pattern$2.getStages()).asScala().zipWithIndex()).find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$addStageBetween$2(folderlessId, t))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyConcurrentModificationException("Stage %s not found", new Object[]{id});
        }))._2$mcI$sp();
    }

    private static final Function1 getStageIndex$1(Delivery pattern$2) {
        return (Function1 & Serializable)id -> BoxesRunTime.boxToInteger((int)DeliveryPatternService.$anonfun$addStageBetween$1(pattern$2, id));
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
        Statics.releaseFence();
    }
}

