/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.Release;
import java.util.List;

public class ReleaseFilter {
    private String searchFilter;
    private Predicate<Release> matchesTitle = new Predicate<Release>(){

        public boolean apply(Release release) {
            return Strings.nullToEmpty((String)release.getTitle()).toLowerCase().contains(ReleaseFilter.this.searchFilter.toLowerCase());
        }
    };
    private Predicate<Release> matchesTags = new Predicate<Release>(){

        public boolean apply(Release release) {
            for (String tag : release.getTags()) {
                if (!tag.toLowerCase().equals(ReleaseFilter.this.searchFilter.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    };

    public ReleaseFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public List<Release> filter(List<Release> releases) {
        if (Strings.isNullOrEmpty((String)this.searchFilter)) {
            return releases;
        }
        Predicate predicate = Predicates.alwaysTrue();
        if (!Strings.isNullOrEmpty((String)this.searchFilter)) {
            predicate = Predicates.or(this.matchesTitle, this.matchesTags);
        }
        return Lists.newArrayList((Iterable)Collections2.filter(releases, (Predicate)predicate));
    }
}

