/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding.internal;

import akka.annotation.InternalApi;
import akka.cluster.sharding.internal.ActiveEntities;
import akka.cluster.sharding.internal.AdmissionFilter;
import akka.cluster.sharding.internal.AdmissionOptimizer;
import akka.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import akka.cluster.sharding.internal.IdleCheck;
import akka.cluster.sharding.internal.LimitBasedEntityPassivationStrategy;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005=c!\u0002\u000f\u001e\u0005\r*\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011I\u0002!\u0011!Q\u0001\nMB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0017\u0001A\u0002\u0013%\u0011\fC\u0004[\u0001\u0001\u0007I\u0011B.\t\r\u0005\u0004\u0001\u0015)\u00038\u0011\u001d\u0011\u0007\u00011A\u0005\n\rDq\u0001\u001a\u0001A\u0002\u0013%Q\r\u0003\u0004h\u0001\u0001\u0006K\u0001\f\u0005\bQ\u0002\u0001\r\u0011\"\u0003d\u0011\u001dI\u0007\u00011A\u0005\n)Da\u0001\u001c\u0001!B\u0013a\u0003\"B7\u0001\t\u0013q\u0007\"B8\u0001\t\u0003\u0002\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u00037\u0001A\u0011KA\u000f\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\u000e\u0001\t\u0003\ni\u0002C\u0004\u00028\u0001!I!!\u000f\t\r\u0005}\u0002\u0001\"\u0003o\u0005\t\u001au.\u001c9pg&$X-\u00128uSRL\b+Y:tSZ\fG/[8o'R\u0014\u0018\r^3hs*\u0011adH\u0001\tS:$XM\u001d8bY*\u0011\u0001%I\u0001\tg\"\f'\u000fZ5oO*\u0011!eI\u0001\bG2,8\u000f^3s\u0015\u0005!\u0013\u0001B1lW\u0006\u001c\"\u0001\u0001\u0014\u0011\u0005\u001dBS\"A\u000f\n\u0005%j\"a\t'j[&$()Y:fI\u0016sG/\u001b;z!\u0006\u001c8/\u001b<bi&|gn\u0015;sCR,w-_\u0001\rS:LG/[1m\u0019&l\u0017\u000e^\u0002\u0001!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\rIe\u000e^\u0001\u0007o&tGm\\<\u0011\u0005\u001d\"\u0014BA\u001b\u001e\u00059\t5\r^5wK\u0016sG/\u001b;jKN\fq#\u001b8ji&\fGnV5oI><\bK]8q_J$\u0018n\u001c8\u0011\u00055B\u0014BA\u001d/\u0005\u0019!u.\u001e2mK\u00069R.\u001b8j[Vlw+\u001b8e_^\u0004&o\u001c9peRLwN\\\u0001\u0018[\u0006D\u0018.\\;n/&tGm\\<Qe>\u0004xN\u001d;j_:\fqb^5oI><x\n\u001d;j[&TXM\u001d\t\u0003OyJ!aP\u000f\u0003%\u0005#W.[:tS>tw\n\u001d;j[&TXM]\u0001\u0010C\u0012l\u0017n]:j_:4\u0015\u000e\u001c;feB\u0011qEQ\u0005\u0003\u0007v\u0011q\"\u00113nSN\u001c\u0018n\u001c8GS2$XM]\u0001\u0005[\u0006Lg.A\u0005jI2,7\t[3dWB\u0019QfR%\n\u0005!s#AB(qi&|g\u000e\u0005\u0002(\u0015&\u00111*\b\u0002\n\u0013\u0012dWm\u00115fG.\fa\u0001P5oSRtDC\u0003(P!F\u00136\u000bV+W/B\u0011q\u0005\u0001\u0005\u0006U)\u0001\r\u0001\f\u0005\u0006e)\u0001\ra\r\u0005\u0006m)\u0001\ra\u000e\u0005\u0006u)\u0001\ra\u000e\u0005\u0006w)\u0001\ra\u000e\u0005\u0006y)\u0001\r!\u0010\u0005\u0006\u0001*\u0001\r!\u0011\u0005\u0006\t*\u0001\ra\r\u0005\u0006\u000b*\u0001\rAR\u0001\u0011o&tGm\\<Qe>\u0004xN\u001d;j_:,\u0012aN\u0001\u0015o&tGm\\<Qe>\u0004xN\u001d;j_:|F%Z9\u0015\u0005q{\u0006CA\u0017^\u0013\tqfF\u0001\u0003V]&$\bb\u00021\r\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0014!E<j]\u0012|w\u000f\u0015:pa>\u0014H/[8oA\u0005Yq/\u001b8e_^d\u0015.\\5u+\u0005a\u0013aD<j]\u0012|w\u000fT5nSR|F%Z9\u0015\u0005q3\u0007b\u00021\u0010\u0003\u0003\u0005\r\u0001L\u0001\ro&tGm\\<MS6LG\u000fI\u0001\n[\u0006Lg\u000eT5nSR\fQ\"\\1j]2KW.\u001b;`I\u0015\fHC\u0001/l\u0011\u001d\u0001'#!AA\u00021\n!\"\\1j]2KW.\u001b;!\u0003=\u0019\u0017\r\\2vY\u0006$X\rT5nSR\u001cH#\u0001/\u0002\u001b\u0015tG/\u001b;z)>,8\r[3e)\t\t\b\u0010\u0005\u0002sk:\u0011qe]\u0005\u0003iv\t\u0011$\u00128uSRL\b+Y:tSZ\fG/[8o'R\u0014\u0018\r^3hs&\u0011ao\u001e\u0002\u0012!\u0006\u001c8/\u001b<bi\u0016,e\u000e^5uS\u0016\u001c(B\u0001;\u001e\u0011\u0015IX\u00031\u0001{\u0003\tIG\rE\u0002|\u0003\u001fq1\u0001`A\u0006\u001d\ri\u0018\u0011\u0002\b\u0004}\u0006\u001dabA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007Y\u0013A\u0002\u001fs_>$h(C\u0001%\u0013\t\u00113%\u0003\u0002!C%\u0019\u0011QB\u0010\u0002\u0017MC\u0017M\u001d3SK\u001eLwN\\\u0005\u0005\u0003#\t\u0019B\u0001\u0005F]RLG/_%e\u0015\r\tiaH\u0001\u0011K:$\u0018\u000e^=UKJl\u0017N\\1uK\u0012$2\u0001XA\r\u0011\u0015Ih\u00031\u0001{\u0003y\u0001\u0018m]:jm\u0006$X-\u00128uSRLWm](o\u0019&l\u0017\u000e^+qI\u0006$X\rF\u0001r\u0003E\u00198\r[3ek2,G-\u00138uKJ4\u0018\r\\\u000b\u0003\u0003G\u0001B!L$\u0002&A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005=b&\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\r\u0002*\tqa)\u001b8ji\u0016$UO]1uS>t\u0017AD5oi\u0016\u0014h/\u00197QCN\u001cX\rZ\u0001\u0011[\u0006L(-Z!e[&$Hk\\'bS:$2!]A\u001e\u0011\u0019\tiD\u0007a\u0001c\u0006Q1-\u00198eS\u0012\fG/Z:\u0002\u0017\u0005$\u0017\r\u001d;XS:$wn\u001e\u0015\u0004\u0001\u0005\r\u0003\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%3%\u0001\u0006b]:|G/\u0019;j_:LA!!\u0014\u0002H\tY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public final class CompositeEntityPassivationStrategy
extends LimitBasedEntityPassivationStrategy {
    private final ActiveEntities window;
    private final double minimumWindowProportion;
    private final double maximumWindowProportion;
    private final AdmissionOptimizer windowOptimizer;
    private final AdmissionFilter admissionFilter;
    private final ActiveEntities main;
    private final Option<IdleCheck> idleCheck;
    private double windowProportion;
    private int windowLimit;
    private int mainLimit;

    private double windowProportion() {
        return this.windowProportion;
    }

    private void windowProportion_$eq(double x$1) {
        this.windowProportion = x$1;
    }

    private int windowLimit() {
        return this.windowLimit;
    }

    private void windowLimit_$eq(int x$1) {
        this.windowLimit = x$1;
    }

    private int mainLimit() {
        return this.mainLimit;
    }

    private void mainLimit_$eq(int x$1) {
        this.mainLimit = x$1;
    }

    private void calculateLimits() {
        this.windowLimit_$eq((int)(this.windowProportion() * (double)this.perShardLimit()));
        this.mainLimit_$eq(this.perShardLimit() - this.windowLimit());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<String> entityTouched(String id) {
        void var2_2;
        Seq<String> seq;
        this.admissionFilter.update(id);
        if (this.window.isActive(id)) {
            this.windowOptimizer.recordActive();
            seq = this.window.update(id);
        } else if (this.main.isActive(id)) {
            this.windowOptimizer.recordActive();
            seq = this.main.update(id);
        } else {
            this.windowOptimizer.recordPassive();
            seq = this.maybeAdmitToMain(this.window.update(id));
        }
        Seq<String> passivated = seq;
        this.adaptWindow();
        return var2_2;
    }

    @Override
    public void entityTerminated(String id) {
        this.window.remove(id);
        this.main.remove(id);
    }

    @Override
    public Seq<String> passivateEntitiesOnLimitUpdate() {
        this.calculateLimits();
        this.windowOptimizer.updateLimit(this.perShardLimit());
        this.admissionFilter.updateCapacity(this.perShardLimit());
        return (Seq)this.maybeAdmitToMain(this.window.updateLimit(this.windowLimit())).$plus$plus(this.main.updateLimit(this.mainLimit()));
    }

    @Override
    public Option<FiniteDuration> scheduledInterval() {
        return this.idleCheck.map((Function1 & Serializable)x$5 -> x$5.interval());
    }

    @Override
    public Seq<String> intervalPassed() {
        return (Seq)this.idleCheck.fold((Function0 & Serializable)() -> EntityPassivationStrategy$PassivateEntities$.MODULE$.none(), (Function1 & Serializable)idle2 -> (Seq)$this.window.removeIdle(idle2.timeout()).$plus$plus($this.main.removeIdle(idle2.timeout())));
    }

    private Seq<String> maybeAdmitToMain(Seq<String> candidates) {
        Seq seq;
        if (candidates.nonEmpty()) {
            ObjectRef passivated = ObjectRef.create(EntityPassivationStrategy$PassivateEntities$.MODULE$.none());
            candidates.foreach((Function1 & Serializable)candidate -> {
                CompositeEntityPassivationStrategy.$anonfun$maybeAdmitToMain$1(this, passivated, candidate);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)passivated.elem;
        } else {
            seq = EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
        }
        return seq;
    }

    private void adaptWindow() {
        block2: {
            double adjustment = this.windowOptimizer.calculateAdjustment();
            if (adjustment == 0.0) break block2;
            this.windowProportion_$eq(package$.MODULE$.max(this.minimumWindowProportion, package$.MODULE$.min(this.maximumWindowProportion, this.windowProportion() + adjustment)));
            this.calculateLimits();
            if (adjustment > 0.0) {
                this.window.updateLimit(this.windowLimit());
                this.main.updateLimit(this.mainLimit()).foreach((Function1 & Serializable)id -> $this.window.update((String)id));
            } else {
                this.main.updateLimit(this.mainLimit());
                this.window.updateLimit(this.windowLimit()).foreach((Function1 & Serializable)id -> $this.main.update((String)id));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$maybeAdmitToMain$1(CompositeEntityPassivationStrategy $this, ObjectRef passivated$1, String candidate) {
        if ($this.main.size() >= $this.mainLimit()) {
            String string = $this.main.select();
            String string2 = (String)OptionVal.Some$.MODULE$.unapply((Object)string);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)string2)) {
                BoxedUnit boxedUnit;
                String selected = (String)OptionVal$.MODULE$.get$extension((Object)string2);
                if ($this.admissionFilter.admit(candidate, selected)) {
                    passivated$1.elem = (Seq)((Seq)passivated$1.elem).$plus$plus($this.main.update(candidate));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    passivated$1.elem = (Seq)((Seq)passivated$1.elem).$colon$plus((Object)candidate);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                passivated$1.elem = (Seq)((Seq)passivated$1.elem).$plus$plus($this.main.update(candidate));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            passivated$1.elem = (Seq)((Seq)passivated$1.elem).$plus$plus($this.main.update(candidate));
        }
    }

    public CompositeEntityPassivationStrategy(int initialLimit, ActiveEntities window, double initialWindowProportion, double minimumWindowProportion, double maximumWindowProportion, AdmissionOptimizer windowOptimizer, AdmissionFilter admissionFilter, ActiveEntities main, Option<IdleCheck> idleCheck) {
        this.window = window;
        this.minimumWindowProportion = minimumWindowProportion;
        this.maximumWindowProportion = maximumWindowProportion;
        this.windowOptimizer = windowOptimizer;
        this.admissionFilter = admissionFilter;
        this.main = main;
        this.idleCheck = idleCheck;
        super(initialLimit);
        this.windowProportion = initialWindowProportion;
        this.windowLimit = 0;
        this.mainLimit = 0;
        this.calculateLimits();
        window.updateLimit(this.windowLimit());
        main.updateLimit(this.mainLimit());
    }
}

