/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class Saml2LoginBeanDefinitionParserUtils {
    private static final String ATT_RELYING_PARTY_REGISTRATION_REPOSITORY_REF = "relying-party-registration-repository-ref";
    private static final String ATT_AUTHENTICATION_REQUEST_REPOSITORY_REF = "authentication-request-repository-ref";
    private static final String ATT_AUTHENTICATION_REQUEST_RESOLVER_REF = "authentication-request-resolver-ref";
    private static final String ATT_AUTHENTICATION_CONVERTER = "authentication-converter-ref";

    private Saml2LoginBeanDefinitionParserUtils() {
    }

    static BeanMetadataElement getRelyingPartyRegistrationRepository(Element element) {
        String relyingPartyRegistrationRepositoryRef = element.getAttribute(ATT_RELYING_PARTY_REGISTRATION_REPOSITORY_REF);
        if (StringUtils.hasText((String)relyingPartyRegistrationRepositoryRef)) {
            return new RuntimeBeanReference(relyingPartyRegistrationRepositoryRef);
        }
        return new RuntimeBeanReference(RelyingPartyRegistrationRepository.class);
    }

    static BeanMetadataElement getAuthenticationRequestRepository(Element element) {
        String authenticationRequestRepositoryRef = element.getAttribute(ATT_AUTHENTICATION_REQUEST_REPOSITORY_REF);
        if (StringUtils.hasText((String)authenticationRequestRepositoryRef)) {
            return new RuntimeBeanReference(authenticationRequestRepositoryRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(HttpSessionSaml2AuthenticationRequestRepository.class).getBeanDefinition();
    }

    static BeanMetadataElement getAuthenticationRequestResolver(Element element) {
        String authenticationRequestContextResolver = element.getAttribute(ATT_AUTHENTICATION_REQUEST_RESOLVER_REF);
        if (StringUtils.hasText((String)authenticationRequestContextResolver)) {
            return new RuntimeBeanReference(authenticationRequestContextResolver);
        }
        return null;
    }

    static BeanMetadataElement createDefaultAuthenticationRequestResolver(BeanMetadataElement relyingPartyRegistrationRepository) {
        AbstractBeanDefinition defaultRelyingPartyRegistrationResolver = BeanDefinitionBuilder.rootBeanDefinition(DefaultRelyingPartyRegistrationResolver.class).addConstructorArgValue((Object)relyingPartyRegistrationRepository).getBeanDefinition();
        return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.saml2.provider.service.web.authentication.OpenSaml4AuthenticationRequestResolver").addConstructorArgValue((Object)defaultRelyingPartyRegistrationResolver).getBeanDefinition();
    }

    static BeanDefinition createAuthenticationProvider() {
        return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider").getBeanDefinition();
    }

    static BeanMetadataElement getAuthenticationConverter(Element element) {
        String authenticationConverter = element.getAttribute(ATT_AUTHENTICATION_CONVERTER);
        if (StringUtils.hasText((String)authenticationConverter)) {
            return new RuntimeBeanReference(authenticationConverter);
        }
        return null;
    }

    static BeanDefinition createDefaultAuthenticationConverter(BeanMetadataElement relyingPartyRegistrationRepository) {
        AbstractBeanDefinition resolver = BeanDefinitionBuilder.rootBeanDefinition(DefaultRelyingPartyRegistrationResolver.class).addConstructorArgValue((Object)relyingPartyRegistrationRepository).getBeanDefinition();
        return BeanDefinitionBuilder.rootBeanDefinition(Saml2AuthenticationTokenConverter.class).addConstructorArgValue((Object)resolver).getBeanDefinition();
    }
}

