/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.typed.internal.receptionist;

import java.io.Serializable;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.internal.receptionist.AbstractServiceKey;
import org.apache.pekko.actor.typed.internal.receptionist.ReceptionistBehaviorProvider;
import org.apache.pekko.actor.typed.internal.receptionist.ReceptionistMessages;
import org.apache.pekko.actor.typed.receptionist.Receptionist;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$;
import org.apache.pekko.actor.typed.scaladsl.package;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.ORMultiMap;
import org.apache.pekko.cluster.ddata.ORMultiMap$;
import org.apache.pekko.cluster.ddata.ORMultiMapKey;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.typed.internal.receptionist.ClusterReceptionist;
import org.apache.pekko.cluster.typed.internal.receptionist.ClusterReceptionist$PruneTombstonesTick$;
import org.apache.pekko.cluster.typed.internal.receptionist.ClusterReceptionist$RemoveTick$;
import org.apache.pekko.cluster.typed.internal.receptionist.ServiceRegistry;
import org.apache.pekko.cluster.typed.internal.receptionist.ServiceRegistry$;
import org.apache.pekko.cluster.typed.internal.receptionist.ShardedServiceRegistry;
import org.apache.pekko.cluster.typed.internal.receptionist.ShardedServiceRegistry$;
import org.apache.pekko.util.TypedMultiMap;
import org.apache.pekko.util.TypedMultiMap$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Deadline;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class ClusterReceptionist$
implements ReceptionistBehaviorProvider {
    public static final ClusterReceptionist$ MODULE$ = new ClusterReceptionist$();
    private static final ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> EmptyORMultiMap = ORMultiMap$.MODULE$.empty();
    private static final String name = "clusterReceptionist";

    public final ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> EmptyORMultiMap() {
        return EmptyORMultiMap;
    }

    public String name() {
        return name;
    }

    public Behavior<Receptionist.Command> behavior() {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)ctx -> {
            ctx.setLoggerName(ClusterReceptionist.class);
            return Behaviors$.MODULE$.withTimers((Function1 & Serializable)timers -> {
                ClusterReceptionist.Setup setup = new ClusterReceptionist.Setup((ActorContext<Receptionist.Command>)ctx);
                ShardedServiceRegistry initialRegistry = ShardedServiceRegistry$.MODULE$.apply(setup.settings().distributedKeyCount()).addNode(setup.selfUniqueAddress());
                ActorRef replicatorMessageAdapter = ctx.messageAdapter((Function1 & Serializable)x0$1 -> {
                    Replicator.ReplicatorMessage replicatorMessage = x0$1;
                    if (replicatorMessage instanceof Replicator.Changed) {
                        Replicator.Changed changed = (Replicator.Changed)replicatorMessage;
                        return new ClusterReceptionist.ChangeFromReplicator((ORMultiMapKey)changed.key(), (ORMultiMap)changed.dataValue());
                    }
                    throw new IllegalArgumentException();
                }, ClassTag$.MODULE$.apply(Replicator.ReplicatorMessage.class));
                initialRegistry.allDdataKeys().foreach((Function1 & Serializable)key -> {
                    ClusterReceptionist$.$anonfun$behavior$4(replicatorMessageAdapter, setup, key);
                    return BoxedUnit.UNIT;
                });
                ActorRef clusterEventMessageAdapter = ctx.messageAdapter((Function1 & Serializable)x0$2 -> {
                    ClusterEvent.ClusterDomainEvent clusterDomainEvent = x0$2;
                    if (clusterDomainEvent instanceof ClusterEvent.MemberJoined) {
                        ClusterEvent.MemberJoined memberJoined = (ClusterEvent.MemberJoined)clusterDomainEvent;
                        Member member = memberJoined.member();
                        return new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    }
                    if (clusterDomainEvent instanceof ClusterEvent.MemberWeaklyUp) {
                        ClusterEvent.MemberWeaklyUp memberWeaklyUp = (ClusterEvent.MemberWeaklyUp)clusterDomainEvent;
                        Member member = memberWeaklyUp.member();
                        return new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    }
                    if (clusterDomainEvent instanceof ClusterEvent.MemberUp) {
                        ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)clusterDomainEvent;
                        Member member = memberUp.member();
                        return new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    }
                    if (clusterDomainEvent instanceof ClusterEvent.MemberRemoved) {
                        ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)clusterDomainEvent;
                        Member member = memberRemoved.member();
                        return new ClusterReceptionist.NodeRemoved(member.uniqueAddress());
                    }
                    if (clusterDomainEvent instanceof ClusterEvent.UnreachableMember) {
                        ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)clusterDomainEvent;
                        Member member = unreachableMember.member();
                        return new ClusterReceptionist.NodeUnreachable(member.uniqueAddress());
                    }
                    if (clusterDomainEvent instanceof ClusterEvent.ReachableMember) {
                        ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)clusterDomainEvent;
                        Member member = reachableMember.member();
                        return new ClusterReceptionist.NodeReachable(member.uniqueAddress());
                    }
                    if (ClusterEvent.ClusterShuttingDown$.MODULE$.equals(clusterDomainEvent)) {
                        return new ClusterReceptionist.NodeRemoved(setup.cluster().selfUniqueAddress());
                    }
                    throw new IllegalStateException(new StringBuilder(50).append("Unexpected ClusterDomainEvent ").append(clusterDomainEvent).append(". Please report bug.").toString());
                }, ClassTag$.MODULE$.apply(ClusterEvent.ClusterDomainEvent.class));
                setup.cluster().subscribe(package.TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(clusterEventMessageAdapter)), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.InitialStateAsEvents$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberJoined.class, ClusterEvent.MemberWeaklyUp.class, ClusterEvent.MemberUp.class, ClusterEvent.MemberRemoved.class, ClusterEvent.ReachabilityEvent.class, ClusterEvent.ClusterShuttingDown$.MODULE$.getClass()}));
                timers.startTimerWithFixedDelay((Object)ClusterReceptionist$RemoveTick$.MODULE$, setup.settings().pruningInterval());
                timers.startTimerWithFixedDelay((Object)ClusterReceptionist$PruneTombstonesTick$.MODULE$, setup.keepTombstonesFor().$div(24L));
                ClusterReceptionist.State initialState = new ClusterReceptionist.State(initialRegistry, Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), (TypedMultiMap<AbstractServiceKey, ActorRef>)TypedMultiMap$.MODULE$.empty());
                return MODULE$.behavior(setup, initialState);
            });
        });
    }

    public Behavior<Receptionist.Command> behavior(ClusterReceptionist.Setup setup, ClusterReceptionist.State state) {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)ctx -> Behaviors$.MODULE$.receive((Function2 & Serializable)(x$7, msg) -> {
            Receptionist.Command command = msg;
            if (command instanceof ClusterReceptionist.InternalCommand) {
                ClusterReceptionist.InternalCommand internalCommand = (ClusterReceptionist.InternalCommand)command;
                return ClusterReceptionist$.onInternalCommand$1(internalCommand, setup, state, ctx);
            }
            if (command != null) {
                Receptionist.Command command2 = command;
                return ClusterReceptionist$.onCommand$1(command2, setup, ctx, state);
            }
            if (command == null) {
                return Behaviors$.MODULE$.unhandled();
            }
            throw new MatchError((Object)command);
        }));
    }

    public static final /* synthetic */ void $anonfun$behavior$4(ActorRef replicatorMessageAdapter$1, ClusterReceptionist.Setup setup$1, ORMultiMapKey key) {
        Replicator.Subscribe x$1 = new Replicator.Subscribe((Key)key, package.TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(replicatorMessageAdapter$1)));
        org.apache.pekko.actor.ActorRef x$2 = setup$1.replicator().$bang$default$2((Object)x$1);
        setup$1.replicator().$bang((Object)x$1, x$2);
    }

    private static final boolean isLeader$1(ClusterReceptionist.Setup setup$2) {
        return setup$2.cluster().state().leader().contains((Object)setup$2.cluster().selfAddress());
    }

    private static final boolean isOnRemovedNode$1(ClusterReceptionist.Entry entry, Set addresses$1, ClusterReceptionist.Setup setup$2) {
        return addresses$1.apply((Object)entry.uniqueAddress(setup$2.selfUniqueAddress().address()));
    }

    private static final boolean isOld$1(ClusterReceptionist.Entry entry, long now$1, ClusterReceptionist.Setup setup$2) {
        return now$1 - entry.createdTimestamp() >= setup$2.settings().pruneRemovedOlderThan().toMillis();
    }

    public static final /* synthetic */ boolean $anonfun$behavior$8(boolean onlyRemoveOldEntries$1, Set addresses$1, ClusterReceptionist.Setup setup$2, long now$1, ClusterReceptionist.Entry entry) {
        return ClusterReceptionist$.isOnRemovedNode$1(entry, addresses$1, setup$2) && (!onlyRemoveOldEntries$1 || ClusterReceptionist$.isOld$1(entry, now$1, setup$2));
    }

    public static final /* synthetic */ void $anonfun$behavior$10(ClusterReceptionist.Setup setup$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            ORMultiMapKey ddataKey = (ORMultiMapKey)tuple2._1();
            Map removalForKey = (Map)tuple2._2();
            Replicator.Update x$1 = Replicator.Update$.MODULE$.apply((Key)ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator.Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.removeAll$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, (Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>)removalForKey, setup$2.selfNodeAddress())));
            org.apache.pekko.actor.ActorRef x$2 = setup$2.replicator().$bang$default$2((Object)x$1);
            setup$2.replicator().$bang((Object)x$1, x$2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void nodesRemoved$1(Set addresses, boolean onlyRemoveOldEntries, ClusterReceptionist.Setup setup$2, ClusterReceptionist.State state$1, ActorContext ctx$2) {
        long now = System.currentTimeMillis();
        Map removals = (Map)state$1.registry().allServices().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    ServiceKey key = (ServiceKey)tuple22._1();
                    Set entries = (Set)tuple22._2();
                    Set removedEntries = (Set)entries.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterReceptionist$.$anonfun$behavior$8(onlyRemoveOldEntries, addresses, setup$2, now, entry)));
                    if (removedEntries.isEmpty()) {
                        return acc;
                    }
                    return (Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)removedEntries));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (removals.nonEmpty()) {
            if (ctx$2.log().isDebugEnabled()) {
                package.LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node(s) removed [{}], updating registry removing entries: [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), addresses.mkString(","), removals.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        AbstractServiceKey key = (AbstractServiceKey)tuple2._1();
                        Set entries = (Set)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.asServiceKey().id()), (Object)entries.mkString("[", ", ", "]"));
                    }
                    throw new MatchError((Object)tuple2);
                }).mkString(",")}));
            }
            Map<ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry>, Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>> removalsPerDdataKey = state$1.registry().entriesPerDdataKey((Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>)removals);
            removalsPerDdataKey.foreach((Function1 & Serializable)x0$3 -> {
                ClusterReceptionist$.$anonfun$behavior$10(setup$2, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final void reachabilityChanged$1(Set keysForNode, ClusterReceptionist.State newState, ClusterReceptionist.Setup setup$2) {
        ClusterReceptionist$.notifySubscribers$1(keysForNode, false, newState, setup$2);
    }

    public static final /* synthetic */ void $anonfun$behavior$12(ClusterReceptionist.State newState$1, ClusterReceptionist.Setup setup$2, boolean servicesWereAddedOrRemoved$1, AbstractServiceKey changedKey) {
        ServiceKey serviceKey = changedKey.asServiceKey();
        Set subscribers = newState$1.subscriptions().get((Object)changedKey);
        if (subscribers.nonEmpty()) {
            Tuple2 tuple2 = newState$1.activeActorRefsFor(serviceKey, setup$2.selfUniqueAddress());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Set reachable = (Set)tuple2._1();
            Set all = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)reachable, (Object)all);
            Set reachable2 = (Set)tuple22._1();
            Set all2 = (Set)tuple22._2();
            ReceptionistMessages.Listing listing = ReceptionistMessages.Listing$.MODULE$.apply(serviceKey, reachable2, all2, servicesWereAddedOrRemoved$1);
            subscribers.foreach((Function1 & Serializable)x$3 -> {
                ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(x$3), (Object)listing);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final void notifySubscribers$1(Set changedKeys, boolean servicesWereAddedOrRemoved, ClusterReceptionist.State newState, ClusterReceptionist.Setup setup$2) {
        changedKeys.foreach((Function1 & Serializable)changedKey -> {
            ClusterReceptionist$.$anonfun$behavior$12(newState, setup$2, servicesWereAddedOrRemoved, changedKey);
            return BoxedUnit.UNIT;
        });
    }

    private static final Behavior onCommand$1(Receptionist.Command cmd, ClusterReceptionist.Setup setup$2, ActorContext ctx$2, ClusterReceptionist.State state$1) {
        Receptionist.Command command = cmd;
        if (command instanceof ReceptionistMessages.Register) {
            ReceptionistMessages.Register register = (ReceptionistMessages.Register)command;
            ServiceKey key = register.key();
            ActorRef serviceInstance = register.serviceInstance();
            Option maybeReplyTo = register.replyTo();
            if (serviceInstance.path().address().hasLocalScope()) {
                Option option;
                ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), System.currentTimeMillis());
                package.LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Actor was registered: [{}] [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), key, entry}));
                if (!state$1.servicesPerActor().contains((Object)serviceInstance)) {
                    ctx$2.watchWith(serviceInstance, new ClusterReceptionist.LocalServiceActorTerminated(serviceInstance));
                }
                if ((option = maybeReplyTo) instanceof Some) {
                    Some some = (Some)option;
                    ActorRef replyTo = (ActorRef)some.value();
                    ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), (Object)ReceptionistMessages.Registered$.MODULE$.apply(key, serviceInstance));
                } else if (None$.MODULE$.equals(option)) {
                } else {
                    throw new MatchError((Object)option);
                }
                ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key);
                Replicator.Update x$1 = Replicator.Update$.MODULE$.apply(ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator.Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.addBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key, entry, setup$2.selfNodeAddress())));
                org.apache.pekko.actor.ActorRef x$2 = setup$2.replicator().$bang$default$2((Object)x$1);
                setup$2.replicator().$bang((Object)x$1, x$2);
                return MODULE$.behavior(setup$2, state$1.addLocalService(serviceInstance, key));
            }
            ctx$2.log().error("ClusterReceptionist [{}] - Register of non-local [{}] is not supported", (Object)serviceInstance);
            return Behaviors$.MODULE$.same();
        }
        if (command instanceof ReceptionistMessages.Deregister) {
            ReceptionistMessages.Deregister deregister = (ReceptionistMessages.Deregister)command;
            ServiceKey key = deregister.key();
            ActorRef serviceInstance = deregister.serviceInstance();
            Option maybeReplyTo = deregister.replyTo();
            if (serviceInstance.path().address().hasLocalScope()) {
                Option option;
                ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), 0L);
                package.LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Unregister actor: [{}] [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), key.asServiceKey().id(), entry}));
                ClusterReceptionist.State newState = state$1.removeLocalService(serviceInstance, key, setup$2.newTombstoneDeadline());
                if (!newState.servicesPerActor().contains((Object)serviceInstance)) {
                    ctx$2.unwatch(serviceInstance);
                }
                if ((option = maybeReplyTo) instanceof Some) {
                    Some some = (Some)option;
                    ActorRef replyTo = (ActorRef)some.value();
                    ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), (Object)ReceptionistMessages.Deregistered$.MODULE$.apply(key, serviceInstance));
                } else if (None$.MODULE$.equals(option)) {
                } else {
                    throw new MatchError((Object)option);
                }
                ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key);
                Replicator.Update x$3 = Replicator.Update$.MODULE$.apply(ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator.Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.removeBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key, entry, setup$2.selfNodeAddress())));
                org.apache.pekko.actor.ActorRef x$4 = setup$2.replicator().$bang$default$2((Object)x$3);
                setup$2.replicator().$bang((Object)x$3, x$4);
                return MODULE$.behavior(setup$2, newState);
            }
            ctx$2.log().error("ClusterReceptionist [{}] - Unregistering non-local [{}] is not supported", (Object)serviceInstance);
            return Behaviors$.MODULE$.same();
        }
        if (command instanceof ReceptionistMessages.Find) {
            ReceptionistMessages.Find find = (ReceptionistMessages.Find)command;
            ServiceKey key = find.key();
            ActorRef replyTo = find.replyTo();
            Tuple2 tuple2 = state$1.activeActorRefsFor(key, setup$2.selfUniqueAddress());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Set reachable = (Set)tuple2._1();
            Set all = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)reachable, (Object)all);
            Set reachable2 = (Set)tuple22._1();
            Set all2 = (Set)tuple22._2();
            ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), (Object)ReceptionistMessages.Listing$.MODULE$.apply(key.asServiceKey(), reachable2, all2, true));
            return Behaviors$.MODULE$.same();
        }
        if (command instanceof ReceptionistMessages.Subscribe) {
            ReceptionistMessages.Subscribe subscribe = (ReceptionistMessages.Subscribe)command;
            ServiceKey key = subscribe.key();
            ActorRef subscriber = subscribe.subscriber();
            if (subscriber.path().address().hasLocalScope()) {
                ctx$2.watchWith(subscriber, new ClusterReceptionist.SubscriberTerminated(subscriber));
                Tuple2 tuple2 = state$1.activeActorRefsFor(key, setup$2.selfUniqueAddress());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Set reachable = (Set)tuple2._1();
                Set all = (Set)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)reachable, (Object)all);
                Set reachable3 = (Set)tuple23._1();
                Set all3 = (Set)tuple23._2();
                ReceptionistMessages.Listing listing = ReceptionistMessages.Listing$.MODULE$.apply(key.asServiceKey(), reachable3, all3, true);
                ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(subscriber), (Object)listing);
                TypedMultiMap x$5 = state$1.subscriptions().inserted((Object)key, (Object)subscriber);
                ShardedServiceRegistry x$6 = state$1.copy$default$1();
                Map<ActorRef<?>, Set<AbstractServiceKey>> x$7 = state$1.copy$default$2();
                Map<ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> x$8 = state$1.copy$default$3();
                return MODULE$.behavior(setup$2, state$1.copy(x$6, x$7, x$8, (TypedMultiMap<AbstractServiceKey, ActorRef>)x$5));
            }
            ctx$2.log().error("ClusterReceptionist [{}] - Subscriptions from non-local [{}] is not supported", (Object)subscriber);
            return Behaviors$.MODULE$.same();
        }
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ void $anonfun$behavior$18(ClusterReceptionist.State state$1, ClusterReceptionist.Setup setup$2, ClusterReceptionist.Entry entry$3, AbstractServiceKey key) {
        ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key.asServiceKey());
        Replicator.Update x$1 = Replicator.Update$.MODULE$.apply(ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator.Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.removeBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key.asServiceKey(), entry$3, setup$2.selfNodeAddress())));
        org.apache.pekko.actor.ActorRef x$2 = setup$2.replicator().$bang$default$2((Object)x$1);
        setup$2.replicator().$bang((Object)x$1, x$2);
    }

    public static final /* synthetic */ void $anonfun$behavior$21(ORMultiMap newRegistry$1, ClusterReceptionist.State state$1, ActorContext ctx$2, ClusterReceptionist.Setup setup$2, ORMultiMapKey ddataKey$1, AbstractServiceKey changedKey) {
        ServiceKey serviceKey = changedKey.asServiceKey();
        Set tombstonedButReAdded = (Set)ServiceRegistry$.MODULE$.actorRefsFor$extension(newRegistry$1, (AbstractServiceKey)serviceKey).filter((Function1 & Serializable)actorRef -> BoxesRunTime.boxToBoolean((boolean)state$1.hasTombstone(serviceKey, actorRef)));
        if (tombstonedButReAdded.nonEmpty()) {
            if (ctx$2.log().isDebugEnabled()) {
                package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Saw ActorRefs that were tomstoned [{}], re-removing.", (Object)setup$2.cluster().selfAddress(), (Object)tombstonedButReAdded.mkString(", "));
            }
            Replicator.Update x$3 = Replicator.Update$.MODULE$.apply((Key)ddataKey$1, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator.Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(((ServiceRegistry)tombstonedButReAdded.foldLeft((Object)new ServiceRegistry((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry), (Function2 & Serializable)(acc, ref) -> new ServiceRegistry(ServiceRegistry$.MODULE$.removeBinding$extension(((ServiceRegistry)acc).entries(), serviceKey, new ClusterReceptionist.Entry(ref, setup$2.selfSystemUid(), 0L), setup$2.selfNodeAddress())))).entries()));
            org.apache.pekko.actor.ActorRef x$4 = setup$2.replicator().$bang$default$2((Object)x$3);
            setup$2.replicator().$bang((Object)x$3, x$4);
            return;
        }
    }

    private static final Behavior onInternalCommand$1(ClusterReceptionist.InternalCommand cmd, ClusterReceptionist.Setup setup$2, ClusterReceptionist.State state$1, ActorContext ctx$2) {
        ClusterReceptionist.InternalCommand internalCommand = cmd;
        if (internalCommand instanceof ClusterReceptionist.SubscriberTerminated) {
            ClusterReceptionist.SubscriberTerminated subscriberTerminated = (ClusterReceptionist.SubscriberTerminated)internalCommand;
            ActorRef subscriber = subscriberTerminated.ref();
            return MODULE$.behavior(setup$2, state$1.removeSubscriber(subscriber));
        }
        if (internalCommand instanceof ClusterReceptionist.LocalServiceActorTerminated) {
            ClusterReceptionist.LocalServiceActorTerminated localServiceActorTerminated = (ClusterReceptionist.LocalServiceActorTerminated)internalCommand;
            ActorRef serviceInstance = localServiceActorTerminated.ref();
            ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), 0L);
            Set keys = (Set)state$1.servicesPerActor().getOrElse(serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            package.LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Registered actor terminated: [{}] [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), ((IterableOnceOps)keys.map((Function1 & Serializable)x$6 -> x$6.asServiceKey().id())).mkString(", "), entry}));
            keys.foreach((Function1 & Serializable)key -> {
                ClusterReceptionist$.$anonfun$behavior$18(state$1, setup$2, entry, key);
                return BoxedUnit.UNIT;
            });
            return MODULE$.behavior(setup$2, state$1.addTombstone(serviceInstance, setup$2.newTombstoneDeadline()));
        }
        if (internalCommand instanceof ClusterReceptionist.ChangeFromReplicator) {
            ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> value;
            ClusterReceptionist.ChangeFromReplicator changeFromReplicator = (ClusterReceptionist.ChangeFromReplicator)internalCommand;
            ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = changeFromReplicator.key();
            ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> newRegistry = value = changeFromReplicator.value();
            Set<AbstractServiceKey> changedKeys = state$1.registry().collectChangedKeys(ddataKey, newRegistry);
            ClusterReceptionist.State newState = state$1.copy(state$1.registry().withServiceRegistry(ddataKey, newRegistry), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
            if (changedKeys.nonEmpty()) {
                if (ctx$2.log().isDebugEnabled()) {
                    package.LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Change from replicator: [{}], changes: [{}], tombstones [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), newRegistry.entries(), ((IterableOnceOps)changedKeys.map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.asServiceKey().id()), (Object)ServiceRegistry$.MODULE$.entriesFor$extension(newRegistry, (AbstractServiceKey)key).mkString("[", ", ", "]")))).mkString(", "), state$1.tombstones().mkString(", ")}));
                }
                ClusterReceptionist$.notifySubscribers$1(changedKeys, true, newState, setup$2);
                changedKeys.foreach((Function1 & Serializable)changedKey -> {
                    ClusterReceptionist$.$anonfun$behavior$21(newRegistry, state$1, ctx$2, setup$2, ddataKey, changedKey);
                    return BoxedUnit.UNIT;
                });
                return MODULE$.behavior(setup$2, newState);
            }
            return Behaviors$.MODULE$.same();
        }
        if (internalCommand instanceof ClusterReceptionist.NodeAdded) {
            ClusterReceptionist.NodeAdded nodeAdded = (ClusterReceptionist.NodeAdded)internalCommand;
            UniqueAddress uniqueAddress = nodeAdded.addresses();
            if (state$1.registry().nodes().contains((Object)uniqueAddress)) {
                return Behaviors$.MODULE$.same();
            }
            ClusterReceptionist.State newState = state$1.copy(state$1.registry().addNode(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
            Set<AbstractServiceKey> keysForNode = newState.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            if (keysForNode.nonEmpty()) {
                package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services added [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                ClusterReceptionist$.notifySubscribers$1(keysForNode, true, newState, setup$2);
            } else {
                package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node added [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
            }
            return MODULE$.behavior(setup$2, newState);
        }
        if (internalCommand instanceof ClusterReceptionist.NodeRemoved) {
            UniqueAddress uniqueAddress;
            ClusterReceptionist.NodeRemoved nodeRemoved = (ClusterReceptionist.NodeRemoved)internalCommand;
            UniqueAddress uniqueAddress2 = uniqueAddress = nodeRemoved.addresses();
            UniqueAddress uniqueAddress3 = setup$2.selfUniqueAddress();
            if (!(uniqueAddress2 != null ? !uniqueAddress2.equals(uniqueAddress3) : uniqueAddress3 != null)) {
                ctx$2.log().debug("ClusterReceptionist [{}] - terminated/removed", (Object)setup$2.cluster().selfAddress());
                return Behaviors$.MODULE$.stopped();
            }
            if (state$1.registry().nodes().contains((Object)uniqueAddress)) {
                Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
                ClusterReceptionist.State newState = state$1.copy(state$1.registry().removeNode(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
                if (keysForNode.nonEmpty()) {
                    package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services removed [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                    ClusterReceptionist$.notifySubscribers$1(keysForNode, true, newState, setup$2);
                }
                if (ClusterReceptionist$.isLeader$1(setup$2)) {
                    package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Leader node observed removed node [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                    ClusterReceptionist$.nodesRemoved$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{uniqueAddress})), false, setup$2, state$1, ctx$2);
                }
                return MODULE$.behavior(setup$2, newState);
            }
            return Behaviors$.MODULE$.same();
        }
        if (internalCommand instanceof ClusterReceptionist.NodeUnreachable) {
            ClusterReceptionist.NodeUnreachable nodeUnreachable = (ClusterReceptionist.NodeUnreachable)internalCommand;
            UniqueAddress uniqueAddress = nodeUnreachable.addresses();
            Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            ClusterReceptionist.State newState = state$1.copy(state$1.registry().addUnreachable(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
            if (keysForNode.nonEmpty()) {
                package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services unreachable [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                ClusterReceptionist$.reachabilityChanged$1(keysForNode, newState, setup$2);
            }
            return MODULE$.behavior(setup$2, newState);
        }
        if (internalCommand instanceof ClusterReceptionist.NodeReachable) {
            ClusterReceptionist.NodeReachable nodeReachable = (ClusterReceptionist.NodeReachable)internalCommand;
            UniqueAddress uniqueAddress = nodeReachable.addresses();
            Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            ClusterReceptionist.State newState = state$1.copy(state$1.registry().removeUnreachable(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
            if (keysForNode.nonEmpty()) {
                package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services reachable again [{}]", (Object)setup$2.cluster().selfAddress(), (Object)uniqueAddress);
                ClusterReceptionist$.reachabilityChanged$1(keysForNode, newState, setup$2);
            }
            return MODULE$.behavior(setup$2, newState);
        }
        if (ClusterReceptionist$RemoveTick$.MODULE$.equals(internalCommand)) {
            Set<UniqueAddress> allAddressesInState;
            Set notInCluster;
            if (ClusterReceptionist$.isLeader$1(setup$2) && (notInCluster = (Set)(allAddressesInState = state$1.registry().allUniqueAddressesInState(setup$2.selfUniqueAddress())).diff(state$1.registry().nodes())).nonEmpty()) {
                if (ctx$2.log().isDebugEnabled()) {
                    package.LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Leader node cleanup tick, removed nodes: [{}]", (Object)setup$2.cluster().selfAddress(), (Object)notInCluster.mkString(","));
                }
                ClusterReceptionist$.nodesRemoved$1(notInCluster, true, setup$2, state$1, ctx$2);
            }
            return Behaviors$.MODULE$.same();
        }
        if (ClusterReceptionist$PruneTombstonesTick$.MODULE$.equals(internalCommand)) {
            ClusterReceptionist.State prunedState = state$1.pruneTombstones();
            if (prunedState == state$1) {
                return Behaviors$.MODULE$.same();
            }
            ctx$2.log().debug("ClusterReceptionist [{}] - Pruning tombstones", (Object)setup$2.cluster().selfAddress());
            return MODULE$.behavior(setup$2, prunedState);
        }
        throw new MatchError((Object)internalCommand);
    }

    private ClusterReceptionist$() {
    }
}

