/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.sql.SqlParseTree;
import com.rabbitmq.jms.parse.sql.SqlToken;
import com.rabbitmq.jms.parse.sql.SqlTokenType;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;
import java.util.ArrayList;
import java.util.List;

enum SqlTreeType {
    LEAF{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return sub[0];
        }
    }
    ,
    DISJUNCTION{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(), sub[0], sub[2]);
        }
    }
    ,
    CONJUNCTION{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(), sub[0], sub[2]);
        }
    }
    ,
    POSTFIXUNARYOP{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(sub[1].getNode().value()), sub[0]);
        }
    }
    ,
    PREFIXUNARYOP{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(sub[0].getNode().value()), sub[1]);
        }
    }
    ,
    BINARYOP{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(sub[1].getNode().value()), sub[0], sub[2]);
        }
    }
    ,
    TERNARYOP{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(sub[1].getNode().value()), sub[0], sub[2], sub[4]);
        }
    }
    ,
    PATTERN1{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(), sub[0]);
        }
    }
    ,
    PATTERN2{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(), sub[0], sub[2]);
        }
    }
    ,
    LIST{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(new SqlToken(SqlTokenType.LIST, SqlTreeType.newList(sub[0].getNode().value().getString()))), new SqlParseTree[0]);
        }
    }
    ,
    COLLAPSE1{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return sub[0];
        }
    }
    ,
    COLLAPSE2{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return sub[1];
        }
    }
    ,
    JOINLIST{

        @Override
        SqlParseTree tree(SqlParseTree[] sub) {
            return new SqlParseTree(this.treeNode(LIST, new SqlToken(SqlTokenType.LIST, SqlTreeType.consList(sub[0].getNode().value().getString(), sub[2].getNode().value().getList()))), new SqlParseTree[0]);
        }
    };


    protected SqlTreeNode treeNode() {
        return new SqlTreeNode(this);
    }

    protected SqlTreeNode treeNode(SqlToken value) {
        return new SqlTreeNode(this, value);
    }

    protected SqlTreeNode treeNode(SqlTreeType type, SqlToken value) {
        return new SqlTreeNode(type, value);
    }

    abstract SqlParseTree tree(SqlParseTree[] var1);

    private static final List<String> newList(String s) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(s);
        return al;
    }

    private static final List<String> consList(String s, List<String> al) {
        al.add(0, s);
        return al;
    }
}

