import React from 'react';
import classNames from 'classnames';
import { DotIconWrapper } from '../../../../../../../../../../core/xlr-ui/app/features/common/components/dot-icon-wrapper/dot-icon-wrapper';

import './application-list-item-component.less';
import { Application } from '../../../application-list.types';
import { useAppDispatch } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { applicationLists } from '../ducks/application-list.reducer';
import { renderEnvironmentDescriptionPopover } from '../../shared/environment/environment-sidebar-item';
export interface ApplicationListItemProps {
    application: Application;
    onDelete(app: Application): void;
}

const { editApplication } = applicationLists.actions;
export const ApplicationListItemComponent = ({ application, onDelete }: ApplicationListItemProps) => {
    const dispatch = useAppDispatch();

    const onEditApplication = (event: React.MouseEvent<HTMLElement>) => {
        event.stopPropagation();
        dispatch(editApplication({ appId: application.id, folderId: application.folderId }));
    };

    const onDeleteApplication = (event: React.MouseEvent<HTMLSpanElement>) => {
        event.stopPropagation();

        onDelete(application);
    };

    const renderLinkedEnvironments = () => {
        const { environments } = application;
        return (
            <div className="application-item-environments col-xs-5">
                {environments.length ? (
                    <>
                        <DotIconWrapper iconId="environment" />
                        <span>
                            {environments.map((e, index) => {
                                const isLast = index === environments.length - 1;
                                return (
                                    <React.Fragment key={e.id}>
                                        <span className="mls">{e.title}</span>
                                        {e.description && (
                                            <span className="environment-description-popup">{renderEnvironmentDescriptionPopover(e.description)}</span>
                                        )}
                                        {!isLast && ', '}
                                    </React.Fragment>
                                );
                            })}
                        </span>
                    </>
                ) : (
                    'All environments'
                )}
            </div>
        );
    };

    const panelClass = classNames('panel', 'panel-default', 'application-panel');

    return (
        <div className={panelClass} onClick={onEditApplication}>
            <div className="application-item-title col-xs-5" title={application.title}>
                <DotIconWrapper className="mrs" iconId="package" />
                <strong>{application.title}</strong>
            </div>
            {renderLinkedEnvironments()}
            <div className="actions-container col-xs-2">
                <div className="actions pull-right">
                    <span className="link color-inherited" data-test="edit-action" onClick={onEditApplication}>
                        <i className="menu-item-icon xl-icon edit-icon" title="Edit" />
                        <span className="action-label">Edit</span>
                    </span>
                    <span className="link delete" data-test="delete-action" onClick={onDeleteApplication}>
                        <i className="menu-item-icon xl-icon delete-icon" title="Delete" />
                        <span className="action-label">Delete</span>
                    </span>
                </div>
            </div>
        </div>
    );
};
