/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemData;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.LazyItemIterator;
import org.apache.jackrabbit.core.NodeData;
import org.apache.jackrabbit.core.NodeDataRef;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyData;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemManager
implements ItemStateListener {
    private static Logger log = LoggerFactory.getLogger(ItemManager.class);
    private final NodeDefinitionImpl rootNodeDef;
    protected final SessionContext sessionContext;
    protected final SessionImpl session;
    private final SessionItemStateManager sism;
    private final HierarchyManager hierMgr;
    private final Map<ItemId, ItemData> itemCache;
    private final ShareableNodesCache shareableNodesCache;

    protected ItemManager(SessionContext sessionContext) {
        this.sism = sessionContext.getItemStateManager();
        this.hierMgr = sessionContext.getHierarchyManager();
        this.sessionContext = sessionContext;
        this.session = sessionContext.getSessionImpl();
        this.rootNodeDef = sessionContext.getNodeTypeManager().getRootNodeDefinition();
        this.itemCache = new ReferenceMap(0, 2);
        this.shareableNodesCache = new ShareableNodesCache();
    }

    private void sanityCheck() throws RepositoryException {
        this.sessionContext.getSessionState().checkAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            this.itemCache.clear();
        }
        this.shareableNodesCache.clear();
    }

    NodeDefinitionImpl getDefinition(NodeState state) throws RepositoryException {
        ChildNodeEntry cne;
        if (state.getId().equals(this.sessionContext.getRootNodeId())) {
            return this.rootNodeDef;
        }
        NodeId parentId = state.getParentId();
        if (parentId == null) {
            ItemState overlaid = state.getOverlayedState();
            if (overlaid != null) {
                parentId = overlaid.getParentId();
            } else {
                throw new InvalidItemStateException("Could not find parent of node " + state.getNodeId());
            }
        }
        NodeState parentState = null;
        try {
            ItemData parentData = this.getItemData(parentId, null, false);
            parentState = (NodeState)parentData.getState();
            if (state.getParentId() == null) {
                parentState = parentState.getStatus() == 4 ? null : (NodeState)parentState.getOverlayedState();
            }
        }
        catch (ItemNotFoundException parentData) {
            // empty catch block
        }
        if (parentState == null) {
            try {
                parentState = (NodeState)this.sism.getAttic().getItemState(parentId).getOverlayedState();
            }
            catch (ItemStateException ex) {
                throw new RepositoryException((Throwable)ex);
            }
        }
        if ((cne = parentState.getChildNodeEntry(state.getNodeId())) == null) {
            throw new InvalidItemStateException("Could not find child " + state.getNodeId() + " of node " + parentState.getNodeId());
        }
        NodeTypeRegistry ntReg = this.sessionContext.getNodeTypeRegistry();
        try {
            QNodeDefinition def;
            EffectiveNodeType ent = ntReg.getEffectiveNodeType(parentState.getNodeTypeName(), parentState.getMixinTypeNames());
            try {
                def = ent.getApplicableChildNodeDef(cne.getName(), state.getNodeTypeName(), ntReg);
            }
            catch (ConstraintViolationException e) {
                ent = ntReg.getEffectiveNodeType(NameConstants.NT_UNSTRUCTURED);
                def = ent.getApplicableChildNodeDef(cne.getName(), state.getNodeTypeName(), ntReg);
                log.warn("Fallback to nt:unstructured due to unknown child node definition for type '" + state.getNodeTypeName() + "'");
            }
            return this.sessionContext.getNodeTypeManager().getNodeDefinition(def);
        }
        catch (NodeTypeConflictException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    PropertyDefinitionImpl getDefinition(PropertyState state) throws RepositoryException {
        if (state.getStatus() == 3 && state.getName().equals(NameConstants.JCR_UUID)) {
            NodeTypeRegistry ntReg = this.sessionContext.getNodeTypeRegistry();
            QPropertyDefinition def = ntReg.getEffectiveNodeType(NameConstants.MIX_REFERENCEABLE).getApplicablePropertyDef(state.getName(), state.getType());
            return this.sessionContext.getNodeTypeManager().getPropertyDefinition(def);
        }
        try {
            ItemData parentData = this.getItemData(state.getParentId(), null, false);
            NodeImpl parent = (NodeImpl)this.createItemInstance(parentData);
            return parent.getApplicablePropertyDefinition(state.getName(), state.getType(), state.isMultiValued(), true);
        }
        catch (ItemNotFoundException parentData) {
            try {
                QPropertyDefinition def;
                NodeState parent = (NodeState)this.sism.getAttic().getItemState(state.getParentId()).getOverlayedState();
                NodeTypeRegistry ntReg = this.sessionContext.getNodeTypeRegistry();
                EffectiveNodeType ent = ntReg.getEffectiveNodeType(parent.getNodeTypeName(), parent.getMixinTypeNames());
                try {
                    def = ent.getApplicablePropertyDef(state.getName(), state.getType(), state.isMultiValued());
                }
                catch (ConstraintViolationException e) {
                    ent = ntReg.getEffectiveNodeType(NameConstants.NT_UNSTRUCTURED);
                    def = ent.getApplicablePropertyDef(state.getName(), state.getType(), state.isMultiValued());
                    log.warn("Fallback to nt:unstructured due to unknown property definition for '" + state.getName() + "'");
                }
                return this.sessionContext.getNodeTypeManager().getPropertyDefinition(def);
            }
            catch (ItemStateException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (NodeTypeConflictException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private boolean itemExists(ItemId itemId, Path path) {
        try {
            this.sanityCheck();
            if (!this.sism.hasItemState(itemId)) {
                return false;
            }
            this.getItemData(itemId, path, true);
            return true;
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    private ItemImpl getItem(ItemId itemId, Path path, boolean permissionCheck) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        ItemData data = this.getItemData(itemId, path, permissionCheck);
        return this.createItemInstance(data);
    }

    private ItemData getItemData(ItemId itemId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getItemData(itemId, null, true);
    }

    ItemData getItemData(ItemId itemId, Path path, boolean permissionCheck) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        ItemData data = this.retrieveItem(itemId);
        if (data == null) {
            ItemState state;
            try {
                state = this.sism.getItemState(itemId);
            }
            catch (NoSuchItemStateException nsise) {
                throw new ItemNotFoundException(itemId.toString(), (Throwable)nsise);
            }
            catch (ItemStateException ise) {
                String msg = "failed to retrieve item state of item " + itemId;
                log.error(msg, (Throwable)ise);
                throw new RepositoryException(msg, (Throwable)ise);
            }
            data = this.createItemData(state, path, permissionCheck);
        } else if (permissionCheck && !this.canRead(data, path)) {
            this.evictItems(itemId);
            throw new AccessDeniedException("cannot read item " + data.getId());
        }
        return data;
    }

    private boolean canRead(ItemData data, Path path) throws AccessDeniedException, RepositoryException {
        ItemState state = data.getState();
        if (state == null) {
            throw new InvalidItemStateException(data.getId() + ": the item does not exist anymore");
        }
        if (state.getStatus() == 4) {
            if (!data.getDefinition().isProtected()) {
                return true;
            }
            return path == null ? this.sessionContext.getAccessManager().isGranted(data.getId(), 1) : this.sessionContext.getAccessManager().isGranted(path, 1);
        }
        return this.sessionContext.getAccessManager().canRead(path, data.getId());
    }

    private boolean canRead(ItemData parent, ItemId childId) throws RepositoryException {
        if (parent.getStatus() == 1) {
            return this.sessionContext.getAccessManager().canRead(null, childId);
        }
        return this.sessionContext.getAccessManager().isGranted(childId, 1);
    }

    public boolean itemExists(Path path) {
        try {
            this.sanityCheck();
            ItemId id = this.hierMgr.resolvePath(path);
            return id != null && this.itemExists(id, path);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean nodeExists(Path path) {
        try {
            this.sanityCheck();
            NodeId id = this.hierMgr.resolveNodePath(path);
            return id != null && this.itemExists(id, path);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean propertyExists(Path path) {
        try {
            this.sanityCheck();
            PropertyId id = this.hierMgr.resolvePropertyPath(path);
            return id != null && this.itemExists(id, path);
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean itemExists(ItemId id) {
        return this.itemExists(id, null);
    }

    NodeImpl getRootNode() throws RepositoryException {
        return (NodeImpl)this.getItem(this.sessionContext.getRootNodeId());
    }

    public ItemImpl getItem(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        ItemId id = this.hierMgr.resolvePath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            ItemImpl item = this.getItem(id, path, true);
            if (item.isNode() && ((NodeImpl)item).isShareable()) {
                return this.getNode(path);
            }
            return item;
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public NodeImpl getNode(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        NodeId id = this.hierMgr.resolveNodePath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        NodeId parentId = null;
        if (!path.denotesRoot()) {
            parentId = this.hierMgr.resolveNodePath(path.getAncestor(1));
        }
        try {
            if (parentId == null) {
                return (NodeImpl)this.getItem(id, path, true);
            }
            return this.getNode(id, parentId);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public PropertyImpl getProperty(Path path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        PropertyId id = this.hierMgr.resolvePropertyPath(path);
        if (id == null) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        try {
            return (PropertyImpl)this.getItem(id, path, true);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
    }

    public synchronized ItemImpl getItem(ItemId id) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getItem(id, null, true);
    }

    synchronized ItemImpl getItem(ItemId id, boolean permissionCheck) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getItem(id, null, permissionCheck);
    }

    public synchronized NodeImpl getNode(NodeId id, NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getNode(id, parentId, true);
    }

    synchronized NodeImpl getNode(NodeId id, NodeId parentId, boolean permissionCheck) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (parentId == null) {
            return (NodeImpl)this.getItem(id);
        }
        AbstractNodeData data = this.retrieveItem(id, parentId);
        if (data == null) {
            data = (AbstractNodeData)this.getItemData(id, null, permissionCheck);
        } else if (permissionCheck && !this.canRead((ItemData)data, id)) {
            this.evictItems(id);
            throw new AccessDeniedException("cannot read item " + data.getId());
        }
        if (!data.getParentId().equals(parentId)) {
            if (!data.getNodeState().containsShare(parentId)) {
                String msg = "Node with id '" + id + "' does not have shared parent with id: " + parentId;
                throw new ItemNotFoundException(msg);
            }
            data = new NodeDataRef(data, parentId);
            this.cacheItem(data);
        }
        return this.createNodeInstance(data);
    }

    synchronized ItemImpl createItemInstance(ItemState state) throws RepositoryException {
        ItemData data = this.createItemData(state, null, false);
        return this.createItemInstance(data);
    }

    synchronized boolean hasChildNodes(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child nodes of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState state = (NodeState)data.getState();
        for (ChildNodeEntry entry : state.getChildNodeEntries()) {
            if (!this.canRead(data, entry.getId())) continue;
            return true;
        }
        return false;
    }

    synchronized NodeIterator getChildNodes(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child nodes of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        ArrayList<NodeId> childIds = new ArrayList<NodeId>();
        for (ChildNodeEntry entry : ((NodeState)data.getState()).getChildNodeEntries()) {
            childIds.add(entry.getId());
        }
        return new LazyItemIterator(this.sessionContext, childIds, parentId);
    }

    synchronized boolean hasChildProperties(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child properties of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        for (Name propName : ((NodeState)data.getState()).getPropertyNames()) {
            if (!this.canRead(data, new PropertyId(parentId, propName))) continue;
            return true;
        }
        return false;
    }

    synchronized PropertyIterator getChildProperties(NodeId parentId) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        ItemData data = this.getItemData(parentId);
        if (!data.isNode()) {
            String msg = "can't list child properties of property " + parentId;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        ArrayList<PropertyId> childIds = new ArrayList<PropertyId>();
        for (Name propName : ((NodeState)data.getState()).getPropertyNames()) {
            PropertyId id = new PropertyId(parentId, propName);
            childIds.add(id);
        }
        return new LazyItemIterator(this.sessionContext, childIds);
    }

    private ItemData createItemData(ItemState state, Path path, boolean permissionCheck) throws RepositoryException {
        ItemData data;
        if (state.isNode()) {
            NodeState nodeState = (NodeState)state;
            data = new NodeData(nodeState, this);
        } else {
            PropertyState propertyState = (PropertyState)state;
            data = new PropertyData(propertyState, this);
        }
        if (permissionCheck && !this.canRead(data, path)) {
            throw new AccessDeniedException("cannot read item " + state.getId());
        }
        this.cacheItem(data);
        return data;
    }

    private ItemImpl createItemInstance(ItemData data) {
        if (data.isNode()) {
            return this.createNodeInstance((AbstractNodeData)data);
        }
        return this.createPropertyInstance((PropertyData)data);
    }

    private NodeImpl createNodeInstance(AbstractNodeData data) {
        NodeState state = data.getNodeState();
        if (state.getNodeTypeName().equals(NameConstants.NT_VERSION)) {
            return new VersionImpl(this, this.sessionContext, data);
        }
        if (state.getNodeTypeName().equals(NameConstants.NT_VERSIONHISTORY)) {
            return new VersionHistoryImpl(this, this.sessionContext, data);
        }
        return new NodeImpl(this, this.sessionContext, data);
    }

    private PropertyImpl createPropertyInstance(PropertyData data) {
        return new PropertyImpl(this, this.sessionContext, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemData retrieveItem(ItemId id) {
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            ItemData data = this.itemCache.get(id);
            if (data == null && id.denotesNode()) {
                data = this.shareableNodesCache.retrieveFirst((NodeId)id);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractNodeData retrieveItem(NodeId id, NodeId parentId) {
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            AbstractNodeData data = this.shareableNodesCache.retrieve(id, parentId);
            if (data == null) {
                data = (AbstractNodeData)this.itemCache.get(id);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheItem(ItemData data) {
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            AbstractNodeData nd;
            if (data.isNode() && (nd = (AbstractNodeData)data).getPrimaryParentId() != null) {
                this.shareableNodesCache.cache(nd);
                return;
            }
            ItemId id = data.getId();
            if (this.itemCache.containsKey(id)) {
                log.debug("overwriting cached item " + id);
            }
            if (log.isDebugEnabled()) {
                log.debug("caching item " + id);
            }
            this.itemCache.put(id, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictItems(ItemId id) {
        if (log.isDebugEnabled()) {
            log.debug("removing items " + id + " from cache");
        }
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            this.itemCache.remove(id);
            if (id.denotesNode()) {
                this.shareableNodesCache.evictAll((NodeId)id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictItem(ItemData data) {
        if (log.isDebugEnabled()) {
            log.debug("removing item " + data.getId() + " from cache");
        }
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            ItemData cached;
            if (data.isNode()) {
                this.shareableNodesCache.evict((AbstractNodeData)data);
            }
            if ((cached = this.itemCache.get(data.getId())) == data) {
                this.itemCache.remove(data.getId());
            }
        }
    }

    String safeGetJCRPath(Path path) {
        try {
            return this.session.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.error("failed to convert " + path.toString() + " to JCR path.");
            return path.toString();
        }
    }

    String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.hierMgr.getPath(id));
        }
        catch (RepositoryException re) {
            log.error(id + ": failed to determine path to");
            return id.toString();
        }
    }

    public void itemInvalidated(ItemId id, ItemData data) {
        if (log.isDebugEnabled()) {
            log.debug("invalidated item " + id);
        }
        this.evictItem(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemDestroyed(ItemId id, ItemData data) {
        if (log.isDebugEnabled()) {
            log.debug("destroyed item " + id);
        }
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            this.evictItems(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ItemManager (" + super.toString() + ")\n");
        builder.append("Items in cache:\n");
        Map<ItemId, ItemData> map = this.itemCache;
        synchronized (map) {
            for (ItemId id : this.itemCache.keySet()) {
                ItemData item = this.itemCache.get(id);
                if (item.isNode()) {
                    builder.append("Node: ");
                } else {
                    builder.append("Property: ");
                }
                if (item.getState().isTransient()) {
                    builder.append("transient ");
                } else {
                    builder.append("          ");
                }
                builder.append(id + "\t" + this.safeGetJCRPath(id) + " (" + item + ")\n");
            }
        }
        return builder.toString();
    }

    @Override
    public void stateCreated(ItemState created) {
        ItemData data = this.retrieveItem(created.getId());
        if (data != null) {
            data.setStatus(0);
        }
    }

    @Override
    public void stateModified(ItemState modified) {
        ItemData data = this.retrieveItem(modified.getId());
        if (data != null && data.getState() == modified) {
            data.setStatus(1);
        }
    }

    @Override
    public void stateDestroyed(ItemState destroyed) {
        ItemData data = this.retrieveItem(destroyed.getId());
        if (data != null && data.getState() == destroyed) {
            this.itemDestroyed(destroyed.getId(), data);
            data.setStatus(2);
        }
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
        ItemData data = this.retrieveItem(discarded.getId());
        if (data != null && data.getState() == discarded) {
            if (discarded.isTransient()) {
                switch (discarded.getStatus()) {
                    case 2: 
                    case 3: {
                        ItemState persistentState = discarded.getOverlayedState();
                        SessionItemStateManager stateMgr = this.sessionContext.getItemStateManager();
                        stateMgr.disconnectTransientItemState(discarded);
                        data.setState(persistentState);
                        return;
                    }
                    case 6: {
                        this.itemDestroyed(discarded.getId(), data);
                        data.setStatus(2);
                        data.setState(null);
                        return;
                    }
                    case 4: {
                        this.itemDestroyed(discarded.getId(), data);
                        data.setStatus(2);
                        data.setState(null);
                        return;
                    }
                }
            }
            this.itemInvalidated(discarded.getId(), data);
            data.setStatus(3);
        }
    }

    static class ShareableNodesCache {
        private final ReferenceMap cache = new ReferenceMap(0, 0);

        public void clear() {
            this.cache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractNodeData retrieveFirst(NodeId id) {
            ReferenceMap map = (ReferenceMap)this.cache.get((Object)id);
            if (map != null) {
                Iterator iter = map.values().iterator();
                try {
                    while (iter.hasNext()) {
                        AbstractNodeData data = (AbstractNodeData)iter.next();
                        if (data == null) continue;
                        AbstractNodeData abstractNodeData = data;
                        return abstractNodeData;
                    }
                }
                finally {
                    iter = null;
                }
            }
            return null;
        }

        public AbstractNodeData retrieve(NodeId id, NodeId parentId) {
            ReferenceMap map = (ReferenceMap)this.cache.get((Object)id);
            if (map != null) {
                return (AbstractNodeData)map.get((Object)parentId);
            }
            return null;
        }

        public void cache(AbstractNodeData data) {
            Object old;
            NodeId id = data.getNodeState().getNodeId();
            ReferenceMap map = (ReferenceMap)this.cache.get((Object)id);
            if (map == null) {
                map = new ReferenceMap(0, 2);
                this.cache.put((Object)id, (Object)map);
            }
            if ((old = map.put((Object)data.getPrimaryParentId(), (Object)data)) != null) {
                log.debug("overwriting cached item: " + old);
            }
        }

        public void evict(AbstractNodeData data) {
            ReferenceMap map = (ReferenceMap)this.cache.get((Object)data.getId());
            if (map != null) {
                map.remove((Object)data.getPrimaryParentId());
            }
        }

        public synchronized void evictAll(NodeId id) {
            this.cache.remove((Object)id);
        }
    }
}

