/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.cluster.ClusterOperation;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.LockEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.lock.LockImpl;
import org.apache.jackrabbit.core.lock.LockInfo;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.SessionLockManager;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.XAReentrantLock;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerImpl
implements LockManager,
SynchronousEventListener,
LockEventListener {
    private static final Logger log = LoggerFactory.getLogger(LockManagerImpl.class);
    private static final String LOCKS_FILE = "locks";
    private final PathMap<LockInfo> lockMap = new PathMap();
    private final XAReentrantLock lockMapLock = new XAReentrantLock();
    private XAReentrantLock lockPropertiesLock = new XAReentrantLock();
    private final ScheduledFuture<?> timeoutHandler;
    private final SessionImpl sysSession;
    private final FileSystemResource locksFile;
    private boolean savingDisabled;
    private LockEventChannel eventChannel;

    public LockManagerImpl(SessionImpl session, FileSystem fs, ScheduledExecutorService executor) throws RepositoryException {
        this.sysSession = session;
        this.locksFile = new FileSystemResource(fs, "/locks");
        session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 3, "/", true, null, null, true);
        try {
            if (this.locksFile.exists()) {
                this.load();
            }
        }
        catch (FileSystemException e) {
            throw new RepositoryException("I/O error while reading locks from '" + this.locksFile.getPath() + "'", (Throwable)e);
        }
        this.timeoutHandler = executor.scheduleWithFixedDelay(new TimeoutHandler(), 1L, 1L, TimeUnit.SECONDS);
    }

    public void close() {
        this.timeoutHandler.cancel(false);
        this.save();
    }

    private void load() throws FileSystemException {
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new InputStreamReader(this.locksFile.getInputStream()));
            while ((s = reader.readLine()) != null && !s.equals("")) {
                this.reapplyLock(s);
            }
        }
        catch (IOException e) {
            try {
                throw new FileSystemException("error while reading locks file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reapplyLock(String lockTokenLine) {
        String[] parts = lockTokenLine.split(",");
        String token = parts[0];
        long timeoutHint = Long.MAX_VALUE;
        if (parts.length > 1) {
            try {
                timeoutHint = Long.parseLong(parts[1]);
            }
            catch (NumberFormatException e) {
                log.warn("Unexpected timeout hint " + parts[1] + " for lock token " + token, (Throwable)e);
            }
        }
        try {
            this.acquire();
            NodeId id = LockInfo.parseLockToken(parts[0]);
            NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(id);
            Path path = this.getPath(this.sysSession, id);
            InternalLockInfo info = new InternalLockInfo(id, false, node.getProperty(NameConstants.JCR_LOCKISDEEP).getBoolean(), node.getProperty(NameConstants.JCR_LOCKOWNER).getString(), timeoutHint);
            info.setLive(true);
            this.lockMap.put(path, (Object)info);
        }
        catch (RepositoryException e) {
            log.warn("Unable to recreate lock '" + token + "': " + e.getMessage());
            log.debug("Root cause: ", (Throwable)e);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void save() {
        if (this.savingDisabled) {
            return;
        }
        final ArrayList list = new ArrayList();
        this.lockMap.traverse((PathMap.ElementVisitor)new PathMap.ElementVisitor<LockInfo>(){

            public void elementVisited(PathMap.Element<LockInfo> element) {
                LockInfo info = (LockInfo)element.get();
                if (!info.isSessionScoped()) {
                    list.add(info);
                }
            }
        }, false);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(this.locksFile.getOutputStream()));
            for (LockInfo info : list) {
                writer.write(info.getLockToken());
                if (info.getTimeoutHint() != Long.MAX_VALUE) {
                    writer.write(44);
                    writer.write(Long.toString(info.getTimeoutHint()));
                }
                writer.newLine();
            }
        }
        catch (FileSystemException fse) {
            log.warn("I/O error while saving locks to '" + this.locksFile.getPath() + "': " + fse.getMessage());
            log.debug("Root cause: ", (Throwable)fse);
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException ioe) {
            log.warn("I/O error while saving locks to '" + this.locksFile.getPath() + "': " + ioe.getMessage());
            log.debug("Root cause: ", (Throwable)ioe);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    static SessionLockManager getSessionLockManager(SessionImpl session) throws RepositoryException {
        Workspace wsp = session.getWorkspace();
        return (SessionLockManager)wsp.getLockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockInfo internalLock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, RepositoryException {
        SessionImpl session = (SessionImpl)node.getSession();
        String lockOwner = ownerInfo != null ? ownerInfo : session.getUserID();
        InternalLockInfo info = new InternalLockInfo(node.getNodeId(), isSessionScoped, isDeep, lockOwner, timeoutHint);
        ClusterOperation operation = null;
        boolean successful = false;
        if (this.eventChannel != null && !isSessionScoped) {
            operation = this.eventChannel.create(node.getNodeId(), isDeep, lockOwner);
        }
        this.acquire();
        try {
            Path path = this.getPath(session, node.getId());
            PathMap.Element element = this.lockMap.map(path, false);
            LockInfo other = (LockInfo)element.get();
            if (other != null) {
                if (element.hasPath(path)) {
                    other.throwLockException("Node already locked: " + node, session);
                } else if (other.isDeep()) {
                    other.throwLockException("Parent node has a deep lock: " + node, session);
                }
            }
            if (info.isDeep() && element.hasPath(path) && element.getChildrenCount() > 0) {
                info.throwLockException("Some child node is locked", session);
            }
            info.setLockHolder(session);
            info.setLive(true);
            session.addListener(info);
            if (!info.isSessionScoped()) {
                LockManagerImpl.getSessionLockManager(session).lockTokenAdded(info.getLockToken());
            }
            this.lockMap.put(path, (Object)info);
            if (!info.isSessionScoped()) {
                this.save();
                successful = true;
            }
            InternalLockInfo internalLockInfo = info;
            return internalLockInfo;
        }
        finally {
            this.release();
            if (operation != null) {
                operation.ended(successful);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean internalUnlock(NodeImpl node) throws LockException, RepositoryException {
        ClusterOperation operation = null;
        boolean successful = false;
        if (this.eventChannel != null) {
            operation = this.eventChannel.create(node.getNodeId());
        }
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            PathMap.Element element = this.lockMap.map(this.getPath(session, node.getId()), true);
            if (element == null) {
                throw new LockException("Node not locked: " + node);
            }
            LockInfo info = (LockInfo)element.get();
            if (info == null) {
                throw new LockException("Node not locked: " + node);
            }
            this.checkUnlock(info, (Session)session);
            LockManagerImpl.getSessionLockManager(session).lockTokenRemoved(info.getLockToken());
            element.set(null);
            info.setLive(false);
            if (!info.isSessionScoped()) {
                this.save();
                successful = true;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.release();
            if (operation != null) {
                operation.ended(successful);
            }
        }
    }

    LockInfo[] getLockInfos(final SessionImpl session) {
        final ArrayList infos = new ArrayList();
        this.lockMap.traverse((PathMap.ElementVisitor)new PathMap.ElementVisitor<LockInfo>(){

            public void elementVisited(PathMap.Element<LockInfo> element) {
                LockInfo info = (LockInfo)element.get();
                if (info.isLive() && info.isLockHolder((Session)session)) {
                    infos.add(info);
                }
            }
        }, false);
        return infos.toArray(new LockInfo[infos.size()]);
    }

    public void copyOpenScopedLocksFrom(LockManagerImpl source) {
        source.lockMap.traverse((PathMap.ElementVisitor)new PathMap.ElementVisitor<LockInfo>(){

            public void elementVisited(PathMap.Element<LockInfo> element) {
                LockInfo info = (LockInfo)element.get();
                if (info.isLive() && !info.isSessionScoped()) {
                    try {
                        LockManagerImpl.this.lockMap.put(element.getPath(), (Object)info);
                    }
                    catch (MalformedPathException e) {
                        log.warn("Ignoring invalid lock path: " + info, (Throwable)e);
                    }
                }
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockInfo getLockInfo(NodeId id) throws RepositoryException {
        Path path;
        try {
            path = this.getPath(this.sysSession, id);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        this.acquire();
        try {
            PathMap.Element element = this.lockMap.map(path, false);
            LockInfo info = (LockInfo)element.get();
            if (info != null && (element.hasPath(path) || info.isDeep())) {
                LockInfo lockInfo = info;
                return lockInfo;
            }
            LockInfo lockInfo = null;
            return lockInfo;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        return this.lock(node, isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    @Override
    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timoutHint, String ownerInfo) throws LockException, RepositoryException {
        LockInfo info = this.internalLock(node, isDeep, isSessionScoped, timoutHint, ownerInfo);
        this.writeLockProperties(node, info.getLockOwner(), info.isDeep());
        return new LockImpl(info, node);
    }

    @Override
    public Lock getLock(NodeImpl node) throws LockException, RepositoryException {
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            Path path = this.getPath(session, node.getId());
            PathMap.Element element = this.lockMap.map(path, false);
            LockInfo info = (LockInfo)element.get();
            if (info != null && (element.hasPath(path) || info.isDeep())) {
                NodeImpl lockHolder = (NodeImpl)session.getItemManager().getItem(info.getId());
                LockImpl lockImpl = new LockImpl(info, lockHolder);
                return lockImpl;
            }
            try {
                throw new LockException("Node not locked: " + node);
            }
            catch (ItemNotFoundException e) {
                throw new LockException("Node not locked: " + node);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock[] getLocks(SessionImpl session) throws RepositoryException {
        this.acquire();
        LockInfo[] infos = this.getLockInfos(session);
        try {
            Lock[] locks = new Lock[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                NodeImpl holder = (NodeImpl)session.getItemManager().getItem(infos[i].getId());
                locks[i] = new LockImpl(infos[i], holder);
            }
            Lock[] lockArray = locks;
            return lockArray;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void unlock(NodeImpl node) throws LockException, RepositoryException {
        this.removeLockProperties(node);
        this.internalUnlock(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean holdsLock(NodeImpl node) throws RepositoryException {
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            PathMap.Element element = this.lockMap.map(this.getPath(session, node.getId()), true);
            if (element == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = element.get() != null;
            return bl;
        }
        catch (ItemNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocked(NodeImpl node) throws RepositoryException {
        this.acquire();
        try {
            SessionImpl session = (SessionImpl)node.getSession();
            Path path = this.getPath(session, node.getId());
            PathMap.Element element = this.lockMap.map(path, false);
            LockInfo info = (LockInfo)element.get();
            if (info == null) {
                boolean bl = false;
                return bl;
            }
            if (element.hasPath(path)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = info.isDeep();
            return bl;
        }
        catch (ItemNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void checkLock(NodeImpl node) throws LockException, RepositoryException {
        SessionImpl session = (SessionImpl)node.getSession();
        this.checkLock(this.getPath(session, node.getId()), (Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkLock(Path path, Session session) throws LockException, RepositoryException {
        this.acquire();
        try {
            PathMap.Element element = this.lockMap.map(path, false);
            LockInfo info = (LockInfo)element.get();
            if (info != null && (element.hasPath(path) || info.isDeep())) {
                this.checkLock(info, session);
            }
        }
        finally {
            this.release();
        }
    }

    protected void checkLock(LockInfo info, Session session) throws LockException, RepositoryException {
        if (!info.isLockHolder(session)) {
            throw new LockException("Node locked.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkUnlock(Session session, NodeImpl node) throws LockException, RepositoryException {
        this.acquire();
        try {
            PathMap.Element element = this.lockMap.map(this.getPath((SessionImpl)session, node.getId()), true);
            if (element == null) {
                throw new LockException("Node not locked: " + node);
            }
            LockInfo info = (LockInfo)element.get();
            if (info == null) {
                throw new LockException("Node not locked: " + node);
            }
            this.checkUnlock(info, session);
        }
        finally {
            this.release();
        }
    }

    protected void checkUnlock(LockInfo info, Session session) throws LockException, RepositoryException {
        if (!info.isLockHolder(session)) {
            throw new LockException("Node not locked by session: " + info.getId());
        }
    }

    @Override
    public void addLockToken(SessionImpl session, String lt) throws LockException, RepositoryException {
        try {
            LockInfo info;
            this.acquire();
            NodeId id = LockInfo.parseLockToken(lt);
            NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(id);
            Path path = node.getPrimaryPath();
            PathMap.Element element = this.lockMap.map(path, true);
            if (element != null && (info = (LockInfo)element.get()) != null && !info.isLockHolder((Session)session)) {
                if (info.getLockHolder() == null) {
                    info.setLockHolder(session);
                    if (info instanceof InternalLockInfo) {
                        session.addListener((InternalLockInfo)info);
                    }
                } else {
                    String msg = "Cannot add lock token: lock already held by other session.";
                    log.warn(msg);
                    info.throwLockException(msg, session);
                }
            }
            LockManagerImpl.getSessionLockManager(session).lockTokenAdded(lt);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad lock token: " + e.getMessage();
            log.warn(msg);
            throw new LockException(msg);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void removeLockToken(SessionImpl session, String lt) throws LockException, RepositoryException {
        try {
            LockInfo info;
            this.acquire();
            NodeId id = LockInfo.parseLockToken(lt);
            NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(id);
            PathMap.Element element = this.lockMap.map(node.getPrimaryPath(), true);
            if (element != null && (info = (LockInfo)element.get()) != null) {
                if (info.isLockHolder((Session)session)) {
                    info.setLockHolder(null);
                } else if (info.getLockHolder() != null) {
                    String msg = "Cannot remove lock token: lock held by other session.";
                    log.warn(msg);
                    info.throwLockException(msg, session);
                }
            }
            LockManagerImpl.getSessionLockManager(session).lockTokenRemoved(lt);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad lock token: " + e.getMessage();
            log.warn(msg);
            throw new LockException(msg);
        }
        finally {
            this.release();
        }
    }

    private Path getPath(SessionImpl session, ItemId id) throws RepositoryException {
        return session.getHierarchyManager().getPath(id);
    }

    private void acquire() {
        while (true) {
            try {
                this.lockMapLock.acquire();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void release() {
        this.lockMapLock.release();
    }

    private void acquireLockPropertiesLock() {
        while (true) {
            try {
                this.lockPropertiesLock.acquire();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void releaseLockPropertiesLock() {
        this.lockPropertiesLock.release();
    }

    public void beginUpdate() {
        this.acquire();
        this.savingDisabled = true;
    }

    public void endUpdate() {
        this.savingDisabled = false;
        this.save();
        this.release();
    }

    public void cancelUpdate() {
        this.savingDisabled = false;
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLockProperties(NodeImpl node, String lockOwner, boolean isDeep) throws RepositoryException {
        boolean success = false;
        SessionImpl editingSession = (SessionImpl)node.getSession();
        WorkspaceImpl wsp = (WorkspaceImpl)editingSession.getWorkspace();
        LocalItemStateManager stateMgr = wsp.getItemStateManager();
        try {
            this.acquireLockPropertiesLock();
            if (stateMgr.inEditMode()) {
                throw new RepositoryException("Unable to write lock properties.");
            }
            stateMgr.edit();
            try {
                PropertyState propState;
                NodeId nodeId = node.getNodeId();
                NodeState nodeState = (NodeState)stateMgr.getItemState(nodeId);
                if (!nodeState.hasPropertyName(NameConstants.JCR_LOCKOWNER)) {
                    propState = stateMgr.createNew(NameConstants.JCR_LOCKOWNER, nodeId);
                    propState.setType(1);
                    propState.setMultiValued(false);
                } else {
                    propState = (PropertyState)stateMgr.getItemState(new PropertyId(nodeId, NameConstants.JCR_LOCKOWNER));
                }
                propState.setValues(new InternalValue[]{InternalValue.create(lockOwner)});
                nodeState.addPropertyName(NameConstants.JCR_LOCKOWNER);
                stateMgr.store(nodeState);
                if (!nodeState.hasPropertyName(NameConstants.JCR_LOCKISDEEP)) {
                    propState = stateMgr.createNew(NameConstants.JCR_LOCKISDEEP, nodeId);
                    propState.setType(6);
                    propState.setMultiValued(false);
                } else {
                    propState = (PropertyState)stateMgr.getItemState(new PropertyId(nodeId, NameConstants.JCR_LOCKISDEEP));
                }
                propState.setValues(new InternalValue[]{InternalValue.create(isDeep)});
                nodeState.addPropertyName(NameConstants.JCR_LOCKISDEEP);
                stateMgr.store(nodeState);
                stateMgr.update();
                success = true;
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Error while creating lock.", (Throwable)e);
            }
            finally {
                if (!success) {
                    stateMgr.cancel();
                    try {
                        this.unlock(node);
                    }
                    catch (RepositoryException e) {
                        log.error("error while cleaning up after failed lock attempt", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.releaseLockPropertiesLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLockProperties(NodeImpl node) throws RepositoryException {
        boolean success = false;
        SessionImpl editingSession = (SessionImpl)node.getSession();
        WorkspaceImpl wsp = (WorkspaceImpl)editingSession.getWorkspace();
        LocalItemStateManager stateMgr = wsp.getItemStateManager();
        try {
            this.acquireLockPropertiesLock();
            if (stateMgr.inEditMode()) {
                throw new RepositoryException("Unable to remove lock properties.");
            }
            stateMgr.edit();
            try {
                PropertyState propState;
                NodeId nodeId = node.getNodeId();
                NodeState nodeState = (NodeState)stateMgr.getItemState(nodeId);
                if (nodeState.hasPropertyName(NameConstants.JCR_LOCKOWNER)) {
                    propState = (PropertyState)stateMgr.getItemState(new PropertyId(nodeId, NameConstants.JCR_LOCKOWNER));
                    nodeState.removePropertyName(NameConstants.JCR_LOCKOWNER);
                    stateMgr.destroy(propState);
                    stateMgr.store(nodeState);
                }
                if (nodeState.hasPropertyName(NameConstants.JCR_LOCKISDEEP)) {
                    propState = (PropertyState)stateMgr.getItemState(new PropertyId(nodeId, NameConstants.JCR_LOCKISDEEP));
                    nodeState.removePropertyName(NameConstants.JCR_LOCKISDEEP);
                    stateMgr.destroy(propState);
                    stateMgr.store(nodeState);
                }
                stateMgr.update();
                success = true;
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Error while removing lock.", (Throwable)e);
            }
            finally {
                if (!success) {
                    stateMgr.cancel();
                }
            }
        }
        finally {
            this.releaseLockPropertiesLock();
        }
    }

    public void onEvent(EventIterator events) {
        Iterator<HierarchyEvent> iter = this.consolidateEvents(events);
        while (iter.hasNext()) {
            HierarchyEvent event = iter.next();
            if (event.type == 1) {
                this.nodeAdded(event.path);
                continue;
            }
            if (event.type == 2) {
                this.nodeRemoved(event.path);
                continue;
            }
            if (event.type != 3) continue;
            this.nodeMoved(event.getOldPath(), event.getNewPath());
        }
    }

    private Iterator<HierarchyEvent> consolidateEvents(EventIterator events) {
        LinkedMap eventMap = new LinkedMap();
        while (events.hasNext()) {
            HierarchyEvent he;
            EventImpl event = (EventImpl)events.nextEvent();
            try {
                he = new HierarchyEvent(event.getChildId(), this.sysSession.getQPath(event.getPath()).getNormalizedPath(), event.getType());
            }
            catch (MalformedPathException e) {
                log.info("Unable to get event's path: " + e.getMessage());
                continue;
            }
            catch (RepositoryException e) {
                log.info("Unable to get event's path: " + e.getMessage());
                continue;
            }
            HierarchyEvent heExisting = (HierarchyEvent)eventMap.get((Object)he.id);
            if (heExisting != null) {
                heExisting.merge(he);
                continue;
            }
            eventMap.put((Object)he.id, (Object)he);
        }
        return eventMap.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(PathMap.Element<LockInfo> element) {
        final ArrayList infos = new ArrayList();
        boolean needsSave = false;
        element.traverse((PathMap.ElementVisitor)new PathMap.ElementVisitor<LockInfo>(){

            public void elementVisited(PathMap.Element<LockInfo> element) {
                infos.add(element.get());
            }
        }, false);
        element.removeAll();
        for (int i = 0; i < infos.size(); ++i) {
            LockInfo info = (LockInfo)infos.get(i);
            try {
                this.acquire();
                NodeImpl node = (NodeImpl)this.sysSession.getItemManager().getItem(info.getId());
                this.lockMap.put(node.getPrimaryPath(), (Object)info);
                continue;
            }
            catch (RepositoryException e) {
                info.setLive(false);
                if (info.isSessionScoped()) continue;
                needsSave = true;
                continue;
            }
            finally {
                this.release();
            }
        }
        if (needsSave) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeAdded(Path path) {
        this.acquire();
        try {
            PathMap.Element parent = this.lockMap.map(path.getAncestor(1), true);
            if (parent != null) {
                this.refresh((PathMap.Element<LockInfo>)parent);
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to determine path of added node's parent.", (Throwable)e);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeMoved(Path oldPath, Path newPath) {
        this.acquire();
        try {
            PathMap.Element parent = this.lockMap.map(oldPath.getAncestor(1), true);
            if (parent != null) {
                this.refresh((PathMap.Element<LockInfo>)parent);
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to determine path of moved node's parent.", (Throwable)e);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeRemoved(Path path) {
        this.acquire();
        try {
            PathMap.Element parent = this.lockMap.map(path.getAncestor(1), true);
            if (parent != null) {
                this.refresh((PathMap.Element<LockInfo>)parent);
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to determine path of removed node's parent.", (Throwable)e);
        }
        finally {
            this.release();
        }
    }

    public void setEventChannel(LockEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void externalLock(NodeId nodeId, boolean isDeep, String lockOwner) throws RepositoryException {
        this.acquire();
        try {
            Path path = this.getPath(this.sysSession, nodeId);
            InternalLockInfo info = new InternalLockInfo(nodeId, false, isDeep, lockOwner, Long.MAX_VALUE);
            info.setLive(true);
            this.lockMap.put(path, (Object)info);
            this.save();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void externalUnlock(NodeId nodeId) throws RepositoryException {
        this.acquire();
        try {
            Path path = this.getPath(this.sysSession, nodeId);
            PathMap.Element element = this.lockMap.map(path, true);
            if (element == null) {
                throw new LockException("Node not locked: " + path.toString());
            }
            LockInfo info = (LockInfo)element.get();
            if (info == null) {
                throw new LockException("Node not locked: " + path.toString());
            }
            element.set(null);
            info.setLive(false);
            this.save();
        }
        finally {
            this.release();
        }
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        this.lockMap.traverse((PathMap.ElementVisitor)new PathMap.ElementVisitor<LockInfo>(){

            public void elementVisited(PathMap.Element<LockInfo> element) {
                for (int i = 0; i < element.getDepth(); ++i) {
                    builder.append("--");
                }
                builder.append(element.getName());
                int index = element.getIndex();
                if (index != 0 && index != 1) {
                    builder.append('[');
                    builder.append(index);
                    builder.append(']');
                }
                builder.append("  ");
                builder.append(element.get());
                builder.append("\n");
            }
        }, true);
        return builder.toString();
    }

    class InternalLockInfo
    extends LockInfo
    implements SessionListener {
        public InternalLockInfo(NodeId lockToken, boolean sessionScoped, boolean deep, String lockOwner, long timeoutHint) {
            super(lockToken, sessionScoped, deep, lockOwner, timeoutHint);
        }

        @Override
        public void loggingOut(SessionImpl session) {
            if (this.isLive()) {
                if (this.isSessionScoped()) {
                    SessionImpl lockHolder = this.getLockHolder();
                    if (lockHolder == null) {
                        this.setLockHolder(session);
                    }
                    try {
                        NodeImpl node = (NodeImpl)session.getItemManager().getItem(this.getId());
                        node.unlock();
                    }
                    catch (RepositoryException e) {
                        SessionImpl systemSession = LockManagerImpl.this.sysSession;
                        this.setLockHolder(systemSession);
                        try {
                            NodeImpl node = (NodeImpl)systemSession.getItemManager().getItem(this.getId());
                            node.unlock();
                        }
                        catch (RepositoryException re) {
                            log.warn("Unable to remove session-scoped lock on node '" + this.getLockToken() + "': " + e.getMessage());
                            log.debug("Root cause: ", (Throwable)e);
                        }
                    }
                } else if (this.isLockHolder((Session)session)) {
                    session.removeLockToken(this.getLockToken());
                    this.setLockHolder(null);
                }
            }
        }

        @Override
        public void loggedOut(SessionImpl session) {
        }
    }

    private static class HierarchyEvent {
        private final NodeId id;
        private final Path path;
        private Path oldPath;
        private Path newPath;
        private int type;

        public HierarchyEvent(NodeId id, Path path, int type) {
            this.id = id;
            this.path = path;
            this.type = type;
        }

        public void merge(HierarchyEvent event) {
            this.type |= event.type;
            if (event.type == 1) {
                this.newPath = event.path;
                this.oldPath = this.path;
            } else {
                this.oldPath = event.path;
                this.newPath = this.path;
            }
        }

        public Path getOldPath() {
            return this.oldPath;
        }

        public Path getNewPath() {
            return this.newPath;
        }
    }

    private class TimeoutHandlerVisitor
    implements PathMap.ElementVisitor<LockInfo> {
        private TimeoutHandlerVisitor() {
        }

        public void elementVisited(PathMap.Element<LockInfo> element) {
            LockInfo info = (LockInfo)element.get();
            if (info != null && info.isLive() && info.isExpired()) {
                NodeId id = info.getId();
                SessionImpl holder = info.getLockHolder();
                if (holder == null) {
                    info.setLockHolder(LockManagerImpl.this.sysSession);
                    holder = LockManagerImpl.this.sysSession;
                }
                try {
                    log.debug("Try to unlock expired lock. NodeId {}", (Object)id);
                    LockManagerImpl.this.unlock(holder.getNodeById(id));
                }
                catch (RepositoryException e) {
                    log.warn("Unable to expire the lock. NodeId " + id, (Throwable)e);
                }
            }
        }
    }

    private class TimeoutHandler
    implements Runnable {
        private final TimeoutHandlerVisitor visitor;

        private TimeoutHandler() {
            this.visitor = new TimeoutHandlerVisitor();
        }

        @Override
        public void run() {
            LockManagerImpl.this.lockMap.traverse((PathMap.ElementVisitor)this.visitor, false);
        }
    }
}

