/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.xml.DefaultProtectedNodeImporter;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlImporter
extends DefaultProtectedNodeImporter {
    private static final Logger log = LoggerFactory.getLogger(AccessControlImporter.class);
    private static final int STATUS_UNDEFINED = 0;
    private static final int STATUS_AC_FOLDER = 1;
    private static final int STATUS_PRINCIPAL_AC = 2;
    private static final int STATUS_ACL = 3;
    private static final int STATUS_ACE = 4;
    private static final Set<Name> ACE_NODETYPES = new HashSet<Name>(2);
    private final Stack<Integer> prevStatus = new Stack();
    private AccessControlManager acMgr;
    private int status = 0;
    private NodeImpl parent = null;
    private boolean principalbased = false;
    private boolean initialized = false;
    private ImportBehavior importBehavior = ImportBehavior.BEST_EFFORT;
    private JackrabbitAccessControlList acl = null;

    @Override
    public boolean init(JackrabbitSession session, NamePathResolver resolver, boolean isWorkspaceImport, int uuidBehavior, ReferenceChangeTracker referenceTracker) {
        if (super.init(session, resolver, isWorkspaceImport, uuidBehavior, referenceTracker)) {
            if (this.initialized) {
                throw new IllegalStateException("Already initialized");
            }
            try {
                this.acMgr = session.getAccessControlManager();
                this.initialized = true;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return this.initialized;
    }

    @Override
    public boolean start(NodeImpl protectedParent) throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.isStarted()) {
            if (!protectedParent.isSame(this.parent)) {
                throw new IllegalStateException();
            }
            return true;
        }
        if (this.isWorkspaceImport) {
            log.debug("AccessControlImporter may not be used with the WorkspaceImporter");
            return false;
        }
        if (!protectedParent.getDefinition().isProtected()) {
            log.debug("AccessControlImporter may not be started with a non-protected parent.");
            return false;
        }
        if (AccessControlImporter.isPolicyNode(protectedParent)) {
            String parentPath = protectedParent.getParent().getPath();
            this.acl = this.getACL(parentPath);
            if (this.acl == null) {
                log.warn("AccessControlImporter cannot be started: no ACL for {}.", (Object)parentPath);
                return false;
            }
            this.status = 3;
        } else if (AccessControlImporter.isRepoPolicyNode(protectedParent)) {
            this.acl = this.getACL(null);
            if (this.acl == null) {
                log.warn("AccessControlImporter cannot be started: no Repo ACL.");
                return false;
            }
            this.status = 3;
        } else if (protectedParent.isNodeType(AccessControlConstants.NT_REP_ACCESS_CONTROL)) {
            this.status = 1;
            this.principalbased = true;
            this.acl = null;
        }
        if (this.isStarted()) {
            this.parent = protectedParent;
            return true;
        }
        return false;
    }

    private JackrabbitAccessControlList getACL(String path) throws RepositoryException, AccessDeniedException {
        JackrabbitAccessControlList acl = null;
        for (AccessControlPolicy accessControlPolicy : this.acMgr.getPolicies(path)) {
            if (!(accessControlPolicy instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)accessControlPolicy;
            break;
        }
        if (acl != null) {
            for (AccessControlPolicy accessControlPolicy : acl.getAccessControlEntries()) {
                acl.removeAccessControlEntry((AccessControlEntry)accessControlPolicy);
            }
        }
        return acl;
    }

    @Override
    public boolean start(NodeState protectedParent) throws IllegalStateException, RepositoryException {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        if (this.isWorkspaceImport) {
            log.debug("AccessControlImporter may not be used with the WorkspaceImporter");
            return false;
        }
        return false;
    }

    @Override
    public void end(NodeImpl protectedParent) throws RepositoryException {
        if (!this.isStarted()) {
            return;
        }
        if (!this.principalbased) {
            this.checkStatus(3, "STATUS_ACL expected.");
            this.acMgr.setPolicy(this.acl.getPath(), (AccessControlPolicy)this.acl);
        } else {
            this.checkStatus(1, "STATUS_AC_FOLDER expected.");
            if (!this.prevStatus.isEmpty()) {
                throw new ConstraintViolationException("Incomplete protected item tree: " + this.prevStatus.size() + " calls to 'endChildInfo' missing.");
            }
        }
        this.reset();
    }

    @Override
    public void end(NodeState protectedParent) throws IllegalStateException, ConstraintViolationException, RepositoryException {
    }

    @Override
    public void startChildInfo(NodeInfo childInfo, List<PropInfo> propInfos) throws RepositoryException {
        if (!this.isStarted()) {
            return;
        }
        Name ntName = childInfo.getNodeTypeName();
        int previousStatus = this.status;
        if (!this.principalbased) {
            this.checkStatus(3, "Cannot handle childInfo " + childInfo + "; rep:ACL may only contain a single level of child nodes representing the ACEs");
            this.addACE(childInfo, propInfos);
            this.status = 4;
        } else {
            switch (this.status) {
                case 1: {
                    if (AccessControlConstants.NT_REP_ACCESS_CONTROL.equals(ntName)) {
                        this.status = 1;
                    } else if (AccessControlConstants.NT_REP_PRINCIPAL_ACCESS_CONTROL.equals(ntName)) {
                        this.status = 2;
                    } else {
                        throw new ConstraintViolationException("Unexpected node type " + ntName + ". Should be rep:AccessControl or rep:PrincipalAccessControl.");
                    }
                    AccessControlImporter.checkIdMixins(childInfo);
                    break;
                }
                case 2: {
                    if (AccessControlConstants.NT_REP_ACCESS_CONTROL.equals(ntName)) {
                        this.status = 1;
                    } else if (AccessControlConstants.NT_REP_PRINCIPAL_ACCESS_CONTROL.equals(ntName)) {
                        this.status = 2;
                    } else {
                        AccessControlImporter.checkDefinition(childInfo, AccessControlConstants.N_POLICY, AccessControlConstants.NT_REP_ACL);
                        this.status = 3;
                    }
                    AccessControlImporter.checkIdMixins(childInfo);
                    break;
                }
                case 3: {
                    this.addACE(childInfo, propInfos);
                    this.status = 4;
                    break;
                }
                default: {
                    throw new ConstraintViolationException("Cannot handle childInfo " + childInfo + "; unexpected status " + this.status + " .");
                }
            }
        }
        this.prevStatus.push(previousStatus);
    }

    @Override
    public void endChildInfo() throws RepositoryException {
        if (!this.isStarted()) {
            return;
        }
        if (!this.principalbased) {
            this.checkStatus(4, "Upon completion of a NodeInfo the status must be STATUS_ACE.");
        }
        this.status = this.prevStatus.pop();
    }

    private boolean isStarted() {
        return this.status > 0;
    }

    private void reset() {
        this.status = 0;
        this.parent = null;
        this.acl = null;
    }

    private void checkStatus(int expectedStatus, String message) throws ConstraintViolationException {
        if (this.status != expectedStatus) {
            throw new ConstraintViolationException(message);
        }
    }

    private static boolean isPolicyNode(NodeImpl node) throws RepositoryException {
        Name nodeName = node.getQName();
        return AccessControlConstants.N_POLICY.equals(nodeName) && node.isNodeType(AccessControlConstants.NT_REP_ACL);
    }

    private static boolean isRepoPolicyNode(NodeImpl node) throws RepositoryException {
        Name nodeName = node.getQName();
        return AccessControlConstants.N_REPO_POLICY.equals(nodeName) && node.isNodeType(AccessControlConstants.NT_REP_ACL) && node.getDepth() == 1;
    }

    private static void checkDefinition(NodeInfo nInfo, Name expName, Name expNodeTypeName) throws ConstraintViolationException {
        if (expName != null && !expName.equals(nInfo.getName())) {
            throw new ConstraintViolationException("Unexpected Node name " + nInfo.getName() + ". Node name should be " + expName + ".");
        }
        if (expNodeTypeName != null && !expNodeTypeName.equals(nInfo.getNodeTypeName())) {
            throw new ConstraintViolationException("Unexpected node type " + nInfo.getNodeTypeName() + ". Node type should be " + expNodeTypeName + ".");
        }
    }

    private static void checkIdMixins(NodeInfo nInfo) throws ConstraintViolationException {
        Name[] mixins = nInfo.getMixinNames();
        NodeId id = nInfo.getId();
        if (id != null || mixins != null) {
            throw new ConstraintViolationException("The node represented by NodeInfo " + nInfo + " may neither be referenceable nor have mixin types.");
        }
    }

    private void addACE(NodeInfo childInfo, List<PropInfo> propInfos) throws RepositoryException, UnsupportedRepositoryOperationException {
        Name ntName = childInfo.getNodeTypeName();
        if (!ACE_NODETYPES.contains(ntName)) {
            throw new ConstraintViolationException("Cannot handle childInfo " + childInfo + "; expected a valid, applicable rep:ACE node definition.");
        }
        AccessControlImporter.checkIdMixins(childInfo);
        boolean isAllow = AccessControlConstants.NT_REP_GRANT_ACE.equals(ntName);
        Object principal = null;
        Privilege[] privileges = null;
        HashMap<String, TextValue> restrictions = new HashMap<String, TextValue>();
        for (PropInfo pInfo : propInfos) {
            TextValue[] txtVls;
            Value[] values;
            Name name = pInfo.getName();
            if (AccessControlConstants.P_PRINCIPAL_NAME.equals(name)) {
                values = pInfo.getValues(1, this.resolver);
                if (values == null || values.length != 1) {
                    throw new ConstraintViolationException("");
                }
                String pName = values[0].getString();
                principal = this.session.getPrincipalManager().getPrincipal(pName);
                if (principal != null) continue;
                if (this.importBehavior == ImportBehavior.BEST_EFFORT) {
                    principal = new UnknownPrincipal(pName);
                    continue;
                }
                principal = new PrincipalImpl(pName);
                continue;
            }
            if (AccessControlConstants.P_PRIVILEGES.equals(name)) {
                values = pInfo.getValues(7, this.resolver);
                privileges = new Privilege[values.length];
                for (int i = 0; i < values.length; ++i) {
                    privileges[i] = this.acMgr.privilegeFromName(values[i].getString());
                }
                continue;
            }
            for (TextValue txtV : txtVls = pInfo.getTextValues()) {
                restrictions.put(this.resolver.getJCRName(name), txtV);
            }
        }
        if (this.principalbased) {
            ArrayList<JackrabbitAccessControlPolicy> policies = new ArrayList<JackrabbitAccessControlPolicy>();
            if (this.acMgr instanceof JackrabbitAccessControlManager) {
                JackrabbitAccessControlManager jacMgr = (JackrabbitAccessControlManager)this.acMgr;
                policies.addAll(Arrays.asList(jacMgr.getPolicies(principal)));
                policies.addAll(Arrays.asList(jacMgr.getApplicablePolicies(principal)));
            }
            for (AccessControlPolicy accessControlPolicy : policies) {
                if (!(accessControlPolicy instanceof JackrabbitAccessControlList)) continue;
                JackrabbitAccessControlList acl = (JackrabbitAccessControlList)accessControlPolicy;
                HashMap<String, Value> restr = new HashMap<String, Value>();
                for (String restName : acl.getRestrictionNames()) {
                    TextValue txtVal = (TextValue)restrictions.remove(restName);
                    if (txtVal == null) continue;
                    restr.put(restName, txtVal.getValue(acl.getRestrictionType(restName), this.resolver));
                }
                if (!restrictions.isEmpty()) {
                    throw new ConstraintViolationException("ACE childInfo contained restrictions that could not be applied.");
                }
                acl.addEntry((Principal)principal, privileges, isAllow, restr);
                this.acMgr.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
                return;
            }
        } else {
            HashMap<String, Value> restr = new HashMap<String, Value>();
            for (String restName : this.acl.getRestrictionNames()) {
                TextValue txtVal = (TextValue)restrictions.remove(restName);
                if (txtVal == null) continue;
                restr.put(restName, txtVal.getValue(this.acl.getRestrictionType(restName), this.resolver));
            }
            if (!restrictions.isEmpty()) {
                throw new ConstraintViolationException("ACE childInfo contained restrictions that could not be applied.");
            }
            this.acl.addEntry(principal, privileges, isAllow, restr);
            return;
        }
        throw new ConstraintViolationException("Cannot handle childInfo " + childInfo + "; No policy found to apply the ACE.");
    }

    public String getImportBehavior() {
        return this.importBehavior.getString();
    }

    public void setImportBehavior(String importBehaviorStr) {
        this.importBehavior = ImportBehavior.fromString(importBehaviorStr);
    }

    static {
        ACE_NODETYPES.add(AccessControlConstants.NT_REP_DENY_ACE);
        ACE_NODETYPES.add(AccessControlConstants.NT_REP_GRANT_ACE);
    }

    public static enum ImportBehavior {
        DEFAULT("default"),
        BEST_EFFORT("bestEffort");

        private final String value;

        private ImportBehavior(String value) {
            this.value = value;
        }

        public static ImportBehavior fromString(String str) {
            if (str.equals("bestEffort")) {
                return BEST_EFFORT;
            }
            return ImportBehavior.valueOf(str.toUpperCase());
        }

        public String getString() {
            return this.value;
        }
    }
}

