/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import java.util.Collection;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.joda.time.DateTime;

public class NodeUtils {
    static Node getReferencedCiNode(Node node, Value value, Session session) throws RepositoryException {
        String referencedCiUuid = value.getString();
        return NodeUtils.getNodeByUuid(node, referencedCiUuid, session);
    }

    protected static Node getNodeByUuid(Node node, String referencedCiUuid, Session session) throws RepositoryException {
        try {
            return session.getNodeByIdentifier(referencedCiUuid);
        }
        catch (ItemNotFoundException exc) {
            Node frozenNode;
            if (NodeUtils.nodeIsFrozen(node) && (frozenNode = NodeUtils.getFrozenNodeByUuid(referencedCiUuid, session)) != null) {
                return frozenNode;
            }
            throw exc;
        }
    }

    static Node getFrozenNodeByUuid(String uuid, Session session) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = session.getValueFactory();
        Query query = queryManager.createQuery("SELECT * FROM [{http://www.jcp.org/jcr/nt/1.0}frozenNode] WHERE [{http://www.jcp.org/jcr/1.0}frozenUuid] = $uuid", "JCR-SQL2");
        query.bindValue("uuid", valueFactory.createValue(uuid));
        QueryResult result = query.execute();
        NodeIterator resultNodes = result.getNodes();
        if (resultNodes.hasNext()) {
            return resultNodes.nextNode();
        }
        return null;
    }

    static boolean nodeIsFrozen(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode");
    }

    static Type typeOf(Node node) throws RepositoryException {
        return Type.valueOf((String)node.getProperty("$configuration.item.type").getString());
    }

    static PropertyDescriptor descriptorOf(Property property) throws RepositoryException {
        return NodeUtils.typeOf(property.getParent()).getDescriptor().getPropertyDescriptor(property.getName());
    }

    static PropertyDescriptor findContainmentListProperty(Type typeToScan, Type typeOfList) {
        Collection propertyDescriptors = typeToScan.getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getKind() != PropertyKind.LIST_OF_CI || !propertyDescriptor.isAsContainment() || !typeOfList.instanceOf(propertyDescriptor.getReferencedType())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    static CiAttributes readCiAttributes(Node node) throws RepositoryException {
        DateTime createdAt = NodeUtils.readDateProperty(node, "$createdAt");
        DateTime lastModifiedAt = NodeUtils.readDateProperty(node, "$lastModified");
        String createdBy = NodeUtils.readStringProperty(node, "$createdBy");
        String lastModifiedBy = NodeUtils.readStringProperty(node, "$creatingUser");
        return new CiAttributes(createdBy != null ? createdBy : lastModifiedBy, createdAt != null ? createdAt : lastModifiedAt, lastModifiedBy, lastModifiedAt);
    }

    static String readStringProperty(Node node, String propertyName) throws RepositoryException {
        return node.hasProperty(propertyName) ? node.getProperty(propertyName).getString() : null;
    }

    static DateTime readDateProperty(Node node, String propertyName) throws RepositoryException {
        return node.hasProperty(propertyName) ? new DateTime((Object)node.getProperty(propertyName).getDate().getTime()) : null;
    }
}

