/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.Variable;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class SetStringVariable
extends Variable.VariableWithValue<Set<String>> {
    @PublicApiMember
    @Property(required=false, description="Value of the release variable or default value of the template variable")
    protected Set<String> value;

    @Override
    @PublicApiMember
    public Set<String> getValue() {
        return this.value == null ? null : Sets.newHashSet(this.value);
    }

    @Override
    public Set<String> getEmptyValue() {
        return Sets.newHashSet();
    }

    @Override
    public boolean isValueEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    @Override
    @PublicApiMember
    public void setValue(Set<String> value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        if (newValue == null) {
            this.setValue(null);
        } else if (newValue instanceof Collection) {
            Collection items = (Collection)newValue;
            Set<String> set = items.stream().map(String::valueOf).collect(Collectors.toSet());
            this.setValue(set);
        } else {
            throw new IllegalArgumentException(String.format("Cannot set instance of %s into Set of strings variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        Set withQuotes = this.getValue().stream().map(e -> String.format("'%s'", this.escapeQuotes((String)e))).collect(Collectors.toSet());
        return String.format("set([%s])", Joiner.on((String)", ").join(new TreeSet(withQuotes)));
    }

    @Override
    public String getEmptyValueAsString() {
        return "set()";
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return value instanceof Collection;
    }
}

