/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.PoisonPill$;
import akka.actor.Props;
import akka.actor.Props$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingGuardian;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.cluster.sharding.ShardCoordinator;
import akka.cluster.sharding.ShardRegion;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Eu!B\u0001\u0003\u0011\u0003I\u0011aD\"mkN$XM]*iCJ$\u0017N\\4\u000b\u0005\r!\u0011\u0001C:iCJ$\u0017N\\4\u000b\u0005\u00151\u0011aB2mkN$XM\u001d\u0006\u0002\u000f\u0005!\u0011m[6b\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\u00025\u0011qb\u00117vgR,'o\u00155be\u0012LgnZ\n\u0006\u00179!\u0012\u0011\u000e\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007UA\"$D\u0001\u0017\u0015\t9b!A\u0003bGR|'/\u0003\u0002\u001a-\tYQ\t\u001f;f]NLwN\\%e!\tQ1D\u0002\u0003\r\u0005\u0001a2cA\u000e\u000f;A\u0011QCH\u0005\u0003?Y\u0011\u0011\"\u0012=uK:\u001c\u0018n\u001c8\t\u0011\u0005Z\"\u0011!Q\u0001\n\t\naa]=ti\u0016l\u0007CA\u000b$\u0013\t!cCA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W\u000eC\u0003'7\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u00035!BQ!I\u0013A\u0002\tBq!B\u000eC\u0002\u0013%!&F\u0001,!\taS&D\u0001\u0005\u0013\tqCAA\u0004DYV\u001cH/\u001a:\t\rAZ\u0002\u0015!\u0003,\u0003!\u0019G.^:uKJ\u0004\u0003b\u0002\u001a\u001c\u0005\u0004%IaM\u0001\be\u0016<\u0017n\u001c8t+\u0005!\u0004\u0003B\u001b=}%k\u0011A\u000e\u0006\u0003oa\n!bY8oGV\u0014(/\u001a8u\u0015\tI$(\u0001\u0003vi&d'\"A\u001e\u0002\t)\fg/Y\u0005\u0003{Y\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tydI\u0004\u0002A\tB\u0011\u0011\tE\u0007\u0002\u0005*\u00111\tC\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\t\u0011\u0005UQ\u0015BA&\u0017\u0005!\t5\r^8s%\u00164\u0007BB'\u001cA\u0003%A'\u0001\u0005sK\u001eLwN\\:!\u0011!y5\u0004#b\u0001\n\u0013\u0001\u0016\u0001C4vCJ$\u0017.\u00198\u0016\u0003%CaAU\u000e\u0005\u0002\u0019\u0019\u0016A\u0005:fcVL'/Z\"mkN$XM\u001d*pY\u0016$\"\u0001V,\u0011\u0005=)\u0016B\u0001,\u0011\u0005\u0011)f.\u001b;\t\u000ba\u000b\u0006\u0019A-\u0002\tI|G.\u001a\t\u0004\u001fis\u0014BA.\u0011\u0005\u0019y\u0005\u000f^5p]\")Ql\u0007C\u0001=\u0006)1\u000f^1siRI\u0011jX1gWRL\u0018Q\u0001\u0005\u0006Ar\u0003\rAP\u0001\tif\u0004XMT1nK\")!\r\u0018a\u0001G\u0006YQM\u001c;jif\u0004&o\u001c9t!\t)B-\u0003\u0002f-\t)\u0001K]8qg\")q\r\u0018a\u0001Q\u0006A1/\u001a;uS:<7\u000f\u0005\u0002\u000bS&\u0011!N\u0001\u0002\u0018\u00072,8\u000f^3s'\"\f'\u000fZ5oON+G\u000f^5oONDQ\u0001\u001c/A\u00025\fq\"\u001a=ue\u0006\u001cG/\u00128uSRL\u0018\n\u001a\t\u0003]Ft!AC8\n\u0005A\u0014\u0011aC*iCJ$'+Z4j_:L!A]:\u0003\u001f\u0015CHO]1di\u0016sG/\u001b;z\u0013\u0012T!\u0001\u001d\u0002\t\u000bUd\u0006\u0019\u0001<\u0002\u001d\u0015DHO]1diNC\u0017M\u001d3JIB\u0011an^\u0005\u0003qN\u0014a\"\u0012=ue\u0006\u001cGo\u00155be\u0012LE\rC\u0003{9\u0002\u000710\u0001\nbY2|7-\u0019;j_:\u001cFO]1uK\u001eL\bC\u0001?\u0000\u001d\tQQ0\u0003\u0002\u007f\u0005\u0005\u00012\u000b[1sI\u000e{wN\u001d3j]\u0006$xN]\u0005\u0005\u0003\u0003\t\u0019AA\fTQ\u0006\u0014H-\u00117m_\u000e\fG/[8o'R\u0014\u0018\r^3hs*\u0011aP\u0001\u0005\b\u0003\u000fa\u0006\u0019AA\u0005\u0003IA\u0017M\u001c3PM\u001a\u001cFo\u001c9NKN\u001c\u0018mZ3\u0011\u0007=\tY!C\u0002\u0002\u000eA\u00111!\u00118z\u0011\u0019i6\u0004\"\u0001\u0002\u0012QY\u0011*a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0011\u0019\u0001\u0017q\u0002a\u0001}!1!-a\u0004A\u0002\rDaaZA\b\u0001\u0004A\u0007B\u00027\u0002\u0010\u0001\u0007Q\u000e\u0003\u0004v\u0003\u001f\u0001\rA\u001e\u0005\u0007;n!\t!a\b\u0015\u001b%\u000b\t#a\t\u0002&\u0005\u001d\u0012\u0011GA\u001a\u0011\u0019\u0001\u0017Q\u0004a\u0001}!1!-!\bA\u0002\rDaaZA\u000f\u0001\u0004A\u0007\u0002CA\u0015\u0003;\u0001\r!a\u000b\u0002!5,7o]1hK\u0016CHO]1di>\u0014\bc\u00018\u0002.%\u0019\u0011qF:\u0003!5+7o]1hK\u0016CHO]1di>\u0014\bB\u0002>\u0002\u001e\u0001\u00071\u0010\u0003\u0005\u0002\b\u0005u\u0001\u0019AA\u0005\u0011\u0019i6\u0004\"\u0001\u00028QI\u0011*!\u000f\u0002<\u0005u\u0012q\b\u0005\u0007A\u0006U\u0002\u0019\u0001 \t\r\t\f)\u00041\u0001d\u0011\u00199\u0017Q\u0007a\u0001Q\"A\u0011\u0011FA\u001b\u0001\u0004\tY\u0003C\u0004\u0002Dm!\t!!\u0012\u0002\u0015M$\u0018M\u001d;Qe>D\u0018\u0010F\u0005J\u0003\u000f\nI%a\u0013\u0002N!1\u0001-!\u0011A\u0002yBa\u0001WA!\u0001\u0004I\u0006B\u00027\u0002B\u0001\u0007Q\u000e\u0003\u0004v\u0003\u0003\u0002\rA\u001e\u0005\b\u0003\u0007ZB\u0011AA))\u001dI\u00151KA+\u0003?Ba\u0001YA(\u0001\u0004q\u0004b\u0002-\u0002P\u0001\u0007\u0011q\u000b\t\u0006\u00033\nYFP\u0007\u0002q%\u0019\u0011Q\f\u001d\u0003\u0011=\u0003H/[8oC2D\u0001\"!\u000b\u0002P\u0001\u0007\u00111\u0006\u0005\b\u0003GZB\u0011AA3\u0003-\u0019\b.\u0019:e%\u0016<\u0017n\u001c8\u0015\u0007%\u000b9\u0007\u0003\u0004a\u0003C\u0002\rA\u0010\t\u0004+\u0005-\u0014bAA7-\t\u0019R\t\u001f;f]NLwN\\%e!J|g/\u001b3fe\"1ae\u0003C\u0001\u0003c\"\u0012!\u0003\u0005\b\u0003kZA\u0011IA<\u0003\r9W\r\u001e\u000b\u00045\u0005e\u0004bB\u0011\u0002t\u0001\u0007\u00111\u0010\t\u0004+\u0005u\u0014bAA@-\tY\u0011i\u0019;peNK8\u000f^3n\u0011\u001d\t\u0019i\u0003C!\u0003\u000b\u000ba\u0001\\8pWV\u0004HCAAD\u001d\tQ\u0001\u0001C\u0004\u0002\f.!\t%!$\u0002\u001f\r\u0014X-\u0019;f\u000bb$XM\\:j_:$2AGAH\u0011\u0019\t\u0013\u0011\u0012a\u0001E\u0001")
public class ClusterSharding
implements Extension {
    private ActorRef guardian;
    private final ExtendedActorSystem system;
    private final Cluster cluster;
    private final ConcurrentHashMap<String, ActorRef> regions;
    private volatile boolean bitmap$0;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.apply(actorSystem);
    }

    public static ClusterSharding createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterSharding$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterSharding$ lookup() {
        return ClusterSharding$.MODULE$.lookup();
    }

    public static ClusterSharding get(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.get(actorSystem);
    }

    private Cluster cluster() {
        return this.cluster;
    }

    private ConcurrentHashMap<String, ActorRef> regions() {
        return this.regions;
    }

    private ActorRef guardian$lzycompute() {
        ClusterSharding clusterSharding = this;
        synchronized (clusterSharding) {
            if (!this.bitmap$0) {
                String guardianName = this.system.settings().config().getString("akka.cluster.sharding.guardian-name");
                String string = this.system.settings().config().getString("akka.cluster.sharding.use-dispatcher");
                String string2 = "".equals(string) ? "akka.actor.default-dispatcher" : string;
                String dispatcher = string2;
                this.guardian = this.system.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(ClusterShardingGuardian.class)).withDispatcher(dispatcher), guardianName);
                this.bitmap$0 = true;
            }
        }
        return this.guardian;
    }

    private ActorRef guardian() {
        return !this.bitmap$0 ? this.guardian$lzycompute() : this.guardian;
    }

    public void requireClusterRole(Option<String> role) {
        Set set = this.cluster().selfRoles();
        Predef$.MODULE$.require(role.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem))), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This cluster member [", "] doesn't have the role [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cluster().selfAddress(), role})));
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        ActorRef shardRegion;
        this.requireClusterRole(settings.role());
        Timeout timeout = this.system.settings().CreationTimeout();
        ClusterShardingGuardian.Start startMsg = new ClusterShardingGuardian.Start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
        ActorRef qual$1 = package$.MODULE$.ask(this.guardian());
        ClusterShardingGuardian.Start x$1 = startMsg;
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        Object object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration());
        if (!(object instanceof ClusterShardingGuardian.Started)) {
            throw new MatchError(object);
        }
        ClusterShardingGuardian.Started started = (ClusterShardingGuardian.Started)object;
        ActorRef actorRef = shardRegion = started.shardRegion();
        ActorRef shardRegion2 = actorRef;
        this.regions().put(typeName, shardRegion2);
        return shardRegion2;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ShardCoordinator.LeastShardAllocationStrategy allocationStrategy = new ShardCoordinator.LeastShardAllocationStrategy(settings.tuningParameters().leastShardAllocationRebalanceThreshold(), settings.tuningParameters().leastShardAllocationMaxSimultaneousRebalance());
        return this.start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.start(typeName, entityProps, settings, (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.messageExtractor$1.entityId(A1) != null ? new Tuple2((Object)this.messageExtractor$1.entityId(A1), this.messageExtractor$1.entityMessage(A1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = this.messageExtractor$1.entityId(object) != null;
                return bl;
            }
            {
                this.messageExtractor$1 = messageExtractor$1;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg), allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor) {
        ShardCoordinator.LeastShardAllocationStrategy allocationStrategy = new ShardCoordinator.LeastShardAllocationStrategy(settings.tuningParameters().leastShardAllocationRebalanceThreshold(), settings.tuningParameters().leastShardAllocationMaxSimultaneousRebalance());
        return this.start(typeName, entityProps, settings, messageExtractor, allocationStrategy, PoisonPill$.MODULE$);
    }

    public ActorRef startProxy(String typeName, Option<String> role, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ActorRef shardRegion;
        ActorRef x$6;
        Timeout x$5;
        ClusterShardingGuardian.StartProxy x$4;
        Timeout timeout = this.system.settings().CreationTimeout();
        ClusterShardingSettings settings = ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system).withRole(role);
        ClusterShardingGuardian.StartProxy startMsg = new ClusterShardingGuardian.StartProxy(typeName, settings, extractEntityId, extractShardId);
        ActorRef qual$2 = package$.MODULE$.ask(this.guardian());
        Object object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$2, (Object)(x$4 = startMsg), x$5 = timeout, x$6 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$2, (Object)x$4)), (Duration)timeout.duration());
        if (!(object instanceof ClusterShardingGuardian.Started)) {
            throw new MatchError(object);
        }
        ClusterShardingGuardian.Started started = (ClusterShardingGuardian.Started)object;
        ActorRef actorRef = shardRegion = started.shardRegion();
        ActorRef shardRegion2 = actorRef;
        this.regions().put(typeName, shardRegion2);
        return shardRegion2;
    }

    public ActorRef startProxy(String typeName, Optional<String> role, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, (Option<String>)Option$.MODULE$.apply(role.orElse(null)), (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$2;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = this.messageExtractor$2.entityId(A1) != null ? new Tuple2((Object)this.messageExtractor$2.entityId(A1), this.messageExtractor$2.entityMessage(A1)) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = this.messageExtractor$2.entityId(object) != null;
                return bl;
            }
            {
                this.messageExtractor$2 = messageExtractor$2;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg));
    }

    public ActorRef shardRegion(String typeName) {
        ActorRef actorRef = this.regions().get(typeName);
        if (actorRef == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shard type [", "] must be started first"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
        }
        ActorRef actorRef2 = actorRef;
        return actorRef2;
    }

    public ClusterSharding(ExtendedActorSystem system) {
        this.system = system;
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)system);
        this.regions = new ConcurrentHashMap();
    }
}

