/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.telnet.term.TelnetLifeCycle;
import org.crsh.vfs.Resource;

public class TelnetPlugin
extends CRaSHPlugin<TelnetPlugin> {
    public static final PropertyDescriptor<Integer> TELNET_PORT = PropertyDescriptor.create((String)"telnet.port", (Integer)5000, (String)"The telnet port");
    private TelnetLifeCycle lifeCycle;

    public TelnetPlugin getImplementation() {
        return this;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Collections.singletonList(TELNET_PORT);
    }

    public void init() {
        Resource res;
        PluginContext context = this.getContext();
        Resource config = null;
        URL configURL = TelnetPlugin.class.getResource("/crash/telnet.properties");
        if (configURL != null) {
            try {
                this.log.log(Level.FINE, "Found embedded telnet config url " + configURL);
                config = new Resource("telnet.properties", configURL);
            }
            catch (IOException e) {
                this.log.log(Level.FINE, "Could not load embedded telnet config url " + configURL + " will bypass it", e);
            }
        }
        if ((res = this.getContext().loadResource("telnet.properties", ResourceKind.CONFIG)) != null) {
            config = res;
            this.log.log(Level.FINE, "Found telnet config url " + configURL);
        }
        if (configURL == null) {
            this.log.log(Level.INFO, "Could not boot Telnet due to missing config");
            return;
        }
        TelnetLifeCycle lifeCycle = new TelnetLifeCycle(context);
        lifeCycle.setConfig(config);
        Integer port = (Integer)context.getProperty(TELNET_PORT);
        if (port == null) {
            port = (Integer)TelnetPlugin.TELNET_PORT.defaultValue;
        }
        lifeCycle.setPort(port);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.lifeCycle.destroy();
        }
    }
}

