/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryInitializer;
import com.xebialabs.xlplatform.XlRepositoryFactory;
import com.xebialabs.xlplatform.repository.XlJcrRepositoryInitializer;
import javax.annotation.PostConstruct;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.ExtendedRepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitRepositoryFactoryBean
implements XlRepositoryFactory {
    private final XlJcrRepositoryInitializer xlJcrRepositoryInitializer;
    private final JackrabbitRepository repository;
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitRepositoryFactoryBean.class);

    public JackrabbitRepositoryFactoryBean(RepositoryConfig repositoryConfig, JackrabbitRepositoryInitializer xlJcrRepositoryInitializer) throws RepositoryException {
        this.xlJcrRepositoryInitializer = xlJcrRepositoryInitializer;
        logger.info("Starting JCR repository");
        this.repository = ExtendedRepositoryImpl.create(repositoryConfig);
        logger.debug("Started JCR repository");
    }

    @PostConstruct
    public void initialize() {
        this.xlJcrRepositoryInitializer.init((Repository)this.repository);
    }

    public Repository getObject() {
        return this.repository;
    }

    public void destroy() {
        this.repository.shutdown();
    }

    public Class<Repository> getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

