/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskAssessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Metadata(label="TaskRetriesAssessor")
public class TaskRetriesRiskAssessor
extends RiskAssessor {
    private static final String TASK_RETRIES_HEADLINE = "Release contains failed tasks";
    private static final String TASK_RETRIES_MESSAGE = "%s has failed %d %s";

    @Override
    public RiskAssessment execute(Release release) {
        List<Task> failedActiveTasks = release.getActiveTasks().stream().filter(task -> task.isFailed() || task.isFailing()).collect(Collectors.toList());
        int totalFailedCount = failedActiveTasks.stream().mapToInt(Task::getFailuresCount).sum();
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        if (!failedActiveTasks.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            failedActiveTasks.forEach(task -> messages.add(String.format(TASK_RETRIES_MESSAGE, task.getTitle(), task.getFailuresCount(), this.suffix(task.getFailuresCount()))));
            int score = Math.min(100, 40 + 10 * totalFailedCount);
            assessment.setScore(score);
            assessment.setMessages(messages);
            assessment.setHeadline(TASK_RETRIES_HEADLINE);
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        return assessment;
    }

    private String suffix(int failuresCount) {
        return failuresCount == 1 ? "time" : "times";
    }
}

