/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.conversion.StringCoder;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.PasswordUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ServerConfiguration.class);
    public static final String DEFAULT_WEBCONTENT_PACKAGE = "web";
    public static final String DEFAULT_WEB_CONTEXT_ROOT = "/";
    public static final String DEFAULT_ADMIN_PASSWORD = "admin";
    public static final String DEFAULT_DEPLOYIT_KEYS_KEYSTORE_PASSWORD = "deployit";
    public static final int DEFAULT_HTTP_PORT = 4516;
    public static final int DEFAULT_HTTPS_PORT = 4517;
    public static final int DEFAULT_MAX_THREADS = 150;
    public static final int DEFAULT_MIN_THREADS = 30;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    public static final int DEFAULT_STOP_TIMEOUT = 1000;
    public static final int DEFAULT_UPLOAD_FILE_BUFFER_SIZE = 262144;
    public static final String FILE_URL_PREFIX = "file://";
    public static final String DEFAULT_JCR_REPOSITORY_PATH = "repository";
    public static final String DEFAULT_IMPORTABLE_PACKAGES_PATH = "importablePackages";
    public static final String DEFAULT_HTTP_BIND_ADDRESS = "0.0.0.0";
    public static final int DEFAULT_CLIENT_SERVER_POLL_DELAY = 30000;
    public static final String DEFAULT_MAINTENANCE_FORBIDDEN_REQUESTS = "deployit/task:POST,deployit/tasks/v2:POST,deployit/control:POST";
    public static final String KEY_USE_SSL = "ssl";
    public static final String KEY_USE_MUTUAL_SSL = "ssl.mutual";
    public static final String KEY_SSL_PROTOCOL = "ssl.protocol";
    public static final String KEY_KEYSTORE_PATH = "keystore.path";
    public static final String KEY_TRUSTSTORE_PATH = "truststore.path";
    public static final String KEY_HTTP_BIND_ADDRESS = "http.bind.address";
    public static final String KEY_HTTP_PORT = "http.port";
    public static final String KEY_HTTP_CONTEXT_ROOT = "http.context.root";
    public static final String KEY_WELCOME_PAGE = "http.welcome.page";
    public static final String KEY_JCR_REPOSITORY_PATH = "jcr.repository.path";
    public static final String KEY_IMPORTABLE_PACKAGES_PATH = "importable.packages.path";
    public static final String KEY_MINIMUM_THREADS = "threads.min";
    public static final String KEY_MAXIMUM_THREADS = "threads.max";
    public static final String KEY_CLIENT_SESSION_TIMEOUT_MINUTES = "client.session.timeout.minutes";
    public static final String KEY_CLIENT_SESSION_REMEMBER_ENABLED = "client.session.remember.enabled";
    public static final String KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES = "client.automatically.map.all.deployables";
    public static final String KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_INITIAL = "client.automatically.map.all.deployables.on.initial";
    public static final String KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_UPDATE = "client.automatically.map.all.deployables.on.update";
    public static final String KEY_SERVER_RESOLVE_APPLICATION_DEPENDENCIES = "server.resolve.application.dependencies";
    public static final String KEY_CLIENT_SERVER_POLL_DELAY = "client.server_poll.delay";
    public static final String KEY_HIDE_INTERNALS = "hide.internals";
    public static final String KEY_SERVER_URL = "server.url";
    public static final String KEY_SERVER_MAPPING_OVERRIDE_DEPLOYED_FIELDS_ON_UPDATE = "server.mapping.override.deployed.fields.on.update";
    public static final String KEY_MAINTENANCE_FORBIDDEN_REQUESTS = "maintenance.forbidden_paths";
    public static final String KEY_UPLOAD_FILE_BUFFER_SIZE = "http.upload.buffer";
    public static final String KEY_HTTP_IDLE_SECONDS = "http.idle.seconds";
    protected String keyStorePath;
    protected String keyStorePassword;
    protected String keyStoreKeyPassword;
    protected String trustStorePath;
    protected String trustStorePassword;
    private String httpBindAddress = "0.0.0.0";
    protected int httpPort = 4516;
    private String webContextRoot = "/";
    private String webWelcomePage;
    protected String jcrRepositoryPath;
    protected String importablePackagesPath;
    protected boolean ssl;
    protected boolean mutualSsl;
    protected String sslProtocol;
    protected int minThreads;
    protected String adminPassword;
    private boolean dirty;
    protected int maxThreads;
    private int clientSessionTimeoutMinutes;
    private boolean clientSessionRememberEnabled = true;
    private boolean hideInternals;
    private String serverUrl;
    private String repositoryKeyStorePassword;
    private Integer httpIdleSeconds = 30;
    private String maintenanceForbiddenRequests = "deployit/task:POST,deployit/tasks/v2:POST,deployit/control:POST";
    private int clientServerPollDelay = 30000;
    private Map<String, String> customPasswords = new HashMap<String, String>();
    private boolean newConfiguration = true;
    private static final AtomicReference<ServerConfiguration> CONFIG = new AtomicReference();
    private File configFile;
    private PasswordEncrypter defaultEncrypter = new PasswordEncrypter(DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);
    private boolean clientAutomaticallyMapAllDeployables = true;
    private boolean clientAutomaticallyMapAllDeployablesOnInitial = false;
    private boolean clientAutomaticallyMapAllDeployablesOnUpdate = false;
    private boolean serverResolveApplicationDependencies = true;
    private boolean serverMappingOverrideDeployedFieldsOnUpdate = true;
    private Integer uploadFileBufferSize;

    public ServerConfiguration() {
        this.setDefaults();
    }

    public static ServerConfiguration getInstance() {
        return CONFIG.get();
    }

    public static void setInstance(ServerConfiguration deployitConfig) {
        CONFIG.compareAndSet(null, deployitConfig);
    }

    public void setDefaults() {
        this.setJcrRepositoryPath(DEFAULT_JCR_REPOSITORY_PATH);
        this.setHttpBindAddress(DEFAULT_HTTP_BIND_ADDRESS);
        this.setHttpPort(4516);
        this.setImportablePackagesPath(DEFAULT_IMPORTABLE_PACKAGES_PATH);
        this.setMinThreads(30);
        this.setMaxThreads(150);
        this.setAdminPassword(DEFAULT_ADMIN_PASSWORD);
        this.setUploadFileBufferSize(262144);
    }

    public void load(Properties properties) {
        this.load(properties, true);
    }

    public void load(Properties properties, boolean encryptedPasswords) {
        this.ssl = "true".equalsIgnoreCase(properties.getProperty(KEY_USE_SSL, "false"));
        this.mutualSsl = "true".equalsIgnoreCase(properties.getProperty(KEY_USE_MUTUAL_SSL, "false"));
        this.sslProtocol = properties.getProperty(KEY_SSL_PROTOCOL);
        this.keyStorePath = properties.getProperty(KEY_KEYSTORE_PATH);
        this.keyStorePassword = properties.getProperty("keystore.password");
        this.keyStoreKeyPassword = properties.getProperty("keystore.keypassword");
        this.trustStorePath = properties.getProperty(KEY_TRUSTSTORE_PATH);
        this.trustStorePassword = properties.getProperty("truststore.password");
        this.repositoryKeyStorePassword = properties.getProperty("repository.keystore.password");
        this.httpBindAddress = properties.getProperty(KEY_HTTP_BIND_ADDRESS, this.httpBindAddress);
        this.httpPort = ServerConfiguration.parseIntSilent(properties, KEY_HTTP_PORT, this.httpPort);
        this.webContextRoot = properties.getProperty(KEY_HTTP_CONTEXT_ROOT, this.webContextRoot);
        this.webWelcomePage = properties.getProperty(KEY_WELCOME_PAGE);
        this.minThreads = ServerConfiguration.parseIntSilent(properties, KEY_MINIMUM_THREADS, this.minThreads);
        this.maxThreads = ServerConfiguration.parseIntSilent(properties, KEY_MAXIMUM_THREADS, this.maxThreads);
        this.clientSessionTimeoutMinutes = ServerConfiguration.parseIntSilent(properties, KEY_CLIENT_SESSION_TIMEOUT_MINUTES, this.clientSessionTimeoutMinutes);
        this.clientSessionRememberEnabled = "true".equalsIgnoreCase(properties.getProperty(KEY_CLIENT_SESSION_REMEMBER_ENABLED, "true"));
        this.clientAutomaticallyMapAllDeployables = "true".equalsIgnoreCase(properties.getProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES, "true"));
        this.clientAutomaticallyMapAllDeployablesOnInitial = "true".equalsIgnoreCase(properties.getProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_INITIAL, "false"));
        this.clientAutomaticallyMapAllDeployablesOnUpdate = "true".equalsIgnoreCase(properties.getProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_UPDATE, "false"));
        this.serverResolveApplicationDependencies = "true".equalsIgnoreCase(properties.getProperty(KEY_SERVER_RESOLVE_APPLICATION_DEPENDENCIES, "true"));
        this.jcrRepositoryPath = properties.getProperty(KEY_JCR_REPOSITORY_PATH, this.jcrRepositoryPath);
        this.importablePackagesPath = properties.getProperty(KEY_IMPORTABLE_PACKAGES_PATH, this.importablePackagesPath);
        this.adminPassword = properties.getProperty("admin.password", DEFAULT_ADMIN_PASSWORD);
        this.hideInternals = "true".equalsIgnoreCase(properties.getProperty(KEY_HIDE_INTERNALS, "false"));
        this.serverUrl = properties.getProperty(KEY_SERVER_URL, this.serverUrl);
        this.serverMappingOverrideDeployedFieldsOnUpdate = "true".equalsIgnoreCase(properties.getProperty(KEY_SERVER_MAPPING_OVERRIDE_DEPLOYED_FIELDS_ON_UPDATE, "true"));
        this.maintenanceForbiddenRequests = properties.getProperty(KEY_MAINTENANCE_FORBIDDEN_REQUESTS, this.maintenanceForbiddenRequests);
        this.clientServerPollDelay = ServerConfiguration.parseIntSilent(properties, KEY_CLIENT_SERVER_POLL_DELAY, this.clientServerPollDelay);
        this.uploadFileBufferSize = ServerConfiguration.parseIntSilent(properties, KEY_UPLOAD_FILE_BUFFER_SIZE, 262144);
        this.httpIdleSeconds = ServerConfiguration.parseIntSilent(properties, KEY_HTTP_IDLE_SECONDS, 30);
        for (String key : properties.stringPropertyNames()) {
            if (!PasswordUtil.isCustomPassword(key)) continue;
            String password = properties.getProperty(key);
            this.customPasswords.put(key, password);
        }
        if (Strings.isNotEmpty((String)this.repositoryKeyStorePassword)) {
            if (this.defaultEncrypter.isEncodedAndDecryptable(this.repositoryKeyStorePassword)) {
                this.repositoryKeyStorePassword = this.defaultEncrypter.decrypt(this.repositoryKeyStorePassword);
            } else {
                logger.info("Read plaintext repository keystore password from the file, marking as dirty to save encrypted.");
                this.dirty = true;
            }
        }
        if (encryptedPasswords) {
            this.loadEncryptedPasswords();
        }
        this.newConfiguration = false;
    }

    public void loadEncryptedPasswords() {
        if (PasswordEncrypter.getInstance().isEncodedAndDecryptable(this.adminPassword)) {
            this.adminPassword = PasswordEncrypter.getInstance().decrypt(this.adminPassword);
        } else {
            logger.info("Read plaintext admin password from the file, marking as dirty to save encrypted.");
            this.dirty = true;
        }
        if (PasswordEncrypter.getInstance().isEncodedAndDecryptable(this.keyStoreKeyPassword)) {
            this.keyStoreKeyPassword = PasswordEncrypter.getInstance().decrypt(this.keyStoreKeyPassword);
        } else if (Strings.isNotEmpty((String)this.keyStoreKeyPassword)) {
            logger.info("Read plaintext keystore key password from the file, marking as dirty to save encrypted.");
            this.dirty = true;
        }
        if (PasswordEncrypter.getInstance().isEncodedAndDecryptable(this.keyStorePassword)) {
            this.keyStorePassword = PasswordEncrypter.getInstance().decrypt(this.keyStorePassword);
        } else if (Strings.isNotEmpty((String)this.keyStorePassword)) {
            logger.info("Read plaintext keystore password from the file, marking as dirty to save encrypted.");
            this.dirty = true;
        }
        if (PasswordEncrypter.getInstance().isEncodedAndDecryptable(this.trustStorePassword)) {
            this.trustStorePassword = PasswordEncrypter.getInstance().decrypt(this.trustStorePassword);
        } else if (Strings.isNotEmpty((String)this.trustStorePassword)) {
            logger.info("Read plaintext truststore password from the file, marking as dirty to save encrypted.");
            this.dirty = true;
        }
        for (Map.Entry<String, String> entry : this.customPasswords.entrySet()) {
            if (PasswordEncrypter.getInstance().isEncodedAndDecryptable(entry.getValue())) {
                this.customPasswords.put(entry.getKey(), PasswordEncrypter.getInstance().decrypt(entry.getValue()));
                continue;
            }
            if (!Strings.isNotEmpty((String)entry.getValue())) continue;
            logger.info("Read plaintext '" + entry.getKey() + "' from the file, marking as dirty to save encrypted.");
            this.dirty = true;
        }
    }

    private static int parseIntSilent(Properties properties, String KEY, int defaultValue) {
        try {
            return Integer.parseInt(properties.getProperty(KEY));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void save(Properties properties) {
        if (this.repositoryKeyStorePassword != null) {
            properties.setProperty("repository.keystore.password", this.defaultEncrypter.ensureEncrypted(this.getRepositoryKeyStorePassword()));
        }
        properties.setProperty(KEY_USE_SSL, Boolean.toString(this.isSsl()));
        properties.setProperty(KEY_USE_MUTUAL_SSL, Boolean.toString(this.isMutualSsl()));
        if (this.isSsl()) {
            properties.setProperty(KEY_KEYSTORE_PATH, this.getKeyStorePath());
            if (this.keyStorePassword != null) {
                properties.setProperty("keystore.password", PasswordEncrypter.getInstance().ensureEncrypted(this.getKeyStorePassword()));
            }
            if (this.keyStoreKeyPassword != null) {
                properties.setProperty("keystore.keypassword", PasswordEncrypter.getInstance().ensureEncrypted(this.getKeyStoreKeyPassword()));
            }
            if (this.getSslProtocol() != null) {
                properties.setProperty(KEY_SSL_PROTOCOL, this.getSslProtocol());
            }
            if (this.isMutualSsl()) {
                properties.setProperty(KEY_TRUSTSTORE_PATH, this.getTrustStorePath());
                if (this.trustStorePassword != null) {
                    properties.setProperty("truststore.password", PasswordEncrypter.getInstance().ensureEncrypted(this.getTrustStorePassword()));
                }
            }
        }
        properties.setProperty(KEY_HTTP_BIND_ADDRESS, this.httpBindAddress);
        properties.setProperty(KEY_HTTP_PORT, Integer.toString(this.getHttpPort()));
        properties.setProperty(KEY_HTTP_CONTEXT_ROOT, this.webContextRoot);
        if (this.webWelcomePage != null) {
            properties.setProperty(KEY_WELCOME_PAGE, this.webWelcomePage);
        }
        properties.setProperty(KEY_JCR_REPOSITORY_PATH, this.getJcrRepositoryPath());
        properties.setProperty(KEY_IMPORTABLE_PACKAGES_PATH, this.getImportablePackagesPath());
        properties.setProperty(KEY_MINIMUM_THREADS, Integer.toString(this.minThreads));
        properties.setProperty(KEY_MAXIMUM_THREADS, Integer.toString(this.maxThreads));
        properties.setProperty(KEY_CLIENT_SESSION_TIMEOUT_MINUTES, Integer.toString(this.clientSessionTimeoutMinutes));
        properties.setProperty(KEY_CLIENT_SESSION_REMEMBER_ENABLED, Boolean.toString(this.clientSessionRememberEnabled));
        properties.setProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES, Boolean.toString(this.clientAutomaticallyMapAllDeployables));
        properties.setProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_INITIAL, Boolean.toString(this.clientAutomaticallyMapAllDeployablesOnInitial));
        properties.setProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_UPDATE, Boolean.toString(this.clientAutomaticallyMapAllDeployablesOnUpdate));
        properties.setProperty(KEY_CLIENT_SERVER_POLL_DELAY, Integer.toString(this.clientServerPollDelay));
        properties.setProperty(KEY_SERVER_MAPPING_OVERRIDE_DEPLOYED_FIELDS_ON_UPDATE, Boolean.toString(this.serverMappingOverrideDeployedFieldsOnUpdate));
        properties.setProperty(KEY_SERVER_RESOLVE_APPLICATION_DEPENDENCIES, Boolean.toString(this.serverResolveApplicationDependencies));
        properties.setProperty(KEY_HIDE_INTERNALS, Boolean.toString(this.hideInternals));
        properties.setProperty("admin.password", PasswordEncrypter.getInstance().ensureEncrypted(this.adminPassword != null ? this.getAdminPassword() : DEFAULT_ADMIN_PASSWORD));
        properties.setProperty(KEY_UPLOAD_FILE_BUFFER_SIZE, this.getUploadFileBufferSize().toString());
        if (this.serverUrl != null) {
            properties.setProperty(KEY_SERVER_URL, this.serverUrl);
        }
        for (Map.Entry<String, String> entry : this.customPasswords.entrySet()) {
            properties.setProperty(entry.getKey(), PasswordEncrypter.getInstance().ensureEncrypted(entry.getValue()));
        }
        properties.setProperty(KEY_MAINTENANCE_FORBIDDEN_REQUESTS, this.maintenanceForbiddenRequests);
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.isSsl()) {
            if (Strings.isBlank((String)this.getKeyStorePath())) {
                System.err.println("keystore.path must be set.");
                valid = false;
            } else if (!new File(this.getKeyStorePath()).exists()) {
                System.err.println("keystore.path must point to an existing keystore.");
                valid = false;
            }
            if (this.isMutualSsl()) {
                if (Strings.isBlank((String)this.getTrustStorePath())) {
                    System.err.println("truststore.path must be set.");
                    valid = false;
                } else if (!new File(this.getTrustStorePath()).exists()) {
                    System.err.println("truststore.path must point to an existing truststore.");
                    valid = false;
                }
            }
        }
        valid &= ServerConfiguration.checkSet(this.getHttpBindAddress(), KEY_HTTP_BIND_ADDRESS);
        valid &= ServerConfiguration.validateThatIntIsBiggerThen(KEY_HTTP_PORT, this.getHttpPort(), 0);
        valid &= ServerConfiguration.checkSet(this.getWebContextRoot(), KEY_HTTP_CONTEXT_ROOT);
        if (!this.getWebContextRoot().startsWith(DEFAULT_WEB_CONTEXT_ROOT)) {
            System.err.println("http.context.root should start with a '/'");
            valid = false;
        }
        valid &= ServerConfiguration.checkSet(this.getJcrRepositoryPath(), KEY_JCR_REPOSITORY_PATH);
        valid &= ServerConfiguration.checkSet(this.getImportablePackagesPath(), KEY_IMPORTABLE_PACKAGES_PATH);
        valid &= ServerConfiguration.validateThatIntIsBiggerThen(KEY_MINIMUM_THREADS, this.getMinThreads(), 0);
        valid &= ServerConfiguration.validateThatIntIsBiggerThen(KEY_MAXIMUM_THREADS, this.getMaxThreads(), this.getMinThreads());
        return valid &= ServerConfiguration.validateThatIntIsBiggerThen(KEY_CLIENT_SESSION_TIMEOUT_MINUTES, this.getClientSessionTimeoutMinutes(), -1);
    }

    private static boolean checkSet(String value, String key) {
        if (Strings.isBlank((String)value)) {
            System.err.println(key + " must be set.");
            return false;
        }
        return true;
    }

    private static boolean validateThatIntIsBiggerThen(String key, int intToValidate, int shouldBeBiggerThen) {
        if (intToValidate <= shouldBeBiggerThen) {
            System.err.println(key + " is not valid, must be a number larger then " + shouldBeBiggerThen);
            return false;
        }
        return true;
    }

    public boolean isNewConfiguration() {
        return this.newConfiguration;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setMutualSsl(boolean mutualSsl) {
        this.mutualSsl = mutualSsl;
    }

    public boolean isMutualSsl() {
        return this.mutualSsl;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return StringCoder.decode((String)this.keyStorePassword);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreKeyPassword() {
        return StringCoder.decode((String)this.keyStoreKeyPassword);
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getTrustStorePassword() {
        return StringCoder.decode((String)this.trustStorePassword);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = StringCoder.encode((String)trustStorePassword);
    }

    public String getRepositoryKeyStorePassword() {
        return StringCoder.decode((String)this.repositoryKeyStorePassword);
    }

    public void setRepositoryKeyStorePassword(String repositoryKeyStorePassword) {
        this.repositoryKeyStorePassword = StringCoder.encode((String)repositoryKeyStorePassword);
    }

    public String getHttpBindAddress() {
        return this.httpBindAddress;
    }

    public void setHttpBindAddress(String httpBindAddress) {
        this.httpBindAddress = httpBindAddress;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getJcrRepositoryPath() {
        return this.jcrRepositoryPath;
    }

    public void setJcrRepositoryPath(String jcrRepositoryPath) {
        this.jcrRepositoryPath = jcrRepositoryPath;
    }

    public String getImportablePackagesPath() {
        return this.importablePackagesPath;
    }

    public void setImportablePackagesPath(String setImportablePackagesPath) {
        this.importablePackagesPath = setImportablePackagesPath;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getClientSessionTimeoutMinutes() {
        return this.clientSessionTimeoutMinutes;
    }

    public boolean isClientSessionRememberEnabled() {
        return this.clientSessionRememberEnabled;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getAdminPassword() {
        return StringCoder.decode((String)this.adminPassword);
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getWebContextRoot() {
        return this.webContextRoot;
    }

    public void setWebContextRoot(String webContextRoot) {
        this.webContextRoot = webContextRoot;
    }

    public String getWebWelcomePage() {
        return this.webWelcomePage;
    }

    public void setWebWelcomePage(String webWelcomePage) {
        this.webWelcomePage = webWelcomePage;
    }

    public boolean isHideInternals() {
        return this.hideInternals;
    }

    public void setHideInternals(boolean hideInternals) {
        this.hideInternals = hideInternals;
    }

    public File getFile() {
        return this.configFile;
    }

    public void setFile(File configFile) {
        this.configFile = configFile;
    }

    public String getServerUrl() {
        String url = this.serverUrl;
        if (url == null) {
            url = this.getDerivedServerUrl();
        }
        if (url.charAt(url.length() - 1) != '/') {
            url = url + '/';
        }
        return url;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getDerivedServerUrl() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("Hostname could not be resolved from name service, server will use loopback address. Please make sure networking is properly configured (e.g. you can successfully ping your_hostname).", (Throwable)e);
            hostname = InetAddress.getLoopbackAddress().getHostAddress();
        }
        return (this.ssl ? "https" : "http") + "://" + hostname + ":" + this.httpPort + this.webContextRoot;
    }

    public String getCustomPassword(String propertyKey) {
        return this.customPasswords.get(propertyKey);
    }

    public boolean isClientAutomaticallyMapAllDeployables() {
        return this.clientAutomaticallyMapAllDeployables;
    }

    public void setClientAutomaticallyMapAllDeployables(boolean clientAutomaticallyMapAllDeployables) {
        this.clientAutomaticallyMapAllDeployables = clientAutomaticallyMapAllDeployables;
    }

    public boolean isClientAutomaticallyMapAllDeployablesOnInitial() {
        return this.clientAutomaticallyMapAllDeployablesOnInitial;
    }

    public void setClientAutomaticallyMapAllDeployablesOnInitial(boolean clientAutomaticallyMapAllDeployablesOnInitial) {
        this.clientAutomaticallyMapAllDeployablesOnInitial = clientAutomaticallyMapAllDeployablesOnInitial;
    }

    public boolean isClientAutomaticallyMapAllDeployablesOnUpdate() {
        return this.clientAutomaticallyMapAllDeployablesOnUpdate;
    }

    public void setClientAutomaticallyMapAllDeployablesOnUpdate(boolean clientAutomaticallyMapAllDeployablesOnUpdate) {
        this.clientAutomaticallyMapAllDeployablesOnUpdate = clientAutomaticallyMapAllDeployablesOnUpdate;
    }

    public boolean isServerMappingOverrideDeployedFieldsOnUpdate() {
        return this.serverMappingOverrideDeployedFieldsOnUpdate;
    }

    public void setServerMappingOverrideDeployedFieldsOnUpdate(boolean serverMappingOverrideDeployedFieldsOnUpdate) {
        this.serverMappingOverrideDeployedFieldsOnUpdate = serverMappingOverrideDeployedFieldsOnUpdate;
    }

    public boolean isServerResolveApplicationDependencies() {
        return this.serverResolveApplicationDependencies;
    }

    public void setServerResolveApplicationDependencies(boolean serverResolveApplicationDependencies) {
        this.serverResolveApplicationDependencies = serverResolveApplicationDependencies;
    }

    public String getMaintenanceForbiddenRequests() {
        return this.maintenanceForbiddenRequests;
    }

    public void setMaintenanceForbiddenRequests(String maintenanceForbiddenRequests) {
        this.maintenanceForbiddenRequests = maintenanceForbiddenRequests;
    }

    public void setClientServerPollDelay(int clientServerPollDelay) {
        this.clientServerPollDelay = clientServerPollDelay;
    }

    public int getClientServerPollDelay() {
        return this.clientServerPollDelay;
    }

    public Integer getUploadFileBufferSize() {
        return this.uploadFileBufferSize;
    }

    public void setUploadFileBufferSize(Integer uploadFileBufferSize) {
        this.uploadFileBufferSize = uploadFileBufferSize;
    }

    public Integer getHttpIdleTimeoutMillis() {
        return this.httpIdleSeconds * 1000;
    }
}

