/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.BigIntType;
import liquibase.datatype.core.IntType;
import liquibase.datatype.core.UnknownType;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;
import liquibase.structure.core.DataType;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtils;

public class DataTypeFactory {
    private static DataTypeFactory instance;
    private Map<String, List<Class<? extends LiquibaseDataType>>> registry = new ConcurrentHashMap<String, List<Class<? extends LiquibaseDataType>>>();

    protected DataTypeFactory() {
        try {
            Class<LiquibaseDataType>[] classes;
            for (Class<LiquibaseDataType> clazz : classes = ServiceLocator.getInstance().findClasses(LiquibaseDataType.class)) {
                this.register(clazz);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static synchronized DataTypeFactory getInstance() {
        if (instance == null) {
            instance = new DataTypeFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new DataTypeFactory();
    }

    public void register(Class<? extends LiquibaseDataType> dataTypeClass) {
        try {
            LiquibaseDataType example = dataTypeClass.newInstance();
            ArrayList<String> names = new ArrayList<String>();
            names.add(example.getName());
            names.addAll(Arrays.asList(example.getAliases()));
            Comparator<Class<? extends LiquibaseDataType>> comparator = new Comparator<Class<? extends LiquibaseDataType>>(){

                @Override
                public int compare(Class<? extends LiquibaseDataType> o1, Class<? extends LiquibaseDataType> o2) {
                    try {
                        return -1 * new Integer(o1.newInstance().getPriority()).compareTo(o2.newInstance().getPriority());
                    }
                    catch (Exception e) {
                        throw new UnexpectedLiquibaseException(e);
                    }
                }
            };
            for (String name : names) {
                if (this.registry.get(name = name.toLowerCase()) == null) {
                    this.registry.put(name, new ArrayList());
                }
                List<Class<? extends LiquibaseDataType>> classes = this.registry.get(name);
                classes.add(dataTypeClass);
                Collections.sort(classes, comparator);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public void unregister(String name) {
        this.registry.remove(name.toLowerCase());
    }

    public LiquibaseDataType fromDescription(String dataTypeDefinition, Database database) {
        String[] params;
        String paramStrings;
        String[][] quotePairs;
        String dataTypeName = dataTypeDefinition;
        if (dataTypeName.matches(".+\\(.*\\).*")) {
            dataTypeName = dataTypeName.replaceFirst("\\s*\\(.*\\)", "");
        }
        if (dataTypeName.matches(".+\\{.*")) {
            dataTypeName = dataTypeName.replaceFirst("\\s*\\{.*", "");
        }
        boolean autoIncrement = false;
        if (dataTypeName.endsWith(" identity")) {
            dataTypeName = dataTypeName.replaceFirst(" identity$", "");
            autoIncrement = true;
        }
        for (String[] quotePair : quotePairs = new String[][]{{"\"", "\""}, {"[", "]"}, {"`", "`"}, {"'", "'"}}) {
            int indexOfCloseQuote;
            String openQuote = quotePair[0];
            String closeQuote = quotePair[1];
            if (!dataTypeName.startsWith(openQuote) || (indexOfCloseQuote = dataTypeName.indexOf(closeQuote, openQuote.length())) == -1 || dataTypeName.indexOf(closeQuote, indexOfCloseQuote + closeQuote.length()) != -1) continue;
            dataTypeName = dataTypeName.substring(openQuote.length(), indexOfCloseQuote) + dataTypeName.substring(indexOfCloseQuote + closeQuote.length(), dataTypeName.length());
            break;
        }
        String additionalInfo = null;
        if (!dataTypeName.toLowerCase().startsWith("bit varying") && !dataTypeName.toLowerCase().startsWith("character varying")) {
            String[] splitTypeName = dataTypeName.split("\\s+", 2);
            dataTypeName = splitTypeName[0];
            if (splitTypeName.length > 1) {
                additionalInfo = splitTypeName[1];
            }
        }
        Collection classes = this.registry.get(dataTypeName.toLowerCase());
        LiquibaseDataType liquibaseDataType = null;
        if (classes == null) {
            liquibaseDataType = dataTypeName.toUpperCase().startsWith("INTERVAL") ? new UnknownType(dataTypeDefinition) : new UnknownType(dataTypeName);
        } else {
            Iterator iterator = classes.iterator();
            do {
                try {
                    liquibaseDataType = (LiquibaseDataType)((Class)iterator.next()).newInstance();
                }
                catch (Exception e) {
                    throw new UnexpectedLiquibaseException(e);
                }
            } while (database != null && !liquibaseDataType.supports(database) && iterator.hasNext());
        }
        if (database != null && !liquibaseDataType.supports(database)) {
            throw new UnexpectedLiquibaseException("Could not find type for " + liquibaseDataType.toString() + " for databaes " + database.getShortName());
        }
        if (liquibaseDataType == null) {
            liquibaseDataType = new UnknownType(dataTypeName);
        }
        liquibaseDataType.setAdditionalInformation(additionalInfo);
        if (dataTypeDefinition.matches(".+\\s*\\(.*")) {
            paramStrings = dataTypeDefinition.replaceFirst(".*?\\(", "").replaceFirst("\\).*", "");
            for (String param : params = paramStrings.split(",")) {
                if ((param = StringUtils.trimToNull(param)) == null) continue;
                liquibaseDataType.addParameter(param);
            }
        }
        if (dataTypeDefinition.matches(".*\\{.*")) {
            paramStrings = dataTypeDefinition.replaceFirst(".*?\\{", "").replaceFirst("\\}.*", "");
            for (String param : params = paramStrings.split(",")) {
                if ((param = StringUtils.trimToNull(param)) == null) continue;
                String[] paramAndValue = param.split(":", 2);
                try {
                    ObjectUtil.setProperty((Object)liquibaseDataType, paramAndValue[0], paramAndValue[1]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unknown property " + paramAndValue[0] + " for " + liquibaseDataType.getClass().getName() + " " + liquibaseDataType.toString());
                }
            }
        }
        if (autoIncrement && liquibaseDataType instanceof IntType) {
            ((IntType)liquibaseDataType).setAutoIncrement(true);
        }
        if (autoIncrement && liquibaseDataType instanceof BigIntType) {
            ((BigIntType)liquibaseDataType).setAutoIncrement(true);
        }
        liquibaseDataType.finishInitialization(dataTypeDefinition);
        return liquibaseDataType;
    }

    public LiquibaseDataType fromObject(Object object, Database database) {
        if (object instanceof ColumnConfig.ValueNumeric) {
            object = ((ColumnConfig.ValueNumeric)object).getDelegate();
        }
        return this.fromDescription(object.getClass().getName(), database);
    }

    public LiquibaseDataType from(DataType type, Database database) {
        if (type == null) {
            return null;
        }
        return this.fromDescription(type.toString(), database);
    }

    public LiquibaseDataType from(DatabaseDataType type, Database database) {
        if (type == null) {
            return null;
        }
        return this.fromDescription(type.toString(), database);
    }

    public String getTrueBooleanValue(Database database) {
        return this.fromDescription("boolean", database).objectToSql(true, database);
    }

    public String getFalseBooleanValue(Database database) {
        return this.fromDescription("boolean", database).objectToSql(false, database);
    }
}

