/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.SqlUtil;
import liquibase.util.StringUtils;

public class ColumnSnapshotGenerator
extends JdbcSnapshotGenerator {
    private static final String LIQUIBASE_COMPLETE = "liquibase-complete";

    public ColumnSnapshotGenerator() {
        super(Column.class, new Class[]{Table.class, View.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Relation relation = ((Column)example).getRelation();
        if (((Column)example).getComputed() != null && ((Column)example).getComputed().booleanValue()) {
            return example;
        }
        Schema schema = relation.getSchema();
        List<CachedRow> columnMetadataRs = null;
        try {
            Column column = null;
            if (example.getAttribute(LIQUIBASE_COMPLETE, false).booleanValue()) {
                column = (Column)example;
                example.setAttribute(LIQUIBASE_COMPLETE, null);
            } else {
                JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                columnMetadataRs = databaseMetaData.getColumns(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), relation.getName(), example.getName());
                if (columnMetadataRs.size() > 0) {
                    CachedRow data = columnMetadataRs.get(0);
                    column = this.readColumn(data, relation, database);
                }
            }
            if (column != null && database instanceof MSSQLDatabase && database.getDatabaseMajorVersion() >= 8) {
                String sql = database.getDatabaseMajorVersion() >= 9 ? "SELECT CAST([ep].[value] AS [nvarchar](MAX)) AS [REMARKS] FROM [sys].[extended_properties] AS [ep] WHERE [ep].[class] = 1 AND [ep].[major_id] = OBJECT_ID(N'" + database.escapeStringForDatabase(database.escapeTableName(schema.getCatalogName(), schema.getName(), relation.getName())) + "') " + "AND [ep].[minor_id] = COLUMNPROPERTY([ep].[major_id], N'" + database.escapeStringForDatabase(column.getName()) + "', 'ColumnId') " + "AND [ep].[name] = 'MS_Description'" : "SELECT CAST([p].[value] AS [ntext]) AS [REMARKS] FROM [dbo].[sysproperties] AS [p] WHERE [p].[id] = OBJECT_ID(N'" + database.escapeStringForDatabase(database.escapeTableName(schema.getCatalogName(), schema.getName(), relation.getName())) + "') " + "AND [p].[smallid] = COLUMNPROPERTY([p].[id], N'" + database.escapeStringForDatabase(column.getName()) + "', 'ColumnId') " + "AND [p].[type] = 4 " + "AND [p].[name] = 'MS_Description'";
                List remarks = ExecutorService.getInstance().getExecutor(snapshot.getDatabase()).queryForList((SqlStatement)new RawSqlStatement(sql), String.class);
                if (remarks != null && remarks.size() > 0) {
                    column.setRemarks(StringUtils.trimToNull((String)remarks.iterator().next()));
                }
            }
            return column;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Column.class)) {
            return;
        }
        if (foundObject instanceof Relation) {
            Database database = snapshot.getDatabase();
            Relation relation = (Relation)foundObject;
            List<CachedRow> allColumnsMetadataRs = null;
            try {
                JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                Schema schema = relation.getSchema();
                allColumnsMetadataRs = databaseMetaData.getColumns(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), relation.getName(), null);
                for (CachedRow row : allColumnsMetadataRs) {
                    Column column = this.readColumn(row, relation, database);
                    column.setAttribute(LIQUIBASE_COMPLETE, true);
                    relation.getColumns().add(column);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Column readColumn(CachedRow columnMetadataResultSet, Relation table, Database database) throws SQLException, DatabaseException {
        String rawTableName = (String)columnMetadataResultSet.get("TABLE_NAME");
        String rawColumnName = (String)columnMetadataResultSet.get("COLUMN_NAME");
        String rawSchemaName = StringUtils.trimToNull((String)columnMetadataResultSet.get("TABLE_SCHEM"));
        String rawCatalogName = StringUtils.trimToNull((String)columnMetadataResultSet.get("TABLE_CAT"));
        String remarks = StringUtils.trimToNull((String)columnMetadataResultSet.get("REMARKS"));
        if (remarks != null) {
            remarks = remarks.replace("''", "'");
        }
        Column column = new Column();
        column.setName(StringUtils.trimToNull(rawColumnName));
        column.setRelation(table);
        column.setRemarks(remarks);
        if (database instanceof OracleDatabase) {
            String nullable = columnMetadataResultSet.getString("NULLABLE");
            if (nullable.equals("Y")) {
                column.setNullable(true);
            } else {
                column.setNullable(false);
            }
        } else {
            int nullable = columnMetadataResultSet.getInt("NULLABLE");
            if (nullable == 0) {
                column.setNullable(false);
            } else if (nullable == 1) {
                column.setNullable(true);
            } else if (nullable == 2) {
                LogFactory.getLogger().info("Unknown nullable state for column " + column.toString() + ". Assuming nullable");
                column.setNullable(true);
            }
        }
        if (database.supportsAutoIncrement() && table instanceof Table) {
            if (columnMetadataResultSet.containsColumn("IS_AUTOINCREMENT")) {
                String isAutoincrement = (String)columnMetadataResultSet.get("IS_AUTOINCREMENT");
                if ((isAutoincrement = StringUtils.trimToNull(isAutoincrement)) == null) {
                    column.setAutoIncrementInformation(null);
                } else if (isAutoincrement.equals("YES")) {
                    column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                } else if (isAutoincrement.equals("NO")) {
                    column.setAutoIncrementInformation(null);
                } else {
                    if (!isAutoincrement.equals("")) throw new UnexpectedLiquibaseException("Unknown is_autoincrement value: '" + isAutoincrement + "'");
                    LogFactory.getLogger().info("Unknown auto increment state for column " + column.toString() + ". Assuming not auto increment");
                    column.setAutoIncrementInformation(null);
                }
            } else {
                String selectStatement;
                if (database.getDatabaseProductName().startsWith("DB2 UDB for AS/400")) {
                    selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + rawSchemaName + "." + rawTableName + " where 0=1";
                    LogFactory.getLogger().debug("rawCatalogName : <" + rawCatalogName + ">");
                    LogFactory.getLogger().debug("rawSchemaName : <" + rawSchemaName + ">");
                    LogFactory.getLogger().debug("rawTableName : <" + rawTableName + ">");
                    LogFactory.getLogger().debug("raw selectStatement : <" + selectStatement + ">");
                } else {
                    selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + database.escapeTableName(rawCatalogName, rawSchemaName, rawTableName) + " where 0=1";
                }
                LogFactory.getLogger().debug("Checking " + rawTableName + "." + rawCatalogName + " for auto-increment with SQL: '" + selectStatement + "'");
                Connection underlyingConnection = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
                Statement statement = null;
                ResultSet columnSelectRS = null;
                try {
                    statement = underlyingConnection.createStatement();
                    columnSelectRS = statement.executeQuery(selectStatement);
                    if (columnSelectRS.getMetaData().isAutoIncrement(1)) {
                        column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                    } else {
                        column.setAutoIncrementInformation(null);
                    }
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException ignore) {}
                    if (columnSelectRS != null) {
                        columnSelectRS.close();
                    }
                }
            }
        }
        DataType type = this.readDataType(columnMetadataResultSet, column, database);
        column.setType(type);
        column.setDefaultValue(this.readDefaultValue(columnMetadataResultSet, column, database));
        return column;
    }

    protected DataType readDataType(CachedRow columnMetadataResultSet, Column column, Database database) throws SQLException {
        String typeName;
        if (database instanceof OracleDatabase) {
            String dataType = columnMetadataResultSet.getString("DATA_TYPE_NAME");
            dataType = dataType.replace("VARCHAR2", "VARCHAR");
            dataType = dataType.replace("NVARCHAR2", "NVARCHAR");
            DataType type = new DataType(dataType);
            if (dataType.equalsIgnoreCase("NUMBER")) {
                type.setColumnSize(columnMetadataResultSet.getInt("DATA_PRECISION"));
                type.setDecimalDigits(columnMetadataResultSet.getInt("DATA_SCALE"));
            } else {
                type.setColumnSize(columnMetadataResultSet.getInt("DATA_LENGTH"));
                if (dataType.equalsIgnoreCase("NCLOB") || dataType.equalsIgnoreCase("BLOB") || dataType.equalsIgnoreCase("CLOB")) {
                    type.setColumnSize(null);
                } else if (dataType.equalsIgnoreCase("NVARCHAR") || dataType.equalsIgnoreCase("NCHAR")) {
                    type.setColumnSize(columnMetadataResultSet.getInt("CHAR_LENGTH"));
                    type.setColumnSizeUnit(DataType.ColumnSizeUnit.CHAR);
                } else {
                    String charUsed = columnMetadataResultSet.getString("CHAR_USED");
                    DataType.ColumnSizeUnit unit = null;
                    if ("C".equals(charUsed)) {
                        unit = DataType.ColumnSizeUnit.CHAR;
                        type.setColumnSize(columnMetadataResultSet.getInt("CHAR_LENGTH"));
                    }
                    type.setColumnSizeUnit(unit);
                }
            }
            return type;
        }
        String columnTypeName = (String)columnMetadataResultSet.get("TYPE_NAME");
        if (database instanceof FirebirdDatabase) {
            if (columnTypeName.equals("BLOB SUB_TYPE 0")) {
                columnTypeName = "BLOB";
            }
            if (columnTypeName.equals("BLOB SUB_TYPE 1")) {
                columnTypeName = "CLOB";
            }
        }
        if (database instanceof MySQLDatabase && (columnTypeName.equalsIgnoreCase("ENUM") || columnTypeName.equalsIgnoreCase("SET"))) {
            try {
                String boilerLength = columnTypeName.equalsIgnoreCase("ENUM") ? "7" : "6";
                List enumValues = ExecutorService.getInstance().getExecutor(database).queryForList((SqlStatement)new RawSqlStatement("SELECT DISTINCT SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING(COLUMN_TYPE, " + boilerLength + ", LENGTH(COLUMN_TYPE) - " + boilerLength + " - 1 ), \"','\", 1 + units.i + tens.i * 10) , \"','\", -1)\n" + "FROM INFORMATION_SCHEMA.COLUMNS\n" + "CROSS JOIN (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) units\n" + "CROSS JOIN (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) tens\n" + "WHERE TABLE_NAME = '" + column.getRelation().getName() + "' \n" + "AND COLUMN_NAME = '" + column.getName() + "'"), String.class);
                String enumClause = "";
                for (String enumValue : enumValues) {
                    enumClause = enumClause + "'" + enumValue + "', ";
                }
                enumClause = enumClause.replaceFirst(", $", "");
                return new DataType(columnTypeName + "(" + enumClause + ")");
            }
            catch (DatabaseException e) {
                LogFactory.getLogger().warning("Error fetching enum values", e);
            }
        }
        DataType.ColumnSizeUnit columnSizeUnit = DataType.ColumnSizeUnit.BYTE;
        int dataType = columnMetadataResultSet.getInt("DATA_TYPE");
        Integer columnSize = null;
        Integer decimalDigits = null;
        if (!database.dataTypeIsNotModifiable(columnTypeName)) {
            columnSize = columnMetadataResultSet.getInt("COLUMN_SIZE");
            decimalDigits = columnMetadataResultSet.getInt("DECIMAL_DIGITS");
            if (decimalDigits != null && decimalDigits.equals(0)) {
                decimalDigits = null;
            }
        }
        Integer radix = columnMetadataResultSet.getInt("NUM_PREC_RADIX");
        Integer characterOctetLength = columnMetadataResultSet.getInt("CHAR_OCTET_LENGTH");
        if (database instanceof DB2Database && ((typeName = columnMetadataResultSet.getString("TYPE_NAME")).equalsIgnoreCase("DBCLOB") || typeName.equalsIgnoreCase("GRAPHIC") || typeName.equalsIgnoreCase("VARGRAPHIC")) && columnSize != null) {
            columnSize = columnSize / 2;
        }
        DataType type = new DataType(columnTypeName);
        type.setDataTypeId(dataType);
        type.setColumnSize(columnSize);
        type.setDecimalDigits(decimalDigits);
        type.setRadix(radix);
        type.setCharacterOctetLength(characterOctetLength);
        type.setColumnSizeUnit(columnSizeUnit);
        return type;
    }

    protected Object readDefaultValue(CachedRow columnMetadataResultSet, Column columnInfo, Database database) throws SQLException, DatabaseException {
        Object defaultValue;
        if (database instanceof MSSQLDatabase && (defaultValue = columnMetadataResultSet.get("COLUMN_DEF")) != null && defaultValue instanceof String && defaultValue.equals("(NULL)")) {
            columnMetadataResultSet.set("COLUMN_DEF", null);
        }
        if (database instanceof OracleDatabase && columnMetadataResultSet.get("COLUMN_DEF") == null) {
            Object column_def;
            columnMetadataResultSet.set("COLUMN_DEF", columnMetadataResultSet.get("DATA_DEFAULT"));
            if (columnMetadataResultSet.get("COLUMN_DEF") != null && ((String)columnMetadataResultSet.get("COLUMN_DEF")).equalsIgnoreCase("NULL")) {
                columnMetadataResultSet.set("COLUMN_DEF", null);
            }
            Object columnDef = columnMetadataResultSet.get("COLUMN_DEF");
            if (columnInfo.getType().getTypeName().equalsIgnoreCase("CHAR") && columnDef instanceof String && !((String)columnDef).startsWith("'") && !((String)columnDef).endsWith("'")) {
                return new DatabaseFunction((String)columnDef);
            }
            if (columnMetadataResultSet.get("VIRTUAL_COLUMN").equals("YES") && (column_def = columnMetadataResultSet.get("COLUMN_DEF")) != null && !column_def.equals("null")) {
                columnMetadataResultSet.set("COLUMN_DEF", "GENERATED ALWAYS AS (" + column_def + ")");
            }
        }
        return SqlUtil.parseValue(database, columnMetadataResultSet.get("COLUMN_DEF"), columnInfo.getType());
    }
}

