/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.repository.Ids;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u0017\tiB)\u001a9f]\u0012,gnY=M_\u001e<\u0017N\\4Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005A\u0011m\u0019;jm&$\u0018P\u0003\u0002\u0006\r\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0007\u00131A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\r\u00154XM\u001c;t\u0013\t9BC\u0001\bFm\u0016tG\u000fT5ti\u0016t\u0017N\\4\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012!B:mMRR'\"A\u000f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\b\u000e\u0003\u000f1{wmZ5oO\"A\u0011\u0005\u0001BC\u0002\u0013\u0005!%\u0001\u0005fm\u0016tGOQ;t+\u0005\u0019\u0003CA\n%\u0013\t)CCA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkND\u0001b\n\u0001\u0003\u0002\u0003\u0006IaI\u0001\nKZ,g\u000e\u001e\"vg\u0002B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\rC\u000e$\u0018N^5us2{wm\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0011\t!B]3q_NLGo\u001c:z\u0013\tyCF\u0001\u0007BGRLg/\u001b;z\u0019><7\u000fC\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0004gU2\u0004C\u0001\u001b\u0001\u001b\u0005\u0011\u0001\"B\u00111\u0001\u0004\u0019\u0003\"B\u00151\u0001\u0004Q\u0003F\u0001\u00199!\tID)D\u0001;\u0015\tYD(\u0001\u0006b]:|G/\u0019;j_:T!!\u0010 \u0002\u000f\u0019\f7\r^8ss*\u0011q\bQ\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0003\n\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015S$!C!vi><\u0018N]3e\u0011\u00159\u0005\u0001\"\u0001I\u0003Eyg\u000eR3qK:$WM\\2z\u000bZ,g\u000e\u001e\u000b\u0003\u00132\u0003\"!\u0004&\n\u0005-s!\u0001B+oSRDQ!\u0014$A\u00029\u000bq\u0002Z3qK:$WM\\2z\u000bZ,g\u000e\u001e\t\u0003\u001fNk\u0011\u0001\u0015\u0006\u0003+ES!A\u0015\u0003\u0002\r\u0011|W.Y5o\u0013\t!\u0006KA\bEKB,g\u000eZ3oGf,e/\u001a8uQ\t1e\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006)AO\r2vg*\u00111\fX\u0001\tU\u00064\u0018\rZ;eK*\tQ,\u0001\u0002oY&\u0011q\f\u0017\u0002\u0016\u00032dwn^\"p]\u000e,(O]3oi\u00163XM\u001c;tQ\t1\u0015\r\u0005\u0002XE&\u00111\r\u0017\u0002\n'V\u00147o\u0019:jE\u0016DQ!\u001a\u0001\u0005\n\u0019\fA$[:Va\u0012\fG/Z\"bkN,GMQ=QQ\u0006\u001cXMU3ti\u0006\u0014H\u000fF\u0002hUB\u0004\"!\u00045\n\u0005%t!a\u0002\"p_2,\u0017M\u001c\u0005\u0006W\u0012\u0004\r\u0001\\\u0001\t_JLw-\u001b8bYB\u0011QN\\\u0007\u0002#&\u0011q.\u0015\u0002\u000b\t\u0016\u0004XM\u001c3f]\u000eL\b\"B9e\u0001\u0004a\u0017aB;qI\u0006$X\r\u001a\u0015\u0003\u0001M\u0004\"\u0001^<\u000e\u0003UT!A\u001e!\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002yk\nI1i\\7q_:,g\u000e\u001e")
public class DependencyLoggingEventHandler
implements EventListening,
Logging {
    private final XLReleaseEventBus eventBus;
    private final ActivityLogs activityLogs;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.postConstruct$((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.preDestroy$((EventListening)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyLoggingEventHandler dependencyLoggingEventHandler = this;
        synchronized (dependencyLoggingEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Subscribe
    @AllowConcurrentEvents
    public void onDependencyEvent(DependencyEvent dependencyEvent) {
        boolean bl = false;
        DependencyUpdatedEvent dependencyUpdatedEvent = null;
        DependencyEvent dependencyEvent2 = dependencyEvent;
        if (dependencyEvent2 instanceof DependencyCreatedEvent) {
            DependencyCreatedEvent dependencyCreatedEvent = (DependencyCreatedEvent)dependencyEvent2;
            Dependency dependency = dependencyCreatedEvent.dependency();
            this.activityLogs.log(Ids.releaseIdFrom((String)dependency.getId()), ReleaseActivity.DEPENDENCY_CREATED.create(dependency.getGateTask().getTitle(), dependency.getTargetDisplayPath()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (dependencyEvent2 instanceof DependencyUpdatedEvent) {
            Dependency updated;
            bl = true;
            dependencyUpdatedEvent = (DependencyUpdatedEvent)dependencyEvent2;
            Dependency original = dependencyUpdatedEvent.original();
            if (this.isUpdateCausedByPhaseRestart(original, updated = dependencyUpdatedEvent.updated())) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            Dependency original = dependencyUpdatedEvent.original();
            Dependency updated = dependencyUpdatedEvent.updated();
            this.activityLogs.log(Ids.releaseIdFrom((String)updated.getId()), ReleaseActivity.DEPENDENCY_UPDATED.create(updated.getGateTask().getTitle(), original.getTargetDisplayPath(), updated.getTargetDisplayPath()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (dependencyEvent2 instanceof DependencyDeletedEvent) {
            DependencyDeletedEvent dependencyDeletedEvent = (DependencyDeletedEvent)dependencyEvent2;
            Dependency dependency = dependencyDeletedEvent.dependency();
            this.activityLogs.log(Ids.releaseIdFrom((String)dependency.getId()), ReleaseActivity.DEPENDENCY_DELETED.create(dependency.getGateTask().getTitle(), dependency.getTargetDisplayPath()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event ", " not traced into activity logs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyEvent2})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUpdateCausedByPhaseRestart(Dependency original, Dependency updated) {
        Tuple2 tuple2 = new Tuple2((Object)DependencyLoggingEventHandler.targetTaskId$1(original), (Object)DependencyLoggingEventHandler.targetTaskId$1(updated));
        if (tuple2 == null) return false;
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return false;
        Some some = (Some)option;
        String originalId = (String)some.value();
        if (!(option2 instanceof Some)) return false;
        Some some2 = (Some)option2;
        String updatedId = (String)some2.value();
        String originalPhaseName = Ids.getName((String)Ids.phaseIdFrom((String)originalId));
        String updatedPhaseName = Ids.getName((String)Ids.phaseIdFrom((String)updatedId));
        String string = originalPhaseName;
        String string2 = updatedPhaseName;
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = originalId.replace(originalPhaseName, updatedPhaseName);
        String string4 = updatedId;
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$isUpdateCausedByPhaseRestart$2(String x$1) {
        return Ids.isTaskId((String)x$1);
    }

    private static final Option targetTaskId$1(Dependency d) {
        return Option$.MODULE$.apply((Object)d.getTarget()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyLoggingEventHandler.$anonfun$isUpdateCausedByPhaseRestart$2(x$1)));
    }

    @Autowired
    public DependencyLoggingEventHandler(XLReleaseEventBus eventBus, ActivityLogs activityLogs) {
        this.eventBus = eventBus;
        this.activityLogs = activityLogs;
        EventListening.$init$((EventListening)this);
        Logging.$init$((Logging)this);
    }
}

