/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.jcr;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JcrTeams
implements Teams {
    private static final Logger logger = LoggerFactory.getLogger(Teams.class);
    private static final String PLATFORM_PREFIX = "Team$";
    private CiIdService ciIdService;
    private PermissionEditor permissionEditor;
    private RoleService roleService;
    private ArchivingService archivingService;
    private static BinaryOperator<Role> throwingMerger = (u, v) -> {
        throw new IllegalStateException(String.format("Duplicate key %s", u));
    };

    public JcrTeams(CiIdService ciIdService, PermissionEditor permissionEditor, RoleService roleService, ArchivingService archivingService) {
        this.ciIdService = ciIdService;
        this.permissionEditor = permissionEditor;
        this.roleService = roleService;
        this.archivingService = archivingService;
    }

    public Team create(String containerId, Team team) {
        if (Ids.isNullId((String)team.getId())) {
            team.setId(this.ciIdService.getUniqueId(Type.valueOf(Team.class), containerId));
        }
        ArrayList<Team> currentTeams = new ArrayList<Team>(this.getStoredTeams(containerId));
        currentTeams.add(team);
        this.saveTeamsToPlatform(containerId, currentTeams);
        return team;
    }

    public void delete(String teamId) {
        String containerId = Ids.getParentId((String)teamId);
        ArrayList<Team> currentTeams = new ArrayList<Team>(this.getStoredTeams(containerId));
        currentTeams.stream().filter(team -> Objects.equals(team.getId(), teamId)).findAny().ifPresent(currentTeams::remove);
        this.saveTeamsToPlatform(containerId, currentTeams);
    }

    public Team update(Team teamToUpdate) {
        String containerId = Ids.getParentId((String)teamToUpdate.getId());
        ArrayList<Team> currentTeams = new ArrayList<Team>(this.getStoredTeams(containerId));
        List<Team> teamUpdatedList = currentTeams.stream().map(team -> Objects.equals(team.getId(), teamToUpdate.getId()) ? teamToUpdate : team).collect(Collectors.toList());
        this.saveTeamsToPlatform(containerId, teamUpdatedList);
        return teamToUpdate;
    }

    public List<Team> saveTeamsToPlatform(Release release) {
        return this.saveTeamsToPlatform(release.getId(), release.getTeams());
    }

    public List<Team> saveTeamsToPlatform(String containerId, List<Team> teams) {
        if (!teams.isEmpty()) {
            Optional<Team> anInheritedTeam = teams.stream().filter(team -> !Ids.isNullId((String)team.getId()) && !Objects.equals(containerId, Ids.getParentId((String)team.getId()))).findAny();
            anInheritedTeam.ifPresent(team -> Checks.checkArgument((boolean)false, (String)"Cannot save team %s as it does not belong to %s", (Object[])new Object[]{team, containerId}));
            int numberOfUniqueTeamNames = teams.stream().map(Team::getTeamName).collect(Collectors.toSet()).size();
            Checks.checkArgument((teams.size() == numberOfUniqueTeamNames ? 1 : 0) != 0, (String)"Cannot save teams %s in %s with duplicates names", (Object[])new Object[]{teams, containerId});
            teams.stream().filter(team -> team.getPermissions().isEmpty()).forEach(team -> team.getPermissions().add(XLReleasePermissions.DUMMY.getPermissionName()));
        }
        return this.saveTeamsToPlatformWithNoValidation(containerId, teams);
    }

    public void deleteTeamsFromPlatform(String containerId) {
        this.saveTeamsToPlatform(containerId, Collections.emptyList());
    }

    List<Team> saveTeamsToPlatformWithNoValidation(String containerId, List<Team> teams) {
        teams.forEach(team -> {
            if (Ids.isNullId((String)team.getId())) {
                team.setId(this.ciIdService.getUniqueId(Type.valueOf(Team.class), containerId));
            }
            this.removeMissingRoles((Team)team);
        });
        Map xlr2platformRoles = teams.stream().collect(Collectors.toMap(Function.identity(), this::convertToPlatformRole, throwingMerger, LinkedHashMap::new));
        this.saveTeamPermissions(xlr2platformRoles, containerId);
        return teams;
    }

    public void decorateWithEffectiveTeams(Release release) {
        List<Team> teams = this.getEffectiveTeams(release);
        release.setTeams(teams);
    }

    public void decorateWithStoredTeams(Release release) {
        List<Team> teams = this.getStoredTeams(release);
        release.setTeams(teams);
    }

    public List<Team> getEffectiveTeams(String containerId) {
        List<Team> containerTeams = this.getStoredTeams(containerId);
        if (containerTeams.isEmpty() && !Ids.ROOT_FOLDER_ID.equals(containerId)) {
            return this.getEffectiveTeams(Ids.getParentId((String)containerId));
        }
        return containerTeams;
    }

    public List<Team> getEffectiveTeams(Release release) {
        List<Team> releaseTeams = this.getStoredTeams(release);
        if (releaseTeams.isEmpty()) {
            String parentFolderId = Ids.getParentId((String)release.getId());
            return this.getEffectiveTeams(parentFolderId);
        }
        return releaseTeams;
    }

    private List<Team> getStoredTeams(Release release) {
        if (release.isArchived()) {
            return release.getTeams();
        }
        return this.getTeamsOfCiInPlatform(release.getId());
    }

    private List<Team> getStoredTeamsOfRelease(String releaseId) {
        if (this.archivingService.exists(releaseId)) {
            Release release = this.archivingService.getRelease(releaseId);
            return release.getTeams();
        }
        return this.getTeamsOfCiInPlatform(releaseId);
    }

    public List<Team> getStoredTeams(String containerId) {
        if (Ids.isNullId((String)containerId) || Ids.isRoot((String)containerId)) {
            return new ArrayList<Team>();
        }
        if (Ids.isReleaseId((String)containerId)) {
            return this.getStoredTeamsOfRelease(containerId);
        }
        return this.getTeamsOfCiInPlatform(containerId);
    }

    private List<Team> getTeamsOfCiInPlatform(String containerId) {
        Map permissionsByTeam = this.permissionEditor.readPermissions(containerId);
        return this.roleService.readRoleAssignments(containerId).stream().map(platformTeam -> this.convertToTeam(containerId, (Role)platformTeam, permissionsByTeam.getOrDefault(platformTeam, Collections.emptySet()))).collect(Collectors.toList());
    }

    public Optional<Team> findTeamByName(String containerId, String teamName) {
        if (StringUtils.isEmpty((Object)teamName)) {
            return Optional.empty();
        }
        return this.getEffectiveTeams(containerId).stream().filter(team -> teamName.equals(team.getTeamName())).findAny();
    }

    public List<Team> findTeamsByNames(String containerId, Collection<String> teamNames) {
        return this.getEffectiveTeams(containerId).stream().filter(team -> teamNames.contains(team.getTeamName())).collect(Collectors.toList());
    }

    public void decorateWithEffectiveTeams(Collection<Release> releases) {
        releases.forEach(this::decorateWithEffectiveTeams);
    }

    private Team convertToTeam(String containerId, Role platformRole, Set<Permission> permissions) {
        Team team = (Team)Type.valueOf(Team.class).getDescriptor().newInstance(this.platformTeamIdToTeamId(containerId, platformRole.getId()));
        team.setRoles(platformRole.getRoles());
        team.setMembers(platformRole.getPrincipals());
        team.setTeamName(platformRole.getName());
        team.setPermissions(permissions.stream().map(Permission::getPermissionName).collect(Collectors.toList()));
        return team;
    }

    private Role convertToPlatformRole(Team team) {
        Checks.checkArgument((!StringUtils.isEmpty((Object)team.getTeamName()) ? 1 : 0) != 0, (String)("Team name is missing in team " + team.getId()), (Object[])new Object[0]);
        Role platformRole = new Role(this.teamIdToPlatformTeamId(team.getId()), team.getTeamName());
        platformRole.setRoles(team.getRoles());
        platformRole.setPrincipals(team.getMembers());
        return platformRole;
    }

    private String teamIdToPlatformTeamId(String id) {
        return PLATFORM_PREFIX + Ids.getName((String)id);
    }

    private String platformTeamIdToTeamId(String containerId, String id) {
        return containerId + "/" + id.replace(PLATFORM_PREFIX, "");
    }

    private void saveTeamPermissions(Map<Team, Role> xlr2platformRoles, String containerId) {
        this.roleService.writeRoleAssignments(containerId, new ArrayList<Role>(xlr2platformRoles.values()));
        Map permissionsMap = this.permissionEditor.readPermissions(containerId);
        xlr2platformRoles.forEach((xlrTeam, platformTeam) -> {
            List permissions = xlrTeam.getPermissions();
            Set platformPermissions = permissions.stream().map(Permission::find).collect(Collectors.toSet());
            permissionsMap.put(platformTeam, platformPermissions);
        });
        this.permissionEditor.editPermissions(containerId, permissionsMap);
    }

    private void removeMissingRoles(Team team) {
        List nonExistingRoles = team.getRoles().stream().filter(role -> !this.roleExists((String)role)).collect(Collectors.toList());
        if (!nonExistingRoles.isEmpty()) {
            logger.warn(String.format("The following role(s) do not exist: %s. They were removed from the team %s (%s).", nonExistingRoles, team.getTeamName(), team.getId()));
            team.getRoles().removeAll(nonExistingRoles);
        }
    }

    private boolean roleExists(String role) {
        boolean exists = true;
        try {
            this.roleService.getRoleForRoleName(role);
        }
        catch (NotFoundException e) {
            exists = false;
        }
        return exists;
    }
}

