/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.repository.query.ParametrizedPredicate;
import com.xebialabs.xlrelease.repository.query.PredicateJoiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class JcrPredicate {
    private String query;
    private List<Object> parameters = Lists.newArrayList();

    public JcrPredicate(String query) {
        this.query = query;
    }

    public JcrPredicate(ParametrizedPredicate predicate, String field, Object parameter) {
        this.query = predicate.getQueryFor(field);
        this.parameters.add(parameter);
    }

    public JcrPredicate(PredicateJoiner type, Collection<JcrPredicate> predicates) {
        ArrayList queries = Lists.newArrayList();
        for (JcrPredicate predicate : predicates) {
            this.parameters.addAll(predicate.getParameters());
            queries.add(predicate.getQuery());
        }
        this.query = type.join(queries);
    }

    public static JcrPredicate equal(String field, String value) {
        return new JcrPredicate(ParametrizedPredicate.EQUAL, field, value);
    }

    public static JcrPredicate oneOf(String field, String ... values) {
        ArrayList choices = Lists.newArrayList((Object[])values);
        return JcrPredicate.or(choices.stream().map(value -> JcrPredicate.equal(field, value)).collect(Collectors.toList()));
    }

    public static JcrPredicate notEqual(String field, String value) {
        return new JcrPredicate(ParametrizedPredicate.NOT_EQUAL, field, value);
    }

    public static JcrPredicate equalIgnoringCase(String field, String value) {
        return JcrPredicate.equal("LOWER(" + field + ")", value.toLowerCase());
    }

    public static JcrPredicate like(String field, String value) {
        return new JcrPredicate(ParametrizedPredicate.LIKE, field, "%" + value + "%");
    }

    public static JcrPredicate likeIgnoringCase(String field, String value) {
        return JcrPredicate.like("LOWER(" + field + ")", value.toLowerCase());
    }

    public static JcrPredicate lowerThan(String field, long date) {
        return new JcrPredicate(String.format("%s <= CAST(%d AS DATE)", field, date));
    }

    public static JcrPredicate greaterThan(String field, long date) {
        return new JcrPredicate(String.format("%s >= CAST(%d AS DATE)", field, date));
    }

    public static JcrPredicate equal(String field, long date) {
        return new JcrPredicate(String.format("%s = CAST(%d AS DATE)", field, date));
    }

    public static JcrPredicate and(JcrPredicate ... predicates) {
        return new JcrPredicate(PredicateJoiner.AND, Lists.newArrayList((Object[])predicates));
    }

    public static JcrPredicate and(Collection<JcrPredicate> predicates) {
        return new JcrPredicate(PredicateJoiner.AND, predicates);
    }

    public static JcrPredicate or(JcrPredicate ... predicates) {
        return new JcrPredicate(PredicateJoiner.OR, Lists.newArrayList((Object[])predicates));
    }

    public static JcrPredicate or(Collection<JcrPredicate> predicates) {
        return new JcrPredicate(PredicateJoiner.OR, predicates);
    }

    public static JcrPredicate getTypePredicate(String selector, Type type) {
        return new JcrPredicate(String.format("%s.[%s] = '%s'", selector, "$configuration.item.type", type));
    }

    public static JcrPredicate as(String selector, Type type) {
        ArrayList predicates = Lists.newArrayList();
        predicates.add(JcrPredicate.getTypePredicate(selector, type));
        for (Type subtype : DescriptorRegistry.getSubtypes((Type)type)) {
            predicates.add(JcrPredicate.getTypePredicate(selector, subtype));
        }
        return JcrPredicate.or(predicates);
    }

    public static JcrPredicate as(String selector, Class clazz) {
        return JcrPredicate.as(selector, Type.valueOf((Class)clazz));
    }

    public static JcrPredicate isChildNode(String childSelector, String parentPath) {
        return new JcrPredicate(String.format("ISCHILDNODE(%s, ['%s'])", childSelector, parentPath));
    }

    public static JcrPredicate isDescendantNode(String childSelector, String parentSelector) {
        return new JcrPredicate(String.format("ISDESCENDANTNODE(%s, %s)", childSelector, parentSelector));
    }

    public static JcrPredicate hasName(String childSelector, String name) {
        return new JcrPredicate(String.format("NAME(%s) = '%s'", childSelector, name));
    }

    public static JcrPredicate isInPath(String selector, String path) {
        String pathSelector = "'" + path + "'";
        return JcrPredicate.isDescendantNode(selector, pathSelector);
    }

    public static JcrPredicate notNull(String field) {
        return new JcrPredicate(String.format("%s IS NOT NULL", field));
    }

    public static JcrPredicate containsAtLeastOne(String field, Collection<String> options) {
        if (Iterables.isEmpty(options)) {
            return new JcrPredicate(null);
        }
        return JcrPredicate.or(JcrPredicate.listContainsPredicates(field, options));
    }

    public static JcrPredicate containsAll(String field, Collection<String> options) {
        if (Iterables.isEmpty(options)) {
            return new JcrPredicate(null);
        }
        return JcrPredicate.and(JcrPredicate.listContainsPredicates(field, options));
    }

    protected static List<JcrPredicate> listContainsPredicates(String field, Collection<String> options) {
        StringValueConverter converter = new StringValueConverter(PasswordEncrypter.getInstance());
        return options.stream().map(option -> JcrPredicate.equalIgnoringCase(field, converter.convert(new StringValue(option), false))).collect(Collectors.toList());
    }

    public static JcrPredicate contains(String field, String value) {
        StringValueConverter converter = new StringValueConverter(PasswordEncrypter.getInstance());
        String convertedOption = converter.convert(new StringValue(value), false);
        return JcrPredicate.equal(field, convertedOption);
    }

    public String getQuery() {
        return this.query;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }
}

