/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.filters.TaskFilter;
import com.xebialabs.xlrelease.repository.DeserializationSupport;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.ReleasesSqlRepository;
import com.xebialabs.xlrelease.repository.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.data.ReleaseData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.views.ReleaseOrderMode;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0001\u0003\u0001-\u0011AcU9m)\u0006\u001c8nU3be\u000eD7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001A\u0002\u0006\r\u001f!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005E!\u0016m]6TK\u0006\u00148\r[*feZL7-\u001a\t\u00033qi\u0011A\u0007\u0006\u00037\u0011\t!B]3q_NLGo\u001c:z\u0013\ti\"D\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\tyB%D\u0001!\u0015\t\t#%A\u0003tY\u001a$$NC\u0001$\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0013!\u0005\u001daunZ4j]\u001eD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\fe>dWmU3sm&\u001cW\r\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005A1/Z2ve&$\u0018P\u0003\u0002.\r\u0005AA-\u001a9m_fLG/\u0003\u00020U\tY!k\u001c7f'\u0016\u0014h/[2f\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014!\u0005;bg.\f5mY3tgN+'O^5dKB\u0011QcM\u0005\u0003i\t\u0011\u0011\u0003V1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f\u0011!1\u0004A!A!\u0002\u00139\u0014\u0001E;tKJLeNZ8SKN|GN^3s!\t)\u0002(\u0003\u0002:\u0005\t\u0001Rk]3s\u0013:4wNU3t_24XM\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t!\tit(D\u0001?\u0015\tYC!\u0003\u0002A}\t\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\t\u0011\t\u0003!\u0011!Q\u0001\n\r\u000b!\u0003^1tWN4\u0016.Z<D_:4XM\u001d;feB\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u000bG>tg/\u001a:uKJ\u001c(B\u0001%\u0005\u0003\u00151\u0018.Z<t\u0013\tQUI\u0001\nUCN\\7OV5fo\u000e{gN^3si\u0016\u0014\b\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\u000bQ,\u0017-\\:\u0011\u0005eq\u0015BA(\u001b\u0005\u0015!V-Y7t\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0016\u0001\u00053fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0005j]R,'O\\1m\u0015\t9F!A\u0002ba&L!!\u0017+\u0003A%sG/\u001a:oC2lU\r^1eCR\fG)Z2pe\u0006$xN]*feZL7-\u001a\u0005\t7\u0002\u0011\t\u0011)A\u00059\u0006)\"/\u001a7fCN,7oU9m%\u0016\u0004xn]5u_JL\bCA\r^\u0013\tq&DA\u000bSK2,\u0017m]3t'Fd'+\u001a9pg&$xN]=\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005\f\u0011C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s+\u0005\u0011\u0007CA\rd\u0013\t!'D\u0001\u000bTc2\u0014V\r]8tSR|'/_!eCB$XM\u001d\u0005\tM\u0002\u0011\t\u0011)A\u0005E\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0011!A\u0007A!b\u0001\n\u0007I\u0017a\u00023jC2,7\r^\u000b\u0002UB\u00111n \b\u0003Yrt!!\\=\u000f\u00059<hBA8w\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002t\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005a$\u0011A\u00013c\u0013\tQ80A\u0002tc2T!\u0001\u001f\u0003\n\u0005ut\u0018AC*rY\n+\u0018\u000e\u001c3fe*\u0011!p_\u0005\u0005\u0003\u0003\t\u0019AA\u0004ES\u0006dWm\u0019;\u000b\u0005ut\b\"CA\u0004\u0001\t\u0005\t\u0015!\u0003k\u0003!!\u0017.\u00197fGR\u0004\u0003bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\u0001\"!\u0006\u0001\t\r\u001d\nI\u00011\u0001)\u0011\u0019\t\u0014\u0011\u0002a\u0001e!1a'!\u0003A\u0002]BaaOA\u0005\u0001\u0004a\u0004B\u0002\"\u0002\n\u0001\u00071\t\u0003\u0004M\u0003\u0013\u0001\r!\u0014\u0005\u0007#\u0006%\u0001\u0019\u0001*\t\rm\u000bI\u00011\u0001]\u0011\u0019\u0001\u0017\u0011\u0002a\u0001E\"1\u0001.!\u0003A\u0004)D\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\u0002'I,G.Z1tK&#7/U;fef\u001c\u0016N_3\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0005\u0005E\u0012!B:dC2\f\u0017\u0002BA\u001b\u0003_\u00111!\u00138u\u0011!\tI\u0004\u0001Q\u0001\n\u0005-\u0012\u0001\u0006:fY\u0016\f7/Z%egF+XM]=TSj,\u0007\u0005C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002*\u0005!\"/\u001a7fCN,G)\u0019;b#V,'/_*ju\u0016D\u0001\"!\u0011\u0001A\u0003%\u00111F\u0001\u0016e\u0016dW-Y:f\t\u0006$\u0018-U;fef\u001c\u0016N_3!\u0011\u001d\t)\u0005\u0001C!\u0003\u000f\n\u0011cZ3u)\u0006\u001c8n\u001d\"z%\u0016dW-Y:f)\u0019\tI%!\u0015\u0002\\A!\u00111JA'\u001b\u00059\u0015bAA(\u000f\nqA+Y:l'\u0016\f'o\u00195WS\u0016<\b\u0002CA*\u0003\u0007\u0002\r!!\u0016\u0002\u0019Q\f7o[:GS2$XM]:\u0011\t\u0005-\u0013qK\u0005\u0004\u00033:%\u0001\u0004+bg.\u001ch)\u001b7uKJ\u001c\b\u0002CA/\u0003\u0007\u0002\r!a\u0018\u0002)1LW.\u001b;UCN\\7\u000fS5oi>\u0003H/[8o!\ri\u0011\u0011M\u0005\u0004\u0003Gr!aB%oi\u0016<WM\u001d\u0005\b\u0003O\u0002A\u0011BA5\u0003-\u0019X-\u0019:dQR\u000b7o[:\u0015\u0019\u0005-\u0014\u0011RAM\u0003g\u000b9,a/\u0011\r\u00055\u0014qOA?\u001d\u0011\ty'a\u001d\u000f\u0007E\f\t(\u0003\u0002\u00022%!\u0011QOA\u0018\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001f\u0002|\t\u00191+Z9\u000b\t\u0005U\u0014q\u0006\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111\u0011\u0003\u0002\r\u0011|W.Y5o\u0013\u0011\t9)!!\u0003\tQ\u000b7o\u001b\u0005\t\u0003\u0017\u000b)\u00071\u0001\u0002\u000e\u0006QA/Y:l\r&dG/\u001a:\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%\u0005\u0003\u001d1\u0017\u000e\u001c;feNLA!a&\u0002\u0012\nQA+Y:l\r&dG/\u001a:\t\u0011\u0005m\u0015Q\ra\u0001\u0003;\u000b1#\u00197m\u0003\u000e$\u0018N^3SK2,\u0017m]3JIN\u0004b!!\u001c\u0002 \u0006\r\u0016\u0002BAQ\u0003w\u0012\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003K\u000biK\u0004\u0003\u0002(\u0006%\u0006cA9\u00020%!\u00111VA\u0018\u0003\u0019\u0001&/\u001a3fM&!\u0011qVAY\u0005\u0019\u0019FO]5oO*!\u00111VA\u0018\u0011!\t),!\u001aA\u0002\u0005-\u0012A\u00047j[&$H+Y:lg\"Kg\u000e\u001e\u0005\t\u0003s\u000b)\u00071\u0001\u0002$\u0006AQo]3s]\u0006lW\r\u0003\u0005\u0002>\u0006\u0015\u0004\u0019AA`\u0003%)8/\u001a:S_2,7\u000f\u0005\u0004\u0002B\u0006\u001d\u00171Z\u0007\u0003\u0003\u0007T1!!2\u0011\u0003\u0011)H/\u001b7\n\t\u0005%\u00171\u0019\u0002\u0005\u0019&\u001cH\u000fE\u0002*\u0003\u001bL1!a4+\u0005\u0011\u0011v\u000e\\3\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\u0006\u0001\"/\u001a7fCN,\u0017\nZ:TiJ,\u0017-\u001c\u000b\u000b\u0003/\fy.!;\u0002t\u0006]\bCBA7\u00033\fi.\u0003\u0003\u0002\\\u0006m$AB*ue\u0016\fW\u000e\u0005\u0004\u0002n\u0005]\u00141\u0015\u0005\t\u0003C\f\t\u000e1\u0001\u0002d\u00069\u0011n]!e[&t\u0007\u0003BA\u0017\u0003KLA!a:\u00020\t9!i\\8mK\u0006t\u0007\u0002CAv\u0003#\u0004\r!!<\u0002\u0015A\u0014\u0018N\\2ja\u0006d7\u000f\u0005\u0004\u0002n\u0005=\u00181U\u0005\u0005\u0003c\fYH\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011!\t)0!5A\u0002\u00055\u0018a\u0002:pY\u0016LEm\u001d\u0005\u000b\u0003s\f\t\u000e%AA\u0002\u0005m\u0018\u0001\u00029bO\u0016\u00042!GA\u007f\u0013\r\tyP\u0007\u0002\u0005!\u0006<W\rC\u0004\u0003\u0004\u0001!IA!\u0002\u0002\u0011\u001d,G\u000fV1tWN$\"\"a\u001b\u0003\b\tM!Q\u0003B\f\u0011!\u0011IA!\u0001A\u0002\t-\u0011AD1di&4XMU3mK\u0006\u001cXm\u001d\t\u0007\u0003\u0003\f9M!\u0004\u0011\t\u0005}$qB\u0005\u0005\u0005#\t\tIA\u0004SK2,\u0017m]3\t\u0011\u0005u&\u0011\u0001a\u0001\u0003\u007fC\u0001\"!/\u0003\u0002\u0001\u0007\u00111\u0015\u0005\t\u0003\u0017\u0013\t\u00011\u0001\u0002\u000e\"I!1\u0004\u0001\u0012\u0002\u0013%!QD\u0001\u001be\u0016dW-Y:f\u0013\u0012\u001c8\u000b\u001e:fC6$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005?QC!a?\u0003\"-\u0012!1\u0005\t\u0005\u0005K\u0011y#\u0004\u0002\u0003()!!\u0011\u0006B\u0016\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003.\u0005=\u0012AC1o]>$\u0018\r^5p]&!!\u0011\u0007B\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SqlTaskSearchService
implements TaskSearchService,
DeserializationSupport,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final UserInfoResolver userInfoResolver;
    private final PermissionChecker permissions;
    private final TasksViewConverter tasksViewConverter;
    private final Teams teams;
    private final InternalMetadataDecoratorService decoratorService;
    private final ReleasesSqlRepository releasesSqlRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final SqlBuilder.Dialect dialect;
    private final int releaseIdsQuerySize;
    private final int releaseDataQuerySize;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeRelease(ReleaseData releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    private int releaseIdsQuerySize() {
        return this.releaseIdsQuerySize;
    }

    private int releaseDataQuerySize() {
        return this.releaseDataQuerySize;
    }

    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOption) {
        int limitTasksHint = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limitTasksHintOption).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100));
        String username = Permissions.getAuthenticatedUserName();
        java.util.List userRoles = this.roleService.getRolesFor(Permissions.getAuthentication());
        Iterator allActiveReleaseIds = this.releaseIdsStream(this.permissions.isCurrentUserAdmin(), (Iterable<String>)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala()), (Iterable<String>)((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(userRoles).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom())), this.releaseIdsStream$default$4()).flatten((Function1)Predef$.MODULE$.$conforms()).iterator();
        TaskFilter taskFilter = new TaskFilter(tasksFilters, this.userInfoResolver);
        Seq<Task> foundTasks = this.searchTasks(taskFilter, (Iterator<String>)allActiveReleaseIds, limitTasksHint, username, userRoles);
        Map tasksByRelease = foundTasks.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getRelease());
        this.decoratorService.decorate((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)tasksByRelease.keySet()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        java.util.List allowedTaskTypesForAuthenticatedUser = this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser();
        Seq releaseTasks2 = (Seq)((TraversableOnce)tasksByRelease.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Release release = (Release)tuple2._1();
            Seq tasks = (Seq)tuple2._2();
            ReleaseTasks releaseTasks = new ReleaseTasks(release, $this.tasksViewConverter.toFullView((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(tasks).asJava(), allowedTaskTypesForAuthenticatedUser));
            return releaseTasks;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1 & Serializable & scala.Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.getTitle()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$);
        return new TaskSearchView((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(releaseTasks2).asJava(), foundTasks.size() >= limitTasksHint);
    }

    private Seq<Task> searchTasks(TaskFilter taskFilter, Iterator<String> allActiveReleaseIds, int limitTasksHint, String username, java.util.List<Role> userRoles) {
        ArrayBuffer foundTasks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (foundTasks.size() < limitTasksHint && allActiveReleaseIds.nonEmpty()) {
            List releaseIdsBatch = allActiveReleaseIds.take(this.releaseDataQuerySize()).toList();
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " full releases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIdsBatch.size())})));
            ReleasesSqlBuilder sql = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withReleaseIds((Seq<String>)releaseIdsBatch);
            Seq releasesBatch = (Seq)this.releasesSqlRepository.findReleaseDatasByQuery(sql.build()).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseData)releaseData), Seq$.MODULE$.canBuildFrom());
            releasesBatch.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.teams.decorateWithEffectiveTeams(x$1);
                return BoxedUnit.UNIT;
            });
            Seq<Task> tasksFromBatch = this.getTasks((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(releasesBatch).asJava(), userRoles, username, taskFilter);
            foundTasks.appendAll((TraversableOnce)tasksFromBatch.take(limitTasksHint - foundTasks.size()));
        }
        return foundTasks;
    }

    private Stream<Seq<String>> releaseIdsStream(boolean isAdmin, Iterable<String> principals, Iterable<String> roleIds, Page page) {
        Stream stream;
        ReleasesSqlBuilder sql = new ReleasesSqlBuilder(this.dialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).orderBy(ReleaseOrderMode.start_date).withPage(page);
        Object object = !isAdmin ? sql.withPermission(XLReleasePermissions.VIEW_RELEASE, principals, roleIds) : BoxedUnit.UNIT;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for batch ", " of release IDs viewable by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{page, principals.head()})));
        Seq<String> ids = this.releasesSqlRepository.findReleaseIdsByQuery(sql.build());
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " release IDs on page ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ids.size()), page})));
        if (ids.isEmpty()) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            Seq<String> seq = ids;
            stream = Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.releaseIdsStream(isAdmin, principals, roleIds, page.copy(page.page() + 1L, page.copy$default$2(), page.copy$default$3()))).$hash$colon$colon(seq);
        }
        return stream;
    }

    private Page releaseIdsStream$default$4() {
        return new Page(0L, (long)this.releaseIdsQuerySize(), Predef$.MODULE$.int2Integer(0));
    }

    private Seq<Task> getTasks(java.util.List<Release> activeReleases, java.util.List<Role> userRoles, String username, TaskFilter taskFilter) {
        java.util.List tasks = taskFilter.filter(username, userRoles, activeReleases);
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tasks).asScala()).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.permissions.hasViewTaskPermissions(task, username, userRoles)));
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, UserInfoResolver userInfoResolver, PermissionChecker permissions, TasksViewConverter tasksViewConverter, Teams teams, InternalMetadataDecoratorService decoratorService, ReleasesSqlRepository releasesSqlRepository, SqlRepositoryAdapter repositoryAdapter, SqlBuilder.Dialect dialect) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.userInfoResolver = userInfoResolver;
        this.permissions = permissions;
        this.tasksViewConverter = tasksViewConverter;
        this.teams = teams;
        this.decoratorService = decoratorService;
        this.releasesSqlRepository = releasesSqlRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.dialect = dialect;
        DeserializationSupport.$init$(this);
        Logging.$init$((Logging)this);
        this.releaseIdsQuerySize = 2000;
        this.releaseDataQuerySize = 20;
    }
}

