/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.email.EmailFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailSender.class);
    private RepositoryService repositoryService;
    private Scheduler scheduler;
    private EmailFactory emailFactory;

    @Autowired
    public EmailSender(RepositoryService repositoryService, Scheduler scheduler, EmailFactory emailFactory) {
        this.repositoryService = repositoryService;
        this.scheduler = scheduler;
        this.emailFactory = emailFactory;
    }

    public CompletableFuture<Void> scheduleEmail(Collection<String> recipients, String subject, String body) {
        return this.scheduleEmail(recipients, subject, body, NotificationTriggerSettings.MailPriority.Normal);
    }

    public CompletableFuture<Void> scheduleEmail(Collection<String> recipients, String subject, String body, NotificationTriggerSettings.MailPriority priority) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (recipients == null) {
            logger.warn("Email with subject '%s' not sent, because the recipient is missing.", (Object)subject);
            future.completeExceptionally(new IllegalArgumentException());
        } else {
            this.scheduler.execute(() -> {
                try {
                    this.sendHTML(recipients, subject, body, priority);
                    future.complete(null);
                }
                catch (NotFoundException notFoundException) {
                    logger.info("Could not send email: {}. Please configure the SMTP Server", (Object)notFoundException.toString());
                    future.completeExceptionally(notFoundException);
                }
                catch (Exception e) {
                    logger.error("Could not send email ", (Throwable)e);
                    future.completeExceptionally(e);
                }
            });
        }
        return future;
    }

    void sendHTML(Collection<String> recipients, String subject, String htmlBody) throws EmailException {
        this.sendHTML(recipients, subject, htmlBody, NotificationTriggerSettings.MailPriority.Normal);
    }

    void sendHTML(Collection<String> recipients, String subject, String htmlBody, NotificationTriggerSettings.MailPriority priority) throws EmailException {
        SmtpServer smtpServer = (SmtpServer)this.repositoryService.read("Configuration/mail/SmtpServer");
        this.sendHTML(smtpServer, recipients, subject, htmlBody, priority);
    }

    public void sendHTML(SmtpServer smtpServer, Collection<String> recipients, String subject, String htmlBody, NotificationTriggerSettings.MailPriority priority) throws EmailException {
        HtmlEmail email = this.emailFactory.newHtmlEmail(smtpServer);
        HashMap<String, String> headers = new HashMap<String, String>();
        switch (priority) {
            case High: {
                headers.put("X-Priority", "1");
                headers.put("Importance", "high");
                break;
            }
            case Normal: {
                headers.put("X-Priority", "3");
                headers.put("Importance", "normal");
                break;
            }
            case Low: {
                headers.put("X-Priority", "5");
                headers.put("Importance", "low");
            }
        }
        email.setHeaders(headers);
        this.setRecipients((Email)email, recipients);
        this.setFrom((Email)email, smtpServer.getFromAddress());
        email.setSubject(subject);
        email.setHtmlMsg(htmlBody);
        email.send();
    }

    @VisibleForTesting
    void setRecipients(Email email, Collection<String> recipients) throws EmailException {
        email.setTo(EmailSender.toInternetAddresses(recipients));
    }

    private static List<InternetAddress> toInternetAddresses(Collection<String> recipients) throws EmailException {
        ArrayList addresses = Lists.newArrayList();
        for (String recipient : recipients) {
            try {
                addresses.addAll(Arrays.asList(InternetAddress.parse((String)recipient)));
            }
            catch (AddressException e) {
                throw new EmailException((Throwable)e);
            }
        }
        return addresses;
    }

    @VisibleForTesting
    void setFrom(Email email, String fromAddress) throws EmailException {
        if (fromAddress == null) {
            return;
        }
        try {
            InternetAddress from = new InternetAddress(fromAddress);
            email.setFrom(from.getAddress(), from.getPersonal());
        }
        catch (AddressException e) {
            throw new EmailException((Throwable)e);
        }
    }
}

