/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.validation;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Validator {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);

    public List<ValidationMessage> validate(ConfigurationItem roe, ConfigurationItem ... cisInContext) {
        return this.validate(roe, Arrays.asList(cisInContext));
    }

    public List<ValidationMessage> validate(ConfigurationItem ci, List<ConfigurationItem> cisInContext) {
        return ci.getType().getDescriptor().validate(ci);
    }

    public void validateCi(ConfigurationItem item) throws ValidationsFailedException {
        List<ValidationMessage> messages = this.validate(item, new ConfigurationItem[0]);
        if (!messages.isEmpty()) {
            item.get$validationMessages().addAll(messages);
            throw new ValidationsFailedException(item);
        }
    }

    public void validateCis(List<ConfigurationItem> entities) {
        boolean allValid = true;
        for (ConfigurationItem entity : entities) {
            try {
                List<ValidationMessage> messages = this.validate(entity, new ConfigurationItem[0]);
                if (messages.isEmpty()) continue;
                logger.error("Validation failed for [{}], messages are:\n" + messages.stream().map(ValidationMessage::toString).collect(Collectors.joining("\n")));
                entity.get$validationMessages().addAll(messages);
                allValid = false;
            }
            catch (Exception e) {
                entity.get$validationMessages().add(new ValidationMessage(entity.getId(), "", e.getMessage()));
                allValid = false;
            }
        }
        if (!allValid) {
            throw new ValidationsFailedException(entities);
        }
    }

    public static class ValidatedCis {
        private List<ConfigurationItem> cis;

        public ValidatedCis(List<ConfigurationItem> cis) {
            this.cis = cis;
        }

        public List<ConfigurationItem> getCis() {
            return this.cis;
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class ValidationsFailedException
    extends DeployitException {
        public ValidationsFailedException(List<ConfigurationItem> cis) {
            super(cis);
        }

        public ValidationsFailedException(ConfigurationItem ci) {
            super((Object)ci);
        }
    }
}

