/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslFormatter$;
import com.xebialabs.xlrelease.dsl.service.renderer.DefaultRenderer;
import com.xebialabs.xlrelease.dsl.service.renderer.DslRendererContext;
import com.xebialabs.xlrelease.repository.Ids;
import java.io.OutputStream;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u001b\tYAi\u001d7FqB|'\u000f^3s\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011a\u00013tY*\u0011q\u0001C\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003=!WMZ1vYR\u0014VM\u001c3fe\u0016\u0014\bCA\f\u001b\u001b\u0005A\"BA\r\u0003\u0003!\u0011XM\u001c3fe\u0016\u0014\u0018BA\u000e\u0019\u0005=!UMZ1vYR\u0014VM\u001c3fe\u0016\u0014\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\u0005!)Q\u0003\ba\u0001-!\u0012Ad\t\t\u0003I=j\u0011!\n\u0006\u0003M\u001d\n!\"\u00198o_R\fG/[8o\u0015\tA\u0013&A\u0004gC\u000e$xN]=\u000b\u0005)Z\u0013!\u00022fC:\u001c(B\u0001\u0017.\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021K\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006e\u0001!\taM\u0001\u000fKb\u0004xN\u001d;UK6\u0004H.\u0019;f)\r!tg\u0010\t\u0003\u001fUJ!A\u000e\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006qE\u0002\r!O\u0001\ti\u0016l\u0007\u000f\\1uKB\u0011!(P\u0007\u0002w)\u0011AHB\u0001\u0007I>l\u0017-\u001b8\n\u0005yZ$a\u0002*fY\u0016\f7/\u001a\u0005\u0006\u0001F\u0002\r!Q\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b!![8\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0006\u0015\u0002!IaS\u0001\u000bC\u0012$\u0007\f\u001c:UC\u001e\u001cHC\u0001'X!\tiEK\u0004\u0002O%B\u0011q\nE\u0007\u0002!*\u0011\u0011\u000bD\u0001\u0007yI|w\u000e\u001e \n\u0005M\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!a\u0015\t\t\u000baK\u0005\u0019\u0001'\u0002\u0017Q,W\u000e\u001d7bi\u0016$5\u000f\u001c\u0005\u00065\u0002!IaW\u0001\u0013C\u0012$W*\u001a;b\u0013:4wN]7bi&|g\u000eF\u0002M9vCQ\u0001O-A\u0002eBQ\u0001W-A\u00021C#\u0001A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\\\u0013AC:uKJ,w\u000e^=qK&\u0011A-\u0019\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DslExporter {
    private final DefaultRenderer defaultRenderer;

    public void exportTemplate(Release template, OutputStream outputStream) {
        DslRendererContext rendererContext = new DslRendererContext();
        String templateDsl = this.addXlrTags(this.defaultRenderer.dsl(rendererContext, (ConfigurationItem)template));
        String dslOut = this.addMetaInformation(template, DslFormatter$.MODULE$.format((String)new StringOps(Predef$.MODULE$.augmentString(rendererContext.context())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(templateDsl)), Predef$.MODULE$.StringCanBuildFrom())));
        outputStream.write(dslOut.getBytes("UTF-8"));
    }

    private String addXlrTags(String templateDsl) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xlr {\n       |", "\n       |}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateDsl})))).stripMargin();
    }

    private String addMetaInformation(Release template, String templateDsl) {
        String templateId = Ids.releasePathInRootFolder((String)template.getId()).replaceAll("/", "-");
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|// Exported from:        ", "#/templates/", "/releasefile\n        |// XL Release version:   ", "\n        |// Date created:         ", "\n        |\n        |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ServerConfiguration.getInstance().getServerUrl(), templateId, releaseInfo.getVersion(), new Date(), templateDsl})))).stripMargin();
    }

    @Autowired
    public DslExporter(DefaultRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }
}

