/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.smb;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.smb.SmbConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.ProcessConnection;

public class SmbProcessConnection
extends SmbConnection {
    private ProcessConnection processConnection;

    public SmbProcessConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, true);
        options.set("protocol", type);
        CifsConnectionType cifsConnectionType = options.getEnum("connectionType", CifsConnectionType.class);
        this.processConnection = cifsConnectionType.getProcessConnection(options, mapper, this.workingDirectory);
        this.connected();
    }

    @Override
    public void connect() {
        this.processConnection.connect();
        super.connect();
        this.connected();
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        super.setWorkingDirectory(workingDirectory);
        this.processConnection.setWorkingDirectory(workingDirectory);
    }

    @Override
    public void doClose() {
        this.processConnection.close();
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmd) {
        return this.processConnection.startProcess(cmd);
    }
}

