/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.tokenizer;

import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.line.LineParser;
import org.crsh.cli.impl.tokenizer.Automaton;
import org.crsh.cli.impl.tokenizer.Token;
import org.crsh.cli.impl.tokenizer.Tokenizer;

public class TokenizerImpl
extends Tokenizer {
    private final Automaton automaton;
    private Delimiter endingDelimiter = Delimiter.EMPTY;

    public TokenizerImpl(CharSequence s) {
        Automaton automaton = new Automaton(s);
        LineParser.Visitor parser2 = new LineParser.Visitor(){

            @Override
            public void openStrongQuote(int index) {
                TokenizerImpl.this.endingDelimiter = Delimiter.SINGLE_QUOTE;
            }

            @Override
            public void closeStrongQuote(int index) {
                TokenizerImpl.this.endingDelimiter = Delimiter.EMPTY;
            }

            @Override
            public void openWeakQuote(int index) {
                TokenizerImpl.this.endingDelimiter = Delimiter.DOUBLE_QUOTE;
            }

            @Override
            public void closeWeakQuote(int index) {
                TokenizerImpl.this.endingDelimiter = Delimiter.EMPTY;
            }
        };
        LineParser parser = new LineParser(automaton, parser2);
        parser.append(s);
        automaton.close();
        this.automaton = automaton;
    }

    @Override
    protected Token parse() {
        if (this.automaton.tokens.size() > 0) {
            return this.automaton.tokens.removeFirst();
        }
        return null;
    }

    public Delimiter getEndingDelimiter() {
        return this.endingDelimiter;
    }
}

