/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.xltype.serialization.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xltype.serialization.SerializationException;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class MetadataIncludingCiJsonWriter
extends CiJsonWriter {
    private ObjectMapper objectMapper;

    public MetadataIncludingCiJsonWriter(Writer writer, ObjectMapper objectMapper) {
        super(writer);
        this.objectMapper = objectMapper;
    }

    public void writeInternalMetadata(Map<String, InternalMetadata> metadata) {
        if (metadata != null && !metadata.isEmpty()) {
            String metadataAsString = null;
            try {
                ObjectWriter ow = this.objectMapper.writer().withDefaultPrettyPrinter();
                metadataAsString = ow.writeValueAsString(metadata);
                JSONObject metadataAsJsonObject = new JSONObject(metadataAsString);
                this.json.key("$metadata").value((Object)metadataAsJsonObject);
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("Could not serialize $metadata of a CI: " + metadata, (Throwable)e);
            }
            catch (JSONException e) {
                throw new SerializationException("Could not serialize $metadata of a CI: " + metadataAsString, (Throwable)e);
            }
        }
    }
}

