/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.xml;

import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.core.xml.PasswordEncryptingXStreamCiConverter;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.xstream.CiXstreamReader;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@XStreamProvider(tagName="configuration-item", readable=ConfigurationItem.class)
public class XStreamCiConverterWithRepository
extends PasswordEncryptingXStreamCiConverter {
    static final ThreadLocal<Map<String, ConfigurationItem>> DESERIALIZATION_CONTEXT = ThreadLocal.withInitial(HashMap::new);
    static final ThreadLocal<List<CiReference>> DESERIALIZATION_REFERENCES = ThreadLocal.withInitial(ArrayList::new);
    static final ThreadLocal<RepositoryService> REPOSITORY = new ThreadLocal();
    private final RepositoryService repository;

    public XStreamCiConverterWithRepository() {
        this.repository = null;
    }

    @Autowired
    public XStreamCiConverterWithRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (this.repository == null) {
            return super.unmarshal(reader, context);
        }
        ConfigurationItemConverter converter = this.createConverter((DataHolder)context);
        ConfigurationItem ci = converter.readCi((CiReader)new CiXstreamReader(reader));
        DESERIALIZATION_REFERENCES.get().addAll(converter.getReferences());
        REPOSITORY.set(this.repository);
        if (ci instanceof ValidatedConfigurationItem) {
            DESERIALIZATION_CONTEXT.get().put(ci.getId(), ((ValidatedConfigurationItem)ci).getWrapped());
        } else {
            DESERIALIZATION_CONTEXT.get().put(ci.getId(), ci);
        }
        return ci;
    }

    static void postProcess() {
        try {
            for (CiReference reference : DESERIALIZATION_REFERENCES.get()) {
                XStreamCiConverterWithRepository.resolve(reference);
            }
        }
        finally {
            XStreamCiConverterWithRepository.clear();
        }
    }

    private static void resolve(CiReference reference) {
        ArrayList<ConfigurationItem> cis = new ArrayList<ConfigurationItem>();
        for (String id : reference.getIds()) {
            cis.add(XStreamCiConverterWithRepository.readCi(id));
        }
        reference.set(cis);
    }

    private static ConfigurationItem readCi(String id) {
        if (DESERIALIZATION_CONTEXT.get().containsKey(id)) {
            return DESERIALIZATION_CONTEXT.get().get(id);
        }
        return REPOSITORY.get().read(id, WorkDirContext.get());
    }

    public static void clear() {
        DESERIALIZATION_REFERENCES.remove();
        DESERIALIZATION_CONTEXT.remove();
        REPOSITORY.remove();
    }
}

