/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.ExportHook;
import com.xebialabs.xlrelease.repository.Configurations;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ConfigurationStatusService;
import com.xebialabs.xlrelease.views.ConfigurationStatusResponse;
import com.xebialabs.xlrelease.views.ConfigurationView;
import com.xebialabs.xlrelease.views.converters.ConfigurationViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ConfigurationResource {
    private Configurations configurations;
    private PermissionChecker permissions;
    private ConfigurationViewConverter configurationViewConverter;
    private ConfigurationStatusService configurationStatusService;

    @Autowired
    public ConfigurationResource(Configurations configurations, PermissionChecker permissions, ConfigurationViewConverter configurationViewConverter, ConfigurationStatusService configurationStatusService) {
        this.configurations = configurations;
        this.permissions = permissions;
        this.configurationStatusService = configurationStatusService;
        this.configurationViewConverter = configurationViewConverter;
    }

    @GET
    @Timed
    @Path(value="descriptors")
    public List<Descriptor> getConfigurationDescriptors() {
        return this.configurations.findAllConfigurationDescriptors();
    }

    @GET
    public List<ConfigurationView> getConfigurationInstances(@QueryParam(value="anonymized") boolean anonymized) {
        if (anonymized) {
            return this.configurations.findAll().stream().map(this.configurationViewConverter::toAnonymizedView).collect(Collectors.toList());
        }
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurations.findAll().stream().map(this.configurationViewConverter::toView).collect(Collectors.toList());
    }

    @POST
    public ConfigurationView addConfigurationInstance(ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurations.create(this.configurationViewConverter.fromView(configurationView));
        return this.configurationViewConverter.toView(configuration);
    }

    @GET
    @Timed
    @Path(value="{configurationInstanceId:((?!descriptors).)*}")
    public ConfigurationView getConfigurationInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurations.findById(configurationInstanceId);
        return this.configurationViewConverter.toView(configuration);
    }

    @PUT
    @Timed
    @Path(value="{configurationInstanceId:((?!descriptors).)*}")
    public ConfigurationView updateConfigurationInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId, ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurations.updateWith(configurationInstanceId, this.configurationViewConverter.fromView(configurationView));
        return this.configurationViewConverter.toView(configuration);
    }

    @DELETE
    @Timed
    @Path(value="{configurationInstanceId}")
    public void deleteConfigurationInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurations.delete(configurationInstanceId);
    }

    @Timed
    @Path(value="status")
    @POST
    public ConfigurationStatusResponse checkConnection(ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        ConfigurationStatusResponse response = this.configurationStatusService.checkStatus(configuration);
        this.fixRestEasyProviders();
        return response;
    }

    @Timed
    @Path(value="hasScript")
    @POST
    public Boolean hasScript(ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        return !(configuration instanceof ExportHook) && this.configurationStatusService.hasScript(configuration);
    }

    private void fixRestEasyProviders() {
        if (ResteasyProviderFactory.getContextDataMap().isEmpty()) {
            ResteasyProviderFactory.getContextDataMap().put(Providers.class, new ResteasyProviderFactory());
        }
    }
}

