/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.repository.Durations;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.DatesForm;
import com.xebialabs.xlrelease.views.LinkForm;
import com.xebialabs.xlrelease.views.LinkView;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/planning")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class PlanningResource {
    private PermissionChecker permissionChecker;
    private ReleaseActorService releaseActorService;

    @Autowired
    public PlanningResource(PermissionChecker permissionChecker, ReleaseActorService releaseActorService) {
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
    }

    @PUT
    @Timed
    @Path(value="{planItemId:.*(Release|Phase|Task)[^/-]*}")
    public void updateDates(@PathParam(value="planItemId") @IdParam String planItemId, DatesForm datesForm) {
        this.permissionChecker.checkEditPlanItem(planItemId);
        this.releaseActorService.updateDates(planItemId, datesForm.getScheduledStartDate(), datesForm.getDueDate(), Durations.fromDurationView(datesForm.getPlannedDuration()));
    }

    @POST
    @Timed
    @Path(value="links/{containerId:.*Task[^/-]*}")
    public LinkView addLink(@PathParam(value="containerId") @IdParam String containerId, LinkForm linkForm) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom((String)containerId));
        return new LinkView(this.releaseActorService.createLink(containerId, linkForm.getSourceId(), linkForm.getTargetId()));
    }

    @DELETE
    @Timed
    @Path(value="links/{linkId:.*Link[^/-]*}")
    public void removeLink(@PathParam(value="linkId") @IdParam String linkId) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom((String)linkId));
        this.releaseActorService.deleteLink(linkId);
    }
}

