/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.metrics;

import com.codahale.metrics.jmx.ObjectNameFactory;
import com.xebialabs.xlrelease.metrics.MetricsConfiguration$;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.util.matching.Regex;

public final class XlrObjectNameFactory$
implements ObjectNameFactory {
    public static XlrObjectNameFactory$ MODULE$;

    static {
        new XlrObjectNameFactory$();
    }

    public ObjectName createName(String type, String originalDomain, String originalName) {
        ObjectName objectName;
        Tuple2<String, String> tuple2 = this.customDomainAndName(originalName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String domain = (String)tuple2._1();
        String name = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)domain, (Object)name);
        Tuple2 tuple23 = tuple22;
        String domain2 = (String)tuple23._1();
        String name2 = (String)tuple23._2();
        try {
            ObjectName objectName2 = new ObjectName(domain2, "name", name2);
            objectName = objectName2.isPattern() ? new ObjectName(domain2, "name", ObjectName.quote(name2)) : objectName2;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            try {
                objectName = new ObjectName(domain2, "name", ObjectName.quote(name2));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        }
        return objectName;
    }

    public Tuple2<String, String> customDomainAndName(String name) {
        Tuple2 tuple2;
        Regex xlrClass = new StringOps(Predef$.MODULE$.augmentString("com\\.xebialabs\\.xlrelease\\.(?:([\\w\\.]+)\\.)?([A-Z]\\w+(?:\\.\\w+)?)")).r();
        String string = name;
        if (string.startsWith("connections")) {
            tuple2 = new Tuple2((Object)"handler", (Object)name);
        } else if (string.startsWith("org.eclipse.jetty.webapp.WebAppContext")) {
            tuple2 = new Tuple2((Object)"handler", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(name)).split('.'))).last());
        } else if (string.startsWith("scheduler")) {
            tuple2 = new Tuple2((Object)"executors", (Object)name);
        } else if (string.startsWith("releaseTrigger")) {
            tuple2 = new Tuple2((Object)"executors", (Object)name);
        } else if (string.startsWith("RepositoryPool")) {
            tuple2 = new Tuple2((Object)"pool.repository", (Object)new StringOps(Predef$.MODULE$.augmentString(name)).stripPrefix("RepositoryPool.pool."));
        } else if (string.startsWith("ReportingPool")) {
            tuple2 = new Tuple2((Object)"pool.reporting", (Object)new StringOps(Predef$.MODULE$.augmentString(name)).stripPrefix("ReportingPool.pool."));
        } else {
            Option option = xlrClass.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String suffix = (String)((LinearSeqOptimized)option.get()).apply(0);
                String className = (String)((LinearSeqOptimized)option.get()).apply(1);
                tuple2 = new Tuple2((Object)suffix, (Object)className);
            } else {
                tuple2 = new Tuple2(null, (Object)name);
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String domainSuffix = (String)tuple22._1();
        String customName = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)domainSuffix, (Object)customName);
        Tuple2 tuple24 = tuple23;
        String domainSuffix2 = (String)tuple24._1();
        String customName2 = (String)tuple24._2();
        String customDomain = domainSuffix2 == null ? MetricsConfiguration$.MODULE$.METRICS_DOMAIN() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MetricsConfiguration$.MODULE$.METRICS_DOMAIN(), domainSuffix2}));
        return new Tuple2((Object)customDomain, (Object)customName2);
    }

    private XlrObjectNameFactory$() {
        MODULE$ = this;
    }
}

