/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script.jython;

import com.google.common.collect.Lists;
import com.xebialabs.platform.script.jython.EngineInstance;
import com.xebialabs.platform.script.jython.Syntactic;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.script.Jsr223ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptPermissionsProvider;
import com.xebialabs.xlrelease.script.jython.JythonScriptHelper;
import java.util.Collection;
import java.util.List;
import javax.script.ScriptContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

@Component
public class JythonScriptExecutor
extends Jsr223ScriptExecutor {
    private static final List<String> PYTHON_UTILITIES = Lists.newArrayList((Object[])new String[]{"xlrelease/XLRequest.py", "xlrelease/XLResponse.py", "xlrelease/CredentialsFallback.py", "xlrelease/HttpRequest.py", "xlrelease/HttpResponse.py"});

    @Autowired
    public JythonScriptExecutor(ScriptPermissionsProvider scriptPermissionsProvider, XlrConfig xlrConfig) {
        super(EngineInstance.jython(), scriptPermissionsProvider, xlrConfig);
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext) throws Exception {
        return this.evalScript(script, scriptContext, true);
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.evalScriptWithUtilities(script, scriptContext, checkPolicyPermissions);
    }

    @Override
    public Object evalScriptWithApi(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        this.evalUtilityScript(Syntactic.wrapperLib().scriptContent(), scriptContext);
        this.loadAndEval("xlrelease/globals.py", scriptContext);
        this.loadAndEval("xlrelease/XLReleaseApi.py", scriptContext);
        this.wrapBindings(scriptContext);
        Object result = this.evalScriptWithUtilities(script, scriptContext, checkPolicyPermissions);
        this.unwrapBindings(scriptContext);
        return result;
    }

    private Object evalScriptWithUtilities(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        for (String pythonFile : PYTHON_UTILITIES) {
            this.loadAndEval(pythonFile, scriptContext);
        }
        return this.evalScriptPrivileged(script, scriptContext, checkPolicyPermissions ? this.getAccessControlContext() : null);
    }

    private void wrapBindings(ScriptContext scriptContext) {
        List bindingsToWrap = (List)scriptContext.getAttribute("_contextBindingsToWrap");
        if (bindingsToWrap != null) {
            this.evalUtilityScript(JythonScriptHelper.wrapBindings((Iterable<String>)JavaConversions.collectionAsScalaIterable((Collection)bindingsToWrap)).scriptContent(), scriptContext);
        }
    }

    private void unwrapBindings(ScriptContext scriptContext) {
        List bindingsToUnwrap = (List)scriptContext.getAttribute("_contextBindingsToUnwrap");
        if (bindingsToUnwrap != null) {
            this.evalUtilityScript(JythonScriptHelper.unwrapBindings((Iterable<String>)JavaConversions.collectionAsScalaIterable((Collection)bindingsToUnwrap)).scriptContent(), scriptContext);
        }
    }
}

