/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.service.ReleaseTitleResolver;
import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.ReleaseExtensionView;
import com.xebialabs.xlrelease.views.ReleaseFullView;
import com.xebialabs.xlrelease.views.ReleaseSearchView;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.PhaseViewConverter;
import com.xebialabs.xlrelease.views.converters.PlanItemConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseExtensionsViewConverter;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleaseViewConverter
implements PlanItemConverter {
    private UserViewConverter userViewConverter;
    private TasksViewConverter tasksViewConverter;
    private PhaseViewConverter phaseViewConverter;
    private ReleaseTitleResolver releaseTitleResolver;
    private ReleaseExtensionsViewConverter releaseExtensionsViewConverter;

    @Autowired
    public ReleaseViewConverter(UserViewConverter userViewConverter, TasksViewConverter tasksViewConverter, PhaseViewConverter phaseViewConverter, ReleaseTitleResolver releaseTitleResolver, ReleaseExtensionsViewConverter releaseExtensionsViewConverter) {
        this.userViewConverter = userViewConverter;
        this.tasksViewConverter = tasksViewConverter;
        this.phaseViewConverter = phaseViewConverter;
        this.releaseTitleResolver = releaseTitleResolver;
        this.releaseExtensionsViewConverter = releaseExtensionsViewConverter;
    }

    public ReleaseFullView toFullView(Release release, List<Type> allowedTaskTypesForAuthenticatedUser, List<String> properties, List<String> extensions, int depth) {
        ReleaseFullView view = new ReleaseFullView();
        this.populatePlanItemView(view, (PlanItem)release);
        view.setStatus(release.getStatus());
        view.setReleaseFlag(Flag.toItemFlag((PlanItem)release));
        view.setFlag(Flag.toFlag(release));
        view.setSecurity((EffectiveSecurity)release.get$metadata().get(EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        view.setArchived(release.isArchived());
        view.setTutorial(release.isTutorial());
        view.setTags(release.getTags());
        view.setCalendarLinkToken(release.getCalendarLinkToken());
        view.setCalendarPublished(release.isCalendarPublished());
        view.setAbortOnFailure(release.isAbortOnFailure());
        view.setAllowConcurrentReleasesFromTrigger(release.isAllowConcurrentReleasesFromTrigger());
        if (release.hasOwner()) {
            view.setOwner(this.userViewConverter.toUserView(release.getOwner()));
        }
        if (release.hasScriptUsername()) {
            view.setScriptUsername(this.userViewConverter.toUserView(release.getScriptUsername()));
        }
        view.setScriptUserPassword(release.getScriptUserPassword());
        view.setStartedFromTaskId(release.getStartedFromTaskId());
        view.setStartedFromTaskReleaseTitle(this.releaseTitleResolver.getReleaseTitleFromChild(release.getStartedFromTaskId()));
        view.setOriginTemplateId(release.getOriginTemplateId());
        view.setOriginTemplateTitle(this.releaseTitleResolver.getReleaseTitle(release.getOriginTemplateId()));
        view.setAutoStart(release.isAutoStart());
        if (depth <= 1) {
            return view;
        }
        if (release.hasCurrentPhase()) {
            Phase currentPhase = release.getCurrentPhase();
            view.setCurrentPhase(currentPhase.getTitle());
            if (currentPhase.hasCurrentTask()) {
                Task currentTask = currentPhase.getCurrentTask();
                view.setCurrentTask(this.tasksViewConverter.toFullView(currentTask, allowedTaskTypesForAuthenticatedUser));
                view.setCurrentSimpleTasks(this.flattenCurrentTask(currentTask, this.tasksViewConverter, allowedTaskTypesForAuthenticatedUser));
            }
        }
        if (!release.isTemplate()) {
            view.setVariables(release.getAllStringVariableValues());
        }
        this.populateSyntheticProperties(release, view, properties);
        this.populateExtensions(release, view, extensions);
        if (depth <= 2) {
            return view;
        }
        if (release.getPhases() != null) {
            view.setPhases(release.getPhases().stream().map(phase -> this.phaseViewConverter.toFullView((Phase)phase, allowedTaskTypesForAuthenticatedUser)).collect(Collectors.toList()));
        }
        if (release.getReleaseAttachments() != null) {
            view.setAttachments(release.getReleaseAttachments().stream().map(AttachmentView::new).collect(Collectors.toList()));
        }
        return view;
    }

    public ReleaseSearchView toSearchView(ReleaseSearchResult releaseSearchResult, List<Type> allowedTaskTypesForAuthenticatedUser, List<String> properties, int depth, List<String> extensions) {
        List<ReleaseFullView> views = releaseSearchResult.getReleases().stream().map(r -> this.toFullView((Release)r, allowedTaskTypesForAuthenticatedUser, properties, extensions, depth)).collect(Collectors.toList());
        return new ReleaseSearchView(releaseSearchResult.getPage(), views);
    }

    @VisibleForTesting
    List<TaskFullView> flattenCurrentTask(Task currentTask, TasksViewConverter tasksViewConverter, List<Type> allowedTaskTypesForAuthenticatedUser) {
        ArrayList currentTasks = Lists.newArrayList();
        if (currentTask.isTaskGroup()) {
            this.collectCurrentSubTasks("", (TaskGroup)currentTask, currentTasks, tasksViewConverter, allowedTaskTypesForAuthenticatedUser);
        } else {
            currentTasks.add(tasksViewConverter.toFullView(currentTask, allowedTaskTypesForAuthenticatedUser));
        }
        return currentTasks;
    }

    private void collectCurrentSubTasks(String parentPrefix, TaskGroup group, List<TaskFullView> target, TasksViewConverter tasksViewConverter, List<Type> allowedTaskTypesForAuthenticatedUser) {
        String prefix = group.getTitle() + " / ";
        if (!parentPrefix.isEmpty()) {
            prefix = parentPrefix + prefix;
        }
        for (Task subTask : group.getTasks()) {
            if (subTask.isTaskGroup()) {
                this.collectCurrentSubTasks(prefix, (TaskGroup)subTask, target, tasksViewConverter, allowedTaskTypesForAuthenticatedUser);
                continue;
            }
            if (!subTask.isActive()) continue;
            TaskFullView view = tasksViewConverter.toFullView(subTask, allowedTaskTypesForAuthenticatedUser);
            view.setTitle(prefix + view.getTitle());
            target.add(view);
        }
    }

    private void populateSyntheticProperties(Release release, ReleaseFullView view, List<String> properties) {
        HashMap<String, Object> syntheticProperties = new HashMap<String, Object>();
        properties.forEach(property -> {
            if (release.hasProperty(property)) {
                syntheticProperties.put((String)property, release.getProperty(property));
            }
        });
        view.setSyntheticProperties(syntheticProperties);
    }

    private void populateExtensions(Release release, ReleaseFullView view, List<String> extensions) {
        List releaseExtensions = release.getExtensions();
        HashMap<String, ReleaseExtensionView> extensionMap = new HashMap<String, ReleaseExtensionView>();
        extensions.forEach(extension -> {
            Optional<ReleaseExtension> e = releaseExtensions.stream().filter(releaseExtension -> Ids.getName((String)releaseExtension.getId()).equals(extension)).findFirst();
            e.ifPresent(releaseExtension -> extensionMap.put((String)extension, this.releaseExtensionsViewConverter.toView((ReleaseExtension)releaseExtension)));
        });
        view.setExtensions(extensionMap);
    }
}

