/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class ReverseListSerializer
extends Serializer<List<Object>> {
    private static final CollectionSerializer serializer = new CollectionSerializer();

    public void write(Kryo kryo, Output output, List<Object> object) {
        List forwardList = Lists.reverse(object);
        serializer.write(kryo, output, (Collection)forwardList);
    }

    public List<Object> copy(Kryo kryo, List<Object> original) {
        List forwardList = Lists.reverse(original);
        return Lists.reverse((List)((List)serializer.copy(kryo, (Collection)forwardList)));
    }

    public static void registerSerializers(Kryo kryo) {
        kryo.register(Lists.reverse((List)Lists.newLinkedList()).getClass(), (Serializer)ReverseListSerializer.forReverseList());
        kryo.register(Lists.reverse((List)Lists.newArrayList()).getClass(), (Serializer)ReverseListSerializer.forRandomAccessReverseList());
    }

    public static ReverseListSerializer forReverseList() {
        return new ReverseList();
    }

    public static ReverseListSerializer forRandomAccessReverseList() {
        return new RandomAccessReverseList();
    }

    private static class RandomAccessReverseList
    extends ReverseListSerializer {
        private RandomAccessReverseList() {
        }

        public List<Object> read(Kryo kryo, Input input, Class<List<Object>> type) {
            List forwardList = (List)serializer.read(kryo, input, ArrayList.class);
            return Lists.reverse((List)forwardList);
        }
    }

    private static class ReverseList
    extends ReverseListSerializer {
        private ReverseList() {
        }

        public List<Object> read(Kryo kryo, Input input, Class<List<Object>> type) {
            List forwardList = (List)serializer.read(kryo, input, LinkedList.class);
            return Lists.reverse((List)forwardList);
        }
    }
}

