/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssSchema;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementPolicy;
import org.owasp.html.FilterUrlByProtocolAttributePolicy;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.Joinable;
import org.owasp.html.PolicyFactory;
import org.owasp.html.StandardUrlAttributePolicy;
import org.owasp.html.Strings;
import org.owasp.html.StylingPolicy;
import org.owasp.html.TCB;
import org.owasp.html.TagBalancingHtmlStreamEventReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
@NotThreadSafe
public class HtmlPolicyBuilder {
    public static final ImmutableSet<String> DEFAULT_SKIP_IF_EMPTY = ImmutableSet.of((Object)"a", (Object)"font", (Object)"img", (Object)"input", (Object)"span");
    public static final ImmutableSet<String> DEFAULT_RELS_ON_TARGETTED_LINKS = ImmutableSet.of((Object)"noopener", (Object)"noreferrer");
    static final String DEFAULT_RELS_ON_TARGETTED_LINKS_STR = Joiner.on((char)' ').join(DEFAULT_RELS_ON_TARGETTED_LINKS);
    private final Map<String, ElementPolicy> elPolicies = Maps.newLinkedHashMap();
    private final Map<String, Map<String, AttributePolicy>> attrPolicies = Maps.newLinkedHashMap();
    private final Map<String, AttributePolicy> globalAttrPolicies = Maps.newLinkedHashMap();
    private final Set<String> allowedProtocols = Sets.newLinkedHashSet();
    private final Set<String> skipIfEmpty = Sets.newLinkedHashSet(DEFAULT_SKIP_IF_EMPTY);
    private final Map<String, Boolean> textContainers = Maps.newLinkedHashMap();
    private HtmlStreamEventProcessor postprocessor = HtmlStreamEventProcessor.Processors.IDENTITY;
    private HtmlStreamEventProcessor preprocessor = HtmlStreamEventProcessor.Processors.IDENTITY;
    private CssSchema stylingPolicySchema = null;
    private AttributePolicy styleUrlPolicy = AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY;
    private Set<String> extraRelsForLinks;
    private Set<String> skipRelsForLinks;
    private static final Set<String> URL_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"action", (Object)"archive", (Object)"background", (Object)"cite", (Object)"classid", (Object)"codebase", (Object[])new String[]{"data", "dsync", "formaction", "href", "icon", "longdesc", "manifest", "poster", "profile", "src", "srcset", "usemap"});
    private transient ImmutableMap<String, ElementAndAttributePolicies> compiledPolicies;

    public HtmlPolicyBuilder allowElements(String ... elementNames) {
        return this.allowElements(ElementPolicy.IDENTITY_ELEMENT_POLICY, elementNames);
    }

    public HtmlPolicyBuilder disallowElements(String ... elementNames) {
        return this.allowElements(ElementPolicy.REJECT_ALL_ELEMENT_POLICY, elementNames);
    }

    public HtmlPolicyBuilder allowElements(ElementPolicy policy, String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            ElementPolicy newPolicy = ElementPolicy.Util.join(this.elPolicies.get(elementName), policy);
            this.elPolicies.put(elementName, newPolicy);
            if (this.textContainers.containsKey(elementName) || !TagBalancingHtmlStreamEventReceiver.allowsPlainTextualContent(elementName)) continue;
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder allowCommonInlineFormattingElements() {
        return this.allowElements("b", "i", "font", "s", "u", "o", "sup", "sub", "ins", "del", "strong", "strike", "tt", "code", "big", "small", "br", "span", "em");
    }

    public HtmlPolicyBuilder allowCommonBlockElements() {
        return this.allowElements("p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "blockquote");
    }

    public HtmlPolicyBuilder allowTextIn(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowTextIn(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.textContainers.put(elementName, false);
        }
        return this;
    }

    public HtmlPolicyBuilder allowWithoutAttributes(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.skipIfEmpty.remove(elementName);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowWithoutAttributes(String ... elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            elementName = HtmlLexer.canonicalName(elementName);
            this.skipIfEmpty.add(elementName);
        }
        return this;
    }

    public AttributeBuilder allowAttributes(String ... attributeNames) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (String attributeName : attributeNames) {
            b.add((Object)HtmlLexer.canonicalName(attributeName));
        }
        return new AttributeBuilder((List<? extends String>)b.build());
    }

    public AttributeBuilder disallowAttributes(String ... attributeNames) {
        return this.allowAttributes(attributeNames).matching(AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY);
    }

    private HtmlPolicyBuilder allowAttributesGlobally(AttributePolicy policy, List<String> attributeNames) {
        this.invalidateCompiledState();
        for (String attributeName : attributeNames) {
            AttributePolicy oldPolicy = this.globalAttrPolicies.get(attributeName);
            this.globalAttrPolicies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
        }
        return this;
    }

    private HtmlPolicyBuilder allowAttributesOnElements(AttributePolicy policy, List<String> attributeNames, List<String> elementNames) {
        this.invalidateCompiledState();
        for (String elementName : elementNames) {
            LinkedHashMap policies = this.attrPolicies.get(elementName);
            if (policies == null) {
                policies = Maps.newLinkedHashMap();
                this.attrPolicies.put(elementName, policies);
            }
            for (String attributeName : attributeNames) {
                AttributePolicy oldPolicy = (AttributePolicy)policies.get(attributeName);
                policies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
            }
        }
        return this;
    }

    public HtmlPolicyBuilder requireRelNofollowOnLinks() {
        return this.requireRelsOnLinks("nofollow");
    }

    public HtmlPolicyBuilder requireRelsOnLinks(String ... linkValues) {
        this.invalidateCompiledState();
        if (this.extraRelsForLinks == null) {
            this.extraRelsForLinks = Sets.newLinkedHashSet();
        }
        for (String linkValue : linkValues) {
            Preconditions.checkArgument((!Strings.containsHtmlSpace(linkValue = HtmlLexer.canonicalName(linkValue)) ? 1 : 0) != 0, (Object)"spaces in input.  use f(\"foo\", \"bar\") not f(\"foo bar\")");
            this.extraRelsForLinks.add(linkValue);
        }
        if (this.skipRelsForLinks != null) {
            this.skipRelsForLinks.removeAll(this.extraRelsForLinks);
        }
        return this;
    }

    public HtmlPolicyBuilder skipRelsOnLinks(String ... linkValues) {
        this.invalidateCompiledState();
        if (this.skipRelsForLinks == null) {
            this.skipRelsForLinks = Sets.newLinkedHashSet();
        }
        for (String linkValue : linkValues) {
            Preconditions.checkArgument((!Strings.containsHtmlSpace(linkValue = HtmlLexer.canonicalName(linkValue)) ? 1 : 0) != 0, (Object)"spaces in input.  use f(\"foo\", \"bar\") not f(\"foo bar\")");
            this.skipRelsForLinks.add(linkValue);
        }
        if (this.extraRelsForLinks != null) {
            this.extraRelsForLinks.removeAll(this.skipRelsForLinks);
        }
        return this;
    }

    public HtmlPolicyBuilder allowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.add(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.remove(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder allowStandardUrlProtocols() {
        return this.allowUrlProtocols("http", "https", "mailto");
    }

    public HtmlPolicyBuilder allowStyling() {
        this.allowStyling(CssSchema.DEFAULT);
        return this;
    }

    public HtmlPolicyBuilder allowStyling(CssSchema whitelist) {
        this.invalidateCompiledState();
        this.allowAttributesGlobally(AttributePolicy.IDENTITY_ATTRIBUTE_POLICY, (List<String>)ImmutableList.of((Object)"style"));
        this.stylingPolicySchema = this.stylingPolicySchema == null ? whitelist : CssSchema.union(this.stylingPolicySchema, whitelist);
        return this;
    }

    public HtmlPolicyBuilder allowUrlsInStyles(AttributePolicy newStyleUrlPolicy) {
        this.invalidateCompiledState();
        this.styleUrlPolicy = newStyleUrlPolicy;
        return this;
    }

    public HtmlPolicyBuilder withPreprocessor(HtmlStreamEventProcessor pp) {
        this.preprocessor = HtmlStreamEventProcessor.Processors.compose(this.preprocessor, pp);
        return this;
    }

    public HtmlPolicyBuilder withPostprocessor(HtmlStreamEventProcessor pp) {
        this.postprocessor = HtmlStreamEventProcessor.Processors.compose(this.postprocessor, pp);
        return this;
    }

    public HtmlSanitizer.Policy build(HtmlStreamEventReceiver out) {
        return this.toFactory().apply(out);
    }

    public <CTX> HtmlSanitizer.Policy build(HtmlStreamEventReceiver out, @Nullable HtmlChangeListener<? super CTX> listener, @Nullable CTX context) {
        return this.toFactory().apply(out, listener, context);
    }

    public PolicyFactory toFactory() {
        ImmutableSet.Builder textContainerSet = ImmutableSet.builder();
        for (Map.Entry<String, Boolean> textContainer : this.textContainers.entrySet()) {
            if (!Boolean.TRUE.equals(textContainer.getValue())) continue;
            textContainerSet.add((Object)textContainer.getKey());
        }
        return new PolicyFactory(this.compilePolicies(), (ImmutableSet<String>)textContainerSet.build(), (ImmutableMap<String, AttributePolicy>)ImmutableMap.copyOf(this.globalAttrPolicies), this.preprocessor, this.postprocessor);
    }

    private void invalidateCompiledState() {
        this.compiledPolicies = null;
    }

    private ImmutableMap<String, ElementAndAttributePolicies> compilePolicies() {
        if (this.compiledPolicies != null) {
            return this.compiledPolicies;
        }
        LinkedHashMap elPolicies = Maps.newLinkedHashMap(this.elPolicies);
        LinkedHashMap attrPolicies = Maps.newLinkedHashMap(this.attrPolicies);
        for (Map.Entry entry : attrPolicies.entrySet()) {
            entry.setValue(Maps.newLinkedHashMap((Map)((Map)entry.getValue())));
        }
        LinkedHashMap globalAttrPolicies = Maps.newLinkedHashMap(this.globalAttrPolicies);
        ImmutableSet immutableSet = ImmutableSet.copyOf(this.allowedProtocols);
        ElementPolicy linkPolicy = (ElementPolicy)elPolicies.get("a");
        if (linkPolicy != null) {
            RelsOnLinksPolicy relsOnLinksPolicy = RelsOnLinksPolicy.create((Set<? extends String>)(this.extraRelsForLinks != null ? this.extraRelsForLinks : ImmutableSet.of()), (Set<? extends String>)(this.skipRelsForLinks != null ? this.skipRelsForLinks : ImmutableSet.of()));
            elPolicies.put("a", ElementPolicy.Util.join(linkPolicy, relsOnLinksPolicy));
        }
        StylingPolicy stylingPolicy = null;
        AttributePolicy urlAttributePolicy = immutableSet.size() == 3 && immutableSet.contains("mailto") && immutableSet.contains("http") && immutableSet.contains("https") ? StandardUrlAttributePolicy.INSTANCE : new FilterUrlByProtocolAttributePolicy((Iterable<? extends String>)immutableSet);
        if (this.stylingPolicySchema != null) {
            final AttributePolicy styleUrlPolicyFinal = AttributePolicy.Util.join(this.styleUrlPolicy, urlAttributePolicy);
            stylingPolicy = new StylingPolicy(this.stylingPolicySchema, new Function<String, String>(){

                public String apply(String url) {
                    return styleUrlPolicyFinal.apply("img", "src", url);
                }
            });
        }
        LinkedHashSet toGuard = Sets.newLinkedHashSet(URL_ATTRIBUTE_NAMES);
        for (String string : URL_ATTRIBUTE_NAMES) {
            if (!globalAttrPolicies.containsKey(string)) continue;
            toGuard.remove(string);
            globalAttrPolicies.put(string, AttributePolicy.Util.join(urlAttributePolicy, (AttributePolicy)globalAttrPolicies.get(string)));
        }
        for (Map.Entry entry : attrPolicies.entrySet()) {
            Map policies = (Map)entry.getValue();
            for (String urlAttributeName : toGuard) {
                if (!policies.containsKey(urlAttributeName)) continue;
                policies.put(urlAttributeName, AttributePolicy.Util.join(urlAttributePolicy, (AttributePolicy)policies.get(urlAttributeName)));
            }
        }
        ImmutableMap.Builder policiesBuilder = ImmutableMap.builder();
        for (Map.Entry e : elPolicies.entrySet()) {
            AttributePolicy policy;
            String attributeName;
            String string = (String)e.getKey();
            ElementPolicy elPolicy = (ElementPolicy)e.getValue();
            if (ElementPolicy.REJECT_ALL_ELEMENT_POLICY.equals(elPolicy)) continue;
            Map elAttrPolicies = (Map)attrPolicies.get(string);
            if (elAttrPolicies == null) {
                elAttrPolicies = ImmutableMap.of();
            }
            ImmutableMap.Builder attrs = ImmutableMap.builder();
            for (Map.Entry ape : elAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                if (globalAttrPolicies.containsKey(attributeName)) continue;
                policy = (AttributePolicy)ape.getValue();
                if ("style".equals(attributeName)) {
                    policy = AttributePolicy.Util.join(policy, stylingPolicy);
                }
                if (AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy)) continue;
                attrs.put((Object)attributeName, (Object)policy);
            }
            for (Map.Entry ape : globalAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                policy = AttributePolicy.Util.join((AttributePolicy)elAttrPolicies.get(attributeName), (AttributePolicy)ape.getValue());
                if ("style".equals(attributeName)) {
                    policy = AttributePolicy.Util.join(policy, stylingPolicy);
                }
                if (AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy)) continue;
                attrs.put((Object)attributeName, (Object)policy);
            }
            policiesBuilder.put((Object)string, (Object)new ElementAndAttributePolicies(string, elPolicy, (Map<? extends String, ? extends AttributePolicy>)attrs.build(), this.skipIfEmpty.contains(string)));
        }
        this.compiledPolicies = policiesBuilder.build();
        return this.compiledPolicies;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JoinRelsOnLinksPolicies
    implements Joinable.JoinStrategy<ElementPolicy.JoinableElementPolicy> {
        static final JoinRelsOnLinksPolicies INSTANCE = new JoinRelsOnLinksPolicies();

        JoinRelsOnLinksPolicies() {
        }

        @Override
        public ElementPolicy.JoinableElementPolicy join(Iterable<? extends ElementPolicy.JoinableElementPolicy> toJoin) {
            LinkedHashSet extra = Sets.newLinkedHashSet();
            LinkedHashSet skip = Sets.newLinkedHashSet();
            for (ElementPolicy.JoinableElementPolicy joinableElementPolicy : toJoin) {
                RelsOnLinksPolicy p = (RelsOnLinksPolicy)joinableElementPolicy;
                extra.addAll(p.extra);
                skip.addAll(p.skip);
            }
            extra.removeAll(skip);
            return RelsOnLinksPolicy.create(extra, skip);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RelsOnLinksPolicy
    implements ElementPolicy.JoinableElementPolicy {
        final ImmutableSet<String> extra;
        final ImmutableSet<String> skip;
        final ImmutableSet<String> whenTargetPresent;
        static final RelsOnLinksPolicy EMPTY = new RelsOnLinksPolicy((Set<? extends String>)ImmutableSet.of(), (Set<? extends String>)ImmutableSet.of());

        static RelsOnLinksPolicy create(Set<? extends String> extra, Set<? extends String> skip) {
            if (extra.isEmpty() && skip.isEmpty()) {
                return EMPTY;
            }
            return new RelsOnLinksPolicy(extra, skip);
        }

        RelsOnLinksPolicy(Set<? extends String> extra, Set<? extends String> skip) {
            this.extra = ImmutableSet.copyOf(extra);
            this.skip = ImmutableSet.copyOf(skip);
            LinkedHashSet targetOnly = Sets.newLinkedHashSet();
            targetOnly.addAll(DEFAULT_RELS_ON_TARGETTED_LINKS);
            targetOnly.removeAll(extra);
            targetOnly.removeAll(skip);
            this.whenTargetPresent = ImmutableSet.copyOf((Collection)targetOnly);
        }

        private static int indexOfAttributeValue(String canonAttrName, List<String> attrs) {
            int n = attrs.size();
            for (int i = 0; i < n; i += 2) {
                if (!canonAttrName.equals(attrs.get(i))) continue;
                return i + 1;
            }
            return -1;
        }

        @Override
        public String apply(String elementName, List<String> attrs) {
            if (RelsOnLinksPolicy.indexOfAttributeValue("href", attrs) >= 0) {
                boolean hasTarget;
                boolean bl = hasTarget = RelsOnLinksPolicy.indexOfAttributeValue("target", attrs) >= 0;
                if (hasTarget || !this.extra.isEmpty()) {
                    String relValue;
                    int relIndex = RelsOnLinksPolicy.indexOfAttributeValue("rel", attrs);
                    if (relIndex < 0 && hasTarget && this.extra.isEmpty() && this.skip.isEmpty()) {
                        relValue = DEFAULT_RELS_ON_TARGETTED_LINKS_STR;
                    } else {
                        StringBuilder sb = new StringBuilder();
                        if (relIndex >= 0) {
                            sb.append(attrs.get(relIndex)).append(' ');
                        }
                        for (String s : this.extra) {
                            sb.append(s).append(' ');
                        }
                        if (hasTarget) {
                            for (String s : this.whenTargetPresent) {
                                sb.append(s).append(' ');
                            }
                        }
                        relValue = sb.substring(0, sb.length() - 1);
                    }
                    if (relIndex < 0) {
                        attrs.add("rel");
                        attrs.add(relValue);
                    } else {
                        attrs.set(relIndex, relValue);
                    }
                }
            }
            return elementName;
        }

        @Override
        public Joinable.JoinStrategy<ElementPolicy.JoinableElementPolicy> getJoinStrategy() {
            return JoinRelsOnLinksPolicies.INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class AttributeBuilder {
        private final List<String> attributeNames;
        private AttributePolicy policy = AttributePolicy.IDENTITY_ATTRIBUTE_POLICY;

        AttributeBuilder(List<? extends String> attributeNames) {
            this.attributeNames = ImmutableList.copyOf(attributeNames);
        }

        public AttributeBuilder matching(AttributePolicy attrPolicy) {
            this.policy = AttributePolicy.Util.join(this.policy, attrPolicy);
            return this;
        }

        public AttributeBuilder matching(final Pattern pattern) {
            return this.matching(new AttributePolicy(){

                @Nullable
                public String apply(String elementName, String attributeName, String value) {
                    return pattern.matcher(value).matches() ? value : null;
                }
            });
        }

        public AttributeBuilder matching(final Predicate<? super String> filter) {
            return this.matching(new AttributePolicy(){

                @Nullable
                public String apply(String elementName, String attributeName, String value) {
                    return filter.apply((Object)value) ? value : null;
                }
            });
        }

        public AttributeBuilder matching(boolean ignoreCase, String ... allowedValues) {
            return this.matching(ignoreCase, (Set<? extends String>)ImmutableSet.copyOf((Object[])allowedValues));
        }

        public AttributeBuilder matching(final boolean ignoreCase, Set<? extends String> allowedValues) {
            final ImmutableSet allowed = ImmutableSet.copyOf(allowedValues);
            return this.matching(new AttributePolicy(){

                @Nullable
                public String apply(String elementName, String attributeName, String uncanonValue) {
                    String value = ignoreCase ? Strings.toLowerCase(uncanonValue) : uncanonValue;
                    return allowed.contains((Object)value) ? value : null;
                }
            });
        }

        public HtmlPolicyBuilder globally() {
            return HtmlPolicyBuilder.this.allowAttributesGlobally(this.policy, this.attributeNames);
        }

        public HtmlPolicyBuilder onElements(String ... elementNames) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (String elementName : elementNames) {
                b.add((Object)HtmlLexer.canonicalName(elementName));
            }
            return HtmlPolicyBuilder.this.allowAttributesOnElements(this.policy, this.attributeNames, (List)b.build());
        }
    }
}

