/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.actors.extension.RiskReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class RiskService {
    private static final Logger logger = LoggerFactory.getLogger(RiskService.class);
    private ReleaseActorService releaseActorService;
    private RiskRepository riskRepository;
    private RiskProfileService riskProfileService;
    private ReleaseRepository releaseRepository;
    private List<Type> riskAssessorTypes = DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class)).stream().filter(type -> !type.getDescriptor().isVirtual()).collect(Collectors.toList());

    @Autowired
    public RiskService(ReleaseActorService releaseActorService, RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseRepository releaseRepository) {
        this.releaseActorService = releaseActorService;
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseRepository = releaseRepository;
    }

    Risk calculateRisk(Release release) {
        logger.debug("Running risk calculations for release {}", (Object)release.getId());
        Risk risk = (Risk)((Object)this.riskRepository.findByIdOrDefault(release, this.generateRiskId(release.getId())));
        RiskProfile riskProfileByRelease = (RiskProfile)((Object)Optional.ofNullable(release.getProperty("riskProfile")).orElse((Object)this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID)));
        List riskAssessors = this.riskAssessorTypes.stream().filter(riskProfileByRelease::hasRiskAssessorEnabled).map(type -> (RiskAssessor)type.getDescriptor().newInstance(this.generateAssessorId(type.getName()))).collect(Collectors.toList());
        List<RiskAssessment> riskAssessments = riskAssessors.stream().map(riskAssessor -> riskAssessor.execute(release, riskProfileByRelease)).collect(Collectors.toList());
        risk.setRiskAssessments(riskAssessments);
        Integer score = riskAssessments.stream().mapToInt(RiskAssessment::getScore).max().orElse(0);
        Integer totalScore = riskAssessments.stream().mapToInt(RiskAssessment::getScore).sum();
        risk.setScore(score);
        risk.setTotalScore(totalScore);
        logger.debug("Finished running risk calculations for release {} with score {} and total score {}", new Object[]{release.getId(), risk.getScore(), risk.getTotalScore()});
        return risk;
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        this.calculateRiskAndUpdateRelease(release);
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(Release release) {
        if (release.isPlannedOrActive()) {
            Risk risk = this.calculateRisk(release);
            this.releaseActorService.executeCommandAsync(release.getId(), (ReleaseExecutionActorMessages.ExtensionCommand)new RiskReleaseExecutionActorMessages.UpdateRisk(risk));
        }
    }

    private String generateRiskId(String releaseId) {
        return MessageFormat.format("{0}/{1}", releaseId, "Risk");
    }

    private String generateAssessorId(String name) {
        return MessageFormat.format("{0}/{1}", Ids.ROOT_FOLDER_ID, name);
    }
}

