/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.serialization;

import akka.actor.ActorSelectionMessage;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.SelectChildName;
import akka.actor.SelectChildPattern;
import akka.actor.SelectParent$;
import akka.actor.SelectionPathElement;
import akka.annotation.InternalApi;
import akka.protobuf.ByteString;
import akka.remote.ContainerFormats;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import java.io.NotSerializableException;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable;
import scala.collection.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u0013\tQR*Z:tC\u001e,7i\u001c8uC&tWM]*fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011A\u0002:f[>$XMC\u0001\b\u0003\u0011\t7n[1\u0004\u0001M\u0019\u0001A\u0003\t\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g!\t\t2#D\u0001\u0013\u0015\t\u0019a!\u0003\u0002\u0015%\tq!)Y:f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011A\f\u0002\rML8\u000f^3n+\u0005A\u0002CA\r\u001d\u001b\u0005Q\"BA\u000e\u0007\u0003\u0015\t7\r^8s\u0013\ti\"DA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W\u000e\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u001d\u0019\u0018p\u001d;f[\u0002BQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDCA\u0012&!\t!\u0003!D\u0001\u0003\u0011\u00151\u0002\u00051\u0001\u0019\u0011!\u0019\u0001\u0001#b\u0001\n\u00139S#\u0001\u0015\u0011\u0005EI\u0013B\u0001\u0016\u0013\u00055\u0019VM]5bY&T\u0018\r^5p]\")A\u0006\u0001C\u0001[\u0005y\u0011N\\2mk\u0012,W*\u00198jM\u0016\u001cH/F\u0001/!\tYq&\u0003\u00021\u0019\t9!i\\8mK\u0006t\u0007\"\u0002\u001a\u0001\t\u0003\u0019\u0014\u0001\u0003;p\u0005&t\u0017M]=\u0015\u0005QR\u0004cA\u00066o%\u0011a\u0007\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0017aJ!!\u000f\u0007\u0003\t\tKH/\u001a\u0005\u0006wE\u0002\rAC\u0001\u0004_\nT\u0007\"B\u001f\u0001\t\u0013q\u0014AE:fe&\fG.\u001b>f'\u0016dWm\u0019;j_:$\"\u0001N \t\u000b\u0001c\u0004\u0019A!\u0002\u0007M,G\u000e\u0005\u0002\u001a\u0005&\u00111I\u0007\u0002\u0016\u0003\u000e$xN]*fY\u0016\u001cG/[8o\u001b\u0016\u001c8/Y4f\u0011\u0015)\u0005\u0001\"\u0003G\u00031\u0011W/\u001b7e!\u0006$H/\u001a:o)\r95k\u0019\t\u0003\u0011Bs!!S'\u000f\u0005)[U\"\u0001\u0003\n\u00051#\u0011\u0001E\"p]R\f\u0017N\\3s\r>\u0014X.\u0019;t\u0013\tqu*A\u0005TK2,7\r^5p]*\u0011A\nB\u0005\u0003#J\u0013qAQ;jY\u0012,'O\u0003\u0002O\u001f\")A\u000b\u0012a\u0001+\u00069Q.\u0019;dQ\u0016\u0014\bcA\u0006W1&\u0011q\u000b\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005e\u0003gB\u0001._!\tYF\"D\u0001]\u0015\ti\u0006\"\u0001\u0004=e>|GOP\u0005\u0003?2\ta\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q\f\u0004\u0005\u0006I\u0012\u0003\r!Z\u0001\u0004iB,\u0007CA%g\u0013\t9wJA\u0006QCR$XM\u001d8UsB,\u0007\"B5\u0001\t\u0003Q\u0017A\u00034s_6\u0014\u0015N\\1ssR\u0019!b[7\t\u000b1D\u0007\u0019\u0001\u001b\u0002\u000b\tLH/Z:\t\u000b9D\u0007\u0019A8\u0002\u00115\fg.\u001b4fgR\u00042a\u0003,qa\t\th\u000fE\u0002ZeRL!a\u001d2\u0003\u000b\rc\u0017m]:\u0011\u0005U4H\u0002\u0001\u0003\no6\f\t\u0011!A\u0003\u0002a\u00141a\u0018\u00132#\tIH\u0010\u0005\u0002\fu&\u00111\u0010\u0004\u0002\b\u001d>$\b.\u001b8h!\tYQ0\u0003\u0002\u007f\u0019\t\u0019\u0011I\\=")
public class MessageContainerSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final int identifier;
    private volatile boolean bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        MessageContainerSerializer messageContainerSerializer = this;
        synchronized (messageContainerSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return !this.bitmap$0 ? this.serialization$lzycompute() : this.serialization;
    }

    public boolean includeManifest() {
        return false;
    }

    public byte[] toBinary(Object obj) {
        Object object = obj;
        if (!(object instanceof ActorSelectionMessage)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot serialize object of type [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obj.getClass().getName()})));
        }
        ActorSelectionMessage actorSelectionMessage = (ActorSelectionMessage)object;
        byte[] byArray = this.serializeSelection(actorSelectionMessage);
        return byArray;
    }

    private byte[] serializeSelection(ActorSelectionMessage sel) {
        BoxedUnit boxedUnit;
        ContainerFormats.SelectionEnvelope.Builder builder = ContainerFormats.SelectionEnvelope.newBuilder();
        Object message = sel.msg();
        Serializer serializer = this.serialization().findSerializerFor(message);
        builder.setEnclosedMessage(ByteString.copyFrom((byte[])serializer.toBinary(message))).setSerializerId(serializer.identifier()).setWildcardFanOut(sel.wildcardFanOut());
        Serializer serializer2 = serializer;
        if (serializer2 instanceof SerializerWithStringManifest) {
            String manifest;
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
            String string = manifest = serializerWithStringManifest.manifest(message);
            String string2 = "";
            boxedUnit = (string == null ? string2 != null : !string.equals(string2)) ? builder.setMessageManifest(ByteString.copyFromUtf8((String)manifest)) : BoxedUnit.UNIT;
        } else {
            boxedUnit = serializer.includeManifest() ? builder.setMessageManifest(ByteString.copyFromUtf8((String)message.getClass().getName())) : BoxedUnit.UNIT;
        }
        sel.elements().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ContainerFormats.SelectionEnvelope.Builder builder;
            SelectionPathElement selectionPathElement = x0$1;
            if (selectionPathElement instanceof SelectChildName) {
                SelectChildName selectChildName = (SelectChildName)selectionPathElement;
                String name = selectChildName.name();
                builder = builder.addPattern(this.buildPattern((Option<String>)new Some((Object)name), ContainerFormats.PatternType.CHILD_NAME));
            } else if (selectionPathElement instanceof SelectChildPattern) {
                SelectChildPattern selectChildPattern = (SelectChildPattern)selectionPathElement;
                String patternStr = selectChildPattern.patternStr();
                builder = builder.addPattern(this.buildPattern((Option<String>)new Some((Object)patternStr), ContainerFormats.PatternType.CHILD_PATTERN));
            } else if (SelectParent$.MODULE$.equals(selectionPathElement)) {
                builder = builder.addPattern(this.buildPattern((Option<String>)None$.MODULE$, ContainerFormats.PatternType.PARENT));
            } else {
                throw new MatchError((Object)selectionPathElement);
            }
            return builder;
        });
        return builder.build().toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private ContainerFormats.Selection.Builder buildPattern(Option<String> matcher, ContainerFormats.PatternType tpe) {
        void var3_3;
        ContainerFormats.Selection.Builder builder = ContainerFormats.Selection.newBuilder().setType(tpe);
        matcher.foreach((Function1 & Serializable & scala.Serializable)value -> builder.setMatcher((String)value));
        return var3_3;
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        ContainerFormats.SelectionEnvelope selectionEnvelope = ContainerFormats.SelectionEnvelope.parseFrom(bytes);
        String manifest2 = selectionEnvelope.hasMessageManifest() ? selectionEnvelope.getMessageManifest().toStringUtf8() : "";
        Object msg = this.serialization().deserialize(selectionEnvelope.getEnclosedMessage().toByteArray(), selectionEnvelope.getSerializerId(), manifest2).get();
        Iterable elements = (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(selectionEnvelope.getPatternList()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> {
            SelectChildName selectChildName;
            ContainerFormats.PatternType patternType = x.getType();
            if (((Object)((Object)ContainerFormats.PatternType.CHILD_NAME)).equals((Object)patternType)) {
                selectChildName = new SelectChildName(x.getMatcher());
            } else if (((Object)((Object)ContainerFormats.PatternType.CHILD_PATTERN)).equals((Object)patternType)) {
                selectChildName = new SelectChildPattern(x.getMatcher());
            } else if (((Object)((Object)ContainerFormats.PatternType.PARENT)).equals((Object)patternType)) {
                selectChildName = SelectParent$.MODULE$;
            } else {
                throw new MatchError((Object)patternType);
            }
            return selectChildName;
        }, package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom()));
        boolean wildcardFanOut = selectionEnvelope.hasWildcardFanOut() ? selectionEnvelope.getWildcardFanOut() : false;
        return new ActorSelectionMessage(msg, elements, wildcardFanOut);
    }

    public MessageContainerSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
    }
}

